/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Segment;
import okio.Source;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u001f\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0013"}, d2={"Lokio/HashingSource;", "Lokio/ForwardingSource;", "Lokio/Source;", "source", "Ljava/security/MessageDigest;", "digest", "<init>", "(Lokio/Source;Ljava/security/MessageDigest;)V", "Ljavax/crypto/Mac;", "mac", "(Lokio/Source;Ljavax/crypto/Mac;)V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "messageDigest", "Ljava/security/MessageDigest;", "Ljavax/crypto/Mac;", "Companion"})
public final class HashingSource
extends ForwardingSource
implements Source {
    public static final Companion Companion = new Companion(null);
    private final MessageDigest messageDigest;
    private final Mac mac;

    /*
     * WARNING - void declaration
     */
    public HashingSource(Source source2, MessageDigest digest) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        super((Source)var1_1);
        this.messageDigest = var2_2;
        this.mac = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(Source source2, Mac mac) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super((Source)var1_1);
        this.mac = var2_2;
        this.messageDigest = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        long result = super.read(sink2, byteCount);
        if (result != -1L) {
            long offset;
            long start = sink2.size() - result;
            Segment segment = sink2.head;
            Intrinsics.checkNotNull((Object)segment);
            Segment s = segment;
            for (offset = sink2.size(); offset > start; offset -= (long)(s.limit - s.pos)) {
                Intrinsics.checkNotNull((Object)s.prev);
            }
            while (offset < sink2.size()) {
                int pos = (int)((long)s.pos + start - offset);
                if (this.messageDigest != null) {
                    this.messageDigest.update(s.data, pos, s.limit - pos);
                } else {
                    void var3_7;
                    Mac mac = this.mac;
                    Intrinsics.checkNotNull((Object)mac);
                    mac.update(s.data, pos, s.limit - var3_7);
                }
                start = offset += (long)(s.limit - s.pos);
                Intrinsics.checkNotNull((Object)s.next);
            }
        }
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lokio/HashingSource$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

