/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.ForwardingSink;
import okio.Segment;
import okio.Sink;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0014"}, d2={"Lokio/HashingSink;", "Lokio/ForwardingSink;", "Lokio/Sink;", "sink", "Ljava/security/MessageDigest;", "digest", "<init>", "(Lokio/Sink;Ljava/security/MessageDigest;)V", "Ljavax/crypto/Mac;", "mac", "(Lokio/Sink;Ljavax/crypto/Mac;)V", "Lokio/Buffer;", "source", "", "byteCount", "", "write", "(Lokio/Buffer;J)V", "messageDigest", "Ljava/security/MessageDigest;", "Ljavax/crypto/Mac;", "Companion"})
@SourceDebugExtension(value={"SMAP\nHashingSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n+ 2 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,149:1\n85#2:150\n*S KotlinDebug\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n*L\n76#1:150\n*E\n"})
public final class HashingSink
extends ForwardingSink
implements Sink {
    public static final Companion Companion = new Companion(null);
    private final MessageDigest messageDigest;
    private final Mac mac;

    /*
     * WARNING - void declaration
     */
    public HashingSink(Sink sink2, MessageDigest digest) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        super((Sink)var1_1);
        this.messageDigest = var2_2;
        this.mac = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSink(Sink sink2, Mac mac) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super((Sink)var1_1);
        this.mac = var2_2;
        this.messageDigest = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(Buffer source2, long byteCount) throws IOException {
        void var2_2;
        void var1_1;
        int toHash;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
        Segment segment = source2.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            void a$iv;
            long l = byteCount - hashedCount;
            int b$iv = s.limit - s.pos;
            toHash = (int)Math.min((long)a$iv, (long)b$iv);
            if (this.messageDigest != null) {
                this.messageDigest.update(s.data, s.pos, toHash);
            } else {
                Mac mac = this.mac;
                Intrinsics.checkNotNull((Object)mac);
                mac.update(s.data, s.pos, toHash);
            }
            Intrinsics.checkNotNull((Object)s.next);
        }
        super.write((Buffer)var1_1, (long)var2_2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lokio/HashingSink$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

