/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.Segment;
import okio.SegmentPool;
import okio.Source;
import okio.Timeout;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 "}, d2={"Lokio/CipherSource;", "Lokio/Source;", "Lokio/BufferedSource;", "source", "Ljavax/crypto/Cipher;", "cipher", "<init>", "(Lokio/BufferedSource;Ljavax/crypto/Cipher;)V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "", "refill", "()V", "update", "doFinal", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "close", "Lokio/BufferedSource;", "Ljavax/crypto/Cipher;", "", "blockSize", "I", "buffer", "Lokio/Buffer;", "", "final", "Z", "closed"})
@SourceDebugExtension(value={"SMAP\nCipherSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CipherSource.kt\nokio/CipherSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class CipherSource
implements Source {
    private final BufferedSource source;
    public final Cipher cipher;
    private final int blockSize;
    private final Buffer buffer;
    private boolean final;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    public CipherSource(BufferedSource source2, Cipher cipher) {
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        this.source = string;
        this.cipher = var2_2;
        this.blockSize = this.cipher.getBlockSize();
        this.buffer = new Buffer();
        if (!(this.blockSize > 0)) {
            string = "Block cipher required " + this.cipher;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (!(byteCount >= 0L)) {
            sink2 = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(sink2.toString());
        }
        if (!(!this.closed)) {
            sink2 = "closed";
            throw new IllegalStateException(sink2.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        this.refill();
        return this.buffer.read((Buffer)var1_1, (long)var2_2);
    }

    private final void refill() {
        while (this.buffer.size() == 0L && !this.final) {
            if (this.source.exhausted()) {
                this.final = true;
                this.doFinal();
                return;
            }
            this.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        void var1_2;
        void var2_3;
        Segment segment = this.source.getBuffer().head;
        Intrinsics.checkNotNull((Object)segment);
        Segment head = segment;
        int size = segment.limit - head.pos;
        int outputSize = this.cipher.getOutputSize(size);
        while (outputSize > 8192) {
            if (size <= this.blockSize) {
                this.final = true;
                byte[] byArray = this.cipher.doFinal(this.source.readByteArray());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
                this.buffer.write(byArray);
                return;
            }
            outputSize = this.cipher.getOutputSize(size -= this.blockSize);
        }
        Segment s = this.buffer.writableSegment$okio(outputSize);
        int ciphered = this.cipher.update(head.data, head.pos, size, s.data, s.pos);
        this.source.skip((long)var2_3);
        s.limit += ciphered;
        Buffer buffer = this.buffer;
        buffer.setSize$okio(buffer.size() + (long)var1_2);
        if (s.pos == s.limit) {
            void var3_6;
            this.buffer.head = s.pop();
            SegmentPool.recycle((Segment)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doFinal() {
        void var2_3;
        int outputSize = this.cipher.getOutputSize(0);
        if (outputSize == 0) {
            return;
        }
        Segment s = this.buffer.writableSegment$okio(outputSize);
        int ciphered = this.cipher.doFinal(s.data, s.pos);
        s.limit += ciphered;
        Buffer buffer = this.buffer;
        buffer.setSize$okio(buffer.size() + (long)var2_3);
        if (s.pos == s.limit) {
            void var1_2;
            this.buffer.head = s.pop();
            SegmentPool.recycle((Segment)var1_2);
        }
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public final void close() throws IOException {
        this.closed = true;
        this.source.close();
    }
}

