/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.BufferedSink;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Timeout;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0011\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\""}, d2={"Lokio/CipherSink;", "Lokio/Sink;", "Lokio/BufferedSink;", "sink", "Ljavax/crypto/Cipher;", "cipher", "<init>", "(Lokio/BufferedSink;Ljavax/crypto/Cipher;)V", "Lokio/Buffer;", "source", "", "byteCount", "", "write", "(Lokio/Buffer;J)V", "remaining", "", "update", "(Lokio/Buffer;J)I", "flush", "()V", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "close", "", "doFinal", "()Ljava/lang/Throwable;", "Lokio/BufferedSink;", "Ljavax/crypto/Cipher;", "blockSize", "I", "", "closed", "Z"})
@SourceDebugExtension(value={"SMAP\nCipherSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CipherSink.kt\nokio/CipherSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,148:1\n1#2:149\n85#3:150\n*S KotlinDebug\n*F\n+ 1 CipherSink.kt\nokio/CipherSink\n*L\n47#1:150\n*E\n"})
public final class CipherSink
implements Sink {
    private final BufferedSink sink;
    public final Cipher cipher;
    private final int blockSize;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    public CipherSink(BufferedSink sink2, Cipher cipher) {
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        this.sink = string;
        this.cipher = var2_2;
        this.blockSize = this.cipher.getBlockSize();
        if (!(this.blockSize > 0)) {
            string = "Block cipher required " + this.cipher;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(Buffer source2, long byteCount) throws IOException {
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
        if (!(!this.closed)) {
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)var2_3) {
            int size = this.update(source2, remaining);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int update(Buffer source2, long remaining) {
        void var3_9;
        Segment segment = source2.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment head = segment;
        int b$iv = segment.limit - head.pos;
        int size = (int)Math.min(remaining, (long)b$iv);
        Buffer buffer = this.sink.getBuffer();
        int outputSize = this.cipher.getOutputSize(size);
        while (outputSize > 8192) {
            if (size <= this.blockSize) {
                byte[] byArray = this.cipher.update(source2.readByteArray(remaining));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"update(...)");
                this.sink.write(byArray);
                return (int)remaining;
            }
            outputSize = this.cipher.getOutputSize(size -= this.blockSize);
        }
        Segment s = buffer.writableSegment$okio(outputSize);
        int ciphered = this.cipher.update(head.data, head.pos, size, s.data, s.limit);
        s.limit += ciphered;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + (long)var3_9);
        if (s.pos == s.limit) {
            void var2_3;
            buffer.head = s.pop();
            SegmentPool.recycle((Segment)var2_3);
        }
        this.sink.emitCompleteSegments();
        Buffer buffer3 = source2;
        buffer3.setSize$okio(buffer3.size() - (long)size);
        head.pos += size;
        if (head.pos == head.limit) {
            var1_1.head = head.pop();
            SegmentPool.recycle(head);
        }
        return size;
    }

    @Override
    public final void flush() {
        this.sink.flush();
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() throws IOException {
        void var1_1;
        block4: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Throwable thrown = this.doFinal();
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                void var2_2;
                if (thrown != null) break block4;
                thrown = var2_2;
            }
        }
        void v0 = var1_1;
        if (v0 != null) {
            throw v0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Throwable doFinal() {
        void var2_5;
        int outputSize = this.cipher.getOutputSize(0);
        if (outputSize == 0) {
            return null;
        }
        if (outputSize > 8192) {
            try {
                byte[] byArray = this.cipher.doFinal();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
                this.sink.write(byArray);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                return throwable;
            }
            return null;
        }
        Throwable thrown = null;
        Buffer buffer = this.sink.getBuffer();
        Segment s = buffer.writableSegment$okio(outputSize);
        try {
            int ciphered = this.cipher.doFinal(s.data, s.limit);
            s.limit += ciphered;
            Buffer buffer2 = buffer;
            buffer2.setSize$okio(buffer2.size() + (long)ciphered);
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            thrown = throwable;
        }
        if (s.pos == s.limit) {
            void var1_2;
            var3_4.head = s.pop();
            SegmentPool.recycle((Segment)var1_2);
        }
        return var2_5;
    }
}

