/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.-Base64;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio._JvmPlatformKt;
import okio.internal.-ByteString;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0012\b\u0017\u0018\u0000 S2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001SB\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\r\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\r\u0010\fJ\r\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0017\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0007H\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\tJ\u000f\u0010\u0014\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0014\u0010\fJ#\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0015H\u0087\u0002\u00a2\u0006\u0004\b \u0010\u001dJ\u000f\u0010$\u001a\u00020\u0015H\u0010\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020\u0003H\u0010\u00a2\u0006\u0004\b'\u0010&J'\u00100\u001a\u00020-2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0010\u00a2\u0006\u0004\b.\u0010/J/\u00104\u001a\u0002032\u0006\u0010+\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b4\u00105J/\u00104\u001a\u0002032\u0006\u0010+\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b4\u00106J\u0015\u00108\u001a\u0002032\u0006\u00107\u001a\u00020\u0000\u00a2\u0006\u0004\b8\u00109J\u0015\u0010;\u001a\u0002032\u0006\u0010:\u001a\u00020\u0000\u00a2\u0006\u0004\b;\u00109J!\u0010=\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00002\b\b\u0002\u0010<\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010=\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b=\u0010?J!\u0010@\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00002\b\b\u0002\u0010<\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b@\u0010>J\u001f\u0010@\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b@\u0010?J\u001a\u0010B\u001a\u0002032\b\u00101\u001a\u0004\u0018\u00010AH\u0096\u0002\u00a2\u0006\u0004\bB\u0010CJ\u000f\u0010D\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\bD\u0010#J\u0018\u0010E\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\bE\u0010FJ\u000f\u0010G\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\bG\u0010\tR\u001a\u0010\u0004\u001a\u00020\u00038\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010H\u001a\u0004\bI\u0010&R\"\u0010D\u001a\u00020\u00158\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010J\u001a\u0004\bK\u0010#\"\u0004\bL\u0010MR$\u0010\b\u001a\u0004\u0018\u00010\u00078\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010N\u001a\u0004\bO\u0010\t\"\u0004\bP\u0010QR\u0011\u0010R\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\bR\u0010#"}, d2={"Lokio/ByteString;", "Ljava/io/Serializable;", "", "", "data", "<init>", "([B)V", "", "utf8", "()Ljava/lang/String;", "base64", "md5", "()Lokio/ByteString;", "sha1", "sha256", "algorithm", "digest$okio", "(Ljava/lang/String;)Lokio/ByteString;", "digest", "hex", "toAsciiLowercase", "", "beginIndex", "endIndex", "substring", "(II)Lokio/ByteString;", "pos", "", "internalGet$okio", "(I)B", "internalGet", "index", "getByte", "get", "getSize$okio", "()I", "getSize", "toByteArray", "()[B", "internalArray$okio", "internalArray", "Lokio/Buffer;", "buffer", "offset", "byteCount", "", "write$okio", "(Lokio/Buffer;II)V", "write", "other", "otherOffset", "", "rangeEquals", "(ILokio/ByteString;II)Z", "(I[BII)Z", "prefix", "startsWith", "(Lokio/ByteString;)Z", "suffix", "endsWith", "fromIndex", "indexOf", "(Lokio/ByteString;I)I", "([BI)I", "lastIndexOf", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "compareTo", "(Lokio/ByteString;)I", "toString", "[B", "getData$okio", "I", "getHashCode$okio", "setHashCode$okio", "(I)V", "Ljava/lang/String;", "getUtf8$okio", "setUtf8$okio", "(Ljava/lang/String;)V", "size", "Companion"})
@SourceDebugExtension(value={"SMAP\nByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteString.kt\nokio/ByteString\n+ 2 ByteString.kt\nokio/internal/-ByteString\n+ 3 Util.kt\nokio/-SegmentedByteString\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n42#2,7:365\n52#2:372\n55#2:373\n62#2,4:374\n66#2:379\n68#2:381\n74#2,23:382\n102#2,23:405\n129#2,2:428\n131#2,9:431\n143#2:440\n146#2:441\n149#2:442\n152#2:443\n160#2:444\n170#2,3:445\n169#2:448\n183#2,2:449\n188#2:451\n192#2:452\n196#2:453\n200#2:454\n204#2,7:455\n217#2:462\n221#2,8:463\n233#2,4:471\n242#2,5:475\n251#2,6:480\n257#2,9:487\n320#2,8:496\n129#2,2:504\n131#2,9:507\n331#2,9:516\n67#3:378\n73#3:380\n73#3:486\n1#4:430\n1#4:506\n*S KotlinDebug\n*F\n+ 1 ByteString.kt\nokio/ByteString\n*L\n66#1:365,7\n71#1:372\n108#1:373\n110#1:374,4\n110#1:379\n110#1:381\n112#1:382,23\n114#1:405,23\n118#1:428,2\n118#1:431,9\n120#1:440\n129#1:441\n131#1:442\n133#1:443\n152#1:444\n159#1:445,3\n159#1:448\n166#1:449,2\n168#1:451\n170#1:452\n172#1:453\n174#1:454\n180#1:455,7\n183#1:462\n186#1:463,8\n188#1:471,4\n190#1:475,5\n192#1:480,6\n192#1:487,9\n194#1:496,8\n194#1:504,2\n194#1:507,9\n194#1:516,9\n110#1:378\n110#1:380\n192#1:486\n118#1:430\n194#1:506\n*E\n"})
public class ByteString
implements Serializable,
Comparable<ByteString> {
    public static final Companion Companion = new Companion(null);
    private final byte[] data;
    private transient int hashCode;
    private transient String utf8;
    @JvmField
    public static final ByteString EMPTY = new ByteString(new byte[0]);

    /*
     * WARNING - void declaration
     */
    public ByteString(byte[] data) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = var1_1;
    }

    public final byte[] getData$okio() {
        return this.data;
    }

    public final int getHashCode$okio() {
        return this.hashCode;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHashCode$okio(int n) {
        void var1_1;
        this.hashCode = var1_1;
    }

    public final String getUtf8$okio() {
        return this.utf8;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUtf8$okio(String string) {
        void var1_1;
        this.utf8 = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String utf8() {
        void var2_2;
        ByteString $this$commonUtf8$iv = this;
        String result$iv = $this$commonUtf8$iv.getUtf8$okio();
        if (result$iv == null) {
            void var1_1;
            result$iv = _JvmPlatformKt.toUtf8String($this$commonUtf8$iv.internalArray$okio());
            var1_1.setUtf8$okio(result$iv);
        }
        return var2_2;
    }

    public String base64() {
        ByteString byteString = this;
        return -Base64.encodeBase64$default(byteString.getData$okio(), null, 1, null);
    }

    public final ByteString md5() {
        return this.digest$okio("MD5");
    }

    public final ByteString sha1() {
        return this.digest$okio("SHA-1");
    }

    public final ByteString sha256() {
        return this.digest$okio("SHA-256");
    }

    /*
     * WARNING - void declaration
     */
    public ByteString digest$okio(String algorithm) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest $this$digest_u24lambda_u240 = MessageDigest.getInstance(algorithm);
        $this$digest_u24lambda_u240.update(this.data, 0, this.size());
        byte[] digestBytes = $this$digest_u24lambda_u240.digest();
        Intrinsics.checkNotNull((Object)digestBytes);
        return new ByteString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String hex() {
        void var2_2;
        byte[] byArray;
        ByteString $this$commonHex$iv = this;
        char[] result$iv = new char[$this$commonHex$iv.getData$okio().length << 1];
        int c$iv = 0;
        for (byte b$iv : byArray.getData$okio()) {
            int n = c$iv++;
            byte by = b$iv;
            result$iv[n] = -ByteString.getHEX_DIGIT_CHARS()[by >> 4 & 0xF];
            int n2 = c$iv++;
            by = b$iv;
            result$iv[n2] = -ByteString.getHEX_DIGIT_CHARS()[by & 0xF];
        }
        return StringsKt.concatToString((char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ByteString toAsciiLowercase() {
        void var1_1;
        ByteString $this$commonToAsciiLowercase$iv = this;
        for (int i$iv = 0; i$iv < $this$commonToAsciiLowercase$iv.getData$okio().length; ++i$iv) {
            byte c$iv = $this$commonToAsciiLowercase$iv.getData$okio()[i$iv];
            if (c$iv < 65 || c$iv > 90) {
                continue;
            }
            byte[] byArray = $this$commonToAsciiLowercase$iv.getData$okio();
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            byte[] lowercase$iv = byArray2;
            byArray2[i$iv++] = (byte)(c$iv - -32);
            while (i$iv < lowercase$iv.length) {
                void var3_3;
                c$iv = lowercase$iv[i$iv];
                if (c$iv < 65 || c$iv > 90) {
                    ++i$iv;
                    continue;
                }
                lowercase$iv[i$iv] = (byte)(var3_3 - -32);
                ++i$iv;
            }
            return new ByteString((byte[])var1_1);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ByteString substring(int beginIndex22, int endIndex) {
        void var2_3;
        void var1_1;
        byte[] byArray;
        int beginIndex22;
        Object $this$commonSubstring$iv = this;
        int endIndex$iv = -SegmentedByteString.resolveDefaultParameter((ByteString)$this$commonSubstring$iv, endIndex);
        if (!(beginIndex22 >= 0)) {
            $this$commonSubstring$iv = "beginIndex < 0";
            throw new IllegalArgumentException($this$commonSubstring$iv.toString());
        }
        if (!(endIndex$iv <= ((ByteString)$this$commonSubstring$iv).getData$okio().length)) {
            $this$commonSubstring$iv = "endIndex > length(" + ((ByteString)$this$commonSubstring$iv).getData$okio().length + ')';
            throw new IllegalArgumentException($this$commonSubstring$iv.toString());
        }
        int n = endIndex$iv - beginIndex22;
        if (!(n >= 0)) {
            String beginIndex22 = "endIndex < beginIndex";
            throw new IllegalArgumentException(beginIndex22.toString());
        }
        if (beginIndex22 == 0 && endIndex$iv == ((ByteString)$this$commonSubstring$iv).getData$okio().length) {
            return $this$commonSubstring$iv;
        }
        byArray = byArray.getData$okio();
        return new ByteString(ArraysKt.copyOfRange((byte[])byArray, (int)var1_1, (int)var2_3));
    }

    public static /* synthetic */ ByteString substring$default(ByteString byteString, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substring");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = -SegmentedByteString.getDEFAULT__ByteString_size();
        }
        return byteString.substring(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public byte internalGet$okio(int pos) {
        void var1_1;
        ByteString byteString = this;
        return byteString.getData$okio()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="getByte")
    public final byte getByte(int index) {
        void var1_1;
        return this.internalGet$okio((int)var1_1);
    }

    @JvmName(name="size")
    public final int size() {
        return this.getSize$okio();
    }

    public int getSize$okio() {
        ByteString byteString = this;
        return byteString.getData$okio().length;
    }

    public byte[] toByteArray() {
        ByteString byteString = this;
        byte[] byArray = byteString.getData$okio();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        return byArray2;
    }

    public byte[] internalArray$okio() {
        ByteString byteString = this;
        return byteString.getData$okio();
    }

    /*
     * WARNING - void declaration
     */
    public void write$okio(Buffer buffer, int offset, int byteCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        -ByteString.commonWrite(this, (Buffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean rangeEquals(int offset, ByteString other, int otherOffset, int byteCount) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ByteString $this$commonRangeEquals$iv = this;
        return var2_2.rangeEquals((int)var3_3, $this$commonRangeEquals$iv.getData$okio(), (int)var1_1, byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public boolean rangeEquals(int offset, byte[] other, int otherOffset, int byteCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ByteString $this$commonRangeEquals$iv = this;
        return offset >= 0 && offset <= $this$commonRangeEquals$iv.getData$okio().length - byteCount && otherOffset >= 0 && otherOffset <= other.length - byteCount && -SegmentedByteString.arrayRangeEquals($this$commonRangeEquals$iv.getData$okio(), (int)var1_1, (byte[])var2_2, (int)var3_3, byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startsWith(ByteString prefix) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ByteString byteString = this;
        return byteString.rangeEquals(0, prefix, 0, var1_1.size());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean endsWith(ByteString suffix) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        ByteString $this$commonEndsWith$iv = this;
        return $this$commonEndsWith$iv.rangeEquals(var2_2.size() - suffix.size(), suffix, 0, var1_1.size());
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final int indexOf(ByteString other, int fromIndex) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.indexOf(var1_1.internalArray$okio(), (int)var2_2);
    }

    public static /* synthetic */ int indexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return byteString.indexOf(byteString2, n);
    }

    @JvmOverloads
    public int indexOf(byte[] other, int fromIndex) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ByteString $this$commonIndexOf$iv = this;
        int limit$iv = $this$commonIndexOf$iv.getData$okio().length - other.length;
        int i$iv = Math.max(fromIndex, 0);
        if (i$iv <= limit$iv) {
            while (true) {
                if (-SegmentedByteString.arrayRangeEquals($this$commonIndexOf$iv.getData$okio(), i$iv, other, 0, other.length)) {
                    return i$iv;
                }
                if (i$iv == limit$iv) break;
                ++i$iv;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final int lastIndexOf(ByteString other, int fromIndex) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ByteString byteString = this;
        return byteString.lastIndexOf(var1_1.internalArray$okio(), (int)var2_2);
    }

    public static /* synthetic */ int lastIndexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
        }
        if ((n2 & 2) != 0) {
            n = -SegmentedByteString.getDEFAULT__ByteString_size();
        }
        return byteString.lastIndexOf(byteString2, n);
    }

    @JvmOverloads
    public int lastIndexOf(byte[] other, int fromIndex) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ByteString $this$commonLastIndexOf$iv = this;
        int fromIndex$iv = -SegmentedByteString.resolveDefaultParameter($this$commonLastIndexOf$iv, fromIndex);
        int limit$iv = $this$commonLastIndexOf$iv.getData$okio().length - other.length;
        for (int i$iv = Math.min(fromIndex$iv, limit$iv); i$iv >= 0; --i$iv) {
            if (!-SegmentedByteString.arrayRangeEquals($this$commonLastIndexOf$iv.getData$okio(), i$iv, other, 0, other.length)) continue;
            return i$iv;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        ByteString $this$commonEquals$iv = this;
        if (other == $this$commonEquals$iv) {
            return true;
        }
        if (other instanceof ByteString) {
            void var2_2;
            void var1_1;
            return ((ByteString)other).size() == $this$commonEquals$iv.getData$okio().length && ((ByteString)var1_1).rangeEquals(0, $this$commonEquals$iv.getData$okio(), 0, var2_2.getData$okio().length);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var3_3;
        void var1_1;
        int n;
        ByteString $this$commonHashCode$iv = this;
        int result$iv = $this$commonHashCode$iv.getHashCode$okio();
        if (result$iv != 0) {
            return n;
        }
        int it$iv = n = Arrays.hashCode($this$commonHashCode$iv.getData$okio());
        var1_1.setHashCode$okio((int)var3_3);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(ByteString other) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ByteString $this$commonCompareTo$iv = this;
        int sizeA$iv = $this$commonCompareTo$iv.size();
        int sizeB$iv = other.size();
        int size$iv = Math.min(sizeA$iv, sizeB$iv);
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            byte by = $this$commonCompareTo$iv.getByte(i$iv);
            int byteA$iv = by & 0xFF;
            int byteB$iv = (by = other.getByte(i$iv)) & 0xFF;
            if (byteA$iv == byteB$iv) {
                continue;
            }
            if (byteA$iv < byteB$iv) {
                return -1;
            }
            return 1;
        }
        if (sizeA$iv == sizeB$iv) {
            return 0;
        }
        if (var3_3 < sizeB$iv) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String toString() {
        void var3_8;
        void var2_4;
        void var1_1;
        String string;
        ByteString $this$commonToString$iv = this;
        if ($this$commonToString$iv.getData$okio().length == 0) {
            return "[size=0]";
        }
        boolean bl = false;
        if (bl) {
            return "[size=0]";
        }
        int i$iv22 = -ByteString.access$codePointIndexToCharIndex($this$commonToString$iv.getData$okio(), 64);
        if (i$iv22 == -1) {
            void var1_2;
            ByteString byteString;
            if ($this$commonToString$iv.getData$okio().length <= 64) {
                string = "[hex=" + $this$commonToString$iv.hex() + ']';
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder("[size=").append($this$commonToString$iv.getData$okio().length).append(" hex=");
            ByteString $this$commonSubstring$iv$iv = $this$commonToString$iv;
            int endIndex$iv$iv2 = -SegmentedByteString.resolveDefaultParameter($this$commonSubstring$iv$iv, 64);
            if (!(endIndex$iv$iv2 <= $this$commonSubstring$iv$iv.getData$okio().length)) {
                String i$iv22 = "endIndex > length(" + $this$commonSubstring$iv$iv.getData$okio().length + ')';
                throw new IllegalArgumentException(i$iv22.toString());
            }
            i$iv22 = endIndex$iv$iv2;
            if (!(i$iv22 >= 0)) {
                String endIndex$iv$iv2 = "endIndex < beginIndex";
                throw new IllegalArgumentException(endIndex$iv$iv2.toString());
            }
            if (endIndex$iv$iv2 == $this$commonSubstring$iv$iv.getData$okio().length) {
                byteString = $this$commonSubstring$iv$iv;
                return stringBuilder.append(byteString.hex()).append("\u2026]").toString();
            }
            byte[] i$iv22 = $this$commonSubstring$iv$iv.getData$okio();
            ByteString byteString2 = new ByteString(ArraysKt.copyOfRange((byte[])i$iv22, (int)0, (int)var1_2));
            byteString = byteString2;
            return stringBuilder.append(byteString.hex()).append("\u2026]").toString();
        }
        String text$iv = var1_1.utf8();
        String string2 = text$iv.substring(0, i$iv22);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String safeText$iv = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null);
        if (var2_4 < var3_8.length()) {
            return "[size=" + var1_1.getData$okio().length + " text=" + safeText$iv + "\u2026]";
        }
        string = "[text=" + safeText$iv + ']';
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\b*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\u00020\b*\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0013\u001a\u00020\b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u0004\u0018\u00010\b*\u00020\fH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\u0013\u0010\u0015\u001a\u00020\b*\u00020\fH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0016\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017"}, d2={"Lokio/ByteString$Companion;", "", "<init>", "()V", "", "", "offset", "byteCount", "Lokio/ByteString;", "of", "([BII)Lokio/ByteString;", "toByteString", "", "encodeUtf8", "(Ljava/lang/String;)Lokio/ByteString;", "Ljava/nio/charset/Charset;", "charset", "encodeString", "(Ljava/lang/String;Ljava/nio/charset/Charset;)Lokio/ByteString;", "encode", "decodeBase64", "decodeHex", "EMPTY", "Lokio/ByteString;"})
    @SourceDebugExtension(value={"SMAP\nByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteString.kt\nokio/ByteString$Companion\n+ 2 ByteString.kt\nokio/internal/-ByteString\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n269#2:365\n273#2,3:366\n280#2,3:369\n287#2,2:372\n293#2:374\n295#2,7:376\n1#3:375\n1#3:383\n*S KotlinDebug\n*F\n+ 1 ByteString.kt\nokio/ByteString$Companion\n*L\n234#1:365\n239#1:366,3\n251#1:369,3\n259#1:372,2\n262#1:374\n262#1:376,7\n262#1:375\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="of")
        public final ByteString of(byte[] $this$toByteString, int offset, int byteCount) {
            void var2_2;
            void var1_1;
            int n;
            Intrinsics.checkNotNullParameter((Object)$this$toByteString, (String)"<this>");
            byte[] $this$commonToByteString$iv = $this$toByteString;
            int byteCount$iv = -SegmentedByteString.resolveDefaultParameter($this$toByteString, byteCount);
            -SegmentedByteString.checkOffsetAndCount($this$commonToByteString$iv.length, offset, byteCount$iv);
            n = offset + n;
            return new ByteString(ArraysKt.copyOfRange((byte[])var1_1, (int)var2_2, (int)n));
        }

        public static /* synthetic */ ByteString of$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = -SegmentedByteString.getDEFAULT__ByteString_size();
            }
            return companion.of(byArray, n, n2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final ByteString encodeUtf8(String $this$encodeUtf8) {
            void var2_2;
            void var1_1;
            void $this$commonEncodeUtf8$iv;
            Intrinsics.checkNotNullParameter((Object)$this$encodeUtf8, (String)"<this>");
            ByteString byteString$iv = new ByteString(_JvmPlatformKt.asUtf8ToByteArray((String)$this$commonEncodeUtf8$iv));
            byteString$iv.setUtf8$okio((String)var1_1);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="encodeString")
        public final ByteString encodeString(String $this$encode, Charset charset) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = var1_1.getBytes((Charset)var2_2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return new ByteString(byArray);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final ByteString decodeBase64(String $this$decodeBase64) {
            Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
            byte[] decoded$iv = -Base64.decodeBase64ToArray($this$decodeBase64);
            if (decoded$iv != null) {
                void var1_1;
                return new ByteString((byte[])var1_1);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final ByteString decodeHex(String $this$decodeHex) {
            void var3_4;
            Intrinsics.checkNotNullParameter((Object)$this$decodeHex, (String)"<this>");
            String $this$commonDecodeHex$iv = $this$decodeHex;
            if (!($this$commonDecodeHex$iv.length() % 2 == 0)) {
                String string = "Unexpected hex string: " + $this$commonDecodeHex$iv;
                throw new IllegalArgumentException(string.toString());
            }
            byte[] result$iv = new byte[$this$commonDecodeHex$iv.length() / 2];
            int n = result$iv.length;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                int d1$iv = -ByteString.access$decodeHexDigit($this$commonDecodeHex$iv.charAt(i$iv << 1)) << 4;
                int d2$iv = -ByteString.access$decodeHexDigit($this$commonDecodeHex$iv.charAt((i$iv << 1) + 1));
                result$iv[i$iv] = (byte)(d1$iv + d2$iv);
            }
            return new ByteString((byte[])var3_4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

