/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0001\u0018\u0000*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u0018\u0010\u001c\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001b\u0010\u000b\u001a\u00020\n8VX\u0097\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!"}, d2={"Lkotlinx/serialization/internal/EnumSerializer;", "", "T", "Lkotlinx/serialization/KSerializer;", "", "serialName", "", "values", "<init>", "(Ljava/lang/String;[Ljava/lang/Enum;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "(Ljava/lang/String;[Ljava/lang/Enum;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "createUnmarkedDescriptor", "(Ljava/lang/String;)Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Enum;)V", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Enum;", "toString", "()Ljava/lang/String;", "[Ljava/lang/Enum;", "overriddenDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor$delegate", "Lkotlin/Lazy;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;"})
@PublishedApi
@SourceDebugExtension(value={"SMAP\nEnums.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Enums.kt\nkotlinx/serialization/internal/EnumSerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,148:1\n13472#2,2:149\n*S KotlinDebug\n*F\n+ 1 Enums.kt\nkotlinx/serialization/internal/EnumSerializer\n*L\n120#1:149,2\n*E\n"})
public final class EnumSerializer<T extends Enum<T>>
implements KSerializer<T> {
    private final T[] values;
    private SerialDescriptor overriddenDescriptor;
    private final Lazy descriptor$delegate;

    /*
     * WARNING - void declaration
     */
    public EnumSerializer(String serialName, T[] values) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)serialName, (String)"serialName");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.values = var2_2;
        this.descriptor$delegate = LazyKt.lazy(() -> EnumSerializer.descriptor_delegate$lambda$0(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public EnumSerializer(String serialName, T[] values, SerialDescriptor descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)serialName, (String)"serialName");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this((String)var1_1, (Enum[])var2_2);
        this.overriddenDescriptor = var3_3;
    }

    @Override
    public final SerialDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (SerialDescriptor)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final SerialDescriptor createUnmarkedDescriptor(String serialName) {
        void var1_1;
        EnumDescriptor d = new EnumDescriptor(serialName, this.values.length);
        T[] $this$forEach$iv = this.values;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            T t;
            T it = t = $this$forEach$iv[i];
            PluginGeneratedSerialDescriptor.addElement$default(d, ((Enum)it).name(), false, 2, null);
        }
        return (SerialDescriptor)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(Encoder encoder, T value) {
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int index = ArraysKt.indexOf((Object[])this.values, value);
        if (index == -1) {
            void var2_2;
            StringBuilder stringBuilder = new StringBuilder().append(var2_2).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
            String string = Arrays.toString(this.values);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new SerializationException(stringBuilder.append(string).toString());
        }
        var1_1.encodeEnum(this.getDescriptor(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T deserialize(Decoder decoder) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        int index = decoder.decodeEnum(this.getDescriptor());
        if (!(index >= 0 ? index < this.values.length : false)) {
            throw new SerializationException(index + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
        }
        return this.values[var1_2];
    }

    public final String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    /*
     * WARNING - void declaration
     */
    private static final SerialDescriptor descriptor_delegate$lambda$0(EnumSerializer this$0, String $serialName) {
        SerialDescriptor serialDescriptor = this$0.overriddenDescriptor;
        if (serialDescriptor == null) {
            void var1_1;
            EnumSerializer enumSerializer;
            serialDescriptor = enumSerializer.createUnmarkedDescriptor((String)var1_1);
        }
        return serialDescriptor;
    }
}

