/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CryptoKt;
import io.ktor.util.NonceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\n\u0010\u000bB5\b\u0016\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#"}, d2={"Lio/ktor/util/StatelessHmacNonceManager;", "Lio/ktor/util/NonceManager;", "Ljavax/crypto/spec/SecretKeySpec;", "keySpec", "", "algorithm", "", "timeoutMillis", "Lkotlin/Function0;", "nonceGenerator", "<init>", "(Ljavax/crypto/spec/SecretKeySpec;Ljava/lang/String;JLkotlin/jvm/functions/Function0;)V", "", "key", "([BLjava/lang/String;JLkotlin/jvm/functions/Function0;)V", "newNonce", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nonce", "", "verifyNonce", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljavax/crypto/spec/SecretKeySpec;", "getKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "Ljava/lang/String;", "getAlgorithm", "()Ljava/lang/String;", "J", "getTimeoutMillis", "()J", "Lkotlin/jvm/functions/Function0;", "getNonceGenerator", "()Lkotlin/jvm/functions/Function0;", "", "macLength", "I"})
public final class StatelessHmacNonceManager
implements NonceManager {
    private final SecretKeySpec keySpec;
    private final String algorithm;
    private final long timeoutMillis;
    private final Function0<String> nonceGenerator;
    private final int macLength;

    /*
     * WARNING - void declaration
     */
    public StatelessHmacNonceManager(SecretKeySpec keySpec, String algorithm, long timeoutMillis, Function0<String> nonceGenerator) {
        void var1_1;
        int n;
        void var3_4;
        StatelessHmacNonceManager statelessHmacNonceManager;
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(nonceGenerator, (String)"nonceGenerator");
        this.keySpec = keySpec;
        this.algorithm = statelessHmacNonceManager;
        this.timeoutMillis = var3_4;
        this.nonceGenerator = nonceGenerator;
        StatelessHmacNonceManager statelessHmacNonceManager2 = this;
        Mac mac = Mac.getInstance(statelessHmacNonceManager2.algorithm);
        statelessHmacNonceManager = statelessHmacNonceManager2;
        mac.init(this.keySpec);
        statelessHmacNonceManager.macLength = n = var1_1.getMacLength();
    }

    public /* synthetic */ StatelessHmacNonceManager(SecretKeySpec secretKeySpec, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = StatelessHmacNonceManager::_init_$lambda$0;
        }
        this(secretKeySpec, string, l, (Function0<String>)function0);
    }

    public final SecretKeySpec getKeySpec() {
        return this.keySpec;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public final Function0<String> getNonceGenerator() {
        return this.nonceGenerator;
    }

    /*
     * WARNING - void declaration
     */
    public StatelessHmacNonceManager(byte[] key, String algorithm, long timeoutMillis, Function0<String> nonceGenerator) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(nonceGenerator, (String)"nonceGenerator");
        this(new SecretKeySpec((byte[])var1_1, algorithm), (String)var2_2, (long)var3_3, nonceGenerator);
    }

    public /* synthetic */ StatelessHmacNonceManager(byte[] byArray, String string, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        if ((n & 4) != 0) {
            l = 60000L;
        }
        if ((n & 8) != 0) {
            function0 = StatelessHmacNonceManager::_init_$lambda$1;
        }
        this(byArray, string, l, (Function0<String>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object newNonce(Continuation<? super String> $completion) {
        void var2_2;
        void var1_1;
        Mac mac;
        String random = (String)this.nonceGenerator.invoke();
        String string = Long.toString(System.nanoTime(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String time = StringsKt.padStart((String)string, (int)16, (char)'0');
        Mac $this$newNonce_u24lambda_u243 = mac = Mac.getInstance(this.algorithm);
        mac.init(this.keySpec);
        byte[] byArray = (random + ':' + time).getBytes(Charsets.ISO_8859_1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$newNonce_u24lambda_u243.update(byArray);
        byte[] byArray2 = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"doFinal(...)");
        String mac2 = CryptoKt.hex(byArray2);
        return (String)var1_1 + '+' + (String)var2_2 + '+' + (String)((Object)mac);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object verifyNonce(String nonce, Continuation<? super Boolean> $completion) {
        void var3_4;
        Mac mac;
        char[] cArray = new char[1];
        $completion = cArray;
        cArray[0] = 43;
        List parts = StringsKt.split$default((CharSequence)nonce, $completion, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 3) {
            return Boxing.boxBoolean((boolean)false);
        }
        String random = (String)parts.get(0);
        String time = (String)parts.get(1);
        String mac2 = (String)parts.get(2);
        if (random.length() < 8) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (mac2.length() != this.macLength << 1) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (time.length() != 16) {
            return Boxing.boxBoolean((boolean)false);
        }
        long l = Long.parseLong(time, CharsKt.checkRadix((int)16));
        if (l + TimeUnit.MILLISECONDS.toNanos(this.timeoutMillis) < System.nanoTime()) {
            return Boxing.boxBoolean((boolean)false);
        }
        Mac $this$verifyNonce_u24lambda_u244 = mac = Mac.getInstance(this.algorithm);
        mac.init(this.keySpec);
        byte[] byArray = (random + ':' + time).getBytes(Charsets.ISO_8859_1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$verifyNonce_u24lambda_u244.update(byArray);
        byte[] byArray2 = mac.doFinal();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"doFinal(...)");
        String computedMac = CryptoKt.hex(byArray2);
        int validCount = 0;
        int n = Math.min(computedMac.length(), mac2.length());
        for (int i = 0; i < n; ++i) {
            if (computedMac.charAt(i) != mac2.charAt(i)) continue;
            ++validCount;
        }
        return Boxing.boxBoolean((var3_4 == this.macLength << 1 ? 1 : 0) != 0);
    }

    private static final String _init_$lambda$0() {
        return CryptoKt.generateNonce();
    }

    private static final String _init_$lambda$1() {
        return CryptoKt.generateNonce();
    }
}

