/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.utility.AsmClassReader;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenedClassReader
implements AsmClassReader.Factory {
    public static final String EXPERIMENTAL_PROPERTY = "net.bytebuddy.experimental";
    public static final String PROCESSOR_PROPERTY = "net.bytebuddy.processor";
    public static final boolean EXPERIMENTAL;
    public static final int ASM_API;
    private static final boolean ACCESS_CONTROLLER;

    /*
     * WARNING - void declaration
     */
    @Override
    public AsmClassReader make(byte[] binaryRepresentation) {
        void var1_1;
        return new AsmClassReader.ForAsm(OpenedClassReader.of((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
        void var2_2;
        void var1_1;
        return new AsmClassReader.ForAsm(OpenedClassReader.of((byte[])var1_1, (boolean)var2_2));
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return privilegedAction.run();
    }

    public static ClassReader of(byte[] binaryRepresentation) {
        return OpenedClassReader.of(binaryRepresentation, EXPERIMENTAL);
    }

    /*
     * WARNING - void declaration
     */
    public static ClassReader of(byte[] binaryRepresentation, boolean experimental) {
        byte[] byArray;
        ClassFileVersion latest;
        ClassFileVersion classFileVersion = ClassFileVersion.ofClassFile(binaryRepresentation);
        if (classFileVersion.isGreaterThan(latest = ClassFileVersion.latest())) {
            void var3_4;
            void var2_3;
            if (experimental) {
                void var1_2;
                binaryRepresentation[4] = (byte)(latest.getMinorVersion() >>> 8);
                binaryRepresentation[5] = (byte)latest.getMinorVersion();
                binaryRepresentation[6] = (byte)(latest.getMajorVersion() >>> 8);
                binaryRepresentation[7] = (byte)latest.getMajorVersion();
                ClassReader classReader = new ClassReader(binaryRepresentation);
                binaryRepresentation[4] = (byte)(classFileVersion.getMinorVersion() >>> 8);
                binaryRepresentation[5] = (byte)classFileVersion.getMinorVersion();
                binaryRepresentation[6] = (byte)(classFileVersion.getMajorVersion() >>> 8);
                binaryRepresentation[7] = (byte)classFileVersion.getMajorVersion();
                return var1_2;
            }
            throw new IllegalArgumentException(var2_3 + " is not supported by the current version of Byte Buddy which officially supports " + var3_4 + " - update Byte Buddy or set net.bytebuddy.experimental" + " as a VM property");
        }
        return new ClassReader(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        void var0;
        boolean experimental;
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        try {
            experimental = Boolean.parseBoolean(OpenedClassReader.doPrivileged(new GetSystemPropertyAction(EXPERIMENTAL_PROPERTY)));
        }
        catch (Exception exception) {
            experimental = false;
        }
        EXPERIMENTAL = var0;
        ASM_API = 589824;
    }
}

