/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraalImageCode
extends Enum<GraalImageCode> {
    public static final /* enum */ GraalImageCode AGENT;
    public static final /* enum */ GraalImageCode BUILD;
    public static final /* enum */ GraalImageCode RUNTIME;
    public static final /* enum */ GraalImageCode UNKNOWN;
    public static final /* enum */ GraalImageCode NONE;
    @MaybeNull
    private static GraalImageCode current;
    private final boolean defined;
    private final boolean nativeImageExecution;
    private static final /* synthetic */ GraalImageCode[] $VALUES;
    private static final boolean ACCESS_CONTROLLER;

    public static GraalImageCode[] values() {
        return (GraalImageCode[])$VALUES.clone();
    }

    public static GraalImageCode valueOf(String name) {
        String string;
        return Enum.valueOf(GraalImageCode.class, string);
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="This behaviour is intended to avoid early binding in native images.")
    public static GraalImageCode getCurrent() {
        GraalImageCode graalImageCode;
        GraalImageCode current = GraalImageCode.current;
        if (current == null) {
            String vendor;
            String value = GraalImageCode.doPrivileged(new GetSystemPropertyAction("org.graalvm.nativeimage.imagecode"));
            graalImageCode = value == null ? ((vendor = GraalImageCode.doPrivileged(new GetSystemPropertyAction("java.vm.vendor"))) != null && ((String)((Object)graalImageCode)).toLowerCase(Locale.US).contains("graalvm") ? GraalImageCode.doPrivileged(ImageCodeContextAction.INSTANCE) : NONE) : (((String)((Object)graalImageCode)).equalsIgnoreCase("agent") ? AGENT : (((String)((Object)graalImageCode)).equalsIgnoreCase("runtime") ? RUNTIME : (((String)((Object)graalImageCode)).equalsIgnoreCase("buildtime") ? BUILD : UNKNOWN)));
            GraalImageCode.current = graalImageCode;
        }
        return graalImageCode;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T[] sorted(T[] value, Comparator<? super T> comparator) {
        void var1_1;
        if (this.defined) {
            void var2_2;
            Arrays.sort(value, var2_2);
        }
        return var1_1;
    }

    @MaybeNull
    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return privilegedAction.run();
    }

    /*
     * WARNING - void declaration
     */
    private GraalImageCode(boolean defined, boolean nativeImageExecution) {
        void var3_3;
        this.defined = var3_3;
        this.nativeImageExecution = nativeImageExecution;
    }

    public final boolean isDefined() {
        return this.defined;
    }

    public final boolean isNativeImageExecution() {
        return this.nativeImageExecution;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        AGENT = new GraalImageCode(true, false);
        BUILD = new GraalImageCode(true, false);
        RUNTIME = new GraalImageCode(true, true);
        UNKNOWN = new GraalImageCode(false, false);
        NONE = new GraalImageCode(false, false);
        $VALUES = new GraalImageCode[]{AGENT, BUILD, RUNTIME, UNKNOWN, NONE};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ImageCodeContextAction implements PrivilegedAction<GraalImageCode>
    {
        INSTANCE;


        @Override
        public final GraalImageCode run() {
            try {
                Object object;
                Method method = Class.forName("java.lang.management.ManagementFactory").getMethod("getRuntimeMXBean", new Class[0]);
                object = (List)method.getReturnType().getMethod("getInputArguments", new Class[0]).invoke(((Method)object).invoke(null, new Object[0]), new Object[0]);
                object = object.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (!string.startsWith("-agentlib:native-image-agent")) continue;
                    return AGENT;
                }
            }
            catch (Throwable throwable) {}
            return NONE;
        }
    }
}

