/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ClassWriter;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.AsmClassReader;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

public interface AsmClassWriter {
    public ClassVisitor getVisitor();

    public byte[] getBinaryRepresentation();

    public static class SuperClassResolvingJdkClassWriter {
        protected static final Method GET_SUPER_CLASS;
        private final TypePool typePool;

        /*
         * WARNING - void declaration
         */
        public SuperClassResolvingJdkClassWriter(TypePool typePool) {
            void var1_1;
            this.typePool = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @MaybeNull
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Object class can never be passed.")
        public String getSuperClass(String internalName) {
            void var1_1;
            TypeDescription typeDescription = this.typePool.describe(internalName.replace('/', '.')).resolve();
            if (typeDescription.isInterface()) {
                return null;
            }
            return var1_1.getSuperClass().asErasure().getInternalName();
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            try {
                Method getSuperClass = SuperClassResolvingJdkClassWriter.class.getMethod("getSuperClass", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to resolve own method", e);
            }
            GET_SUPER_CLASS = var0;
        }
    }

    public static class FrameComputingClassWriter
    extends ClassWriter {
        private final TypePool typePool;

        /*
         * WARNING - void declaration
         */
        public FrameComputingClassWriter(int flags, TypePool typePool) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.typePool = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public FrameComputingClassWriter(ClassReader classReader, int flags, TypePool typePool) {
            super((ClassReader)var1_1, (int)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.typePool = var3_3;
        }

        protected String getCommonSuperClass(String leftTypeName, String rightTypeName) {
            TypeDescription typeDescription;
            TypeDescription rightType;
            TypeDescription leftType = this.typePool.describe(leftTypeName.replace('/', '.')).resolve();
            if (leftType.isAssignableFrom(rightType = this.typePool.describe(rightTypeName.replace('/', '.')).resolve())) {
                return leftType.getInternalName();
            }
            if (leftType.isAssignableTo(rightType)) {
                return rightType.getInternalName();
            }
            if (leftType.isInterface() || rightType.isInterface()) {
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            }
            do {
                TypeDescription.Generic superClass;
                if ((superClass = leftType.getSuperClass()) != null) continue;
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            } while (!(typeDescription = typeDescription.asErasure()).isAssignableFrom(rightType));
            return typeDescription.getInternalName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForClassFileApi
    implements AsmClassWriter {
        private static final JdkClassWriter DISPATCHER;
        private final ClassVisitor classWriter;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        public ForClassFileApi(ClassVisitor classWriter) {
            void var1_1;
            if (!DISPATCHER.isInstance(classWriter)) {
                throw new IllegalArgumentException("Not a JDK class writer: " + classWriter);
            }
            this.classWriter = var1_1;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        @Override
        public ClassVisitor getVisitor() {
            return this.classWriter;
        }

        @Override
        public byte[] getBinaryRepresentation() {
            return DISPATCHER.toByteArray(this.classWriter);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            DISPATCHER = ForClassFileApi.doPrivileged(JavaDispatcher.of(JdkClassWriter.class, ForClassFileApi.class.getClassLoader()));
        }

        @JavaDispatcher.Proxied(value="net.bytebuddy.jar.asmjdkbridge.JdkClassWriter")
        protected static interface JdkClassWriter {
            @JavaDispatcher.Instance
            @JavaDispatcher.Proxied(value="isInstance")
            public boolean isInstance(ClassVisitor var1);

            @JavaDispatcher.IsConstructor
            @JavaDispatcher.Proxied(value="make")
            public ClassVisitor make(int var1, Method var2, Object var3);

            @JavaDispatcher.IsConstructor
            @JavaDispatcher.Proxied(value="make")
            public ClassVisitor make(@JavaDispatcher.Proxied(value="net.bytebuddy.jar.asmjdkbridge.JdkClassReader") Object var1, int var2, Method var3, Object var4);

            @JavaDispatcher.Proxied(value="toByteArray")
            public byte[] toByteArray(ClassVisitor var1);
        }
    }

    public static class ForAsm
    implements AsmClassWriter {
        private final ClassWriter classWriter;

        /*
         * WARNING - void declaration
         */
        public ForAsm(ClassWriter classWriter) {
            void var1_1;
            this.classWriter = var1_1;
        }

        public ClassVisitor getVisitor() {
            return this.classWriter;
        }

        public byte[] getBinaryRepresentation() {
            return this.classWriter.toByteArray();
        }
    }

    public static interface Factory {
        public AsmClassWriter make(int var1);

        public AsmClassWriter make(int var1, AsmClassReader var2);

        public AsmClassWriter make(int var1, TypePool var2);

        public AsmClassWriter make(int var1, AsmClassReader var2, TypePool var3);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Suppressing
        implements Factory {
            private final Factory delegate;

            /*
             * WARNING - void declaration
             */
            public Suppressing(Factory delegate) {
                void var1_1;
                this.delegate = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public AsmClassWriter make(int flags) {
                void var1_1;
                return this.delegate.make((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                void var1_1;
                return this.delegate.make((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public AsmClassWriter make(int flags, TypePool typePool) {
                void var2_2;
                void var1_1;
                return this.delegate.make((int)var1_1, (TypePool)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                void var3_3;
                void var1_1;
                return this.delegate.make((int)var1_1, (TypePool)var3_3);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.delegate.equals(((Suppressing)object).delegate);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.delegate.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Default
        extends Enum<Default>
        implements Factory {
            public static final /* enum */ Default IMPLICIT;
            public static final /* enum */ Default ASM_FIRST;
            public static final /* enum */ Default CLASS_FILE_API_FIRST;
            public static final /* enum */ Default ASM_ONLY;
            public static final /* enum */ Default CLASS_FILE_API_ONLY;
            @MaybeNull
            private static final Class<?> JDK_CLASS_READER;
            private static final Factory FACTORY;
            private static final /* synthetic */ Default[] $VALUES;
            private static final boolean ACCESS_CONTROLLER;

            public static Default[] values() {
                return (Default[])$VALUES.clone();
            }

            public static Default valueOf(String name) {
                String string;
                return Enum.valueOf(Default.class, string);
            }

            @MaybeNull
            @AccessControllerPlugin.Enhance
            private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
                if (ACCESS_CONTROLLER) {
                    return AccessController.doPrivileged(privilegedAction);
                }
                return privilegedAction.run();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AsmClassWriter make(int flags) {
                void var1_1;
                return this.make((int)var1_1, TypePool.Empty.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                void var2_2;
                void var1_1;
                return this.make((int)var1_1, (AsmClassReader)var2_2, TypePool.Empty.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AsmClassWriter make(int flags, TypePool typePool) {
                void var2_2;
                void var1_1;
                return this.make((int)var1_1, EmptyAsmClassReader.INSTANCE, (TypePool)var2_2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static {
                void var0;
                Class<?> type;
                String processor;
                try {
                    Class.forName("java.security.AccessController", false, null);
                    ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ACCESS_CONTROLLER = false;
                }
                catch (SecurityException securityException) {
                    ACCESS_CONTROLLER = true;
                }
                IMPLICIT = new Default(){

                    /*
                     * WARNING - void declaration
                     */
                    public final AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        return (FACTORY == IMPLICIT ? ASM_FIRST : FACTORY).make((int)var1_1, (AsmClassReader)var2_2, (TypePool)var3_3);
                    }
                };
                ASM_FIRST = new Default(){

                    /*
                     * WARNING - void declaration
                     */
                    public final AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        if (ClassFileVersion.ofThisVm().isGreaterThan(ClassFileVersion.latest())) {
                            return CLASS_FILE_API_ONLY.make(flags, classReader, typePool);
                        }
                        return ASM_ONLY.make((int)var1_1, (AsmClassReader)var2_2, (TypePool)var3_3);
                    }
                };
                CLASS_FILE_API_FIRST = new Default(){

                    /*
                     * WARNING - void declaration
                     */
                    public final AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        if (ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V24)) {
                            return CLASS_FILE_API_ONLY.make(flags, classReader, typePool);
                        }
                        return ASM_ONLY.make((int)var1_1, (AsmClassReader)var2_2, (TypePool)var3_3);
                    }
                };
                ASM_ONLY = new Default(){

                    /*
                     * WARNING - void declaration
                     */
                    public final AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        void var3_3;
                        void var1_1;
                        void var2_2;
                        ClassReader unwrapped = classReader.unwrap(ClassReader.class);
                        return new ForAsm(unwrapped == null ? new FrameComputingClassWriter(flags, typePool) : new FrameComputingClassWriter((ClassReader)var2_2, (int)var1_1, (TypePool)var3_3));
                    }
                };
                CLASS_FILE_API_ONLY = new Default(){

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="False positive in FindBugs.")
                    public final AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        void var3_3;
                        void var1_1;
                        void var2_2;
                        Object jdkClassReader = JDK_CLASS_READER == null ? null : classReader.unwrap(JDK_CLASS_READER);
                        if (jdkClassReader == null) {
                            return new ForClassFileApi(ForClassFileApi.DISPATCHER.make(flags, SuperClassResolvingJdkClassWriter.GET_SUPER_CLASS, new SuperClassResolvingJdkClassWriter(typePool)));
                        }
                        return new ForClassFileApi(ForClassFileApi.DISPATCHER.make(var2_2, (int)var1_1, SuperClassResolvingJdkClassWriter.GET_SUPER_CLASS, new SuperClassResolvingJdkClassWriter((TypePool)var3_3)));
                    }
                };
                $VALUES = new Default[]{IMPLICIT, ASM_FIRST, CLASS_FILE_API_FIRST, ASM_ONLY, CLASS_FILE_API_ONLY};
                try {
                    processor = Default.doPrivileged(new GetSystemPropertyAction("net.bytebuddy.processor"));
                }
                catch (Throwable throwable) {
                    processor = null;
                }
                FACTORY = processor == null ? ASM_FIRST : Default.valueOf(processor);
                try {
                    type = ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V24) ? Class.forName("net.bytebuddy.jar.asmjdkbridge.JdkClassReader") : null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    type = null;
                }
                JDK_CLASS_READER = var0;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class NonRetainingAsmClassReader
            implements AsmClassReader {
                private final AsmClassReader delegate;

                /*
                 * WARNING - void declaration
                 */
                public NonRetainingAsmClassReader(AsmClassReader delegate) {
                    void var1_1;
                    this.delegate = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @MaybeNull
                public <T> T unwrap(Class<T> type) {
                    void var1_1;
                    return this.delegate.unwrap(var1_1);
                }

                @AlwaysNull
                public AsmClassWriter toWriter(int flags, TypePool typePool) {
                    return null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void accept(ClassVisitor classVisitor, int flags) {
                    void var2_2;
                    void var1_1;
                    this.delegate.accept((ClassVisitor)var1_1, (int)var2_2);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum EmptyAsmClassReader implements AsmClassReader
            {
                INSTANCE;


                @Override
                @AlwaysNull
                public final <T> T unwrap(Class<T> type) {
                    return null;
                }

                @AlwaysNull
                public final AsmClassWriter toWriter(int flags, TypePool typePool) {
                    return null;
                }

                @Override
                public final void accept(ClassVisitor classVisitor, int flags) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

