/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class StringMatcher
extends ElementMatcher.Junction.ForNonNullValues<String> {
    private final String value;
    private final Mode mode;

    /*
     * WARNING - void declaration
     */
    public StringMatcher(String value, Mode mode) {
        void var2_2;
        void var1_1;
        this.value = var1_1;
        this.mode = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean doMatch(String target) {
        void var1_1;
        return this.mode.matches(this.value, (String)var1_1);
    }

    public String toString() {
        return this.mode.getDescription() + '(' + this.value + ')';
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.mode.equals((Object)((StringMatcher)object).mode)) {
            return false;
        }
        return this.value.equals(((StringMatcher)object).value);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.value.hashCode()) * 31 + this.mode.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        EQUALS_FULLY("equals"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.equals(var1_1);
            }
        }
        ,
        EQUALS_FULLY_IGNORE_CASE("equalsIgnoreCase"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.equalsIgnoreCase((String)var1_1);
            }
        }
        ,
        STARTS_WITH("startsWith"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.startsWith((String)var1_1);
            }
        }
        ,
        STARTS_WITH_IGNORE_CASE("startsWithIgnoreCase"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale.")
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.toLowerCase().startsWith(var1_1.toLowerCase());
            }
        }
        ,
        ENDS_WITH("endsWith"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.endsWith((String)var1_1);
            }
        }
        ,
        ENDS_WITH_IGNORE_CASE("endsWithIgnoreCase"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale.")
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.toLowerCase().endsWith(var1_1.toLowerCase());
            }
        }
        ,
        CONTAINS("contains"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.contains((CharSequence)var1_1);
            }
        }
        ,
        CONTAINS_IGNORE_CASE("containsIgnoreCase"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale.")
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.toLowerCase().contains(var1_1.toLowerCase());
            }
        }
        ,
        MATCHES("matches"){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            protected final boolean matches(String expected, String actual) {
                void var1_1;
                return actual.matches((String)var1_1);
            }
        };

        private final String description;

        /*
         * WARNING - void declaration
         */
        private Mode(String description) {
            void var3_3;
            this.description = var3_3;
        }

        protected String getDescription() {
            return this.description;
        }

        protected abstract boolean matches(String var1, String var2);
    }
}

