/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.SafeVarargsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.RecordComponentDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface LatentMatcher<T> {
    public ElementMatcher<? super T> resolve(TypeDescription var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Disjunction<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        /*
         * WARNING - void declaration
         */
        @SafeVarargsPlugin.Enhance
        @SafeVarargs
        public Disjunction(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Disjunction(List<? extends LatentMatcher<? super S>> matchers) {
            void var1_1;
            this.matchers = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            void var2_2;
            ElementMatcher.Junction<Object> matcher = ElementMatchers.none();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.or(latentMatcher.resolve(typeDescription));
            }
            return var2_2;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.matchers).equals(((Disjunction)object).matchers);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.matchers).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Conjunction<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        /*
         * WARNING - void declaration
         */
        @SafeVarargsPlugin.Enhance
        @SafeVarargs
        public Conjunction(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Conjunction(List<? extends LatentMatcher<? super S>> matchers) {
            void var1_1;
            this.matchers = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            void var2_2;
            ElementMatcher.Junction<Object> matcher = ElementMatchers.any();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.and(latentMatcher.resolve(typeDescription));
            }
            return var2_2;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.matchers).equals(((Conjunction)object).matchers);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.matchers).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForRecordComponentToken
    implements LatentMatcher<RecordComponentDescription> {
        private final RecordComponentDescription.Token token;

        /*
         * WARNING - void declaration
         */
        public ForRecordComponentToken(RecordComponentDescription.Token token) {
            void var1_1;
            this.token = var1_1;
        }

        @Override
        public ElementMatcher<? super RecordComponentDescription> resolve(TypeDescription typeDescription) {
            return ElementMatchers.named(this.token.getName());
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.token.equals(((ForRecordComponentToken)object).token);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.token.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForMethodToken
    implements LatentMatcher<MethodDescription> {
        private final MethodDescription.Token token;

        /*
         * WARNING - void declaration
         */
        public ForMethodToken(MethodDescription.Token token) {
            void var1_1;
            this.token = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            void var1_1;
            return new ResolvedMatcher(this.token.asSignatureToken((TypeDescription)var1_1));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.token.equals(((ForMethodToken)object).token);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.token.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class ResolvedMatcher
        extends ElementMatcher.Junction.ForNonNullValues<MethodDescription> {
            private final MethodDescription.SignatureToken signatureToken;

            /*
             * WARNING - void declaration
             */
            protected ResolvedMatcher(MethodDescription.SignatureToken signatureToken) {
                void var1_1;
                this.signatureToken = var1_1;
            }

            @Override
            public boolean doMatch(MethodDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.signatureToken.equals(((ResolvedMatcher)object).signatureToken);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.signatureToken.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForFieldToken
    implements LatentMatcher<FieldDescription> {
        private final FieldDescription.Token token;

        /*
         * WARNING - void declaration
         */
        public ForFieldToken(FieldDescription.Token token) {
            void var1_1;
            this.token = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ElementMatcher<? super FieldDescription> resolve(TypeDescription typeDescription) {
            void var1_1;
            return new ResolvedMatcher(this.token.asSignatureToken((TypeDescription)var1_1));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.token.equals(((ForFieldToken)object).token);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.token.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class ResolvedMatcher
        extends ElementMatcher.Junction.ForNonNullValues<FieldDescription> {
            private final FieldDescription.SignatureToken signatureToken;

            /*
             * WARNING - void declaration
             */
            protected ResolvedMatcher(FieldDescription.SignatureToken signatureToken) {
                void var1_1;
                this.signatureToken = var1_1;
            }

            @Override
            protected boolean doMatch(FieldDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.signatureToken.equals(((ResolvedMatcher)object).signatureToken);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.signatureToken.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Resolved<S>
    implements LatentMatcher<S> {
        private final ElementMatcher<? super S> matcher;

        /*
         * WARNING - void declaration
         */
        public Resolved(ElementMatcher<? super S> matcher) {
            void var1_1;
            this.matcher = var1_1;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            return this.matcher;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.matcher.equals(((Resolved)object).matcher);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.matcher.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForSelfDeclaredMethod implements LatentMatcher<MethodDescription>
    {
        DECLARED(false),
        NOT_DECLARED(true);

        private final boolean inverted;

        /*
         * WARNING - void declaration
         */
        private ForSelfDeclaredMethod(boolean inverted) {
            void var3_3;
            this.inverted = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            void var1_1;
            if (this.inverted) {
                return ElementMatchers.not(ElementMatchers.isDeclaredBy(typeDescription));
            }
            return ElementMatchers.isDeclaredBy((TypeDescription)var1_1);
        }
    }
}

