/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.AccessibilityMatcher;
import net.bytebuddy.matcher.AnnotationTargetMatcher;
import net.bytebuddy.matcher.AnnotationTypeMatcher;
import net.bytebuddy.matcher.ArrayTypeMatcher;
import net.bytebuddy.matcher.BooleanMatcher;
import net.bytebuddy.matcher.CachingMatcher;
import net.bytebuddy.matcher.ClassFileVersionMatcher;
import net.bytebuddy.matcher.ClassLoaderHierarchyMatcher;
import net.bytebuddy.matcher.ClassLoaderParentMatcher;
import net.bytebuddy.matcher.CollectionElementMatcher;
import net.bytebuddy.matcher.CollectionErasureMatcher;
import net.bytebuddy.matcher.CollectionItemMatcher;
import net.bytebuddy.matcher.CollectionOneToOneMatcher;
import net.bytebuddy.matcher.CollectionSizeMatcher;
import net.bytebuddy.matcher.DeclaringAnnotationMatcher;
import net.bytebuddy.matcher.DeclaringFieldMatcher;
import net.bytebuddy.matcher.DeclaringMethodMatcher;
import net.bytebuddy.matcher.DeclaringTypeMatcher;
import net.bytebuddy.matcher.DefinedShapeMatcher;
import net.bytebuddy.matcher.DescriptorMatcher;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.EqualityMatcher;
import net.bytebuddy.matcher.ErasureMatcher;
import net.bytebuddy.matcher.FailSafeMatcher;
import net.bytebuddy.matcher.FieldTypeMatcher;
import net.bytebuddy.matcher.HasSuperClassMatcher;
import net.bytebuddy.matcher.HasSuperTypeMatcher;
import net.bytebuddy.matcher.InheritedAnnotationMatcher;
import net.bytebuddy.matcher.InstanceTypeMatcher;
import net.bytebuddy.matcher.IsNamedMatcher;
import net.bytebuddy.matcher.MethodExceptionTypeMatcher;
import net.bytebuddy.matcher.MethodOverrideMatcher;
import net.bytebuddy.matcher.MethodParameterTypeMatcher;
import net.bytebuddy.matcher.MethodParameterTypesMatcher;
import net.bytebuddy.matcher.MethodParametersMatcher;
import net.bytebuddy.matcher.MethodReturnTypeMatcher;
import net.bytebuddy.matcher.MethodSortMatcher;
import net.bytebuddy.matcher.ModifierMatcher;
import net.bytebuddy.matcher.NameMatcher;
import net.bytebuddy.matcher.NegatingMatcher;
import net.bytebuddy.matcher.NullMatcher;
import net.bytebuddy.matcher.PrimitiveTypeMatcher;
import net.bytebuddy.matcher.RecordMatcher;
import net.bytebuddy.matcher.SignatureTokenMatcher;
import net.bytebuddy.matcher.StringMatcher;
import net.bytebuddy.matcher.StringSetMatcher;
import net.bytebuddy.matcher.SubTypeMatcher;
import net.bytebuddy.matcher.SuperTypeMatcher;
import net.bytebuddy.matcher.TypeSortMatcher;
import net.bytebuddy.matcher.VisibilityMatcher;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementMatchers {
    private ElementMatchers() {
        throw new UnsupportedOperationException("This class is a utility class and not supposed to be instantiated");
    }

    public static <T> ElementMatcher.Junction<T> failSafe(ElementMatcher<? super T> matcher) {
        ElementMatcher<? super T> elementMatcher;
        return new FailSafeMatcher<T>(elementMatcher, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ElementMatcher.Junction<T> cached(ElementMatcher<? super T> matcher, ConcurrentMap<? super T, Boolean> map) {
        void var1_1;
        ElementMatcher<? super T> elementMatcher;
        return new CachingMatcher<T>(elementMatcher, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ElementMatcher.Junction<T> cached(ElementMatcher<? super T> matcher, int evictionSize) {
        void var1_1;
        ElementMatcher<? super T> elementMatcher;
        if (evictionSize <= 0) {
            throw new IllegalArgumentException("Eviction size must be a positive number: " + evictionSize);
        }
        return new CachingMatcher.WithInlineEviction<T>(elementMatcher, new ConcurrentHashMap(), (int)var1_1);
    }

    public static <T> ElementMatcher.Junction<T> is(@MaybeNull Object value) {
        Object object;
        if (value == null) {
            return NullMatcher.make();
        }
        return new EqualityMatcher(object);
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> is(Field field) {
        Field field2;
        return ElementMatchers.is(new FieldDescription.ForLoadedField(field2));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> is(FieldDescription.InDefinedShape field) {
        FieldDescription.InDefinedShape inDefinedShape;
        return ElementMatchers.definedField(new EqualityMatcher(inDefinedShape));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> definedField(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        ElementMatcher<? super FieldDescription.InDefinedShape> elementMatcher;
        return new DefinedShapeMatcher(elementMatcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Method method) {
        Method method2;
        return ElementMatchers.is(new MethodDescription.ForLoadedMethod(method2));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Constructor<?> constructor) {
        Constructor<?> constructor2;
        return ElementMatchers.is(new MethodDescription.ForLoadedConstructor(constructor2));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(MethodDescription.InDefinedShape method) {
        MethodDescription.InDefinedShape inDefinedShape;
        return ElementMatchers.definedMethod(new EqualityMatcher(inDefinedShape));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> definedMethod(ElementMatcher<? super MethodDescription.InDefinedShape> matcher) {
        ElementMatcher<? super MethodDescription.InDefinedShape> elementMatcher;
        return new DefinedShapeMatcher(elementMatcher);
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> is(ParameterDescription.InDefinedShape parameter) {
        ParameterDescription.InDefinedShape inDefinedShape;
        return ElementMatchers.definedParameter(new EqualityMatcher(inDefinedShape));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> definedParameter(ElementMatcher<? super ParameterDescription.InDefinedShape> matcher) {
        ElementMatcher<? super ParameterDescription.InDefinedShape> elementMatcher;
        return new DefinedShapeMatcher(elementMatcher);
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> hasType(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasGenericType(ElementMatchers.erasure(matcher));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> hasGenericType(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return new MethodParameterTypeMatcher(elementMatcher);
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> isMandated() {
        return ModifierMatcher.of(ModifierMatcher.Mode.MANDATED);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> is(Type type) {
        return ElementMatchers.is(TypeDefinition.Sort.describe(type));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> is(Annotation annotation) {
        return ElementMatchers.is(AnnotationDescription.ForLoadedAnnotation.of(annotation));
    }

    public static <T> ElementMatcher.Junction<T> not(ElementMatcher<? super T> matcher) {
        ElementMatcher<? super T> elementMatcher;
        return new NegatingMatcher<T>(elementMatcher);
    }

    public static <T> ElementMatcher.Junction<T> any() {
        return BooleanMatcher.of(true);
    }

    public static <T> ElementMatcher.Junction<T> none() {
        return BooleanMatcher.of(false);
    }

    public static <T> ElementMatcher.Junction<T> anyOf(Object ... value) {
        return ElementMatchers.anyOf(Arrays.asList(value));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ElementMatcher.Junction<T> anyOf(Iterable<?> values) {
        void var1_1;
        Iterator<?> iterator;
        ElementMatcher.Junction<T> matcher = null;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object value = iterator.next();
            matcher = matcher == null ? ElementMatchers.is(value) : matcher.or(ElementMatchers.is(var2_2));
        }
        if (matcher == null) {
            return ElementMatchers.none();
        }
        return var1_1;
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> anyOf(Type ... value) {
        Type[] typeArray;
        return ElementMatchers.anyOf(new TypeList.Generic.ForLoadedTypes(typeArray));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Constructor<?> ... value) {
        Constructor<?>[] constructorArray;
        return ElementMatchers.definedMethod(ElementMatchers.anyOf(new MethodList.ForLoadedMethods(constructorArray, new Method[0])));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Method ... value) {
        Method[] methodArray;
        return ElementMatchers.definedMethod(ElementMatchers.anyOf(new MethodList.ForLoadedMethods(new Constructor[0], methodArray)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> anyOf(Field ... value) {
        Field[] fieldArray;
        return ElementMatchers.definedField(ElementMatchers.anyOf(new FieldList.ForLoadedFields(fieldArray)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> anyOf(Annotation ... value) {
        Annotation[] annotationArray;
        return ElementMatchers.anyOf(new AnnotationList.ForLoadedAnnotations(annotationArray));
    }

    public static <T> ElementMatcher.Junction<T> noneOf(Object ... value) {
        return ElementMatchers.noneOf(Arrays.asList(value));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ElementMatcher.Junction<T> noneOf(Iterable<?> values) {
        void var1_1;
        Iterator<?> iterator;
        ElementMatcher.Junction<T> matcher = null;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object value = iterator.next();
            matcher = matcher == null ? ElementMatchers.not(ElementMatchers.is(value)) : matcher.and(ElementMatchers.not(ElementMatchers.is(var2_2)));
        }
        if (matcher == null) {
            return ElementMatchers.any();
        }
        return var1_1;
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> noneOf(Type ... value) {
        Type[] typeArray;
        return ElementMatchers.noneOf(new TypeList.Generic.ForLoadedTypes(typeArray));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Constructor<?> ... value) {
        Constructor<?>[] constructorArray;
        return ElementMatchers.definedMethod(ElementMatchers.noneOf(new MethodList.ForLoadedMethods(constructorArray, new Method[0])));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Method ... value) {
        Method[] methodArray;
        return ElementMatchers.definedMethod(ElementMatchers.noneOf(new MethodList.ForLoadedMethods(new Constructor[0], methodArray)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> noneOf(Field ... value) {
        Field[] fieldArray;
        return ElementMatchers.definedField(ElementMatchers.noneOf(new FieldList.ForLoadedFields(fieldArray)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> noneOf(Annotation ... value) {
        Annotation[] annotationArray;
        return ElementMatchers.noneOf(new AnnotationList.ForLoadedAnnotations(annotationArray));
    }

    public static <T> ElementMatcher.Junction<Iterable<? extends T>> whereAny(ElementMatcher<? super T> matcher) {
        ElementMatcher<? super T> elementMatcher;
        return new CollectionItemMatcher<T>(elementMatcher);
    }

    public static <T> ElementMatcher.Junction<Iterable<? extends T>> whereNone(ElementMatcher<? super T> matcher) {
        return ElementMatchers.not(ElementMatchers.whereAny(matcher));
    }

    public static <T extends TypeDescription.Generic> ElementMatcher.Junction<T> erasure(Class<?> type) {
        return ElementMatchers.erasure(ElementMatchers.is(type));
    }

    public static <T extends TypeDescription.Generic> ElementMatcher.Junction<T> erasure(TypeDescription type) {
        return ElementMatchers.erasure(ElementMatchers.is(type));
    }

    public static <T extends TypeDescription.Generic> ElementMatcher.Junction<T> erasure(ElementMatcher<? super TypeDescription> matcher) {
        ElementMatcher<? super TypeDescription> elementMatcher;
        return new ErasureMatcher(elementMatcher);
    }

    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(Class<?> ... type) {
        Class<?>[] classArray;
        return ElementMatchers.erasures(new TypeList.ForLoadedTypes(classArray));
    }

    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(TypeDescription ... type) {
        return ElementMatchers.erasures(Arrays.asList(type));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(Iterable<? extends TypeDescription> types) {
        void var1_1;
        Iterator<? extends TypeDescription> iterator;
        ArrayList<ElementMatcher.Junction<T>> typeMatchers = new ArrayList<ElementMatcher.Junction<T>>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            TypeDescription type = (TypeDescription)iterator.next();
            typeMatchers.add(ElementMatchers.is(var2_2));
        }
        return ElementMatchers.erasures(new CollectionOneToOneMatcher(var1_1));
    }

    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(ElementMatcher<? super Iterable<? extends TypeDescription>> matcher) {
        ElementMatcher<? super Iterable<? extends TypeDescription>> elementMatcher;
        return new CollectionErasureMatcher(elementMatcher);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isVariable(String symbol) {
        return ElementMatchers.isVariable(ElementMatchers.named(symbol));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isVariable(ElementMatcher<? super NamedElement> matcher) {
        ElementMatcher<? super NamedElement> elementMatcher;
        return new TypeSortMatcher(ElementMatchers.anyOf(new Object[]{TypeDefinition.Sort.VARIABLE, TypeDefinition.Sort.VARIABLE_SYMBOLIC})).and(elementMatcher);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> named(String name) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedOneOf(String ... names) {
        String[] stringArray;
        return new NameMatcher(new StringSetMatcher(new HashSet<String>(Arrays.asList(stringArray))));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedIgnoreCase(String name) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.EQUALS_FULLY_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWith(String prefix) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.STARTS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWithIgnoreCase(String prefix) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.STARTS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWith(String suffix) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.ENDS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWithIgnoreCase(String suffix) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.ENDS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContains(String infix) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.CONTAINS));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContainsIgnoreCase(String infix) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.CONTAINS_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameMatches(String regex) {
        String string;
        return new NameMatcher(new StringMatcher(string, StringMatcher.Mode.MATCHES));
    }

    public static <T extends NamedElement.WithOptionalName> ElementMatcher.Junction<T> isNamed() {
        return new IsNamedMatcher();
    }

    public static <T extends NamedElement.WithDescriptor> ElementMatcher.Junction<T> hasDescriptor(String descriptor) {
        String string;
        return new DescriptorMatcher(new StringMatcher(string, StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(Class<?> type) {
        return ElementMatchers.isDeclaredBy(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(TypeDescription type) {
        return ElementMatchers.isDeclaredBy(ElementMatchers.is(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isDeclaredByGeneric(ElementMatchers.erasure(matcher));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(Type type) {
        return ElementMatchers.isDeclaredByGeneric(TypeDefinition.Sort.describe(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(TypeDescription.Generic type) {
        return ElementMatchers.isDeclaredByGeneric(ElementMatchers.is(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return new DeclaringTypeMatcher(elementMatcher);
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(Class<?> type) {
        return ElementMatchers.isVisibleTo(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(TypeDescription type) {
        TypeDescription typeDescription;
        return new VisibilityMatcher(typeDescription);
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isAccessibleTo(Class<?> type) {
        return ElementMatchers.isAccessibleTo(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isAccessibleTo(TypeDescription type) {
        TypeDescription typeDescription;
        return new AccessibilityMatcher(typeDescription);
    }

    public static <T extends ModifierReviewable.OfAbstraction> ElementMatcher.Junction<T> isAbstract() {
        return ModifierMatcher.of(ModifierMatcher.Mode.ABSTRACT);
    }

    public static <T extends ModifierReviewable.OfEnumeration> ElementMatcher.Junction<T> isEnum() {
        return ModifierMatcher.of(ModifierMatcher.Mode.ENUMERATION);
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> isAnnotatedWith(Class<? extends Annotation> type) {
        return ElementMatchers.isAnnotatedWith(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> isAnnotatedWith(TypeDescription type) {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.is(type));
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> isAnnotatedWith(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.declaresAnnotation(ElementMatchers.annotationType(matcher));
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> declaresAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        ElementMatcher<? super AnnotationDescription> elementMatcher;
        return new DeclaringAnnotationMatcher(new CollectionItemMatcher<AnnotationDescription>(elementMatcher));
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isPublic() {
        return ModifierMatcher.of(ModifierMatcher.Mode.PUBLIC);
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isProtected() {
        return ModifierMatcher.of(ModifierMatcher.Mode.PROTECTED);
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isPackagePrivate() {
        return ElementMatchers.not(ElementMatchers.isPublic().or(ElementMatchers.<T>isProtected()).or(ElementMatchers.<T>isPrivate()));
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isPrivate() {
        return ModifierMatcher.of(ModifierMatcher.Mode.PRIVATE);
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isStatic() {
        return ModifierMatcher.of(ModifierMatcher.Mode.STATIC);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isFinal() {
        return ModifierMatcher.of(ModifierMatcher.Mode.FINAL);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isSynthetic() {
        return ModifierMatcher.of(ModifierMatcher.Mode.SYNTHETIC);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isSynchronized() {
        return ModifierMatcher.of(ModifierMatcher.Mode.SYNCHRONIZED);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isNative() {
        return ModifierMatcher.of(ModifierMatcher.Mode.NATIVE);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isStrict() {
        return ModifierMatcher.of(ModifierMatcher.Mode.STRICT);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isVarArgs() {
        return ModifierMatcher.of(ModifierMatcher.Mode.VAR_ARGS);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isBridge() {
        return ModifierMatcher.of(ModifierMatcher.Mode.BRIDGE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(Type type) {
        return ElementMatchers.returnsGeneric(TypeDefinition.Sort.describe(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(TypeDescription.Generic type) {
        return ElementMatchers.returnsGeneric(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(Class<?> type) {
        return ElementMatchers.returnsGeneric(ElementMatchers.erasure(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(TypeDescription type) {
        return ElementMatchers.returns(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.returnsGeneric(ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return new MethodReturnTypeMatcher(elementMatcher);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArgument(int index, Type type) {
        void var1_1;
        return ElementMatchers.takesGenericArgument(index, TypeDefinition.Sort.describe((Type)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArgument(int index, TypeDescription.Generic type) {
        void var1_1;
        return ElementMatchers.takesGenericArgument(index, ElementMatchers.is(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArgument(int index, ElementMatcher<? super TypeDescription.Generic> matcher) {
        void var1_1;
        int n;
        return ElementMatchers.takesGenericArguments(new CollectionElementMatcher(n, var1_1));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(Type ... type) {
        Type[] typeArray;
        return ElementMatchers.takesGenericArguments(new TypeList.Generic.ForLoadedTypes(typeArray));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(TypeDefinition ... type) {
        return ElementMatchers.takesGenericArguments(Arrays.asList(type));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(List<? extends TypeDefinition> types) {
        void var1_1;
        Iterator<? extends TypeDefinition> iterator;
        ArrayList<ElementMatcher.Junction<T>> typeMatchers = new ArrayList<ElementMatcher.Junction<T>>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            TypeDefinition type = (TypeDefinition)iterator.next();
            typeMatchers.add(ElementMatchers.is(var2_2));
        }
        return ElementMatchers.takesGenericArguments(new CollectionOneToOneMatcher(var1_1));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(ElementMatcher<? super Iterable<? extends TypeDescription.Generic>> matchers) {
        ElementMatcher<? super Iterable<? extends TypeDescription.Generic>> elementMatcher;
        return new MethodParametersMatcher(new MethodParameterTypesMatcher(elementMatcher));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArgument(int index, Class<?> type) {
        void var1_1;
        return ElementMatchers.takesArgument(index, TypeDescription.ForLoadedType.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArgument(int index, TypeDescription type) {
        void var1_1;
        return ElementMatchers.takesArgument(index, ElementMatchers.is(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArgument(int index, ElementMatcher<? super TypeDescription> matcher) {
        void var1_1;
        return ElementMatchers.takesGenericArgument(index, ElementMatchers.erasure((ElementMatcher<? super TypeDescription>)var1_1));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Class<?> ... type) {
        return ElementMatchers.takesGenericArguments(ElementMatchers.erasures(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(TypeDescription ... type) {
        return ElementMatchers.takesGenericArguments(ElementMatchers.erasures(type));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Iterable<? extends TypeDescription> types) {
        void var1_1;
        Iterator<? extends TypeDescription> iterator;
        ArrayList<ElementMatcher.Junction<T>> typeMatchers = new ArrayList<ElementMatcher.Junction<T>>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            TypeDescription type = (TypeDescription)iterator.next();
            typeMatchers.add(ElementMatchers.erasure((TypeDescription)var2_2));
        }
        return ElementMatchers.takesGenericArguments(new CollectionOneToOneMatcher(var1_1));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(ElementMatcher<? super Iterable<? extends TypeDescription>> matchers) {
        ElementMatcher<? super Iterable<? extends TypeDescription>> elementMatcher;
        return new MethodParametersMatcher(new MethodParameterTypesMatcher(ElementMatchers.erasures(elementMatcher)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(int length) {
        int n;
        return new MethodParametersMatcher(new CollectionSizeMatcher(n));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesNoArguments() {
        return ElementMatchers.takesArguments(0);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasParameters(ElementMatcher<? super Iterable<? extends ParameterDescription>> matcher) {
        ElementMatcher<? super Iterable<? extends ParameterDescription>> elementMatcher;
        return new MethodParametersMatcher(elementMatcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(Class<? extends Throwable> exceptionType) {
        return ElementMatchers.canThrow(TypeDescription.ForLoadedType.of(exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(TypeDescription exceptionType) {
        TypeDescription typeDescription;
        if (exceptionType.isAssignableTo(RuntimeException.class) || exceptionType.isAssignableTo(Error.class)) {
            return BooleanMatcher.of(true);
        }
        return ElementMatchers.declaresGenericException(new CollectionItemMatcher<T>(ElementMatchers.erasure(ElementMatchers.isSuperTypeOf(typeDescription))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(Type exceptionType) {
        return ElementMatchers.declaresGenericException(TypeDefinition.Sort.describe(exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(TypeDescription.Generic exceptionType) {
        if (!exceptionType.getSort().isWildcard() && exceptionType.asErasure().isAssignableTo(Throwable.class)) {
            TypeDescription.Generic generic;
            return ElementMatchers.declaresGenericException(new CollectionItemMatcher<T>(ElementMatchers.is(generic)));
        }
        return BooleanMatcher.of(false);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresException(Class<? extends Throwable> exceptionType) {
        return ElementMatchers.declaresException(TypeDescription.ForLoadedType.of(exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresException(TypeDescription exceptionType) {
        if (exceptionType.isAssignableTo(Throwable.class)) {
            TypeDescription typeDescription;
            return ElementMatchers.declaresGenericException(new CollectionItemMatcher<T>(ElementMatchers.erasure(typeDescription)));
        }
        return BooleanMatcher.of(false);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(ElementMatcher<? super Iterable<? extends TypeDescription.Generic>> matcher) {
        ElementMatcher<? super Iterable<? extends TypeDescription.Generic>> elementMatcher;
        return new MethodExceptionTypeMatcher(elementMatcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFrom(Class<?> type) {
        return ElementMatchers.isOverriddenFrom(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFrom(TypeDescription type) {
        return ElementMatchers.isOverriddenFrom(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFrom(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isOverriddenFromGeneric(ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFromGeneric(Type type) {
        return ElementMatchers.isOverriddenFromGeneric(TypeDefinition.Sort.describe(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFromGeneric(TypeDescription.Generic type) {
        return ElementMatchers.isOverriddenFromGeneric(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFromGeneric(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return new MethodOverrideMatcher(elementMatcher);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isInterface() {
        return ModifierMatcher.of(ModifierMatcher.Mode.INTERFACE);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isAnnotation() {
        return ModifierMatcher.of(ModifierMatcher.Mode.ANNOTATION);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isMethod() {
        return MethodSortMatcher.of(MethodSortMatcher.Sort.METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isConstructor() {
        return MethodSortMatcher.of(MethodSortMatcher.Sort.CONSTRUCTOR);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isTypeInitializer() {
        return MethodSortMatcher.of(MethodSortMatcher.Sort.TYPE_INITIALIZER);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isVirtual() {
        return MethodSortMatcher.of(MethodSortMatcher.Sort.VIRTUAL);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultMethod() {
        return MethodSortMatcher.of(MethodSortMatcher.Sort.DEFAULT_METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultConstructor() {
        return ElementMatchers.isConstructor().and(ElementMatchers.<T>takesNoArguments());
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isMain() {
        return ElementMatchers.named("main").and(ElementMatchers.takesArguments(String[].class)).and(ElementMatchers.returns(TypeDescription.ForLoadedType.of(Void.TYPE)).and(ElementMatchers.<T>isStatic()).and(ElementMatchers.<T>isPublic()));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultFinalizer() {
        return ElementMatchers.isFinalizer().and(ElementMatchers.isDeclaredBy(TypeDescription.ForLoadedType.of(Object.class)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isFinalizer() {
        return ElementMatchers.named("finalize").and(ElementMatchers.<T>takesNoArguments()).and(ElementMatchers.returns(TypeDescription.ForLoadedType.of(Void.TYPE)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isHashCode() {
        return ElementMatchers.named("hashCode").and(ElementMatchers.<T>takesNoArguments()).and(ElementMatchers.returns(Integer.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isEquals() {
        return ElementMatchers.named("equals").and(ElementMatchers.takesArguments(TypeDescription.ForLoadedType.of(Object.class))).and(ElementMatchers.returns(Boolean.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isClone() {
        return ElementMatchers.named("clone").and(ElementMatchers.<T>takesNoArguments());
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isToString() {
        return ElementMatchers.named("toString").and(ElementMatchers.<T>takesNoArguments()).and(ElementMatchers.returns(TypeDescription.ForLoadedType.of(String.class)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter() {
        return ElementMatchers.nameStartsWith("set").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.returns(TypeDescription.ForLoadedType.of(Void.TYPE)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(String property) {
        String string;
        return ElementMatchers.isSetter().and(property.length() == 0 ? ElementMatchers.named("set") : ElementMatchers.named("set" + Character.toUpperCase(property.charAt(0)) + string.substring(1)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(Class<?> type) {
        return ElementMatchers.isSetter(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericSetter(Type type) {
        return ElementMatchers.isGenericSetter(TypeDefinition.Sort.describe(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(TypeDescription type) {
        return ElementMatchers.isSetter(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericSetter(TypeDescription.Generic type) {
        return ElementMatchers.isGenericSetter(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isGenericSetter(ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericSetter(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return ElementMatchers.isSetter().and(ElementMatchers.takesGenericArguments(new CollectionOneToOneMatcher<TypeDescription.Generic>(Collections.singletonList(elementMatcher))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter() {
        return ElementMatchers.takesNoArguments().and(ElementMatchers.not(ElementMatchers.returns(TypeDescription.ForLoadedType.of(Void.TYPE)))).and(ElementMatchers.nameStartsWith("get").or(ElementMatchers.nameStartsWith("is").and(ElementMatchers.returnsGeneric(ElementMatchers.anyOf(new Type[]{Boolean.TYPE, Boolean.class})))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(String property) {
        String string;
        return ElementMatchers.isGetter().and(property.length() == 0 ? ElementMatchers.named("get").or(ElementMatchers.named("is")) : ElementMatchers.named("get" + Character.toUpperCase(property.charAt(0)) + property.substring(1)).or(ElementMatchers.named("is" + Character.toUpperCase(property.charAt(0)) + string.substring(1))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(Class<?> type) {
        return ElementMatchers.isGetter(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericGetter(Type type) {
        return ElementMatchers.isGenericGetter(TypeDefinition.Sort.describe(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(TypeDescription type) {
        return ElementMatchers.isGetter(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericGetter(TypeDescription.Generic type) {
        return ElementMatchers.isGenericGetter(ElementMatchers.is(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isGenericGetter(ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericGetter(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return ElementMatchers.isGetter().and(ElementMatchers.returnsGeneric(elementMatcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasMethodName(String internalName) {
        String string;
        if ("<init>".equals(internalName)) {
            return ElementMatchers.isConstructor();
        }
        if ("<clinit>".equals(internalName)) {
            return ElementMatchers.isTypeInitializer();
        }
        return ElementMatchers.named(string);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasSignature(MethodDescription.SignatureToken token) {
        MethodDescription.SignatureToken signatureToken;
        return new SignatureTokenMatcher(ElementMatchers.is(signatureToken));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(Class<?> type) {
        return ElementMatchers.isSubTypeOf(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(TypeDescription type) {
        TypeDescription typeDescription;
        return new SubTypeMatcher(typeDescription);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(Class<?> type) {
        return ElementMatchers.isSuperTypeOf(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(TypeDescription type) {
        TypeDescription typeDescription;
        return new SuperTypeMatcher(typeDescription);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasSuperClass(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasGenericSuperClass(ElementMatchers.erasure(matcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasGenericSuperClass(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return new HasSuperClassMatcher(elementMatcher);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasSuperType(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasGenericSuperType(ElementMatchers.erasure(matcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasGenericSuperType(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return new HasSuperTypeMatcher(elementMatcher);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(Class<?> type) {
        return ElementMatchers.inheritsAnnotation(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(TypeDescription type) {
        return ElementMatchers.inheritsAnnotation(ElementMatchers.is(type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasAnnotation(ElementMatchers.annotationType(matcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        ElementMatcher<? super AnnotationDescription> elementMatcher;
        return new InheritedAnnotationMatcher(new CollectionItemMatcher<AnnotationDescription>(elementMatcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasClassFileVersionAtLeast(ClassFileVersion classFileVersion) {
        ClassFileVersion classFileVersion2;
        return new ClassFileVersionMatcher(classFileVersion2, false);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasClassFileVersionAtMost(ClassFileVersion classFileVersion) {
        ClassFileVersion classFileVersion2;
        return new ClassFileVersionMatcher(classFileVersion2, true);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> declaresField(ElementMatcher<? super FieldDescription> matcher) {
        ElementMatcher<? super FieldDescription> elementMatcher;
        return new DeclaringFieldMatcher(new CollectionItemMatcher<FieldDescription>(elementMatcher));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> declaresMethod(ElementMatcher<? super MethodDescription> matcher) {
        ElementMatcher<? super MethodDescription> elementMatcher;
        return new DeclaringMethodMatcher(new CollectionItemMatcher<MethodDescription>(elementMatcher));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> ofSort(TypeDefinition.Sort sort) {
        return ElementMatchers.ofSort(ElementMatchers.is((Object)sort));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> ofSort(ElementMatcher<? super TypeDefinition.Sort> matcher) {
        ElementMatcher<? super TypeDefinition.Sort> elementMatcher;
        return new TypeSortMatcher(elementMatcher);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isPrimitive() {
        return new PrimitiveTypeMatcher();
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isArray() {
        return new ArrayTypeMatcher();
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isRecord() {
        return new RecordMatcher();
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(Type fieldType) {
        return ElementMatchers.genericFieldType(TypeDefinition.Sort.describe(fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(TypeDescription.Generic fieldType) {
        return ElementMatchers.genericFieldType(ElementMatchers.is(fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(ElementMatcher<? super TypeDescription.Generic> matcher) {
        ElementMatcher<? super TypeDescription.Generic> elementMatcher;
        return new FieldTypeMatcher(elementMatcher);
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(Class<?> fieldType) {
        return ElementMatchers.fieldType(TypeDescription.ForLoadedType.of(fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(TypeDescription fieldType) {
        return ElementMatchers.fieldType(ElementMatchers.is(fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.genericFieldType(ElementMatchers.erasure(matcher));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> isVolatile() {
        return ModifierMatcher.of(ModifierMatcher.Mode.VOLATILE);
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> isTransient() {
        return ModifierMatcher.of(ModifierMatcher.Mode.TRANSIENT);
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> annotationType(Class<? extends Annotation> type) {
        return ElementMatchers.annotationType(TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> annotationType(TypeDescription type) {
        return ElementMatchers.annotationType(ElementMatchers.is(type));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> annotationType(ElementMatcher<? super TypeDescription> matcher) {
        ElementMatcher<? super TypeDescription> elementMatcher;
        return new AnnotationTypeMatcher(elementMatcher);
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> targetsElement(ElementType elementType) {
        ElementType elementType2;
        return new AnnotationTargetMatcher(elementType2);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isBootstrapClassLoader() {
        return NullMatcher.make();
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isSystemClassLoader() {
        return new EqualityMatcher(ClassLoader.getSystemClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends ClassLoader> ElementMatcher.Junction<T> isExtensionClassLoader() {
        void var0;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader().getParent();
        if (classLoader == null) {
            return ElementMatchers.none();
        }
        return new EqualityMatcher(var0);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isChildOf(@MaybeNull ClassLoader classLoader) {
        ClassLoader classLoader2;
        if (classLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
            return BooleanMatcher.of(true);
        }
        return ElementMatchers.hasChild(ElementMatchers.is(classLoader2));
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> hasChild(ElementMatcher<? super ClassLoader> matcher) {
        ElementMatcher<? super ClassLoader> elementMatcher;
        return new ClassLoaderHierarchyMatcher(elementMatcher);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isParentOf(@MaybeNull ClassLoader classLoader) {
        ClassLoader classLoader2;
        if (classLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
            return ElementMatchers.isBootstrapClassLoader();
        }
        return new ClassLoaderParentMatcher(classLoader2);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> ofType(ElementMatcher<? super TypeDescription> matcher) {
        ElementMatcher<? super TypeDescription> elementMatcher;
        return new InstanceTypeMatcher(elementMatcher);
    }

    public static <T extends JavaModule> ElementMatcher.Junction<T> supportsModules() {
        return ElementMatchers.not(NullMatcher.make());
    }
}

