/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.SafeVarargsPlugin;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.nullability.UnknownNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ElementMatcher<T> {
    public boolean matches(@UnknownNull T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Junction<S>
    extends ElementMatcher<S> {
        public <U extends S> Junction<U> and(ElementMatcher<? super U> var1);

        public <U extends S> Junction<U> or(ElementMatcher<? super U> var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static abstract class ForNonNullValues<W>
        extends AbstractBase<W> {
            /*
             * WARNING - void declaration
             */
            @Override
            public boolean matches(@MaybeNull W target) {
                void var1_1;
                return target != null && this.doMatch(var1_1);
            }

            protected abstract boolean doMatch(W var1);

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                return this.getClass() == object.getClass();
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Disjunction<W>
        extends AbstractBase<W> {
            private final List<ElementMatcher<? super W>> matchers;

            /*
             * WARNING - void declaration
             */
            @SafeVarargsPlugin.Enhance
            @SafeVarargs
            public Disjunction(ElementMatcher<? super W> ... matcher) {
                this(Arrays.asList(var1_1));
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Disjunction(List<ElementMatcher<? super W>> matchers) {
                Iterator iterator;
                this.matchers = new ArrayList<ElementMatcher<? super W>>(matchers.size());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var2_2;
                    ElementMatcher matcher = (ElementMatcher)iterator.next();
                    if (matcher instanceof Disjunction) {
                        this.matchers.addAll(((Disjunction)matcher).matchers);
                        continue;
                    }
                    this.matchers.add((ElementMatcher<W>)var2_2);
                }
            }

            @Override
            public boolean matches(@UnknownNull W target) {
                for (ElementMatcher<W> elementMatcher : this.matchers) {
                    if (!elementMatcher.matches(target)) continue;
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public String toString() {
                void var1_1;
                StringBuilder stringBuilder = new StringBuilder("(");
                boolean first = true;
                for (ElementMatcher<? super W> elementMatcher : this.matchers) {
                    if (first) {
                        first = false;
                    } else {
                        stringBuilder.append(" or ");
                    }
                    stringBuilder.append(elementMatcher);
                }
                return var1_1.append(")").toString();
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.matchers).equals(((Disjunction)object).matchers);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + ((Object)this.matchers).hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Conjunction<W>
        extends AbstractBase<W> {
            private final List<ElementMatcher<? super W>> matchers;

            /*
             * WARNING - void declaration
             */
            @SafeVarargsPlugin.Enhance
            @SafeVarargs
            public Conjunction(ElementMatcher<? super W> ... matcher) {
                this(Arrays.asList(var1_1));
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Conjunction(List<ElementMatcher<? super W>> matchers) {
                Iterator iterator;
                this.matchers = new ArrayList<ElementMatcher<? super W>>(matchers.size());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var2_2;
                    ElementMatcher matcher = (ElementMatcher)iterator.next();
                    if (matcher instanceof Conjunction) {
                        this.matchers.addAll(((Conjunction)matcher).matchers);
                        continue;
                    }
                    this.matchers.add((ElementMatcher<W>)var2_2);
                }
            }

            @Override
            public boolean matches(@UnknownNull W target) {
                for (ElementMatcher<W> elementMatcher : this.matchers) {
                    if (elementMatcher.matches(target)) continue;
                    return false;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public String toString() {
                void var1_1;
                StringBuilder stringBuilder = new StringBuilder("(");
                boolean first = true;
                for (ElementMatcher<? super W> elementMatcher : this.matchers) {
                    if (first) {
                        first = false;
                    } else {
                        stringBuilder.append(" and ");
                    }
                    stringBuilder.append(elementMatcher);
                }
                return var1_1.append(")").toString();
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.matchers).equals(((Conjunction)object).matchers);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + ((Object)this.matchers).hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class AbstractBase<V>
        implements Junction<V> {
            /*
             * WARNING - void declaration
             */
            @Override
            public <U extends V> Junction<U> and(ElementMatcher<? super U> other) {
                void var1_1;
                return new Conjunction(new ElementMatcher[]{this, var1_1});
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <U extends V> Junction<U> or(ElementMatcher<? super U> other) {
                void var1_1;
                return new Disjunction(new ElementMatcher[]{this, var1_1});
            }
        }
    }
}

