/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance(permitSubclassEquality=true)
public class CachingMatcher<T>
extends ElementMatcher.Junction.AbstractBase<T> {
    private static final Object NULL_VALUE = new Object();
    private final ElementMatcher<? super T> matcher;
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    protected final ConcurrentMap<? super T, Boolean> map;

    /*
     * WARNING - void declaration
     */
    public CachingMatcher(ElementMatcher<? super T> matcher, ConcurrentMap<? super T, Boolean> map) {
        void var2_2;
        void var1_1;
        this.matcher = var1_1;
        this.map = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean matches(@MaybeNull T target) {
        void var2_2;
        Boolean cached = (Boolean)this.map.get(target == null ? NULL_VALUE : target);
        if (cached == null) {
            void var1_1;
            cached = this.onCacheMiss(var1_1);
        }
        return var2_2.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean onCacheMiss(@MaybeNull T target) {
        void var2_2;
        void var1_1;
        boolean cached = this.matcher.matches(target);
        this.map.put(target == null ? NULL_VALUE : var1_1, cached);
        return (boolean)var2_2;
    }

    public String toString() {
        return "cached(" + this.matcher + ")";
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CachingMatcher)) {
            return false;
        }
        return this.matcher.equals(((CachingMatcher)object).matcher);
    }

    public int hashCode() {
        return CachingMatcher.class.hashCode() * 31 + this.matcher.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Equality does not consider eviction size.")
    public static class WithInlineEviction<S>
    extends CachingMatcher<S> {
        private final int evictionSize;

        /*
         * WARNING - void declaration
         */
        public WithInlineEviction(ElementMatcher<? super S> matcher, ConcurrentMap<? super S, Boolean> map, int evictionSize) {
            super(var1_1, var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.evictionSize = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean onCacheMiss(@MaybeNull S target) {
            void var1_1;
            if (this.map.size() >= this.evictionSize) {
                void var2_2;
                Iterator iterator = this.map.entrySet().iterator();
                iterator.next();
                var2_2.remove();
            }
            return super.onCacheMiss(var1_1);
        }
    }
}

