/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.jar.asm.commons;

import net.bytebuddy.jar.asm.ConstantDynamic;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.commons.SignatureRemapper;
import net.bytebuddy.jar.asm.signature.SignatureReader;
import net.bytebuddy.jar.asm.signature.SignatureVisitor;
import net.bytebuddy.jar.asm.signature.SignatureWriter;

public abstract class Remapper {
    /*
     * WARNING - void declaration
     */
    public String mapDesc(String descriptor) {
        void var1_1;
        return this.mapType(Type.getType((String)var1_1)).getDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    private Type mapType(Type type) {
        void var1_1;
        switch (type.getSort()) {
            case 9: {
                void var2_2;
                StringBuilder remappedDescriptor = new StringBuilder();
                for (int i = 0; i < type.getDimensions(); ++i) {
                    remappedDescriptor.append('[');
                }
                remappedDescriptor.append(this.mapType(type.getElementType()).getDescriptor());
                return Type.getType(var2_2.toString());
            }
            case 10: {
                String remappedInternalName = this.map(type.getInternalName());
                if (remappedInternalName != null) {
                    void var3_4;
                    return Type.getObjectType((String)var3_4);
                }
                return type;
            }
            case 11: {
                return Type.getMethodType(this.mapMethodDesc(type.getDescriptor()));
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String mapType(String internalName) {
        void var1_1;
        if (internalName == null) {
            return null;
        }
        return this.mapType(Type.getObjectType((String)var1_1)).getInternalName();
    }

    /*
     * WARNING - void declaration
     */
    public String[] mapTypes(String[] internalNames) {
        void var1_1;
        String[] remappedInternalNames = null;
        for (int i = 0; i < internalNames.length; ++i) {
            String internalName = internalNames[i];
            String remappedInternalName = this.mapType(internalName);
            if (remappedInternalName == null) continue;
            if (remappedInternalNames == null) {
                remappedInternalNames = (String[])internalNames.clone();
            }
            remappedInternalNames[i] = remappedInternalName;
        }
        if (remappedInternalNames != null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String mapMethodDesc(String methodDescriptor) {
        void var2_2;
        void var1_1;
        if ("()V".equals(methodDescriptor)) {
            return methodDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        Type[] typeArray = Type.getArgumentTypes(methodDescriptor);
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type argumentType = typeArray[i];
            stringBuilder.append(this.mapType(argumentType).getDescriptor());
        }
        Type returnType = Type.getReturnType((String)var1_1);
        if (returnType == Type.VOID_TYPE) {
            stringBuilder.append(")V");
        } else {
            stringBuilder.append(')').append(this.mapType((Type)typeArray).getDescriptor());
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Object mapValue(Object value) {
        void var1_1;
        Handle handle;
        if (value instanceof Type) {
            return this.mapType((Type)value);
        }
        if (value instanceof Handle) {
            handle = (Handle)value;
            boolean isFieldHandle = handle.getTag() <= 4;
            return new Handle(handle.getTag(), this.mapType(handle.getOwner()), isFieldHandle ? this.mapFieldName(handle.getOwner(), handle.getName(), handle.getDesc()) : this.mapMethodName(handle.getOwner(), handle.getName(), handle.getDesc()), isFieldHandle ? this.mapDesc(handle.getDesc()) : this.mapMethodDesc(handle.getDesc()), handle.isInterface());
        }
        if (handle instanceof ConstantDynamic) {
            void var3_4;
            ConstantDynamic constantDynamic = (ConstantDynamic)((Object)handle);
            int bootstrapMethodArgumentCount = constantDynamic.getBootstrapMethodArgumentCount();
            Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArgumentCount];
            for (int i = 0; i < bootstrapMethodArgumentCount; ++i) {
                remappedBootstrapMethodArguments[i] = this.mapValue(constantDynamic.getBootstrapMethodArgument(i));
            }
            String descriptor = constantDynamic.getDescriptor();
            return new ConstantDynamic(this.mapInvokeDynamicMethodName(constantDynamic.getName(), descriptor), this.mapDesc(descriptor), (Handle)this.mapValue(var1_1.getBootstrapMethod()), (Object[])var3_4);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String mapSignature(String signature, boolean typeSignature) {
        void var3_3;
        void var2_2;
        if (signature == null) {
            return null;
        }
        SignatureReader signatureReader = new SignatureReader(signature);
        SignatureWriter signatureWriter = new SignatureWriter();
        SignatureVisitor signatureRemapper = this.createSignatureRemapper(signatureWriter);
        if (var2_2 != false) {
            signatureReader.acceptType(signatureRemapper);
        } else {
            void var1_1;
            var1_1.accept(signatureRemapper);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor signatureVisitor) {
        void var1_1;
        return this.createSignatureRemapper((SignatureVisitor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected SignatureVisitor createSignatureRemapper(SignatureVisitor signatureVisitor) {
        void var1_1;
        return new SignatureRemapper((SignatureVisitor)var1_1, this);
    }

    public String mapAnnotationAttributeName(String descriptor, String name) {
        return name;
    }

    /*
     * WARNING - void declaration
     */
    public String mapInnerClassName(String name, String ownerName, String innerName) {
        void var3_3;
        void var1_1;
        String remappedInnerName = this.mapType(name);
        if (remappedInnerName.equals(name)) {
            return innerName;
        }
        int originSplit = name.lastIndexOf(47);
        int remappedSplit = remappedInnerName.lastIndexOf(47);
        if (originSplit != -1 && remappedSplit != -1 && var1_1.substring(originSplit).equals(remappedInnerName.substring(remappedSplit))) {
            return innerName;
        }
        if (remappedInnerName.contains("$")) {
            void var2_2;
            int index;
            for (index = remappedInnerName.lastIndexOf(36) + 1; index < remappedInnerName.length() && Character.isDigit(remappedInnerName.charAt(index)); ++index) {
            }
            return var2_2.substring(index);
        }
        return var3_3;
    }

    public String mapMethodName(String owner, String name, String descriptor) {
        return name;
    }

    public String mapInvokeDynamicMethodName(String name, String descriptor) {
        return name;
    }

    public String mapRecordComponentName(String owner, String name, String descriptor) {
        return name;
    }

    public String mapFieldName(String owner, String name, String descriptor) {
        return name;
    }

    public String mapPackageName(String name) {
        return name;
    }

    public String mapModuleName(String name) {
        return name;
    }

    public String map(String internalName) {
        return internalName;
    }
}

