/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.jar.asm;

import net.bytebuddy.jar.asm.ByteVector;

public final class TypePath {
    public static final int ARRAY_ELEMENT = 0;
    public static final int INNER_TYPE = 1;
    public static final int WILDCARD_BOUND = 2;
    public static final int TYPE_ARGUMENT = 3;
    private final byte[] typePathContainer;
    private final int typePathOffset;

    /*
     * WARNING - void declaration
     */
    TypePath(byte[] typePathContainer, int typePathOffset) {
        void var2_2;
        void var1_1;
        this.typePathContainer = var1_1;
        this.typePathOffset = var2_2;
    }

    public final int getLength() {
        return this.typePathContainer[this.typePathOffset];
    }

    /*
     * WARNING - void declaration
     */
    public final int getStep(int index) {
        void var1_1;
        return this.typePathContainer[this.typePathOffset + 2 * var1_1 + 1];
    }

    /*
     * WARNING - void declaration
     */
    public final int getStepArgument(int index) {
        void var1_1;
        return this.typePathContainer[this.typePathOffset + 2 * var1_1 + 2];
    }

    /*
     * WARNING - void declaration
     */
    public static TypePath fromString(String typePath) {
        void var2_2;
        if (typePath == null || typePath.length() == 0) {
            return null;
        }
        int typePathLength = typePath.length();
        ByteVector output = new ByteVector(typePathLength);
        output.putByte(0);
        int typePathIndex = 0;
        while (typePathIndex < typePathLength) {
            char c;
            if ((c = typePath.charAt(typePathIndex++)) == '[') {
                output.put11(0, 0);
                continue;
            }
            if (c == '.') {
                output.put11(1, 0);
                continue;
            }
            if (c == '*') {
                output.put11(2, 0);
                continue;
            }
            if (c >= '0' && c <= '9') {
                int typeArg = c - 48;
                while (typePathIndex < typePathLength) {
                    if ((c = typePath.charAt(typePathIndex++)) >= '0' && c <= '9') {
                        typeArg = typeArg * 10 + c - 48;
                        continue;
                    }
                    if (c == ';') break;
                    throw new IllegalArgumentException();
                }
                output.put11(3, typeArg);
                continue;
            }
            throw new IllegalArgumentException();
        }
        output.data[0] = (byte)(output.length / 2);
        return new TypePath(var2_2.data, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        int length = this.getLength();
        StringBuilder result = new StringBuilder(length << 1);
        block6: for (int i = 0; i < length; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    result.append('[');
                    continue block6;
                }
                case 1: {
                    result.append('.');
                    continue block6;
                }
                case 2: {
                    result.append('*');
                    continue block6;
                }
                case 3: {
                    result.append(this.getStepArgument(i)).append(';');
                    continue block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static void put(TypePath typePath, ByteVector output) {
        void var2_2;
        TypePath typePath2;
        void var1_1;
        if (typePath == null) {
            output.putByte(0);
            return;
        }
        int length = (typePath.typePathContainer[typePath.typePathOffset] << 1) + 1;
        var1_1.putByteArray(typePath.typePathContainer, typePath2.typePathOffset, (int)var2_2);
    }
}

