/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.jar.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final int METHOD = 11;
    private static final int INTERNAL = 12;
    private static final String PRIMITIVE_DESCRIPTORS = "VZCBSIFJD";
    public static final Type VOID_TYPE = new Type(0, "VZCBSIFJD", 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, "VZCBSIFJD", 1, 2);
    public static final Type CHAR_TYPE = new Type(2, "VZCBSIFJD", 2, 3);
    public static final Type BYTE_TYPE = new Type(3, "VZCBSIFJD", 3, 4);
    public static final Type SHORT_TYPE = new Type(4, "VZCBSIFJD", 4, 5);
    public static final Type INT_TYPE = new Type(5, "VZCBSIFJD", 5, 6);
    public static final Type FLOAT_TYPE = new Type(6, "VZCBSIFJD", 6, 7);
    public static final Type LONG_TYPE = new Type(7, "VZCBSIFJD", 7, 8);
    public static final Type DOUBLE_TYPE = new Type(8, "VZCBSIFJD", 8, 9);
    private final int sort;
    private final String valueBuffer;
    private final int valueBegin;
    private final int valueEnd;

    /*
     * WARNING - void declaration
     */
    private Type(int sort, String valueBuffer, int valueBegin, int valueEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.sort = var1_1;
        this.valueBuffer = var2_2;
        this.valueBegin = var3_3;
        this.valueEnd = valueEnd;
    }

    public static Type getType(String typeDescriptor) {
        String string;
        return Type.getTypeInternal(typeDescriptor, 0, string.length());
    }

    public static Type getType(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            if (clazz == Long.TYPE) {
                return LONG_TYPE;
            }
            throw new AssertionError();
        }
        return Type.getType(Type.getDescriptor(clazz2));
    }

    public static Type getType(Constructor<?> constructor) {
        return Type.getType(Type.getConstructorDescriptor(constructor));
    }

    public static Type getType(Method method) {
        return Type.getType(Type.getMethodDescriptor(method));
    }

    /*
     * WARNING - void declaration
     */
    public final Type getElementType() {
        void var1_1;
        int numDimensions = this.getDimensions();
        return Type.getTypeInternal(this.valueBuffer, this.valueBegin + var1_1, this.valueEnd);
    }

    public static Type getObjectType(String internalName) {
        String string;
        return new Type(internalName.charAt(0) == '[' ? 9 : 12, internalName, 0, string.length());
    }

    public static Type getMethodType(String methodDescriptor) {
        String string;
        return new Type(11, methodDescriptor, 0, string.length());
    }

    /*
     * WARNING - void declaration
     */
    public static Type getMethodType(Type returnType, Type ... argumentTypes) {
        void var1_1;
        return Type.getType(Type.getMethodDescriptor(returnType, (Type[])var1_1));
    }

    public final Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    public static Type[] getArgumentTypes(String methodDescriptor) {
        void var1_2;
        int n = Type.getArgumentCount(methodDescriptor);
        Type[] argumentTypes = new Type[n];
        int currentOffset = 1;
        int currentArgumentTypeIndex = 0;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            int currentArgumentTypeOffset = currentOffset;
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            argumentTypes[currentArgumentTypeIndex++] = Type.getTypeInternal(methodDescriptor, currentArgumentTypeOffset, currentOffset);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Type[] getArgumentTypes(Method method) {
        void var1_1;
        Class<?>[] classes = method.getParameterTypes();
        Type[] types = new Type[classes.length];
        for (int i = classes.length - 1; i >= 0; --i) {
            types[i] = Type.getType(classes[i]);
        }
        return var1_1;
    }

    public final Type getReturnType() {
        return Type.getReturnType(this.getDescriptor());
    }

    public static Type getReturnType(String methodDescriptor) {
        String string;
        String string2 = methodDescriptor;
        return Type.getTypeInternal(string2, Type.getReturnTypeOffset(string2), string.length());
    }

    public static Type getReturnType(Method method) {
        return Type.getType(method.getReturnType());
    }

    /*
     * WARNING - void declaration
     */
    static int getReturnTypeOffset(String methodDescriptor) {
        void var1_1;
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            void var2_2;
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) != 'L') continue;
            int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
            currentOffset = Math.max(currentOffset, (int)(var2_2 + true));
        }
        return (int)(var1_1 + true);
    }

    /*
     * WARNING - void declaration
     */
    private static Type getTypeInternal(String descriptorBuffer, int descriptorBegin, int descriptorEnd) {
        String string;
        switch (descriptorBuffer.charAt(descriptorBegin)) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                return new Type(9, descriptorBuffer, descriptorBegin, descriptorEnd);
            }
            case 'L': {
                return new Type(10, descriptorBuffer, descriptorBegin + 1, descriptorEnd - 1);
            }
            case '(': {
                void var2_2;
                void var1_1;
                return new Type(11, descriptorBuffer, (int)var1_1, (int)var2_2);
            }
        }
        throw new IllegalArgumentException(Type.stringConcat$0(string));
    }

    private static /* synthetic */ String stringConcat$0(String string) {
        return "Invalid descriptor: " + string;
    }

    /*
     * WARNING - void declaration
     */
    public final String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                void var1_1;
                StringBuilder stringBuilder = new StringBuilder(this.getElementType().getClassName());
                for (int i = this.getDimensions(); i > 0; --i) {
                    stringBuilder.append("[]");
                }
                return var1_1.toString();
            }
            case 10: 
            case 12: {
                return this.valueBuffer.substring(this.valueBegin, this.valueEnd).replace('/', '.');
            }
        }
        throw new AssertionError();
    }

    public final String getInternalName() {
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public final String getDescriptor() {
        if (this.sort == 10) {
            return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
        }
        if (this.sort == 12) {
            return Type.stringConcat$1(this.valueBuffer.substring(this.valueBegin, this.valueEnd));
        }
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    private static /* synthetic */ String stringConcat$1(String string) {
        return "L" + string + ";";
    }

    /*
     * WARNING - void declaration
     */
    public static String getDescriptor(Class<?> clazz) {
        void var1_1;
        Class<?> clazz2;
        StringBuilder stringBuilder = new StringBuilder();
        Type.appendDescriptor(clazz2, stringBuilder);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getConstructorDescriptor(Constructor<?> constructor) {
        void var1_1;
        Class<?>[] classArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        Class<?>[] classArray2 = classArray.getParameterTypes();
        classArray = classArray2;
        classArray = classArray2;
        int n = classArray2.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz = classArray[i];
            Type.appendDescriptor(clazz, stringBuilder);
        }
        return var1_1.append(")V").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getMethodDescriptor(Type returnType, Type ... argumentTypes) {
        void var2_2;
        Type type;
        void var1_1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (void var5_5 : var1_1) {
            var5_5.appendDescriptor(stringBuilder);
        }
        stringBuilder.append(')');
        type.appendDescriptor(stringBuilder);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getMethodDescriptor(Method method) {
        void var1_1;
        Method method2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        Class<?>[] classArray2 = classArray;
        classArray2 = classArray;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz = classArray2[i];
            Type.appendDescriptor(clazz, stringBuilder);
        }
        stringBuilder.append(')');
        Type.appendDescriptor(method2.getReturnType(), stringBuilder);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void appendDescriptor(StringBuilder stringBuilder) {
        void var1_1;
        if (this.sort == 10) {
            stringBuilder.append(this.valueBuffer, this.valueBegin - 1, this.valueEnd + 1);
            return;
        }
        if (this.sort == 12) {
            stringBuilder.append('L').append(this.valueBuffer, this.valueBegin, this.valueEnd).append(';');
            return;
        }
        var1_1.append(this.valueBuffer, this.valueBegin, this.valueEnd);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> clazz2;
        void var1_2;
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append('[');
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            void var0_1;
            Class<?> descriptor2;
            int descriptor2;
            if (currentClass == Integer.TYPE) {
                descriptor2 = 73;
            } else if (descriptor2 == Void.TYPE) {
                descriptor2 = 86;
            } else if (descriptor2 == Boolean.TYPE) {
                descriptor2 = 90;
            } else if (descriptor2 == Byte.TYPE) {
                descriptor2 = 66;
            } else if (descriptor2 == Character.TYPE) {
                descriptor2 = 67;
            } else if (descriptor2 == Short.TYPE) {
                descriptor2 = 83;
            } else if (descriptor2 == Double.TYPE) {
                descriptor2 = 68;
            } else if (descriptor2 == Float.TYPE) {
                descriptor2 = 70;
            } else if (descriptor2 == Long.TYPE) {
                descriptor2 = 74;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)var0_1);
            return;
        }
        var1_2.append('L').append(Type.getInternalName(clazz2)).append(';');
    }

    public final int getSort() {
        if (this.sort == 12) {
            return 10;
        }
        return this.sort;
    }

    /*
     * WARNING - void declaration
     */
    public final int getDimensions() {
        void var1_1;
        int numDimensions = 1;
        while (this.valueBuffer.charAt(this.valueBegin + numDimensions) == '[') {
            ++numDimensions;
        }
        return (int)var1_1;
    }

    public final int getSize() {
        switch (this.sort) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                return 1;
            }
            case 7: 
            case 8: {
                return 2;
            }
        }
        throw new AssertionError();
    }

    public final int getArgumentCount() {
        return Type.getArgumentCount(this.getDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    public static int getArgumentCount(String methodDescriptor) {
        void var1_1;
        int argumentCount = 0;
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                void var3_3;
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, (int)(var3_3 + true));
            }
            ++argumentCount;
        }
        return (int)var1_1;
    }

    public final int getArgumentsAndReturnSizes() {
        return Type.getArgumentsAndReturnSizes(this.getDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    public static int getArgumentsAndReturnSizes(String methodDescriptor) {
        void var3_3;
        void var1_1;
        void var2_2;
        String string;
        int semiColumnOffset;
        int argumentsSize = 1;
        int currentOffset = 1;
        char currentChar = methodDescriptor.charAt(1);
        while (currentChar != ')') {
            if (currentChar == 'J' || currentChar == 'D') {
                ++currentOffset;
                argumentsSize += 2;
            } else {
                while (methodDescriptor.charAt(currentOffset) == '[') {
                    ++currentOffset;
                }
                if (methodDescriptor.charAt(currentOffset++) == 'L') {
                    semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                    currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
                }
                ++argumentsSize;
            }
            semiColumnOffset = methodDescriptor.charAt(currentOffset);
        }
        semiColumnOffset = string.charAt((int)(var2_2 + true));
        if (semiColumnOffset == 86) {
            return argumentsSize << 2;
        }
        int returnSize = semiColumnOffset == 74 || semiColumnOffset == 68 ? 2 : 1;
        return var1_1 << 2 | var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final int getOpcode(int opcode) {
        if (opcode == 46 || opcode == 79) {
            switch (this.sort) {
                case 1: 
                case 3: {
                    return opcode + 5;
                }
                case 2: {
                    return opcode + 6;
                }
                case 4: {
                    return opcode + 7;
                }
                case 5: {
                    return opcode;
                }
                case 6: {
                    return opcode + 2;
                }
                case 7: {
                    return opcode + 1;
                }
                case 8: {
                    return opcode + 3;
                }
                case 9: 
                case 10: 
                case 12: {
                    return opcode + 4;
                }
                case 0: 
                case 11: {
                    throw new UnsupportedOperationException();
                }
            }
            throw new AssertionError();
        }
        switch (this.sort) {
            case 0: {
                if (opcode != 172) {
                    throw new UnsupportedOperationException();
                }
                return 177;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return opcode;
            }
            case 6: {
                return opcode + 2;
            }
            case 7: {
                return opcode + 1;
            }
            case 8: {
                return opcode + 3;
            }
            case 9: 
            case 10: 
            case 12: {
                void var1_1;
                if (opcode != 21 && opcode != 54 && opcode != 172) {
                    throw new UnsupportedOperationException();
                }
                return (int)(var1_1 + 4);
            }
            case 11: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        void i;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type other = (Type)object;
        if ((this.sort == 12 ? 10 : this.sort) != (other.sort == 12 ? 10 : other.sort)) {
            return false;
        }
        int end = this.valueEnd;
        int begin = this.valueBegin;
        int otherEnd = other.valueEnd;
        int otherBegin = other.valueBegin;
        if (end - begin != otherEnd - otherBegin) {
            return false;
        }
        int j = otherBegin;
        while (i < end) {
            if (this.valueBuffer.charAt((int)i) != other.valueBuffer.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int hashCode = 13 * (this.sort == 12 ? 10 : this.sort);
        if (this.sort >= 9) {
            int end = this.valueEnd;
            for (int i = this.valueBegin; i < end; ++i) {
                hashCode = 17 * (hashCode + this.valueBuffer.charAt(i));
            }
        }
        return (int)var1_1;
    }

    public final String toString() {
        return this.getDescriptor();
    }
}

