/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.member;

import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MethodVariableAccess {
    INTEGER(21, 54, StackSize.SINGLE),
    LONG(22, 55, StackSize.DOUBLE),
    FLOAT(23, 56, StackSize.SINGLE),
    DOUBLE(24, 57, StackSize.DOUBLE),
    REFERENCE(25, 58, StackSize.SINGLE);

    private final int loadOpcode;
    private final int storeOpcode;
    private final StackSize size;
    private static /* synthetic */ StackManipulation loadThis;

    /*
     * WARNING - void declaration
     */
    private MethodVariableAccess(int loadOpcode, int storeOpcode, StackSize stackSize) {
        void var3_3;
        this.loadOpcode = var3_3;
        this.size = stackSize;
        this.storeOpcode = storeOpcode;
    }

    public static MethodVariableAccess of(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            TypeDefinition typeDefinition2;
            if (typeDefinition.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition2.represents(Void.TYPE)) {
                throw new IllegalArgumentException("Variable type cannot be void");
            }
            return INTEGER;
        }
        return REFERENCE;
    }

    public static MethodLoading allArgumentsOf(MethodDescription methodDescription) {
        MethodDescription methodDescription2;
        return new MethodLoading(methodDescription2, MethodLoading.TypeCastingHandler.NoOp.INSTANCE);
    }

    @CachedReturnPlugin.Enhance(value="loadThis")
    public static StackManipulation loadThis() {
        StackManipulation stackManipulation = loadThis;
        stackManipulation = stackManipulation != null ? null : REFERENCE.loadFrom(0);
        if (stackManipulation == null) {
            stackManipulation = loadThis;
        } else {
            loadThis = stackManipulation;
        }
        return stackManipulation;
    }

    /*
     * WARNING - void declaration
     */
    public final StackManipulation loadFrom(int offset) {
        void var1_1;
        return new OffsetLoading(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final StackManipulation storeAt(int offset) {
        void var1_1;
        return new OffsetWriting(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final StackManipulation increment(int offset, int value) {
        void var2_2;
        void var1_1;
        if (this != INTEGER) {
            throw new IllegalStateException("Cannot increment type: " + (Object)((Object)this));
        }
        return new OffsetIncrementing((int)var1_1, (int)var2_2);
    }

    public static StackManipulation load(ParameterDescription parameterDescription) {
        ParameterDescription parameterDescription2;
        return MethodVariableAccess.of(parameterDescription.getType()).loadFrom(parameterDescription2.getOffset());
    }

    public static StackManipulation store(ParameterDescription parameterDescription) {
        ParameterDescription parameterDescription2;
        return MethodVariableAccess.of(parameterDescription.getType()).storeAt(parameterDescription2.getOffset());
    }

    /*
     * WARNING - void declaration
     */
    public static StackManipulation increment(ParameterDescription parameterDescription, int value) {
        void var1_1;
        ParameterDescription parameterDescription2;
        return MethodVariableAccess.of(parameterDescription.getType()).increment(parameterDescription2.getOffset(), (int)var1_1);
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class OffsetIncrementing
    extends StackManipulation.AbstractBase {
        private final int offset;
        private final int value;

        /*
         * WARNING - void declaration
         */
        protected OffsetIncrementing(int offset, int value) {
            void var2_2;
            void var1_1;
            this.offset = var1_1;
            this.value = var2_2;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIincInsn(this.offset, this.value);
            return StackManipulation.Size.ZERO;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.offset != ((OffsetIncrementing)object).offset) {
                return false;
            }
            return this.value == ((OffsetIncrementing)object).value;
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.offset) * 31 + this.value;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class OffsetWriting
    extends StackManipulation.AbstractBase {
        private final int offset;
        final /* synthetic */ MethodVariableAccess this$0;

        /*
         * WARNING - void declaration
         */
        protected OffsetWriting(MethodVariableAccess this$0, int offset) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.offset = var2_2;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitVarInsn(this.this$0.storeOpcode, this.offset);
            return this.this$0.size.toDecreasingSize();
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.offset != ((OffsetWriting)object).offset) {
                return false;
            }
            return this.this$0.equals((Object)((OffsetWriting)object).this$0);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.offset) * 31 + this.this$0.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class OffsetLoading
    extends StackManipulation.AbstractBase {
        private final int offset;
        final /* synthetic */ MethodVariableAccess this$0;

        /*
         * WARNING - void declaration
         */
        protected OffsetLoading(MethodVariableAccess this$0, int offset) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.offset = var2_2;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitVarInsn(this.this$0.loadOpcode, this.offset);
            return this.this$0.size.toIncreasingSize();
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.offset != ((OffsetLoading)object).offset) {
                return false;
            }
            return this.this$0.equals((Object)((OffsetLoading)object).this$0);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.offset) * 31 + this.this$0.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class MethodLoading
    extends StackManipulation.AbstractBase {
        private final MethodDescription methodDescription;
        private final TypeCastingHandler typeCastingHandler;

        /*
         * WARNING - void declaration
         */
        protected MethodLoading(MethodDescription methodDescription, TypeCastingHandler typeCastingHandler) {
            void var2_2;
            void var1_1;
            this.methodDescription = var1_1;
            this.typeCastingHandler = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            void var2_2;
            void var1_1;
            void var3_3;
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>();
            for (ParameterDescription parameterDescription : this.methodDescription.getParameters()) {
                TypeDescription parameterType = parameterDescription.getType().asErasure();
                stackManipulations.add(MethodVariableAccess.of(parameterType).loadFrom(parameterDescription.getOffset()));
                stackManipulations.add(this.typeCastingHandler.ofIndex(parameterType, parameterDescription.getIndex()));
            }
            return new StackManipulation.Compound((List<? extends StackManipulation>)var3_3).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2);
        }

        public StackManipulation prependThisReference() {
            if (this.methodDescription.isStatic()) {
                return this;
            }
            return new StackManipulation.Compound(MethodVariableAccess.loadThis(), this);
        }

        /*
         * WARNING - void declaration
         */
        public MethodLoading asBridgeOf(MethodDescription bridgeTarget) {
            void var1_1;
            return new MethodLoading(this.methodDescription, new TypeCastingHandler.ForBridgeTarget((MethodDescription)var1_1));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.methodDescription.equals(((MethodLoading)object).methodDescription)) {
                return false;
            }
            return this.typeCastingHandler.equals(((MethodLoading)object).typeCastingHandler);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.methodDescription.hashCode()) * 31 + this.typeCastingHandler.hashCode();
        }

        protected static interface TypeCastingHandler {
            public StackManipulation ofIndex(TypeDescription var1, int var2);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForBridgeTarget
            implements TypeCastingHandler {
                private final MethodDescription bridgeTarget;

                /*
                 * WARNING - void declaration
                 */
                public ForBridgeTarget(MethodDescription bridgeTarget) {
                    void var1_1;
                    this.bridgeTarget = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    void var2_3;
                    void var1_1;
                    TypeDescription targetType = ((ParameterDescription)this.bridgeTarget.getParameters().get(index)).getType().asErasure();
                    if (var1_1.equals(targetType)) {
                        return StackManipulation.Trivial.INSTANCE;
                    }
                    return TypeCasting.to((TypeDefinition)var2_3);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.bridgeTarget.equals(((ForBridgeTarget)object).bridgeTarget);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.bridgeTarget.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum NoOp implements TypeCastingHandler
            {
                INSTANCE;


                @Override
                public final StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            }
        }
    }
}

