/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.auxiliary.PrivilegedMemberLookupAction;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodConstant
extends StackManipulation.AbstractBase {
    @MaybeNull
    protected static final MethodDescription.InDefinedShape DO_PRIVILEGED = MethodConstant.doPrivileged();
    protected final MethodDescription.InDefinedShape methodDescription;

    /*
     * WARNING - void declaration
     */
    @MaybeNull
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
    private static MethodDescription.InDefinedShape doPrivileged() {
        void var0;
        MethodDescription.ForLoadedMethod doPrivileged;
        try {
            doPrivileged = new MethodDescription.ForLoadedMethod(Class.forName("java.security.AccessController").getMethod("doPrivileged", PrivilegedExceptionAction.class));
            try {
                if (!Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"))) {
                    doPrivileged = null;
                }
            }
            catch (SecurityException securityException) {}
        }
        catch (Exception exception) {
            doPrivileged = null;
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    protected MethodConstant(MethodDescription.InDefinedShape methodDescription) {
        void var1_1;
        this.methodDescription = var1_1;
    }

    public static CanCache of(MethodDescription.InDefinedShape methodDescription) {
        MethodDescription.InDefinedShape inDefinedShape;
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription);
        }
        return new ForMethod(inDefinedShape);
    }

    public static CanCache ofPrivileged(MethodDescription.InDefinedShape methodDescription) {
        MethodDescription.InDefinedShape inDefinedShape;
        if (DO_PRIVILEGED == null) {
            return MethodConstant.of(methodDescription);
        }
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription).withPrivilegedLookup();
        }
        return new ForMethod(inDefinedShape).withPrivilegedLookup();
    }

    /*
     * WARNING - void declaration
     */
    protected static List<StackManipulation> typeConstantsFor(List<TypeDescription> parameterTypes) {
        void var1_1;
        Iterator<TypeDescription> iterator;
        ArrayList<StackManipulation> typeConstants = new ArrayList<StackManipulation>(parameterTypes.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            TypeDescription parameterType = (TypeDescription)iterator.next();
            typeConstants.add(ClassConstant.of((TypeDescription)var2_2));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        void var2_2;
        void var1_1;
        return new StackManipulation.Compound(ClassConstant.of(this.methodDescription.getDeclaringType()), this.methodName(), ArrayFactory.forType(TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Class.class)).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke(this.accessorMethod())).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2);
    }

    protected CanCache withPrivilegedLookup() {
        return new PrivilegedLookup(this.methodDescription, this.methodName());
    }

    protected abstract StackManipulation methodName();

    protected abstract MethodDescription.InDefinedShape accessorMethod();

    public int hashCode() {
        return this.methodDescription.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@MaybeNull Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodConstant methodConstant = (MethodConstant)other;
        return this.methodDescription.equals(var1_1.methodDescription);
    }

    protected static class CachedConstructor
    implements StackManipulation {
        private static final TypeDescription CONSTRUCTOR_TYPE = TypeDescription.ForLoadedType.of(Constructor.class);
        private final StackManipulation constructorConstant;

        /*
         * WARNING - void declaration
         */
        protected CachedConstructor(StackManipulation constructorConstant) {
            void var1_1;
            this.constructorConstant = var1_1;
        }

        public boolean isValid() {
            return this.constructorConstant.isValid();
        }

        /*
         * WARNING - void declaration
         */
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            void var2_2;
            void var1_1;
            return FieldAccess.forField(implementationContext.cache(this.constructorConstant, CONSTRUCTOR_TYPE)).read().apply((MethodVisitor)var1_1, (Implementation.Context)var2_2);
        }

        public int hashCode() {
            return this.constructorConstant.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedConstructor cachedConstructor = (CachedConstructor)other;
            return this.constructorConstant.equals(var1_1.constructorConstant);
        }
    }

    protected static class CachedMethod
    implements StackManipulation {
        private static final TypeDescription METHOD_TYPE = TypeDescription.ForLoadedType.of(Method.class);
        private final StackManipulation methodConstant;

        /*
         * WARNING - void declaration
         */
        protected CachedMethod(StackManipulation methodConstant) {
            void var1_1;
            this.methodConstant = var1_1;
        }

        public boolean isValid() {
            return this.methodConstant.isValid();
        }

        /*
         * WARNING - void declaration
         */
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            void var2_2;
            void var1_1;
            return FieldAccess.forField(implementationContext.cache(this.methodConstant, METHOD_TYPE)).read().apply((MethodVisitor)var1_1, (Implementation.Context)var2_2);
        }

        public int hashCode() {
            return this.methodConstant.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedMethod cachedMethod = (CachedMethod)other;
            return this.methodConstant.equals(var1_1.methodConstant);
        }
    }

    protected static class PrivilegedLookup
    implements StackManipulation,
    CanCache {
        private final MethodDescription.InDefinedShape methodDescription;
        private final StackManipulation methodName;

        /*
         * WARNING - void declaration
         */
        protected PrivilegedLookup(MethodDescription.InDefinedShape methodDescription, StackManipulation methodName) {
            void var2_2;
            void var1_1;
            this.methodDescription = var1_1;
            this.methodName = var2_2;
        }

        public boolean isValid() {
            return this.methodName.isValid();
        }

        /*
         * WARNING - void declaration
         */
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            void var2_2;
            void var1_1;
            void var3_3;
            if (DO_PRIVILEGED == null) {
                throw new IllegalStateException("Privileged method invocation is not supported on the current VM");
            }
            TypeDescription auxiliaryType = implementationContext.register(PrivilegedMemberLookupAction.of(this.methodDescription));
            return new StackManipulation.Compound(TypeCreation.of(auxiliaryType), Duplication.SINGLE, ClassConstant.of(this.methodDescription.getDeclaringType()), this.methodName, ArrayFactory.forType(TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Class.class)).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)var3_3.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), MethodInvocation.invoke(DO_PRIVILEGED), TypeCasting.to(TypeDescription.ForLoadedType.of(this.methodDescription.isConstructor() ? Constructor.class : Method.class))).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2);
        }

        public StackManipulation cached() {
            if (this.methodDescription.isConstructor()) {
                return new CachedConstructor(this);
            }
            return new CachedMethod(this);
        }

        public int hashCode() {
            return this.methodDescription.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            PrivilegedLookup privilegedLookup = (PrivilegedLookup)other;
            return this.methodDescription.equals(var1_1.methodDescription);
        }
    }

    protected static class ForConstructor
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_CONSTRUCTOR;
        private static final MethodDescription.InDefinedShape GET_DECLARED_CONSTRUCTOR;

        /*
         * WARNING - void declaration
         */
        protected ForConstructor(MethodDescription.InDefinedShape methodDescription) {
            super((MethodDescription.InDefinedShape)var1_1);
            void var1_1;
        }

        protected StackManipulation methodName() {
            return StackManipulation.Trivial.INSTANCE;
        }

        protected MethodDescription.InDefinedShape accessorMethod() {
            if (this.methodDescription.isPublic()) {
                return GET_CONSTRUCTOR;
            }
            return GET_DECLARED_CONSTRUCTOR;
        }

        public StackManipulation cached() {
            return new CachedConstructor(this);
        }

        /*
         * WARNING - void declaration
         */
        static {
            try {
                GET_CONSTRUCTOR = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getConstructor", Class[].class));
                GET_DECLARED_CONSTRUCTOR = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredConstructor", Class[].class));
                return;
            }
            catch (NoSuchMethodException exception) {
                void var0;
                throw new IllegalStateException("Could not locate Class::getDeclaredConstructor", (Throwable)var0);
            }
        }
    }

    protected static class ForMethod
    extends MethodConstant
    implements CanCache {
        private static final MethodDescription.InDefinedShape GET_METHOD;
        private static final MethodDescription.InDefinedShape GET_DECLARED_METHOD;

        /*
         * WARNING - void declaration
         */
        protected ForMethod(MethodDescription.InDefinedShape methodDescription) {
            super((MethodDescription.InDefinedShape)var1_1);
            void var1_1;
        }

        protected StackManipulation methodName() {
            return new TextConstant(this.methodDescription.getInternalName());
        }

        protected MethodDescription.InDefinedShape accessorMethod() {
            if (this.methodDescription.isPublic()) {
                return GET_METHOD;
            }
            return GET_DECLARED_METHOD;
        }

        public StackManipulation cached() {
            return new CachedMethod(this);
        }

        /*
         * WARNING - void declaration
         */
        static {
            try {
                GET_METHOD = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getMethod", String.class, Class[].class));
                GET_DECLARED_METHOD = new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredMethod", String.class, Class[].class));
                return;
            }
            catch (NoSuchMethodException exception) {
                void var0;
                throw new IllegalStateException("Could not locate method lookup", (Throwable)var0);
            }
        }
    }

    public static interface CanCache
    extends StackManipulation {
        public StackManipulation cached();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CanCacheIllegal implements CanCache
    {
        INSTANCE;


        @Override
        public final StackManipulation cached() {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public final boolean isValid() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            void var2_2;
            void var1_1;
            return StackManipulation.Illegal.INSTANCE.apply((MethodVisitor)var1_1, (Implementation.Context)var2_2);
        }
    }
}

