/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.jar.asm.ConstantDynamic;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class JavaConstantValue
extends StackManipulation.AbstractBase {
    private final JavaConstant constant;

    /*
     * WARNING - void declaration
     */
    public JavaConstantValue(JavaConstant constant) {
        void var1_1;
        this.constant = var1_1;
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn(this.constant.accept(Visitor.INSTANCE));
        return this.constant.getTypeDescription().getStackSize().toIncreasingSize();
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.constant.equals(((JavaConstantValue)object).constant);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.constant.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visitor implements JavaConstant.Visitor<Object>
    {
        INSTANCE;


        @Override
        public final Object onValue(JavaConstant.Simple<?> constant) {
            return constant.getValue();
        }

        @Override
        public final Type onType(JavaConstant.Simple<TypeDescription> constant) {
            return Type.getType(constant.getValue().getDescriptor());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Type onMethodType(JavaConstant.MethodType constant) {
            void var1_1;
            void var2_2;
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : constant.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            return Type.getMethodType(var2_2.append(')').append(var1_1.getReturnType().getDescriptor()).toString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Handle onMethodHandle(JavaConstant.MethodHandle constant) {
            void var1_1;
            return new Handle(constant.getHandleType().getIdentifier(), constant.getOwnerType().getInternalName(), constant.getName(), constant.getDescriptor(), var1_1.getOwnerType().isInterface());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ConstantDynamic onDynamic(JavaConstant.Dynamic constant) {
            void var2_2;
            void var1_1;
            Object[] argument = new Object[constant.getArguments().size()];
            for (int index = 0; index < argument.length; ++index) {
                argument[index] = constant.getArguments().get(index).accept(this);
            }
            return new ConstantDynamic(constant.getName(), constant.getTypeDescription().getDescriptor(), this.onMethodHandle(var1_1.getBootstrap()), (Object[])var2_2);
        }
    }
}

