/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.collection;

import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.collection.CollectionFactory;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ArrayFactory
implements CollectionFactory {
    private final TypeDescription.Generic componentType;
    private final ArrayCreator arrayCreator;
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    private final StackManipulation.Size sizeDecrease;

    /*
     * WARNING - void declaration
     */
    protected ArrayFactory(TypeDescription.Generic componentType, ArrayCreator arrayCreator) {
        void var1_1;
        void var2_2;
        this.componentType = componentType;
        this.arrayCreator = var2_2;
        this.sizeDecrease = StackSize.DOUBLE.toDecreasingSize().aggregate(var1_1.getStackSize().toDecreasingSize());
    }

    public static ArrayFactory forType(TypeDescription.Generic componentType) {
        TypeDescription.Generic generic;
        TypeDescription.Generic generic2 = generic;
        return new ArrayFactory(generic2, ArrayFactory.makeArrayCreatorFor(generic2));
    }

    private static ArrayCreator makeArrayCreatorFor(TypeDefinition componentType) {
        TypeDefinition typeDefinition;
        if (!componentType.isPrimitive()) {
            return new ArrayCreator.ForReferenceType(componentType.asErasure());
        }
        if (componentType.represents(Boolean.TYPE)) {
            return ArrayCreator.ForPrimitiveType.BOOLEAN;
        }
        if (componentType.represents(Byte.TYPE)) {
            return ArrayCreator.ForPrimitiveType.BYTE;
        }
        if (componentType.represents(Short.TYPE)) {
            return ArrayCreator.ForPrimitiveType.SHORT;
        }
        if (componentType.represents(Character.TYPE)) {
            return ArrayCreator.ForPrimitiveType.CHARACTER;
        }
        if (componentType.represents(Integer.TYPE)) {
            return ArrayCreator.ForPrimitiveType.INTEGER;
        }
        if (componentType.represents(Long.TYPE)) {
            return ArrayCreator.ForPrimitiveType.LONG;
        }
        if (componentType.represents(Float.TYPE)) {
            return ArrayCreator.ForPrimitiveType.FLOAT;
        }
        if (componentType.represents(Double.TYPE)) {
            return ArrayCreator.ForPrimitiveType.DOUBLE;
        }
        throw new IllegalArgumentException("Cannot create array of type " + typeDefinition);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StackManipulation withValues(List<? extends StackManipulation> stackManipulations) {
        void var1_1;
        return new ArrayStackManipulation(this, (List<? extends StackManipulation>)var1_1);
    }

    @Override
    public TypeDescription.Generic getComponentType() {
        return this.componentType;
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.componentType.equals(((ArrayFactory)object).componentType)) {
            return false;
        }
        return this.arrayCreator.equals(((ArrayFactory)object).arrayCreator);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.componentType.hashCode()) * 31 + this.arrayCreator.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class ArrayStackManipulation
    implements StackManipulation {
        private final List<? extends StackManipulation> stackManipulations;
        final /* synthetic */ ArrayFactory this$0;

        /*
         * WARNING - void declaration
         */
        protected ArrayStackManipulation(ArrayFactory this$0, List<? extends StackManipulation> stackManipulations) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.stackManipulations = var2_2;
        }

        @Override
        public boolean isValid() {
            for (StackManipulation stackManipulation : this.stackManipulations) {
                if (stackManipulation.isValid()) continue;
                return false;
            }
            return this.this$0.arrayCreator.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            StackManipulation.Size size = IntegerConstant.forValue(this.stackManipulations.size()).apply(methodVisitor, implementationContext);
            StackManipulation.Size size2 = size.aggregate(this.this$0.arrayCreator.apply(methodVisitor, implementationContext));
            int index = 0;
            for (StackManipulation stackManipulation : this.stackManipulations) {
                methodVisitor.visitInsn(89);
                size2 = size2.aggregate(StackSize.SINGLE.toIncreasingSize());
                size2 = size2.aggregate(IntegerConstant.forValue(index++).apply(methodVisitor, implementationContext));
                size2 = size2.aggregate(stackManipulation.apply(methodVisitor, implementationContext));
                methodVisitor.visitInsn(this.this$0.arrayCreator.getStorageOpcode());
                size2 = size2.aggregate(this.this$0.sizeDecrease);
            }
            return size;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!((Object)this.stackManipulations).equals(((ArrayStackManipulation)object).stackManipulations)) {
                return false;
            }
            return this.this$0.equals(((ArrayStackManipulation)object).this$0);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + ((Object)this.stackManipulations).hashCode()) * 31 + this.this$0.hashCode();
        }
    }

    protected static interface ArrayCreator
    extends StackManipulation {
        public static final StackManipulation.Size ARRAY_CREATION_SIZE_CHANGE = StackSize.ZERO.toDecreasingSize();

        public int getStorageOpcode();

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForReferenceType
        extends StackManipulation.AbstractBase
        implements ArrayCreator {
            private final String internalTypeName;

            /*
             * WARNING - void declaration
             */
            protected ForReferenceType(TypeDescription referenceType) {
                void var1_1;
                this.internalTypeName = var1_1.getInternalName();
            }

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitTypeInsn(189, this.internalTypeName);
                return ARRAY_CREATION_SIZE_CHANGE;
            }

            public int getStorageOpcode() {
                return 83;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.internalTypeName.equals(((ForReferenceType)object).internalTypeName);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.internalTypeName.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForPrimitiveType implements ArrayCreator
        {
            BOOLEAN(4, 84),
            BYTE(8, 84),
            SHORT(9, 86),
            CHARACTER(5, 85),
            INTEGER(10, 79),
            LONG(11, 80),
            FLOAT(6, 81),
            DOUBLE(7, 82);

            private final int creationOpcode;
            private final int storageOpcode;

            /*
             * WARNING - void declaration
             */
            private ForPrimitiveType(int creationOpcode, int storageOpcode) {
                void var3_3;
                this.creationOpcode = var3_3;
                this.storageOpcode = storageOpcode;
            }

            @Override
            public final boolean isValid() {
                return true;
            }

            @Override
            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitIntInsn(188, this.creationOpcode);
                return ARRAY_CREATION_SIZE_CHANGE;
            }

            @Override
            public final int getStorageOpcode() {
                return this.storageOpcode;
            }
        }
    }
}

