/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.assign.reference;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.utility.QueueFactory;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenericTypeAwareAssigner implements Assigner
{
    INSTANCE;


    /*
     * WARNING - void declaration
     */
    @Override
    public final StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        void var3_3;
        if (source.isPrimitive() || target.isPrimitive()) {
            return (StackManipulation)((Object)(source.equals(target) ? StackManipulation.Trivial.INSTANCE : StackManipulation.Illegal.INSTANCE));
        }
        if (source.accept(new IsAssignableToVisitor(target)).booleanValue()) {
            return StackManipulation.Trivial.INSTANCE;
        }
        if (var3_3.isDynamic()) {
            void var2_2;
            void var1_1;
            if (var1_1.asErasure().isAssignableTo(target.asErasure())) {
                return StackManipulation.Trivial.INSTANCE;
            }
            return TypeCasting.to((TypeDefinition)var2_2);
        }
        return StackManipulation.Illegal.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class IsAssignableToVisitor
    implements TypeDescription.Generic.Visitor<Boolean> {
        private final TypeDescription.Generic typeDescription;
        private final boolean polymorphic;

        /*
         * WARNING - void declaration
         */
        public IsAssignableToVisitor(TypeDescription.Generic typeDescription) {
            this((TypeDescription.Generic)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected IsAssignableToVisitor(TypeDescription.Generic typeDescription, boolean polymorphic) {
            void var2_2;
            void var1_1;
            this.typeDescription = var1_1;
            this.polymorphic = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean onGenericArray(TypeDescription.Generic genericArray) {
            void var1_1;
            return this.typeDescription.accept(new OfGenericArray((TypeDescription.Generic)var1_1, this.polymorphic));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean onWildcard(TypeDescription.Generic wildcard) {
            void var1_1;
            return this.typeDescription.accept(new OfWildcard((TypeDescription.Generic)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean onParameterizedType(TypeDescription.Generic parameterizedType) {
            void var1_1;
            return this.typeDescription.accept(new OfParameterizedType((TypeDescription.Generic)var1_1, this.polymorphic));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean onTypeVariable(TypeDescription.Generic typeVariable) {
            if (typeVariable.getTypeVariableSource().isInferrable()) {
                throw new UnsupportedOperationException("Assignability checks for type variables declared by methods are not currently supported");
            }
            if (typeVariable.equals(this.typeDescription)) {
                return Boolean.TRUE;
            }
            if (this.polymorphic) {
                Queue<TypeDescription.Generic> candidates = QueueFactory.make(typeVariable.getUpperBounds());
                while (!candidates.isEmpty()) {
                    void var2_2;
                    TypeDescription.Generic candidate = candidates.remove();
                    if (candidate.accept(new IsAssignableToVisitor(this.typeDescription)).booleanValue()) {
                        return Boolean.TRUE;
                    }
                    if (!candidate.getSort().isTypeVariable()) continue;
                    candidates.addAll(var2_2.getUpperBounds());
                }
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean onNonGenericType(TypeDescription.Generic typeDescription) {
            void var1_1;
            return this.typeDescription.accept(new OfNonGenericType((TypeDescription.Generic)var1_1, this.polymorphic));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.polymorphic != ((IsAssignableToVisitor)object).polymorphic) {
                return false;
            }
            return this.typeDescription.equals(((IsAssignableToVisitor)object).typeDescription);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.typeDescription.hashCode()) * 31 + this.polymorphic;
        }

        protected static class OfNonGenericType
        extends OfSimpleType {
            /*
             * WARNING - void declaration
             */
            protected OfNonGenericType(TypeDescription.Generic typeDescription, boolean polymorphic) {
                super((TypeDescription.Generic)var1_1, (boolean)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Boolean onGenericArray(TypeDescription.Generic genericArray) {
                void var1_1;
                return this.polymorphic ? this.typeDescription.asErasure().isAssignableTo(genericArray.asErasure()) : this.typeDescription.asErasure().equals(var1_1.asErasure());
            }
        }

        protected static class OfParameterizedType
        extends OfSimpleType {
            /*
             * WARNING - void declaration
             */
            protected OfParameterizedType(TypeDescription.Generic typeDescription, boolean polymorphic) {
                super((TypeDescription.Generic)var1_1, (boolean)var2_2);
                void var2_2;
                void var1_1;
            }

            public Boolean onGenericArray(TypeDescription.Generic genericArray) {
                return Boolean.FALSE;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class OfWildcard
        implements TypeDescription.Generic.Visitor<Boolean> {
            private final TypeDescription.Generic wildcard;

            /*
             * WARNING - void declaration
             */
            protected OfWildcard(TypeDescription.Generic wildcard) {
                void var1_1;
                this.wildcard = var1_1;
            }

            @Override
            public Boolean onGenericArray(TypeDescription.Generic genericArray) {
                return Boolean.FALSE;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean onWildcard(TypeDescription.Generic wildcard) {
                void var3_3;
                void var2_2;
                void var1_1;
                boolean hasUpperBounds = false;
                boolean hasLowerBounds = false;
                for (TypeDescription.Generic target : wildcard.getUpperBounds()) {
                    for (TypeDescription.Generic generic : this.wildcard.getUpperBounds()) {
                        if (generic.accept(new IsAssignableToVisitor(target)).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    hasUpperBounds = hasUpperBounds || !target.represents((Type)((Object)Object.class));
                }
                for (TypeDescription.Generic target : var1_1.getLowerBounds()) {
                    for (TypeDescription.Generic source : this.wildcard.getLowerBounds()) {
                        if (target.accept(new IsAssignableToVisitor(source)).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    hasLowerBounds = true;
                }
                if (var2_2 != false) {
                    return this.wildcard.getLowerBounds().isEmpty();
                }
                if (var3_3 != false) {
                    TypeList.Generic upperBounds = this.wildcard.getUpperBounds();
                    return upperBounds.size() == 0 || upperBounds.size() == 1 && ((TypeDescription.Generic)upperBounds.getOnly()).represents((Type)((Object)Object.class));
                }
                return Boolean.TRUE;
            }

            @Override
            public Boolean onParameterizedType(TypeDescription.Generic parameterizedType) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean onTypeVariable(TypeDescription.Generic typeVariable) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean onNonGenericType(TypeDescription.Generic typeDescription) {
                return Boolean.FALSE;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.wildcard.equals(((OfWildcard)object).wildcard);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.wildcard.hashCode();
            }
        }

        protected static class OfGenericArray
        extends OfManifestType {
            /*
             * WARNING - void declaration
             */
            protected OfGenericArray(TypeDescription.Generic typeDescription, boolean polymorphic) {
                super((TypeDescription.Generic)var1_1, (boolean)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
            public Boolean onGenericArray(TypeDescription.Generic genericArray) {
                void var1_1;
                void var2_2;
                TypeDescription.Generic source = this.typeDescription.getComponentType();
                TypeDescription.Generic target = genericArray.getComponentType();
                while (source.getSort().isGenericArray() && target.getSort().isGenericArray()) {
                    source = source.getComponentType();
                    target = target.getComponentType();
                }
                return !source.getSort().isGenericArray() && !target.getSort().isGenericArray() && var2_2.accept(new IsAssignableToVisitor((TypeDescription.Generic)var1_1)) != false;
            }

            public Boolean onParameterizedType(TypeDescription.Generic parameterizedType) {
                return Boolean.FALSE;
            }

            /*
             * WARNING - void declaration
             */
            public Boolean onNonGenericType(TypeDescription.Generic typeDescription) {
                void var1_1;
                return this.polymorphic ? this.typeDescription.asErasure().isAssignableTo(typeDescription.asErasure()) : this.typeDescription.asErasure().equals(var1_1.asErasure());
            }
        }

        protected static abstract class OfSimpleType
        extends OfManifestType {
            /*
             * WARNING - void declaration
             */
            protected OfSimpleType(TypeDescription.Generic typeDescription, boolean polymorphic) {
                super((TypeDescription.Generic)var1_1, (boolean)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Boolean onParameterizedType(TypeDescription.Generic parameterizedType) {
                void var2_2;
                Queue<TypeDescription.Generic> candidates = QueueFactory.make(Collections.singleton(this.typeDescription));
                HashSet<TypeDescription> previous = new HashSet<TypeDescription>(Collections.singleton(this.typeDescription.asErasure()));
                do {
                    Iterator iterator;
                    TypeDescription.Generic candidate;
                    if ((candidate = candidates.remove()).asErasure().equals(parameterizedType.asErasure())) {
                        void var2_4;
                        if (candidate.getSort().isNonGeneric()) {
                            return Boolean.TRUE;
                        }
                        TypeList.Generic source = candidate.getTypeArguments();
                        TypeList.Generic target = parameterizedType.getTypeArguments();
                        int size = target.size();
                        if (source.size() != size) {
                            return Boolean.FALSE;
                        }
                        for (int index = 0; index < size; ++index) {
                            if (((TypeDescription.Generic)source.get(index)).accept(new IsAssignableToVisitor((TypeDescription.Generic)target.get(index), false)).booleanValue()) continue;
                            return Boolean.FALSE;
                        }
                        TypeDescription.Generic ownerType = parameterizedType.getOwnerType();
                        return ownerType == null || ownerType.accept(new IsAssignableToVisitor((TypeDescription.Generic)var2_4)) != false;
                    }
                    if (!this.polymorphic) continue;
                    TypeDescription.Generic superClass = iterator.getSuperClass();
                    if (superClass != null && previous.add(superClass.asErasure())) {
                        var2_2.add(superClass);
                    }
                    iterator = iterator.getInterfaces().iterator();
                    while (iterator.hasNext()) {
                        TypeDescription.Generic anInterface = (TypeDescription.Generic)iterator.next();
                        if (!previous.add(anInterface.asErasure())) continue;
                        var2_2.add(anInterface);
                    }
                } while (!var2_2.isEmpty());
                return Boolean.FALSE;
            }

            /*
             * WARNING - void declaration
             */
            public Boolean onNonGenericType(TypeDescription.Generic typeDescription) {
                void var1_1;
                return this.polymorphic ? this.typeDescription.asErasure().isAssignableTo(typeDescription.asErasure()) : this.typeDescription.asErasure().equals(var1_1.asErasure());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static abstract class OfManifestType
        implements TypeDescription.Generic.Visitor<Boolean> {
            protected final TypeDescription.Generic typeDescription;
            protected final boolean polymorphic;

            /*
             * WARNING - void declaration
             */
            protected OfManifestType(TypeDescription.Generic typeDescription, boolean polymorphic) {
                void var2_2;
                void var1_1;
                this.typeDescription = var1_1;
                this.polymorphic = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean onWildcard(TypeDescription.Generic wildcard) {
                void var1_1;
                for (TypeDescription.Generic upperBound : wildcard.getUpperBounds()) {
                    TypeDescription.Generic generic;
                    if (this.typeDescription.accept(new IsAssignableToVisitor(generic)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                for (TypeDescription.Generic generic : var1_1.getLowerBounds()) {
                    if (generic.accept(new IsAssignableToVisitor(this.typeDescription)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }

            @Override
            public Boolean onTypeVariable(TypeDescription.Generic typeVariable) {
                if (typeVariable.getTypeVariableSource().isInferrable()) {
                    throw new UnsupportedOperationException("Assignability checks for type variables declared by methods arel not currently supported");
                }
                return Boolean.FALSE;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.polymorphic != ((OfManifestType)object).polymorphic) {
                    return false;
                }
                return this.typeDescription.equals(((OfManifestType)object).typeDescription);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.typeDescription.hashCode()) * 31 + this.polymorphic;
            }
        }
    }
}

