/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.implementation.bytecode.StackManipulation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StackSize {
    ZERO(0),
    SINGLE(1),
    DOUBLE(2);

    private final int size;

    /*
     * WARNING - void declaration
     */
    private StackSize(int size) {
        void var3_3;
        this.size = var3_3;
    }

    public static StackSize of(Class<?> type) {
        Class<?> clazz;
        if (type == Void.TYPE) {
            return ZERO;
        }
        if (type == Double.TYPE || clazz == Long.TYPE) {
            return DOUBLE;
        }
        return SINGLE;
    }

    public static StackSize of(int size) {
        int n;
        switch (size) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return SINGLE;
            }
            case 2: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException("Unexpected stack size value: " + n);
    }

    public static int of(TypeDefinition ... typeDefinition) {
        return StackSize.of(Arrays.asList(typeDefinition));
    }

    /*
     * WARNING - void declaration
     */
    public static int of(Collection<? extends TypeDefinition> typeDefinitions) {
        void var1_1;
        Iterator<? extends TypeDefinition> iterator;
        int size = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            TypeDefinition typeDefinition = (TypeDefinition)iterator.next();
            size += var2_2.getStackSize().getSize();
        }
        return (int)var1_1;
    }

    public final int getSize() {
        return this.size;
    }

    public final StackManipulation.Size toIncreasingSize() {
        return new StackManipulation.Size(this.getSize(), this.getSize());
    }

    public final StackManipulation.Size toDecreasingSize() {
        return new StackManipulation.Size(-1 * this.getSize(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public final StackSize maximum(StackSize stackSize) {
        switch (this) {
            case ZERO: {
                return stackSize;
            }
            case SINGLE: {
                switch (stackSize) {
                    case DOUBLE: {
                        void var1_1;
                        return var1_1;
                    }
                    case SINGLE: 
                    case ZERO: {
                        return this;
                    }
                }
                throw new AssertionError();
            }
            case DOUBLE: {
                return this;
            }
        }
        throw new AssertionError();
    }
}

