/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodAccessorFactory;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface SuperMethod {
    public boolean cached() default true;

    public boolean privileged() default false;

    public boolean fallbackToDefault() default true;

    public boolean nullIfImpossible() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Binder
    extends Enum<Binder>
    implements TargetMethodAnnotationDrivenBinder.ParameterBinder<SuperMethod> {
        public static final /* enum */ Binder INSTANCE;
        private static final MethodDescription.InDefinedShape CACHED;
        private static final MethodDescription.InDefinedShape PRIVILEGED;
        private static final MethodDescription.InDefinedShape FALLBACK_TO_DEFAULT;
        private static final MethodDescription.InDefinedShape NULL_IF_IMPOSSIBLE;
        private static final /* synthetic */ Binder[] $VALUES;

        public static Binder[] values() {
            return (Binder[])$VALUES.clone();
        }

        public static Binder valueOf(String name) {
            String string;
            return Enum.valueOf(Binder.class, string);
        }

        @Override
        public final Class<SuperMethod> getHandledType() {
            return SuperMethod.class;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<SuperMethod> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            void var1_1;
            if (!target.getType().asErasure().isAssignableFrom(Method.class)) {
                void var3_3;
                throw new IllegalStateException("Cannot assign Method type to " + var3_3);
            }
            if (source.isMethod()) {
                Implementation.SpecialMethodInvocation specialMethodInvocation = (annotation.getValue(FALLBACK_TO_DEFAULT).resolve(Boolean.class) != false ? implementationTarget.invokeDominant(source.asSignatureToken()) : implementationTarget.invokeSuper(source.asSignatureToken())).withCheckedCompatibilityTo(source.asTypeToken());
                if (specialMethodInvocation.isValid()) {
                    void var2_2;
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(new DelegationMethod((Implementation.SpecialMethodInvocation)var2_2, annotation.getValue(CACHED).resolve(Boolean.class), annotation.getValue(PRIVILEGED).resolve(Boolean.class)));
                }
                if (annotation.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
                }
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            if (var1_1.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
            }
            return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            INSTANCE = new Binder();
            $VALUES = new Binder[]{INSTANCE};
            MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(SuperMethod.class).getDeclaredMethods();
            CACHED = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("cached"))).getOnly();
            PRIVILEGED = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("privileged"))).getOnly();
            FALLBACK_TO_DEFAULT = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("fallbackToDefault"))).getOnly();
            NULL_IF_IMPOSSIBLE = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("nullIfImpossible"))).getOnly();
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class DelegationMethod
        implements StackManipulation {
            private final Implementation.SpecialMethodInvocation specialMethodInvocation;
            private final boolean cached;
            private final boolean privileged;

            /*
             * WARNING - void declaration
             */
            protected DelegationMethod(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean cached, boolean privileged) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.specialMethodInvocation = var1_1;
                this.cached = var2_2;
                this.privileged = var3_3;
            }

            public boolean isValid() {
                return this.specialMethodInvocation.isValid();
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                void var2_2;
                void var1_1;
                void var3_3;
                MethodConstant.CanCache methodConstant = this.privileged ? MethodConstant.ofPrivileged(implementationContext.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.PUBLIC)) : MethodConstant.of(implementationContext.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.PUBLIC));
                return (this.cached ? FieldAccess.forField(implementationContext.cache(methodConstant, TypeDescription.ForLoadedType.of(Method.class))).read() : var3_3).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.cached != ((DelegationMethod)object).cached) {
                    return false;
                }
                if (this.privileged != ((DelegationMethod)object).privileged) {
                    return false;
                }
                return this.specialMethodInvocation.equals(((DelegationMethod)object).specialMethodInvocation);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.specialMethodInvocation.hashCode()) * 31 + this.cached) * 31 + this.privileged;
            }
        }
    }
}

