/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.attribute.AnnotationAppender;
import net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.utility.nullability.MaybeNull;

public interface TypeAttributeAppender {
    public void apply(ClassVisitor var1, TypeDescription var2, AnnotationValueFilter var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    implements TypeAttributeAppender {
        private final List<TypeAttributeAppender> typeAttributeAppenders = new ArrayList<TypeAttributeAppender>();

        /*
         * WARNING - void declaration
         */
        public Compound(TypeAttributeAppender ... typeAttributeAppender) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Compound(List<? extends TypeAttributeAppender> typeAttributeAppenders) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                TypeAttributeAppender typeAttributeAppender = (TypeAttributeAppender)iterator.next();
                if (typeAttributeAppender instanceof Compound) {
                    this.typeAttributeAppenders.addAll(((Compound)typeAttributeAppender).typeAttributeAppenders);
                    continue;
                }
                if (typeAttributeAppender instanceof NoOp) continue;
                this.typeAttributeAppenders.add((TypeAttributeAppender)var2_2);
            }
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            for (TypeAttributeAppender typeAttributeAppender : this.typeAttributeAppenders) {
                typeAttributeAppender.apply(classVisitor, instrumentedType, annotationValueFilter);
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.typeAttributeAppenders).equals(((Compound)object).typeAttributeAppenders);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.typeAttributeAppenders).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Explicit
    implements TypeAttributeAppender {
        private final List<? extends AnnotationDescription> annotations;

        /*
         * WARNING - void declaration
         */
        public Explicit(List<? extends AnnotationDescription> annotations) {
            void var1_1;
            this.annotations = var1_1;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender appender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.annotations).equals(((Explicit)object).annotations);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.annotations).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForInstrumentedType implements TypeAttributeAppender
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            void var2_2;
            classVisitor = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType((ClassVisitor)classVisitor));
            AnnotationAppender annotationAppender = AnnotationAppender.ForTypeAnnotations.ofTypeVariable((AnnotationAppender)classVisitor, annotationValueFilter, true, instrumentedType.getTypeVariables());
            TypeDescription.Generic superClass = instrumentedType.getSuperClass();
            if (superClass != null) {
                annotationAppender = superClass.accept(AnnotationAppender.ForTypeAnnotations.ofSuperClass(annotationAppender, annotationValueFilter));
            }
            int interfaceIndex = 0;
            for (TypeDescription.Generic generic : instrumentedType.getInterfaces()) {
                annotationAppender = generic.accept(AnnotationAppender.ForTypeAnnotations.ofInterfaceType(annotationAppender, annotationValueFilter, interfaceIndex++));
            }
            for (AnnotationDescription annotation : var2_2.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Differentiating
        implements TypeAttributeAppender {
            private final int annotationIndex;
            private final int typeVariableIndex;
            private final int interfaceTypeIndex;

            /*
             * WARNING - void declaration
             */
            public Differentiating(TypeDescription typeDescription) {
                this(typeDescription.getDeclaredAnnotations().size(), typeDescription.getTypeVariables().size(), var1_1.getInterfaces().size());
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            protected Differentiating(int annotationIndex, int typeVariableIndex, int interfaceTypeIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.annotationIndex = var1_1;
                this.typeVariableIndex = var2_2;
                this.interfaceTypeIndex = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
                AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
                AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, true, this.typeVariableIndex, instrumentedType.getTypeVariables());
                TypeList.Generic interfaceTypes = instrumentedType.getInterfaces();
                int interfaceTypeIndex = this.interfaceTypeIndex;
                for (Object object : (TypeList.Generic)interfaceTypes.subList(this.interfaceTypeIndex, interfaceTypes.size())) {
                    annotationAppender = object.accept(AnnotationAppender.ForTypeAnnotations.ofInterfaceType(annotationAppender, annotationValueFilter, interfaceTypeIndex++));
                }
                AnnotationList declaredAnnotations = instrumentedType.getDeclaredAnnotations();
                for (AnnotationDescription annotationDescription : (AnnotationList)declaredAnnotations.subList(this.annotationIndex, declaredAnnotations.size())) {
                    void var2_2;
                    annotationAppender = annotationAppender.append((AnnotationDescription)var2_2, annotationValueFilter);
                }
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.annotationIndex != ((Differentiating)object).annotationIndex) {
                    return false;
                }
                if (this.typeVariableIndex != ((Differentiating)object).typeVariableIndex) {
                    return false;
                }
                return this.interfaceTypeIndex == ((Differentiating)object).interfaceTypeIndex;
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.annotationIndex) * 31 + this.typeVariableIndex) * 31 + this.interfaceTypeIndex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoOp implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public final void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
        }
    }
}

