/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.attribute.AnnotationAppender;
import net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

public interface MethodAttributeAppender {
    public void apply(MethodVisitor var1, MethodDescription var2, AnnotationValueFilter var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    implements MethodAttributeAppender {
        private final List<MethodAttributeAppender> methodAttributeAppenders = new ArrayList<MethodAttributeAppender>();

        /*
         * WARNING - void declaration
         */
        public Compound(MethodAttributeAppender ... methodAttributeAppender) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Compound(List<? extends MethodAttributeAppender> methodAttributeAppenders) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                MethodAttributeAppender methodAttributeAppender = (MethodAttributeAppender)iterator.next();
                if (methodAttributeAppender instanceof Compound) {
                    this.methodAttributeAppenders.addAll(((Compound)methodAttributeAppender).methodAttributeAppenders);
                    continue;
                }
                if (methodAttributeAppender instanceof NoOp) continue;
                this.methodAttributeAppenders.add((MethodAttributeAppender)var2_2);
            }
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            for (MethodAttributeAppender methodAttributeAppender : this.methodAttributeAppenders) {
                methodAttributeAppender.apply(methodVisitor, methodDescription, annotationValueFilter);
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.methodAttributeAppenders).equals(((Compound)object).methodAttributeAppenders);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.methodAttributeAppenders).hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class ForReceiverType
    implements MethodAttributeAppender,
    Factory {
        private final TypeDescription.Generic receiverType;

        /*
         * WARNING - void declaration
         */
        public ForReceiverType(TypeDescription.Generic receiverType) {
            void var1_1;
            this.receiverType = var1_1;
        }

        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            void var3_3;
            void var1_1;
            this.receiverType.accept(AnnotationAppender.ForTypeAnnotations.ofReceiverType(new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod((MethodVisitor)var1_1)), (AnnotationValueFilter)var3_3));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.receiverType.equals(((ForReceiverType)object).receiverType);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.receiverType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Explicit
    implements MethodAttributeAppender,
    Factory {
        private final Target target;
        private final List<? extends AnnotationDescription> annotations;

        /*
         * WARNING - void declaration
         */
        public Explicit(int parameterIndex, List<? extends AnnotationDescription> annotations) {
            this(new Target.OnMethodParameter((int)var1_1), (List<? extends AnnotationDescription>)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Explicit(List<? extends AnnotationDescription> annotations) {
            this(Target.OnMethod.INSTANCE, (List<? extends AnnotationDescription>)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected Explicit(Target target, List<? extends AnnotationDescription> annotations) {
            void var2_2;
            void var1_1;
            this.target = var1_1;
            this.annotations = var2_2;
        }

        public static Factory of(MethodDescription methodDescription) {
            MethodDescription methodDescription2;
            return new Factory.Compound(Explicit.ofMethodAnnotations(methodDescription), Explicit.ofParameterAnnotations(methodDescription2));
        }

        public static Factory ofMethodAnnotations(MethodDescription methodDescription) {
            MethodDescription methodDescription2;
            return new Explicit(methodDescription2.getDeclaredAnnotations());
        }

        /*
         * WARNING - void declaration
         */
        public static Factory ofParameterAnnotations(MethodDescription methodDescription) {
            void var1_1;
            Iterator iterator;
            Iterator parameters = methodDescription.getParameters();
            ArrayList<Explicit> factories = new ArrayList<Explicit>(parameters.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                ParameterDescription parameter = (ParameterDescription)iterator.next();
                factories.add(new Explicit(parameter.getIndex(), (List<? extends AnnotationDescription>)var2_2.getDeclaredAnnotations()));
            }
            return new Factory.Compound((List<? extends Factory>)var1_1);
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            Iterator<? extends AnnotationDescription> iterator;
            AnnotationAppender appender = new AnnotationAppender.Default(this.target.make(methodVisitor, (MethodDescription)((Object)iterator)));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.target.equals(((Explicit)object).target)) {
                return false;
            }
            return ((Object)this.annotations).equals(((Explicit)object).annotations);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + ((Object)this.annotations).hashCode();
        }

        protected static interface Target {
            public AnnotationAppender.Target make(MethodVisitor var1, MethodDescription var2);

            @HashCodeAndEqualsPlugin.Enhance
            public static class OnMethodParameter
            implements Target {
                private final int parameterIndex;

                /*
                 * WARNING - void declaration
                 */
                protected OnMethodParameter(int parameterIndex) {
                    void var1_1;
                    this.parameterIndex = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    void var1_1;
                    if (this.parameterIndex >= methodDescription.getParameters().size()) {
                        void var2_2;
                        throw new IllegalArgumentException("Method " + var2_2 + " has less then " + this.parameterIndex + " parameters");
                    }
                    return new AnnotationAppender.Target.OnMethodParameter((MethodVisitor)var1_1, this.parameterIndex);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.parameterIndex == ((OnMethodParameter)object).parameterIndex;
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.parameterIndex;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum OnMethod implements Target
            {
                INSTANCE;


                /*
                 * WARNING - void declaration
                 */
                @Override
                public final AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    void var1_1;
                    return new AnnotationAppender.Target.OnMethod((MethodVisitor)var1_1);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForInstrumentedMethod implements MethodAttributeAppender,
    Factory
    {
        EXCLUDING_RECEIVER{

            protected final AnnotationAppender appendReceiver(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, MethodDescription methodDescription) {
                return annotationAppender;
            }
        }
        ,
        INCLUDING_RECEIVER{

            /*
             * WARNING - void declaration
             */
            protected final AnnotationAppender appendReceiver(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, MethodDescription methodDescription) {
                void var2_2;
                void var1_1;
                void var3_3;
                TypeDescription.Generic receiverType = methodDescription.getReceiverType();
                if (receiverType == null) {
                    return annotationAppender;
                }
                return var3_3.accept(AnnotationAppender.ForTypeAnnotations.ofReceiverType((AnnotationAppender)var1_1, (AnnotationValueFilter)var2_2));
            }
        };


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            void var2_2;
            AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor));
            annotationAppender = methodDescription.getReturnType().accept(AnnotationAppender.ForTypeAnnotations.ofMethodReturnType(annotationAppender, annotationValueFilter));
            annotationAppender = AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, false, methodDescription.getTypeVariables());
            for (AnnotationDescription annotation : (AnnotationList)methodDescription.getDeclaredAnnotations().filter(ElementMatchers.not(ElementMatchers.annotationType(ElementMatchers.nameStartsWith("jdk.internal."))))) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
            for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
                AnnotationAppender parameterAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethodParameter(methodVisitor, parameterDescription.getIndex()));
                parameterAppender = parameterDescription.getType().accept(AnnotationAppender.ForTypeAnnotations.ofMethodParameterType(parameterAppender, annotationValueFilter, parameterDescription.getIndex()));
                for (AnnotationDescription annotation : parameterDescription.getDeclaredAnnotations()) {
                    parameterAppender = parameterAppender.append(annotation, annotationValueFilter);
                }
            }
            annotationAppender = this.appendReceiver(annotationAppender, annotationValueFilter, methodDescription);
            int exceptionTypeIndex = 0;
            for (TypeDescription.Generic generic : var2_2.getExceptionTypes()) {
                annotationAppender = generic.accept(AnnotationAppender.ForTypeAnnotations.ofExceptionType(annotationAppender, annotationValueFilter, exceptionTypeIndex++));
            }
        }

        protected abstract AnnotationAppender appendReceiver(AnnotationAppender var1, AnnotationValueFilter var2, MethodDescription var3);
    }

    public static interface Factory {
        public MethodAttributeAppender make(TypeDescription var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Compound
        implements Factory {
            private final List<Factory> factories = new ArrayList<Factory>();

            /*
             * WARNING - void declaration
             */
            public Compound(Factory ... factory) {
                this(Arrays.asList(var1_1));
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Compound(List<? extends Factory> factories) {
                Iterator iterator;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var2_2;
                    Factory factory = (Factory)iterator.next();
                    if (factory instanceof Compound) {
                        this.factories.addAll(((Compound)factory).factories);
                        continue;
                    }
                    if (factory instanceof NoOp) continue;
                    this.factories.add((Factory)var2_2);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public MethodAttributeAppender make(TypeDescription typeDescription) {
                void var2_2;
                ArrayList<MethodAttributeAppender> methodAttributeAppenders = new ArrayList<MethodAttributeAppender>(this.factories.size());
                for (Factory factory : this.factories) {
                    methodAttributeAppenders.add(factory.make(typeDescription));
                }
                return new net.bytebuddy.implementation.attribute.MethodAttributeAppender$Compound((List<? extends MethodAttributeAppender>)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.factories).equals(((Compound)object).factories);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + ((Object)this.factories).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoOp implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public final MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public final void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
        }
    }
}

