/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.RecordComponentVisitor;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.jar.asm.TypeReference;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

public interface AnnotationAppender {
    @AlwaysNull
    public static final String NO_NAME = null;

    public AnnotationAppender append(AnnotationDescription var1, AnnotationValueFilter var2);

    public AnnotationAppender append(AnnotationDescription var1, AnnotationValueFilter var2, int var3, String var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForTypeAnnotations
    implements TypeDescription.Generic.Visitor<AnnotationAppender> {
        public static final boolean VARIABLE_ON_TYPE = true;
        public static final boolean VARIABLE_ON_INVOKEABLE = false;
        private static final String EMPTY_TYPE_PATH = "";
        private static final char COMPONENT_TYPE_PATH = '[';
        private static final char WILDCARD_TYPE_PATH = '*';
        private static final char INNER_CLASS_PATH = '.';
        private static final char INDEXED_TYPE_DELIMITER = ';';
        private static final int SUPER_CLASS_INDEX = -1;
        private final AnnotationAppender annotationAppender;
        private final AnnotationValueFilter annotationValueFilter;
        private final int typeReference;
        private final String typePath;

        /*
         * WARNING - void declaration
         */
        protected ForTypeAnnotations(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, TypeReference typeReference) {
            this((AnnotationAppender)var1_1, (AnnotationValueFilter)var2_2, var3_3.getValue(), EMPTY_TYPE_PATH);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected ForTypeAnnotations(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int typeReference, String typePath) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.annotationAppender = var1_1;
            this.annotationValueFilter = var2_2;
            this.typeReference = var3_3;
            this.typePath = typePath;
        }

        /*
         * WARNING - void declaration
         */
        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofSuperClass(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            void var1_1;
            AnnotationAppender annotationAppender2;
            return new ForTypeAnnotations(annotationAppender2, (AnnotationValueFilter)var1_1, TypeReference.newSuperTypeReference(-1));
        }

        /*
         * WARNING - void declaration
         */
        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofInterfaceType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int index) {
            void var2_2;
            void var1_1;
            AnnotationAppender annotationAppender2;
            return new ForTypeAnnotations(annotationAppender2, (AnnotationValueFilter)var1_1, TypeReference.newSuperTypeReference((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofFieldType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            void var1_1;
            AnnotationAppender annotationAppender2;
            return new ForTypeAnnotations(annotationAppender2, (AnnotationValueFilter)var1_1, TypeReference.newTypeReference(19));
        }

        /*
         * WARNING - void declaration
         */
        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofMethodReturnType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            void var1_1;
            AnnotationAppender annotationAppender2;
            return new ForTypeAnnotations(annotationAppender2, (AnnotationValueFilter)var1_1, TypeReference.newTypeReference(20));
        }

        /*
         * WARNING - void declaration
         */
        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofMethodParameterType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int index) {
            void var2_2;
            void var1_1;
            AnnotationAppender annotationAppender2;
            return new ForTypeAnnotations(annotationAppender2, (AnnotationValueFilter)var1_1, TypeReference.newFormalParameterReference((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofExceptionType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, int index) {
            void var2_2;
            void var1_1;
            AnnotationAppender annotationAppender2;
            return new ForTypeAnnotations(annotationAppender2, (AnnotationValueFilter)var1_1, TypeReference.newExceptionReference((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public static TypeDescription.Generic.Visitor<AnnotationAppender> ofReceiverType(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter) {
            void var1_1;
            AnnotationAppender annotationAppender2;
            return new ForTypeAnnotations(annotationAppender2, (AnnotationValueFilter)var1_1, TypeReference.newTypeReference(21));
        }

        /*
         * WARNING - void declaration
         */
        public static AnnotationAppender ofTypeVariable(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, boolean variableOnType, List<? extends TypeDescription.Generic> typeVariables) {
            void var3_3;
            void var2_2;
            void var1_1;
            return ForTypeAnnotations.ofTypeVariable(annotationAppender, (AnnotationValueFilter)var1_1, (boolean)var2_2, 0, (List<? extends TypeDescription.Generic>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public static AnnotationAppender ofTypeVariable(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, boolean variableOnType, int subListIndex, List<? extends TypeDescription.Generic> typeVariables) {
            AnnotationAppender annotationAppender2;
            void var3_3;
            int variableBoundBaseBase;
            int variableBaseReference;
            int typeVariableIndex = subListIndex;
            if (variableOnType) {
                variableBaseReference = 0;
                variableBoundBaseBase = 17;
            } else {
                variableBaseReference = 1;
                variableBoundBaseBase = 18;
            }
            for (TypeDescription.Generic typeVariable : typeVariables.subList((int)var3_3, typeVariables.size())) {
                int typeReference = TypeReference.newTypeParameterReference(variableBaseReference, typeVariableIndex).getValue();
                for (AnnotationDescription annotationDescription : typeVariable.getDeclaredAnnotations()) {
                    annotationAppender = annotationAppender.append(annotationDescription, annotationValueFilter, typeReference, EMPTY_TYPE_PATH);
                }
                int boundIndex = !((TypeDescription.Generic)typeVariable.getUpperBounds().get(0)).getSort().isTypeVariable() && ((TypeDescription.Generic)typeVariable.getUpperBounds().get(0)).isInterface() ? 1 : 0;
                for (TypeDescription.Generic generic : typeVariable.getUpperBounds()) {
                    annotationAppender = generic.accept(new ForTypeAnnotations(annotationAppender, annotationValueFilter, TypeReference.newTypeParameterBoundReference(variableBoundBaseBase, typeVariableIndex, boundIndex++)));
                }
                ++typeVariableIndex;
            }
            return annotationAppender2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
        public AnnotationAppender onGenericArray(TypeDescription.Generic genericArray) {
            void var1_1;
            return genericArray.getComponentType().accept(new ForTypeAnnotations(this.apply((TypeDescription.Generic)var1_1, this.typePath), this.annotationValueFilter, this.typeReference, this.typePath + '['));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationAppender onWildcard(TypeDescription.Generic wildcard) {
            void var1_1;
            void var2_2;
            TypeList.Generic lowerBounds = wildcard.getLowerBounds();
            return (lowerBounds.isEmpty() ? (TypeDescription.Generic)wildcard.getUpperBounds().getOnly() : (TypeDescription.Generic)var2_2.getOnly()).accept(new ForTypeAnnotations(this.apply((TypeDescription.Generic)var1_1, this.typePath), this.annotationValueFilter, this.typeReference, this.typePath + '*'));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationAppender onParameterizedType(TypeDescription.Generic parameterizedType) {
            void var3_4;
            Iterator iterator;
            StringBuilder typePath = new StringBuilder(this.typePath);
            for (int index = 0; index < parameterizedType.asErasure().getInnerClassCount(); ++index) {
                typePath = typePath.append('.');
            }
            AnnotationAppender annotationAppender = this.apply(parameterizedType, typePath.toString());
            TypeDescription.Generic ownerType = parameterizedType.getOwnerType();
            if (ownerType != null) {
                annotationAppender = ownerType.accept(new ForTypeAnnotations(annotationAppender, this.annotationValueFilter, this.typeReference, this.typePath));
            }
            int index = 0;
            for (TypeDescription.Generic generic : iterator.getTypeArguments()) {
                annotationAppender = generic.accept(new ForTypeAnnotations(annotationAppender, this.annotationValueFilter, this.typeReference, typePath.toString() + index++ + ';'));
            }
            return var3_4;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationAppender onTypeVariable(TypeDescription.Generic typeVariable) {
            void var1_1;
            return this.apply((TypeDescription.Generic)var1_1, this.typePath);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationAppender onNonGenericType(TypeDescription.Generic typeDescription) {
            void var3_4;
            void var2_2;
            StringBuilder typePath = new StringBuilder(this.typePath);
            for (int index = 0; index < typeDescription.asErasure().getInnerClassCount(); ++index) {
                typePath = typePath.append('.');
            }
            AnnotationAppender annotationAppender = this.apply(typeDescription, var2_2.toString());
            TypeDescription.Generic componentType = typeDescription.getComponentType();
            if (componentType != null) {
                void var1_1;
                annotationAppender = var1_1.accept(new ForTypeAnnotations(annotationAppender, this.annotationValueFilter, this.typeReference, this.typePath + '['));
            }
            return var3_4;
        }

        /*
         * WARNING - void declaration
         */
        private AnnotationAppender apply(TypeDescription.Generic typeDescription, String typePath) {
            void var3_3;
            Iterator iterator;
            AnnotationAppender annotationAppender = this.annotationAppender;
            for (AnnotationDescription annotationDescription : iterator.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotationDescription, this.annotationValueFilter, this.typeReference, typePath);
            }
            return var3_3;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.typeReference != ((ForTypeAnnotations)object).typeReference) {
                return false;
            }
            if (!this.typePath.equals(((ForTypeAnnotations)object).typePath)) {
                return false;
            }
            if (!this.annotationAppender.equals(((ForTypeAnnotations)object).annotationAppender)) {
                return false;
            }
            return this.annotationValueFilter.equals(((ForTypeAnnotations)object).annotationValueFilter);
        }

        public int hashCode() {
            return (((this.getClass().hashCode() * 31 + this.annotationAppender.hashCode()) * 31 + this.annotationValueFilter.hashCode()) * 31 + this.typeReference) * 31 + this.typePath.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class Default
    implements AnnotationAppender {
        private final Target target;

        /*
         * WARNING - void declaration
         */
        public Default(Target target) {
            void var1_1;
            this.target = var1_1;
        }

        private static void handle(AnnotationVisitor annotationVisitor, AnnotationDescription annotation, AnnotationValueFilter annotationValueFilter) {
            AnnotationVisitor annotationVisitor2;
            for (MethodDescription.InDefinedShape methodDescription : annotation.getAnnotationType().getDeclaredMethods()) {
                if (!annotationValueFilter.isRelevant(annotation, methodDescription)) continue;
                Default.apply(annotationVisitor, methodDescription.getReturnType().asErasure(), methodDescription.getName(), annotation.getValue(methodDescription).resolve());
            }
            annotationVisitor2.visitEnd();
        }

        /*
         * WARNING - void declaration
         */
        public static void apply(AnnotationVisitor annotationVisitor, TypeDescription valueType, @MaybeNull String name, Object value) {
            void var3_4;
            void var2_2;
            void var1_1;
            AnnotationVisitor annotationVisitor2;
            if (valueType.isArray()) {
                AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                int length = Array.getLength(value);
                TypeDescription componentType = valueType.getComponentType();
                for (int index = 0; index < length; ++index) {
                    Default.apply(arrayVisitor, componentType, NO_NAME, Array.get(value, index));
                }
                annotationVisitor2.visitEnd();
                return;
            }
            if (var1_1.isAnnotation()) {
                Default.handle(annotationVisitor2.visitAnnotation((String)var2_2, var1_1.getDescriptor()), (AnnotationDescription)value, AnnotationValueFilter.Default.APPEND_DEFAULTS);
                return;
            }
            if (var1_1.isEnum()) {
                annotationVisitor2.visitEnum((String)var2_2, var1_1.getDescriptor(), ((EnumerationDescription)value).getValue());
                return;
            }
            if (var1_1.represents((Type)((Object)Class.class))) {
                annotationVisitor2.visit((String)var2_2, net.bytebuddy.jar.asm.Type.getType(((TypeDescription)value).getDescriptor()));
                return;
            }
            annotationVisitor2.visit((String)var2_2, var3_4);
        }

        /*
         * WARNING - void declaration
         */
        public AnnotationAppender append(AnnotationDescription annotationDescription, AnnotationValueFilter annotationValueFilter) {
            switch (annotationDescription.getRetention()) {
                case RUNTIME: {
                    this.doAppend(annotationDescription, true, annotationValueFilter);
                    break;
                }
                case CLASS: {
                    void var2_2;
                    this.doAppend(annotationDescription, false, (AnnotationValueFilter)var2_2);
                    break;
                }
                case SOURCE: {
                    break;
                }
                default: {
                    void var1_1;
                    throw new IllegalStateException("Unexpected retention policy: " + (Object)((Object)var1_1.getRetention()));
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private void doAppend(AnnotationDescription annotation, boolean visible, AnnotationValueFilter annotationValueFilter) {
            AnnotationVisitor annotationVisitor = this.target.visit(annotation.getAnnotationType().getDescriptor(), visible);
            if (annotationVisitor != null) {
                void var3_4;
                void var1_1;
                void var2_3;
                Default.handle((AnnotationVisitor)var2_3, (AnnotationDescription)var1_1, (AnnotationValueFilter)var3_4);
            }
        }

        /*
         * WARNING - void declaration
         */
        public AnnotationAppender append(AnnotationDescription annotationDescription, AnnotationValueFilter annotationValueFilter, int typeReference, String typePath) {
            switch (annotationDescription.getRetention()) {
                case RUNTIME: {
                    this.doAppend(annotationDescription, true, annotationValueFilter, typeReference, typePath);
                    break;
                }
                case CLASS: {
                    void var3_3;
                    void var2_2;
                    this.doAppend(annotationDescription, false, (AnnotationValueFilter)var2_2, (int)var3_3, typePath);
                    break;
                }
                case SOURCE: {
                    break;
                }
                default: {
                    void var1_1;
                    throw new IllegalStateException("Unexpected retention policy: " + (Object)((Object)var1_1.getRetention()));
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private void doAppend(AnnotationDescription annotation, boolean visible, AnnotationValueFilter annotationValueFilter, int typeReference, String typePath) {
            AnnotationVisitor annotationVisitor = this.target.visit(annotation.getAnnotationType().getDescriptor(), visible, typeReference, typePath);
            if (annotationVisitor != null) {
                void var3_4;
                void var1_1;
                void var2_3;
                Default.handle((AnnotationVisitor)var2_3, (AnnotationDescription)var1_1, (AnnotationValueFilter)var3_4);
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.target.equals(((Default)object).target);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.target.hashCode();
        }
    }

    public static interface Target {
        @MaybeNull
        public AnnotationVisitor visit(String var1, boolean var2);

        @MaybeNull
        public AnnotationVisitor visit(String var1, boolean var2, int var3, String var4);

        @HashCodeAndEqualsPlugin.Enhance
        public static class OnRecordComponent
        implements Target {
            private final RecordComponentVisitor recordComponentVisitor;

            /*
             * WARNING - void declaration
             */
            public OnRecordComponent(RecordComponentVisitor recordComponentVisitor) {
                void var1_1;
                this.recordComponentVisitor = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                void var2_2;
                void var1_1;
                return this.recordComponentVisitor.visitAnnotation((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                void var2_2;
                void var1_1;
                void var3_3;
                return this.recordComponentVisitor.visitTypeAnnotation((int)var3_3, TypePath.fromString(typePath), (String)var1_1, (boolean)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.recordComponentVisitor.equals(((OnRecordComponent)object).recordComponentVisitor);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.recordComponentVisitor.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class OnMethodParameter
        implements Target {
            private final MethodVisitor methodVisitor;
            private final int parameterIndex;

            /*
             * WARNING - void declaration
             */
            public OnMethodParameter(MethodVisitor methodVisitor, int parameterIndex) {
                void var2_2;
                void var1_1;
                this.methodVisitor = var1_1;
                this.parameterIndex = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                void var2_2;
                void var1_1;
                return this.methodVisitor.visitParameterAnnotation(this.parameterIndex, (String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                void var2_2;
                void var1_1;
                void var3_3;
                return this.methodVisitor.visitTypeAnnotation((int)var3_3, TypePath.fromString(typePath), (String)var1_1, (boolean)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.parameterIndex != ((OnMethodParameter)object).parameterIndex) {
                    return false;
                }
                return this.methodVisitor.equals(((OnMethodParameter)object).methodVisitor);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.methodVisitor.hashCode()) * 31 + this.parameterIndex;
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class OnMethod
        implements Target {
            private final MethodVisitor methodVisitor;

            /*
             * WARNING - void declaration
             */
            public OnMethod(MethodVisitor methodVisitor) {
                void var1_1;
                this.methodVisitor = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                void var2_2;
                void var1_1;
                return this.methodVisitor.visitAnnotation((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                void var2_2;
                void var1_1;
                void var3_3;
                return this.methodVisitor.visitTypeAnnotation((int)var3_3, TypePath.fromString(typePath), (String)var1_1, (boolean)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.methodVisitor.equals(((OnMethod)object).methodVisitor);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.methodVisitor.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class OnField
        implements Target {
            private final FieldVisitor fieldVisitor;

            /*
             * WARNING - void declaration
             */
            public OnField(FieldVisitor fieldVisitor) {
                void var1_1;
                this.fieldVisitor = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                void var2_2;
                void var1_1;
                return this.fieldVisitor.visitAnnotation((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                void var2_2;
                void var1_1;
                void var3_3;
                return this.fieldVisitor.visitTypeAnnotation((int)var3_3, TypePath.fromString(typePath), (String)var1_1, (boolean)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.fieldVisitor.equals(((OnField)object).fieldVisitor);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.fieldVisitor.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class OnType
        implements Target {
            private final ClassVisitor classVisitor;

            /*
             * WARNING - void declaration
             */
            public OnType(ClassVisitor classVisitor) {
                void var1_1;
                this.classVisitor = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                void var2_2;
                void var1_1;
                return this.classVisitor.visitAnnotation((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible, int typeReference, String typePath) {
                void var2_2;
                void var1_1;
                void var3_3;
                return this.classVisitor.visitTypeAnnotation((int)var3_3, TypePath.fromString(typePath), (String)var1_1, (boolean)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.classVisitor.equals(((OnType)object).classVisitor);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.classVisitor.hashCode();
            }
        }
    }
}

