/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.ConstantValue;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.RandomString;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class MethodCall
implements Implementation.Composable {
    protected final MethodLocator.Factory methodLocator;
    protected final TargetHandler.Factory targetHandler;
    protected final List<ArgumentLoader.Factory> argumentLoaders;
    protected final MethodInvoker.Factory methodInvoker;
    protected final TerminationHandler.Factory terminationHandler;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    /*
     * WARNING - void declaration
     */
    protected MethodCall(MethodLocator.Factory methodLocator, TargetHandler.Factory targetHandler, List<ArgumentLoader.Factory> argumentLoaders, MethodInvoker.Factory methodInvoker, TerminationHandler.Factory terminationHandler, Assigner assigner, Assigner.Typing typing) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.methodLocator = var1_1;
        this.targetHandler = var2_2;
        this.argumentLoaders = var3_3;
        this.methodInvoker = methodInvoker;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static WithoutSpecifiedTarget invoke(Method method) {
        Method method2;
        return MethodCall.invoke(new MethodDescription.ForLoadedMethod(method2));
    }

    public static WithoutSpecifiedTarget invoke(Constructor<?> constructor) {
        Constructor<?> constructor2;
        return MethodCall.invoke(new MethodDescription.ForLoadedConstructor(constructor2));
    }

    public static WithoutSpecifiedTarget invoke(MethodDescription methodDescription) {
        MethodDescription methodDescription2;
        return MethodCall.invoke(new MethodLocator.ForExplicitMethod(methodDescription2));
    }

    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher) {
        return MethodCall.invoke(matcher, MethodGraph.Compiler.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
        void var1_1;
        ElementMatcher<? super MethodDescription> elementMatcher;
        return MethodCall.invoke(new MethodLocator.ForElementMatcher.Factory(elementMatcher, (MethodGraph.Compiler)var1_1));
    }

    public static WithoutSpecifiedTarget invoke(MethodLocator.Factory methodLocator) {
        MethodLocator.Factory factory;
        return new WithoutSpecifiedTarget(factory);
    }

    public static WithoutSpecifiedTarget invokeSelf() {
        return new WithoutSpecifiedTarget(MethodLocator.ForInstrumentedMethod.INSTANCE);
    }

    public static MethodCall invokeSuper() {
        return MethodCall.invokeSelf().onSuper();
    }

    /*
     * WARNING - void declaration
     */
    public static Implementation.Composable call(Callable<?> callable) {
        try {
            return MethodCall.invoke(Callable.class.getMethod("call", new Class[0])).on(callable, Callable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            void var0_1;
            throw new IllegalStateException("Could not locate Callable::call method", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Implementation.Composable run(Runnable runnable) {
        try {
            return MethodCall.invoke(Runnable.class.getMethod("run", new Class[0])).on(runnable, Runnable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            void var0_1;
            throw new IllegalStateException("Could not locate Runnable::run method", (Throwable)var0_1);
        }
    }

    public static MethodCall construct(Constructor<?> constructor) {
        Constructor<?> constructor2;
        return MethodCall.construct(new MethodDescription.ForLoadedConstructor(constructor2));
    }

    public static MethodCall construct(MethodDescription methodDescription) {
        MethodDescription methodDescription2;
        if (!methodDescription.isConstructor()) {
            throw new IllegalArgumentException("Not a constructor: " + methodDescription);
        }
        return new MethodCall(new MethodLocator.ForExplicitMethod(methodDescription2), TargetHandler.ForConstructingInvocation.Factory.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.Factory.INSTANCE, TerminationHandler.Simple.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(Object ... argument) {
        void var2_2;
        void var1_1;
        ArrayList<ArgumentLoader.Factory> argumentLoaders = new ArrayList<ArgumentLoader.Factory>(argument.length);
        for (void anArgument : var1_1) {
            argumentLoaders.add(ArgumentLoader.ForStackManipulation.of(anArgument));
        }
        return this.with((List<? extends ArgumentLoader.Factory>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(TypeDescription ... typeDescription) {
        void var2_2;
        void var1_1;
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(typeDescription.length);
        for (void aTypeDescription : var1_1) {
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(ClassConstant.of((TypeDescription)aTypeDescription), (Type)((Object)Class.class)));
        }
        return this.with((List<? extends ArgumentLoader.Factory>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(EnumerationDescription ... enumerationDescription) {
        void var2_2;
        void var1_1;
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(enumerationDescription.length);
        for (void anEnumerationDescription : var1_1) {
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(FieldAccess.forEnumeration((EnumerationDescription)anEnumerationDescription), anEnumerationDescription.getEnumerationType()));
        }
        return this.with((List<? extends ArgumentLoader.Factory>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(ConstantValue ... constant) {
        void var2_2;
        void var1_1;
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(constant.length);
        for (void aConstant : var1_1) {
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(aConstant.toStackManipulation(), aConstant.getTypeDescription()));
        }
        return this.with((List<? extends ArgumentLoader.Factory>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(JavaConstant ... constant) {
        void var1_1;
        return this.with((ConstantValue[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall withReference(Object ... argument) {
        void var2_2;
        void var1_1;
        ArrayList<ArgumentLoader.ForNullConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForNullConstant>(argument.length);
        for (void anArgument : var1_1) {
            argumentLoaders.add((ArgumentLoader.ForNullConstant)(anArgument == null ? ArgumentLoader.ForNullConstant.INSTANCE : new ArgumentLoader.ForInstance.Factory(anArgument)));
        }
        return this.with((List<? extends ArgumentLoader.Factory>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall withArgument(int ... index) {
        void var2_2;
        void var1_1;
        ArrayList<ArgumentLoader.ForMethodParameter.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameter.Factory>(index.length);
        for (void anIndex : var1_1) {
            if (anIndex < 0) {
                throw new IllegalArgumentException("Negative index: " + (int)anIndex);
            }
            argumentLoaders.add(new ArgumentLoader.ForMethodParameter.Factory((int)anIndex));
        }
        return this.with((List<? extends ArgumentLoader.Factory>)var2_2);
    }

    public MethodCall withAllArguments() {
        return this.with(ArgumentLoader.ForMethodParameter.OfInstrumentedMethod.INSTANCE);
    }

    public MethodCall withArgumentArray() {
        return this.with(ArgumentLoader.ForMethodParameterArray.ForInstrumentedMethod.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall withArgumentArrayElements(int index) {
        void var1_1;
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        return this.with(new ArgumentLoader.ForMethodParameterArrayElement.OfInvokedMethod((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall withArgumentArrayElements(int index, int size) {
        void var2_2;
        void var1_1;
        return this.withArgumentArrayElements((int)var1_1, 0, (int)var2_2);
    }

    public MethodCall withArgumentArrayElements(int index, int start, int size) {
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        if (start < 0) {
            throw new IllegalArgumentException("An array index cannot be negative: " + start);
        }
        if (size == 0) {
            return this;
        }
        if (size < 0) {
            throw new IllegalArgumentException("Size cannot be negative: " + size);
        }
        ArrayList<ArgumentLoader.ForMethodParameterArrayElement.OfParameter> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameterArrayElement.OfParameter>(size);
        for (int position = 0; position < size; ++position) {
            argumentLoaders.add(new ArgumentLoader.ForMethodParameterArrayElement.OfParameter(index, start + position));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withThis() {
        return this.with(ArgumentLoader.ForThisReference.Factory.INSTANCE);
    }

    public MethodCall withOwnType() {
        return this.with(ArgumentLoader.ForInstrumentedType.Factory.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall withField(String ... name) {
        void var1_1;
        return this.withField(FieldLocator.ForClassHierarchy.Factory.INSTANCE, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall withField(FieldLocator.Factory fieldLocatorFactory, String ... name) {
        void var3_3;
        void var2_2;
        ArrayList<ArgumentLoader.ForField.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForField.Factory>(name.length);
        for (void aName : var2_2) {
            argumentLoaders.add(new ArgumentLoader.ForField.Factory((String)aName, fieldLocatorFactory));
        }
        return this.with((List<? extends ArgumentLoader.Factory>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall withMethodCall(MethodCall methodCall) {
        void var1_1;
        return this.with(new ArgumentLoader.ForMethodCall.Factory((MethodCall)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(StackManipulation stackManipulation, Type type) {
        void var2_2;
        void var1_1;
        return this.with((StackManipulation)var1_1, TypeDefinition.Sort.describe((Type)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(StackManipulation stackManipulation, TypeDefinition typeDefinition) {
        void var2_2;
        void var1_1;
        return this.with(new ArgumentLoader.ForStackManipulation((StackManipulation)var1_1, (TypeDefinition)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(ArgumentLoader.Factory ... argumentLoader) {
        void var1_1;
        return this.with(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public MethodCall with(List<? extends ArgumentLoader.Factory> argumentLoaders) {
        void var1_1;
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, var1_1), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    /*
     * WARNING - void declaration
     */
    public FieldSetting setsField(Field field) {
        void var1_1;
        return this.setsField(new FieldDescription.ForLoadedField((Field)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public FieldSetting setsField(FieldDescription fieldDescription) {
        void var1_1;
        return new FieldSetting(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, new TerminationHandler.FieldSetting.Explicit((FieldDescription)var1_1), this.assigner, this.typing));
    }

    /*
     * WARNING - void declaration
     */
    public FieldSetting setsField(ElementMatcher<? super FieldDescription> matcher) {
        void var1_1;
        return new FieldSetting(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, new TerminationHandler.FieldSetting.Implicit((ElementMatcher<? super FieldDescription>)var1_1), this.assigner, this.typing));
    }

    /*
     * WARNING - void declaration
     */
    public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
        void var2_2;
        void var1_1;
        return new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, this.terminationHandler, (Assigner)var1_1, (Assigner.Typing)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Implementation andThen(Implementation implementation) {
        void var1_1;
        return new Implementation.Compound(new Implementation[]{new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.Simple.DROPPING, this.assigner, this.typing), var1_1});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Implementation.Composable andThen(Implementation.Composable implementation) {
        void var1_1;
        return new Implementation.Compound.Composable(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.Simple.DROPPING, this.assigner, this.typing), (Implementation.Composable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        void var1_1;
        for (InstrumentedType.Prepareable prepareable : this.argumentLoaders) {
            instrumentedType = prepareable.prepare(instrumentedType);
        }
        return this.targetHandler.prepare((InstrumentedType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        void var1_1;
        return new Appender(implementationTarget, this.terminationHandler.make(var1_1.getInstrumentedType()));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.typing.equals((Object)((MethodCall)object).typing)) {
            return false;
        }
        if (!this.methodLocator.equals(((MethodCall)object).methodLocator)) {
            return false;
        }
        if (!this.targetHandler.equals(((MethodCall)object).targetHandler)) {
            return false;
        }
        if (!((Object)this.argumentLoaders).equals(((MethodCall)object).argumentLoaders)) {
            return false;
        }
        if (!this.methodInvoker.equals(((MethodCall)object).methodInvoker)) {
            return false;
        }
        if (!this.terminationHandler.equals(((MethodCall)object).terminationHandler)) {
            return false;
        }
        return this.assigner.equals(((MethodCall)object).assigner);
    }

    public int hashCode() {
        return ((((((this.getClass().hashCode() * 31 + this.methodLocator.hashCode()) * 31 + this.targetHandler.hashCode()) * 31 + ((Object)this.argumentLoaders).hashCode()) * 31 + this.methodInvoker.hashCode()) * 31 + this.terminationHandler.hashCode()) * 31 + this.assigner.hashCode()) * 31 + this.typing.hashCode();
    }

    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;
        private final MethodLocator methodLocator;
        private final List<ArgumentLoader.ArgumentProvider> argumentProviders;
        private final MethodInvoker methodInvoker;
        private final TargetHandler targetHandler;
        private final TerminationHandler terminationHandler;

        /*
         * WARNING - void declaration
         */
        protected Appender(Implementation.Target implementationTarget, TerminationHandler terminationHandler) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.implementationTarget = implementationTarget;
            this.methodLocator = MethodCall.this.methodLocator.make(implementationTarget.getInstrumentedType());
            this.argumentProviders = new ArrayList<ArgumentLoader.ArgumentProvider>(MethodCall.this.argumentLoaders.size());
            for (ArgumentLoader.Factory factory : MethodCall.this.argumentLoaders) {
                this.argumentProviders.add(factory.make(implementationTarget));
            }
            this.methodInvoker = MethodCall.this.methodInvoker.make(implementationTarget.getInstrumentedType());
            this.targetHandler = var1_1.targetHandler.make((Implementation.Target)var2_2);
            this.terminationHandler = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var2_2;
            void var1_1;
            TargetHandler.Resolved targetHandler = this.targetHandler.resolve(instrumentedMethod);
            return new ByteCodeAppender.Size(new StackManipulation.Compound(this.terminationHandler.prepare(), this.toStackManipulation(instrumentedMethod, this.toInvokedMethod(instrumentedMethod, targetHandler), targetHandler)).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2).getMaximalSize(), var3_3.getStackSize());
        }

        /*
         * WARNING - void declaration
         */
        protected MethodDescription toInvokedMethod(MethodDescription instrumentedMethod, TargetHandler.Resolved targetHandler) {
            void var1_1;
            void var2_2;
            return this.methodLocator.resolve(var2_2.getTypeDescription(), (MethodDescription)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected StackManipulation toStackManipulation(MethodDescription instrumentedMethod, MethodDescription invokedMethod, TargetHandler.Resolved targetHandler) {
            void var1_1;
            void var2_2;
            void var3_3;
            ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>();
            for (ArgumentLoader.ArgumentProvider argumentProvider : this.argumentProviders) {
                argumentLoaders.addAll(argumentProvider.resolve(instrumentedMethod, invokedMethod));
            }
            ParameterList<?> parameters = invokedMethod.getParameters();
            if (parameters.size() != argumentLoaders.size()) {
                throw new IllegalStateException(invokedMethod + " does not accept " + argumentLoaders.size() + " arguments");
            }
            Iterator parameterIterator = parameters.iterator();
            ArrayList<StackManipulation> argumentInstructions = new ArrayList<StackManipulation>(argumentLoaders.size());
            for (ArgumentLoader argumentLoader : argumentLoaders) {
                argumentInstructions.add(argumentLoader.toStackManipulation((ParameterDescription)parameterIterator.next(), MethodCall.this.assigner, MethodCall.this.typing));
            }
            return new StackManipulation.Compound(var3_3.toStackManipulation(invokedMethod, MethodCall.this.assigner, MethodCall.this.typing), new StackManipulation.Compound(argumentInstructions), this.methodInvoker.toStackManipulation(invokedMethod, this.implementationTarget), this.terminationHandler.toStackManipulation((MethodDescription)var2_2, (MethodDescription)var1_1, MethodCall.this.assigner, MethodCall.this.typing));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.implementationTarget.equals(((Appender)object).implementationTarget)) {
                return false;
            }
            if (!this.methodLocator.equals(((Appender)object).methodLocator)) {
                return false;
            }
            if (!((Object)this.argumentProviders).equals(((Appender)object).argumentProviders)) {
                return false;
            }
            if (!this.methodInvoker.equals(((Appender)object).methodInvoker)) {
                return false;
            }
            if (!this.targetHandler.equals(((Appender)object).targetHandler)) {
                return false;
            }
            if (!this.terminationHandler.equals(((Appender)object).terminationHandler)) {
                return false;
            }
            return MethodCall.this.equals(((Appender)object).MethodCall.this);
        }

        public int hashCode() {
            return ((((((this.getClass().hashCode() * 31 + this.implementationTarget.hashCode()) * 31 + this.methodLocator.hashCode()) * 31 + ((Object)this.argumentProviders).hashCode()) * 31 + this.methodInvoker.hashCode()) * 31 + this.targetHandler.hashCode()) * 31 + this.terminationHandler.hashCode()) * 31 + MethodCall.this.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class FieldSetting
    implements Implementation.Composable {
        private final MethodCall methodCall;

        /*
         * WARNING - void declaration
         */
        protected FieldSetting(MethodCall methodCall) {
            void var1_1;
            this.methodCall = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
            void var2_2;
            void var1_1;
            return new FieldSetting((MethodCall)this.methodCall.withAssigner((Assigner)var1_1, (Assigner.Typing)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            void var1_1;
            return this.methodCall.prepare((InstrumentedType)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            void var1_1;
            return new ByteCodeAppender.Compound(this.methodCall.appender((Implementation.Target)var1_1), Appender.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public Implementation andThen(Implementation implementation) {
            void var1_1;
            return new Implementation.Compound(new Implementation[]{this.methodCall, var1_1});
        }

        /*
         * WARNING - void declaration
         */
        public Implementation.Composable andThen(Implementation.Composable implementation) {
            void var1_1;
            return new Implementation.Compound.Composable(this.methodCall, (Implementation.Composable)var1_1);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.methodCall.equals(((FieldSetting)object).methodCall);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.methodCall.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum Appender implements ByteCodeAppender
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            public final ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    throw new IllegalStateException("Instrumented method " + instrumentedMethod + " does not return void for field setting method call");
                }
                return new ByteCodeAppender.Size(MethodReturn.VOID.apply((MethodVisitor)var1_1, (Implementation.Context)var2_2).getMaximalSize(), var3_3.getStackSize());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithoutSpecifiedTarget
    extends MethodCall {
        /*
         * WARNING - void declaration
         */
        protected WithoutSpecifiedTarget(MethodLocator.Factory methodLocator) {
            super((MethodLocator.Factory)var1_1, TargetHandler.ForSelfOrStaticInvocation.Factory.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.Factory.INSTANCE, TerminationHandler.Simple.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall on(Object target) {
            void var1_1;
            void v0 = var1_1;
            return this.on(v0, v0.getClass());
        }

        /*
         * WARNING - void declaration
         */
        public <T> MethodCall on(T target, Class<? super T> type) {
            void var2_2;
            void var1_1;
            return new MethodCall(this.methodLocator, new TargetHandler.ForValue.Factory(var1_1, TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(type)), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation.Factory(TypeDescription.ForLoadedType.of(var2_2)), this.terminationHandler, this.assigner, this.typing);
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall on(StackManipulation stackManipulation, Class<?> type) {
            void var2_2;
            void var1_1;
            return this.on((StackManipulation)var1_1, TypeDescription.ForLoadedType.of(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall on(StackManipulation stackManipulation, TypeDescription typeDescription) {
            void var2_2;
            void var1_1;
            return new MethodCall(this.methodLocator, new TargetHandler.Simple(typeDescription, (StackManipulation)var1_1), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation.Factory((TypeDescription)var2_2), this.terminationHandler, this.assigner, this.typing);
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall onArgument(int index) {
            void var1_1;
            if (index < 0) {
                throw new IllegalArgumentException("An argument index cannot be negative: " + index);
            }
            return new MethodCall(this.methodLocator, new TargetHandler.ForMethodParameter((int)var1_1), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall onField(String name) {
            void var1_1;
            return this.onField((String)var1_1, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall onField(String name, FieldLocator.Factory fieldLocatorFactory) {
            void var2_2;
            void var1_1;
            return new MethodCall(this.methodLocator, new TargetHandler.ForField.Factory(new TargetHandler.ForField.Location.ForImplicitField((String)var1_1, (FieldLocator.Factory)var2_2)), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall onField(Field field) {
            void var1_1;
            return this.onField(new FieldDescription.ForLoadedField((Field)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall onField(FieldDescription fieldDescription) {
            void var1_1;
            return new MethodCall(this.methodLocator, new TargetHandler.ForField.Factory(new TargetHandler.ForField.Location.ForExplicitField((FieldDescription)var1_1)), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        /*
         * WARNING - void declaration
         */
        public MethodCall onMethodCall(MethodCall methodCall) {
            void var1_1;
            return new MethodCall(this.methodLocator, new TargetHandler.ForMethodCall.Factory((MethodCall)var1_1), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onSuper() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.Factory.INSTANCE, this.argumentLoaders, MethodInvoker.ForSuperMethodInvocation.Factory.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onDefault() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.Factory.INSTANCE, this.argumentLoaders, MethodInvoker.ForDefaultMethodInvocation.Factory.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }
    }

    protected static interface TerminationHandler {
        public StackManipulation prepare();

        public StackManipulation toStackManipulation(MethodDescription var1, MethodDescription var2, Assigner var3, Assigner.Typing var4);

        @HashCodeAndEqualsPlugin.Enhance
        public static class FieldSetting
        implements TerminationHandler {
            private final FieldDescription fieldDescription;

            /*
             * WARNING - void declaration
             */
            protected FieldSetting(FieldDescription fieldDescription) {
                void var1_1;
                this.fieldDescription = var1_1;
            }

            public StackManipulation prepare() {
                if (this.fieldDescription.isStatic()) {
                    return StackManipulation.Trivial.INSTANCE;
                }
                return MethodVariableAccess.loadThis();
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                StackManipulation stackManipulation = assigner.assign(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType().asGenericType() : invokedMethod.getReturnType(), this.fieldDescription.getType(), typing);
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign result of " + var1_1 + " to " + this.fieldDescription);
                }
                return new StackManipulation.Compound(new StackManipulation[]{var2_2, FieldAccess.forField(this.fieldDescription).write()});
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.fieldDescription.equals(((FieldSetting)object).fieldDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Implicit
            implements Factory {
                private final ElementMatcher<? super FieldDescription> matcher;

                /*
                 * WARNING - void declaration
                 */
                protected Implicit(ElementMatcher<? super FieldDescription> matcher) {
                    void var1_1;
                    this.matcher = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public TerminationHandler make(TypeDescription instrumentedType) {
                    void var1_1;
                    TypeDefinition current = instrumentedType;
                    do {
                        void var3_3;
                        FieldList candidates;
                        if ((candidates = (FieldList)current.getDeclaredFields().filter(ElementMatchers.isVisibleTo(instrumentedType).and(this.matcher))).size() == 1) {
                            return new FieldSetting((FieldDescription)candidates.getOnly());
                        }
                        if (candidates.size() != 2) continue;
                        throw new IllegalStateException(this.matcher + " is ambiguous and resolved: " + var3_3);
                    } while ((current = current.getSuperClass()) != null);
                    throw new IllegalStateException(this.matcher + " does not locate any accessible fields for " + var1_1);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.matcher.equals(((Implicit)object).matcher);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.matcher.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Explicit
            implements Factory {
                private final FieldDescription fieldDescription;

                /*
                 * WARNING - void declaration
                 */
                protected Explicit(FieldDescription fieldDescription) {
                    void var1_1;
                    this.fieldDescription = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
                public TerminationHandler make(TypeDescription instrumentedType) {
                    if (!this.fieldDescription.isStatic() && !instrumentedType.isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                        throw new IllegalStateException("Cannot set " + this.fieldDescription + " from " + instrumentedType);
                    }
                    if (!this.fieldDescription.isVisibleTo(instrumentedType)) {
                        void var1_1;
                        throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + var1_1);
                    }
                    return new FieldSetting(this.fieldDescription);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.fieldDescription.equals(((Explicit)object).fieldDescription);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Simple implements TerminationHandler,
        Factory
        {
            RETURNING{

                /*
                 * WARNING - void declaration
                 */
                public final StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    void var2_2;
                    void var3_3;
                    StackManipulation stackManipulation = assigner.assign(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType().asGenericType() : invokedMethod.getReturnType(), instrumentedMethod.getReturnType(), typing);
                    if (!stackManipulation.isValid()) {
                        void var1_1;
                        throw new IllegalStateException("Cannot return " + var1_1.getReturnType() + " from " + instrumentedMethod);
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{var3_3, MethodReturn.of(var2_2.getReturnType())});
                }
            }
            ,
            DROPPING{

                /*
                 * WARNING - void declaration
                 */
                public final StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    void var1_1;
                    return Removal.of(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType() : var1_1.getReturnType());
                }
            }
            ,
            IGNORING{

                public final StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            };


            @Override
            public TerminationHandler make(TypeDescription instrumentedType) {
                return this;
            }

            @Override
            public StackManipulation prepare() {
                return StackManipulation.Trivial.INSTANCE;
            }
        }

        public static interface Factory {
            public TerminationHandler make(TypeDescription var1);
        }
    }

    protected static interface MethodInvoker {
        public StackManipulation toStackManipulation(MethodDescription var1, Implementation.Target var2);

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForDefaultMethodInvocation
        implements MethodInvoker {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            protected ForDefaultMethodInvocation(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                void var2_2;
                if (!invokedMethod.isInvokableOn(this.instrumentedType)) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as default method of " + this.instrumentedType);
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDefault(invokedMethod.asSignatureToken(), invokedMethod.getDeclaringType().asErasure()).withCheckedCompatibilityTo(invokedMethod.asTypeToken());
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot invoke " + var1_1 + " on " + this.instrumentedType);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((ForDefaultMethodInvocation)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum Factory implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                /*
                 * WARNING - void declaration
                 */
                @Override
                public final MethodInvoker make(TypeDescription instrumentedType) {
                    void var1_1;
                    return new ForDefaultMethodInvocation((TypeDescription)var1_1);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForSuperMethodInvocation
        implements MethodInvoker {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            protected ForSuperMethodInvocation(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                void var2_2;
                if (!invokedMethod.isInvokableOn(implementationTarget.getOriginType().asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as super method of " + this.instrumentedType);
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDominant(invokedMethod.asSignatureToken()).withCheckedCompatibilityTo(invokedMethod.asTypeToken());
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot invoke " + var1_1 + " as a super method");
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((ForSuperMethodInvocation)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum Factory implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                /*
                 * WARNING - void declaration
                 */
                @Override
                public final MethodInvoker make(TypeDescription instrumentedType) {
                    void var1_1;
                    if (instrumentedType.getSuperClass() == null) {
                        throw new IllegalStateException("Cannot invoke super method for " + instrumentedType);
                    }
                    return new ForSuperMethodInvocation((TypeDescription)var1_1);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForVirtualInvocation
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            /*
             * WARNING - void declaration
             */
            protected ForVirtualInvocation(TypeDescription typeDescription) {
                void var1_1;
                this.typeDescription = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                void var1_1;
                if (!invokedMethod.isInvokableOn(this.typeDescription)) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.typeDescription);
                }
                return MethodInvocation.invoke((MethodDescription)var1_1).virtual(this.typeDescription);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.typeDescription.equals(((ForVirtualInvocation)object).typeDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.typeDescription.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory {
                private final TypeDescription typeDescription;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(TypeDescription typeDescription) {
                    void var1_1;
                    this.typeDescription = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public MethodInvoker make(TypeDescription instrumentedType) {
                    if (!this.typeDescription.asErasure().isAccessibleTo(instrumentedType)) {
                        void var1_1;
                        throw new IllegalStateException(this.typeDescription + " is not accessible to " + var1_1);
                    }
                    return new ForVirtualInvocation(this.typeDescription);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.typeDescription.equals(((Factory)object).typeDescription);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.typeDescription.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum WithImplicitType implements MethodInvoker,
            net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                @Override
                public final MethodInvoker make(TypeDescription instrumentedType) {
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                    void var1_1;
                    void var2_2;
                    if (!invokedMethod.isAccessibleTo(var2_2.getInstrumentedType()) || !invokedMethod.isVirtual()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                    }
                    return MethodInvocation.invoke((MethodDescription)var1_1);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForContextualInvocation
        implements MethodInvoker {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            protected ForContextualInvocation(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                void var1_1;
                if (invokedMethod.isVirtual() && !invokedMethod.isInvokableOn(this.instrumentedType)) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.instrumentedType);
                }
                if (invokedMethod.isVirtual()) {
                    return MethodInvocation.invoke(invokedMethod).virtual(this.instrumentedType);
                }
                return MethodInvocation.invoke((MethodDescription)var1_1);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((ForContextualInvocation)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum Factory implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                /*
                 * WARNING - void declaration
                 */
                @Override
                public final MethodInvoker make(TypeDescription instrumentedType) {
                    void var1_1;
                    return new ForContextualInvocation((TypeDescription)var1_1);
                }
            }
        }

        public static interface Factory {
            public MethodInvoker make(TypeDescription var1);
        }
    }

    protected static interface TargetHandler {
        public Resolved resolve(MethodDescription var1);

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodCall
        implements TargetHandler {
            private final Appender appender;

            /*
             * WARNING - void declaration
             */
            protected ForMethodCall(Appender appender) {
                void var1_1;
                this.appender = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved resolve(MethodDescription instrumentedMethod) {
                void var2_2;
                void var1_1;
                net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved targetHandler = this.appender.targetHandler.resolve(instrumentedMethod);
                return new Resolved(this.appender, this.appender.toInvokedMethod(instrumentedMethod, targetHandler), (MethodDescription)var1_1, (net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.appender.equals(((ForMethodCall)object).appender);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.appender.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory {
                private final MethodCall methodCall;

                /*
                 * WARNING - void declaration
                 */
                public Factory(MethodCall methodCall) {
                    void var1_1;
                    this.methodCall = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    void var1_1;
                    return this.methodCall.prepare((InstrumentedType)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public TargetHandler make(Implementation.Target implementationTarget) {
                    void var1_1;
                    MethodCall methodCall = this.methodCall;
                    methodCall.getClass();
                    return new ForMethodCall(methodCall.new Appender((Implementation.Target)var1_1, TerminationHandler.Simple.IGNORING));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.methodCall.equals(((Factory)object).methodCall);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.methodCall.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Resolved
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved {
                private final Appender appender;
                private final MethodDescription methodDescription;
                private final MethodDescription instrumentedMethod;
                private final net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved targetHandler;

                /*
                 * WARNING - void declaration
                 */
                protected Resolved(Appender appender, MethodDescription methodDescription, MethodDescription instrumentedMethod, net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved targetHandler) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.appender = var1_1;
                    this.methodDescription = var2_2;
                    this.instrumentedMethod = var3_3;
                    this.targetHandler = targetHandler;
                }

                public TypeDescription getTypeDescription() {
                    if (this.methodDescription.isConstructor()) {
                        return this.methodDescription.getDeclaringType().asErasure();
                    }
                    return this.methodDescription.getReturnType().asErasure();
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                    void var2_2;
                    void var3_3;
                    StackManipulation stackManipulation = assigner.assign(this.methodDescription.isConstructor() ? this.methodDescription.getDeclaringType().asGenericType() : this.methodDescription.getReturnType(), invokedMethod.getDeclaringType().asGenericType(), (Assigner.Typing)var3_3);
                    if (!stackManipulation.isValid()) {
                        void var1_1;
                        throw new IllegalStateException("Cannot invoke " + var1_1 + " on " + (this.methodDescription.isConstructor() ? this.methodDescription.getDeclaringType() : this.methodDescription.getReturnType()));
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{this.appender.toStackManipulation(this.instrumentedMethod, this.methodDescription, this.targetHandler), var2_2});
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.appender.equals(((Resolved)object).appender)) {
                        return false;
                    }
                    if (!this.methodDescription.equals(((Resolved)object).methodDescription)) {
                        return false;
                    }
                    if (!this.instrumentedMethod.equals(((Resolved)object).instrumentedMethod)) {
                        return false;
                    }
                    return this.targetHandler.equals(((Resolved)object).targetHandler);
                }

                public int hashCode() {
                    return (((this.getClass().hashCode() * 31 + this.appender.hashCode()) * 31 + this.methodDescription.hashCode()) * 31 + this.instrumentedMethod.hashCode()) * 31 + this.targetHandler.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameter
        implements TargetHandler,
        Factory {
            private final int index;

            /*
             * WARNING - void declaration
             */
            protected ForMethodParameter(int index) {
                void var1_1;
                this.index = var1_1;
            }

            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public TargetHandler make(Implementation.Target implementationTarget) {
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved resolve(MethodDescription instrumentedMethod) {
                void var1_1;
                if (this.index >= instrumentedMethod.getParameters().size()) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not have a parameter with index " + this.index);
                }
                return new Resolved((ParameterDescription)var1_1.getParameters().get(this.index));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.index == ((ForMethodParameter)object).index;
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.index;
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Resolved
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved {
                private final ParameterDescription parameterDescription;

                /*
                 * WARNING - void declaration
                 */
                protected Resolved(ParameterDescription parameterDescription) {
                    void var1_1;
                    this.parameterDescription = var1_1;
                }

                public TypeDescription getTypeDescription() {
                    return this.parameterDescription.getType().asErasure();
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                    void var2_2;
                    void var3_3;
                    StackManipulation stackManipulation = assigner.assign(this.parameterDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), (Assigner.Typing)var3_3);
                    if (!stackManipulation.isValid()) {
                        void var1_1;
                        throw new IllegalStateException("Cannot invoke " + var1_1 + " on " + this.parameterDescription.getType());
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.load(this.parameterDescription), var2_2});
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.parameterDescription.equals(((Resolved)object).parameterDescription);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.parameterDescription.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForField
        implements TargetHandler,
        Resolved {
            private final FieldDescription fieldDescription;

            /*
             * WARNING - void declaration
             */
            protected ForField(FieldDescription fieldDescription) {
                void var1_1;
                this.fieldDescription = var1_1;
            }

            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            public TypeDescription getTypeDescription() {
                return this.fieldDescription.getType().asErasure();
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var1_1;
                void var3_3;
                if (!(invokedMethod.isMethod() && invokedMethod.isVirtual() && invokedMethod.isVisibleTo(this.fieldDescription.getType().asErasure()))) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.fieldDescription);
                }
                StackManipulation stackManipulation = assigner.assign(this.fieldDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), (Assigner.Typing)var3_3);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.fieldDescription);
                }
                return new StackManipulation.Compound(new StackManipulation[]{var1_1.isStatic() || this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), var2_2});
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.fieldDescription.equals(((ForField)object).fieldDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory {
                private final Location location;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(Location location) {
                    void var1_1;
                    this.location = var1_1;
                }

                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
                public TargetHandler make(Implementation.Target implementationTarget) {
                    void var2_2;
                    FieldDescription fieldDescription = this.location.resolve(implementationTarget.getInstrumentedType());
                    if (!fieldDescription.isStatic() && !implementationTarget.getInstrumentedType().isAssignableTo(fieldDescription.getDeclaringType().asErasure())) {
                        void var1_1;
                        throw new IllegalStateException("Cannot access " + fieldDescription + " from " + var1_1.getInstrumentedType());
                    }
                    return new ForField((FieldDescription)var2_2);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.location.equals(((Factory)object).location);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.location.hashCode();
                }
            }

            protected static interface Location {
                public FieldDescription resolve(TypeDescription var1);

                @HashCodeAndEqualsPlugin.Enhance
                public static class ForExplicitField
                implements Location {
                    private final FieldDescription fieldDescription;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForExplicitField(FieldDescription fieldDescription) {
                        void var1_1;
                        this.fieldDescription = var1_1;
                    }

                    public FieldDescription resolve(TypeDescription instrumentedType) {
                        return this.fieldDescription;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.fieldDescription.equals(((ForExplicitField)object).fieldDescription);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class ForImplicitField
                implements Location {
                    private final String name;
                    private final FieldLocator.Factory fieldLocatorFactory;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForImplicitField(String name, FieldLocator.Factory fieldLocatorFactory) {
                        void var2_2;
                        void var1_1;
                        this.name = var1_1;
                        this.fieldLocatorFactory = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public FieldDescription resolve(TypeDescription instrumentedType) {
                        void var2_2;
                        FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.name);
                        if (!resolution.isResolved()) {
                            void var1_1;
                            throw new IllegalStateException("Could not locate field name " + this.name + " on " + var1_1);
                        }
                        return var2_2.getField();
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.name.equals(((ForImplicitField)object).name)) {
                            return false;
                        }
                        return this.fieldLocatorFactory.equals(((ForImplicitField)object).fieldLocatorFactory);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.name.hashCode()) * 31 + this.fieldLocatorFactory.hashCode();
                    }
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForValue
        implements TargetHandler,
        Resolved {
            private final FieldDescription.InDefinedShape fieldDescription;

            /*
             * WARNING - void declaration
             */
            protected ForValue(FieldDescription.InDefinedShape fieldDescription) {
                void var1_1;
                this.fieldDescription = var1_1;
            }

            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            public TypeDescription getTypeDescription() {
                return this.fieldDescription.getType().asErasure();
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                StackManipulation stackManipulation = assigner.assign(this.fieldDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), (Assigner.Typing)var3_3);
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot invoke " + var1_1 + " on " + this.fieldDescription);
                }
                return new StackManipulation.Compound(new StackManipulation[]{FieldAccess.forField(this.fieldDescription).read(), var2_2});
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.fieldDescription.equals(((ForValue)object).fieldDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory {
                private static final String FIELD_PREFIX = "invocationTarget";
                private final Object target;
                private final TypeDescription.Generic fieldType;
                @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
                private final String name;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(Object target, TypeDescription.Generic fieldType) {
                    void var1_1;
                    void var2_2;
                    this.target = target;
                    this.fieldType = var2_2;
                    this.name = "invocationTarget$" + RandomString.hashOf(var1_1);
                }

                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withAuxiliaryField(new FieldDescription.Token(this.name, 4169, this.fieldType), this.target);
                }

                /*
                 * WARNING - void declaration
                 */
                public TargetHandler make(Implementation.Target implementationTarget) {
                    void var1_1;
                    return new ForValue((FieldDescription.InDefinedShape)((FieldList)var1_1.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly());
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.target.equals(((Factory)object).target)) {
                        return false;
                    }
                    return this.fieldType.equals(((Factory)object).fieldType);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.fieldType.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForConstructingInvocation
        implements TargetHandler,
        Resolved {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            protected ForConstructingInvocation(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            public TypeDescription getTypeDescription() {
                return this.instrumentedType;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                void var1_1;
                return new StackManipulation.Compound(TypeCreation.of(var1_1.getDeclaringType().asErasure()), Duplication.SINGLE);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((ForConstructingInvocation)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum Factory implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory
            {
                INSTANCE;


                @Override
                public final InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final TargetHandler make(Implementation.Target implementationTarget) {
                    void var1_1;
                    return new ForConstructingInvocation(var1_1.getInstrumentedType());
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForSelfOrStaticInvocation
        implements TargetHandler {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            protected ForSelfOrStaticInvocation(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved resolve(MethodDescription instrumentedMethod) {
                void var1_1;
                return new Resolved(this.instrumentedType, (MethodDescription)var1_1);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((ForSelfOrStaticInvocation)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum Factory implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory
            {
                INSTANCE;


                @Override
                public final InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final TargetHandler make(Implementation.Target implementationTarget) {
                    void var1_1;
                    return new ForSelfOrStaticInvocation(var1_1.getInstrumentedType());
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Resolved
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved {
                private final TypeDescription instrumentedType;
                private final MethodDescription instrumentedMethod;

                /*
                 * WARNING - void declaration
                 */
                protected Resolved(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    void var2_2;
                    void var1_1;
                    this.instrumentedType = var1_1;
                    this.instrumentedMethod = var2_2;
                }

                public TypeDescription getTypeDescription() {
                    return this.instrumentedType;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                    void var1_1;
                    if (this.instrumentedMethod.isStatic() && !invokedMethod.isStatic() && !invokedMethod.isConstructor()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " from " + this.instrumentedMethod);
                    }
                    if (!(!invokedMethod.isConstructor() || this.instrumentedMethod.isConstructor() && (this.instrumentedType.equals(invokedMethod.getDeclaringType().asErasure()) || this.instrumentedType.getSuperClass() != null && this.instrumentedType.getSuperClass().asErasure().equals(invokedMethod.getDeclaringType().asErasure())))) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " from " + this.instrumentedMethod + " in " + this.instrumentedType);
                    }
                    return new StackManipulation.Compound(invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), (StackManipulation)((Object)(var1_1.isConstructor() ? Duplication.SINGLE : StackManipulation.Trivial.INSTANCE)));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.instrumentedType.equals(((Resolved)object).instrumentedType)) {
                        return false;
                    }
                    return this.instrumentedMethod.equals(((Resolved)object).instrumentedMethod);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.instrumentedType.hashCode()) * 31 + this.instrumentedMethod.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Simple
        implements TargetHandler,
        Factory,
        Resolved {
            private final TypeDescription typeDescription;
            private final StackManipulation stackManipulation;

            /*
             * WARNING - void declaration
             */
            protected Simple(TypeDescription typeDescription, StackManipulation stackManipulation) {
                void var2_2;
                void var1_1;
                this.typeDescription = var1_1;
                this.stackManipulation = var2_2;
            }

            public TargetHandler make(Implementation.Target implementationTarget) {
                return this;
            }

            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                return this.stackManipulation;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.typeDescription.equals(((Simple)object).typeDescription)) {
                    return false;
                }
                return this.stackManipulation.equals(((Simple)object).stackManipulation);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.typeDescription.hashCode()) * 31 + this.stackManipulation.hashCode();
            }
        }

        public static interface Factory
        extends InstrumentedType.Prepareable {
            public TargetHandler make(Implementation.Target var1);
        }

        public static interface Resolved {
            public TypeDescription getTypeDescription();

            public StackManipulation toStackManipulation(MethodDescription var1, Assigner var2, Assigner.Typing var3);
        }
    }

    public static interface ArgumentLoader {
        public StackManipulation toStackManipulation(ParameterDescription var1, Assigner var2, Assigner.Typing var3);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForStackManipulation
        implements ArgumentLoader,
        ArgumentProvider,
        Factory {
            private final StackManipulation stackManipulation;
            private final TypeDefinition typeDefinition;

            /*
             * WARNING - void declaration
             */
            public ForStackManipulation(StackManipulation stackManipulation, Type type) {
                this((StackManipulation)var1_1, TypeDefinition.Sort.describe((Type)var2_2));
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForStackManipulation(StackManipulation stackManipulation, TypeDefinition typeDefinition) {
                void var2_2;
                void var1_1;
                this.stackManipulation = var1_1;
                this.typeDefinition = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public static Factory of(@MaybeNull Object value) {
                void var1_1;
                if (value == null) {
                    return ForNullConstant.INSTANCE;
                }
                ConstantValue constant = ConstantValue.Simple.wrapOrNull(value);
                if (constant == null) {
                    Object object;
                    return new ForInstance.Factory(object);
                }
                return new ForStackManipulation(constant.toStackManipulation(), var1_1.getTypeDescription());
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public ArgumentProvider make(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                StackManipulation assignment = assigner.assign(this.typeDefinition.asGenericType(), target.getType(), (Assigner.Typing)var3_3);
                if (!assignment.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign " + var1_1 + " to " + this.typeDefinition);
                }
                return new StackManipulation.Compound(new StackManipulation[]{this.stackManipulation, var2_2});
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.stackManipulation.equals(((ForStackManipulation)object).stackManipulation)) {
                    return false;
                }
                return this.typeDefinition.equals(((ForStackManipulation)object).typeDefinition);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.stackManipulation.hashCode()) * 31 + this.typeDefinition.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodCall
        implements ArgumentLoader {
            private final Appender appender;
            private final MethodDescription methodDescription;
            private final MethodDescription instrumentedMethod;
            private final TargetHandler.Resolved targetHandler;

            /*
             * WARNING - void declaration
             */
            public ForMethodCall(Appender appender, MethodDescription methodDescription, MethodDescription instrumentedMethod, TargetHandler.Resolved targetHandler) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.appender = var1_1;
                this.methodDescription = var2_2;
                this.instrumentedMethod = var3_3;
                this.targetHandler = targetHandler;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.appender.toStackManipulation(this.instrumentedMethod, this.methodDescription, this.targetHandler), assigner.assign(this.methodDescription.isConstructor() ? this.methodDescription.getDeclaringType().asGenericType() : this.methodDescription.getReturnType(), target.getType(), (Assigner.Typing)var3_3));
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign return type of " + this.methodDescription + " to " + var1_1);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.appender.equals(((ForMethodCall)object).appender)) {
                    return false;
                }
                if (!this.methodDescription.equals(((ForMethodCall)object).methodDescription)) {
                    return false;
                }
                if (!this.instrumentedMethod.equals(((ForMethodCall)object).instrumentedMethod)) {
                    return false;
                }
                return this.targetHandler.equals(((ForMethodCall)object).targetHandler);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.appender.hashCode()) * 31 + this.methodDescription.hashCode()) * 31 + this.instrumentedMethod.hashCode()) * 31 + this.targetHandler.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final MethodCall methodCall;

                /*
                 * WARNING - void declaration
                 */
                public Factory(MethodCall methodCall) {
                    void var1_1;
                    this.methodCall = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    void var1_1;
                    return this.methodCall.prepare((InstrumentedType)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider make(Implementation.Target implementationTarget) {
                    void var1_1;
                    MethodCall methodCall = this.methodCall;
                    methodCall.getClass();
                    return new ArgumentProvider(methodCall.new Appender((Implementation.Target)var1_1, TerminationHandler.Simple.IGNORING));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.methodCall.equals(((Factory)object).methodCall);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.methodCall.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class ArgumentProvider
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider {
                private final Appender appender;

                /*
                 * WARNING - void declaration
                 */
                protected ArgumentProvider(Appender appender) {
                    void var1_1;
                    this.appender = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    void var2_2;
                    void var1_1;
                    TargetHandler.Resolved targetHandler = this.appender.targetHandler.resolve(instrumentedMethod);
                    return Collections.singletonList(new ForMethodCall(this.appender, this.appender.toInvokedMethod(instrumentedMethod, targetHandler), (MethodDescription)var1_1, (TargetHandler.Resolved)var2_2));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.appender.equals(((ArgumentProvider)object).appender);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.appender.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForField
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;
            private final MethodDescription instrumentedMethod;

            /*
             * WARNING - void declaration
             */
            public ForField(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
                void var2_2;
                void var1_1;
                this.fieldDescription = var1_1;
                this.instrumentedMethod = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                if (!this.fieldDescription.isStatic() && this.instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static " + this.fieldDescription + " from " + this.instrumentedMethod);
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), (Assigner.Typing)var3_3));
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription + " to " + var1_1);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.fieldDescription.equals(((ForField)object).fieldDescription)) {
                    return false;
                }
                return this.instrumentedMethod.equals(((ForField)object).instrumentedMethod);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.fieldDescription.hashCode()) * 31 + this.instrumentedMethod.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final String name;
                private final FieldLocator.Factory fieldLocatorFactory;

                /*
                 * WARNING - void declaration
                 */
                public Factory(String name, FieldLocator.Factory fieldLocatorFactory) {
                    void var2_2;
                    void var1_1;
                    this.name = var1_1;
                    this.fieldLocatorFactory = var2_2;
                }

                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                /*
                 * WARNING - void declaration
                 */
                public net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider make(Implementation.Target implementationTarget) {
                    void var2_2;
                    FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()).locate(this.name);
                    if (!resolution.isResolved()) {
                        void var1_1;
                        throw new IllegalStateException("Could not locate field '" + this.name + "' on " + var1_1.getInstrumentedType());
                    }
                    return new ArgumentProvider(var2_2.getField());
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.name.equals(((Factory)object).name)) {
                        return false;
                    }
                    return this.fieldLocatorFactory.equals(((Factory)object).fieldLocatorFactory);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.name.hashCode()) * 31 + this.fieldLocatorFactory.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class ArgumentProvider
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider {
                private final FieldDescription fieldDescription;

                /*
                 * WARNING - void declaration
                 */
                protected ArgumentProvider(FieldDescription fieldDescription) {
                    void var1_1;
                    this.fieldDescription = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    void var1_1;
                    return Collections.singletonList(new ForField(this.fieldDescription, (MethodDescription)var1_1));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.fieldDescription.equals(((ArgumentProvider)object).fieldDescription);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForInstance
        implements ArgumentLoader,
        ArgumentProvider {
            private final FieldDescription fieldDescription;

            /*
             * WARNING - void declaration
             */
            public ForInstance(FieldDescription fieldDescription) {
                void var1_1;
                this.fieldDescription = var1_1;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), (Assigner.Typing)var3_3));
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription.getType() + " to " + var1_1);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.fieldDescription.equals(((ForInstance)object).fieldDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private static final String FIELD_PREFIX = "methodCall";
                private final Object value;
                @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
                private final String name;

                /*
                 * WARNING - void declaration
                 */
                public Factory(Object value) {
                    void var1_1;
                    this.value = value;
                    this.name = "methodCall$" + RandomString.hashOf(var1_1);
                }

                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withAuxiliaryField(new FieldDescription.Token(this.name, 4105, TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.value.getClass())), this.value);
                }

                /*
                 * WARNING - void declaration
                 */
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    void var1_1;
                    return new ForInstance((FieldDescription)((FieldList)var1_1.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly());
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.value.equals(((Factory)object).value);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.value.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameterArrayElement
        implements ArgumentLoader {
            private final ParameterDescription parameterDescription;
            private final int index;

            /*
             * WARNING - void declaration
             */
            public ForMethodParameterArrayElement(ParameterDescription parameterDescription, int index) {
                void var2_2;
                void var1_1;
                this.parameterDescription = var1_1;
                this.index = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(this.parameterDescription), IntegerConstant.forValue(this.index), ArrayAccess.of(this.parameterDescription.getType().getComponentType()).load(), assigner.assign(this.parameterDescription.getType().getComponentType(), target.getType(), (Assigner.Typing)var3_3));
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign " + this.parameterDescription.getType().getComponentType() + " to " + var1_1);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.index != ((ForMethodParameterArrayElement)object).index) {
                    return false;
                }
                return this.parameterDescription.equals(((ForMethodParameterArrayElement)object).parameterDescription);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.parameterDescription.hashCode()) * 31 + this.index;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class OfInvokedMethod
            implements ArgumentProvider,
            Factory {
                private final int index;

                /*
                 * WARNING - void declaration
                 */
                public OfInvokedMethod(int index) {
                    void var1_1;
                    this.index = var1_1;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    void var3_3;
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index + ", " + instrumentedMethod.getParameters().size() + " defined");
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index) + " at index " + this.index);
                    }
                    ArrayList<ForMethodParameterArrayElement> argumentLoaders = new ArrayList<ForMethodParameterArrayElement>(invokedMethod.getParameters().size());
                    for (int index = 0; index < invokedMethod.getParameters().size(); ++index) {
                        argumentLoaders.add(new ForMethodParameterArrayElement((ParameterDescription)instrumentedMethod.getParameters().get(this.index), index));
                    }
                    return var3_3;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.index == ((OfInvokedMethod)object).index;
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.index;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class OfParameter
            implements ArgumentProvider,
            Factory {
                private final int index;
                private final int arrayIndex;

                /*
                 * WARNING - void declaration
                 */
                public OfParameter(int index, int arrayIndex) {
                    void var2_2;
                    void var1_1;
                    this.index = var1_1;
                    this.arrayIndex = var2_2;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    void var1_1;
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index + ", " + instrumentedMethod.getParameters().size() + " defined");
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index) + " at index " + this.index);
                    }
                    return Collections.singletonList(new ForMethodParameterArrayElement((ParameterDescription)var1_1.getParameters().get(this.index), this.arrayIndex));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((OfParameter)object).index) {
                        return false;
                    }
                    return this.arrayIndex == ((OfParameter)object).arrayIndex;
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.index) * 31 + this.arrayIndex;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameterArray
        implements ArgumentLoader {
            private final ParameterList<?> parameters;

            /*
             * WARNING - void declaration
             */
            public ForMethodParameterArray(ParameterList<?> parameters) {
                void var1_1;
                this.parameters = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var1_1;
                TypeDescription.Generic componentType;
                if (target.getType().represents((Type)((Object)Object.class))) {
                    componentType = TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Object.class);
                } else if (componentType.getType().isArray()) {
                    componentType = componentType.getType().getComponentType();
                } else {
                    throw new IllegalStateException("Cannot set method parameter array for non-array type: " + componentType);
                }
                ArrayList<StackManipulation.Compound> stackManipulations = new ArrayList<StackManipulation.Compound>(this.parameters.size());
                for (ParameterDescription parameter : this.parameters) {
                    StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameter), assigner.assign(parameter.getType(), componentType, typing));
                    if (stackManipulation.isValid()) {
                        stackManipulations.add(stackManipulation);
                        continue;
                    }
                    throw new IllegalStateException("Cannot assign " + parameter + " to " + componentType);
                }
                return new StackManipulation.Compound(ArrayFactory.forType((TypeDescription.Generic)var1_1).withValues(stackManipulations));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.parameters.equals(((ForMethodParameterArray)object).parameters);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.parameters.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForInstrumentedMethod implements ArgumentProvider,
            Factory
            {
                INSTANCE;


                @Override
                public final InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public final ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    void var1_1;
                    return Collections.singletonList(new ForMethodParameterArray(var1_1.getParameters()));
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameter
        implements ArgumentLoader {
            private final int index;
            private final MethodDescription instrumentedMethod;

            /*
             * WARNING - void declaration
             */
            public ForMethodParameter(int index, MethodDescription instrumentedMethod) {
                void var2_2;
                void var1_1;
                this.index = var1_1;
                this.instrumentedMethod = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                ParameterDescription parameterDescription = (ParameterDescription)this.instrumentedMethod.getParameters().get(this.index);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), assigner.assign(parameterDescription.getType(), target.getType(), (Assigner.Typing)var3_3));
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + var1_1 + " for " + this.instrumentedMethod);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.index != ((ForMethodParameter)object).index) {
                    return false;
                }
                return this.instrumentedMethod.equals(((ForMethodParameter)object).instrumentedMethod);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.index) * 31 + this.instrumentedMethod.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Factory
            implements ArgumentProvider,
            net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final int index;

                /*
                 * WARNING - void declaration
                 */
                public Factory(int index) {
                    void var1_1;
                    this.index = var1_1;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    void var1_1;
                    if (this.index >= instrumentedMethod.getParameters().size()) {
                        throw new IllegalStateException(instrumentedMethod + " does not have a parameter with index " + this.index + ", " + instrumentedMethod.getParameters().size() + " defined");
                    }
                    return Collections.singletonList(new ForMethodParameter(this.index, (MethodDescription)var1_1));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.index == ((Factory)object).index;
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.index;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum OfInstrumentedMethod implements ArgumentProvider,
            net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public final InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public final ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    void var2_2;
                    ArrayList<ForMethodParameter> argumentLoaders = new ArrayList<ForMethodParameter>(instrumentedMethod.getParameters().size());
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        argumentLoaders.add(new ForMethodParameter(parameterDescription.getIndex(), instrumentedMethod));
                    }
                    return var2_2;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForInstrumentedType
        implements ArgumentLoader,
        ArgumentProvider {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            public ForInstrumentedType(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(ClassConstant.of(this.instrumentedType), assigner.assign(TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Class.class), target.getType(), (Assigner.Typing)var3_3));
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign Class value to " + var1_1);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((ForInstrumentedType)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public final InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final ArgumentProvider make(Implementation.Target implementationTarget) {
                    void var1_1;
                    return new ForInstrumentedType(var1_1.getInstrumentedType());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForThisReference
        implements ArgumentLoader,
        ArgumentProvider {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            public ForThisReference(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                if (instrumentedMethod.isStatic()) {
                    void var1_1;
                    throw new IllegalStateException(var1_1 + " is static and cannot supply an invoker instance");
                }
                return Collections.singletonList(this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                void var2_2;
                void var3_3;
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.loadThis(), assigner.assign(this.instrumentedType.asGenericType(), target.getType(), (Assigner.Typing)var3_3));
                if (!stackManipulation.isValid()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign " + this.instrumentedType + " to " + var1_1);
                }
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((ForThisReference)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public final InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final ArgumentProvider make(Implementation.Target implementationTarget) {
                    void var1_1;
                    return new ForThisReference(var1_1.getInstrumentedType());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForNullConstant implements ArgumentLoader,
        ArgumentProvider,
        Factory
        {
            INSTANCE;


            @Override
            public final InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public final ArgumentProvider make(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public final List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (target.getType().isPrimitive()) {
                    void var1_1;
                    throw new IllegalStateException("Cannot assign null to " + var1_1);
                }
                return NullConstant.INSTANCE;
            }
        }

        public static interface Factory
        extends InstrumentedType.Prepareable {
            public ArgumentProvider make(Implementation.Target var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ArgumentProvider {
            public List<ArgumentLoader> resolve(MethodDescription var1, MethodDescription var2);
        }
    }

    public static interface MethodLocator {
        public MethodDescription resolve(TypeDescription var1, MethodDescription var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForElementMatcher
        implements MethodLocator {
            private final TypeDescription instrumentedType;
            private final ElementMatcher<? super MethodDescription> matcher;
            private final MethodGraph.Compiler methodGraphCompiler;

            /*
             * WARNING - void declaration
             */
            protected ForElementMatcher(TypeDescription instrumentedType, ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.instrumentedType = var1_1;
                this.matcher = var2_2;
                this.methodGraphCompiler = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public MethodDescription resolve(TypeDescription targetType, MethodDescription instrumentedMethod) {
                void var1_1;
                void var2_2;
                TypeDescription.Generic superClass = this.instrumentedType.getSuperClass();
                List candidates = CompoundList.of(superClass == null ? Collections.emptyList() : var2_2.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(this.matcher)), this.instrumentedType.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isVirtual()).and(this.matcher)), this.methodGraphCompiler.compile((TypeDefinition)targetType, this.instrumentedType).listNodes().asMethodList().filter(this.matcher));
                if (candidates.size() == 1) {
                    return (MethodDescription)candidates.get(0);
                }
                throw new IllegalStateException(this.instrumentedType + " does not define exactly one virtual method or constructor for " + this.matcher + " but contained " + candidates.size() + " candidates: " + var1_1);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.instrumentedType.equals(((ForElementMatcher)object).instrumentedType)) {
                    return false;
                }
                if (!this.matcher.equals(((ForElementMatcher)object).matcher)) {
                    return false;
                }
                return this.methodGraphCompiler.equals(((ForElementMatcher)object).methodGraphCompiler);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.instrumentedType.hashCode()) * 31 + this.matcher.hashCode()) * 31 + this.methodGraphCompiler.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Factory
            implements net.bytebuddy.implementation.MethodCall$MethodLocator$Factory {
                private final ElementMatcher<? super MethodDescription> matcher;
                private final MethodGraph.Compiler methodGraphCompiler;

                /*
                 * WARNING - void declaration
                 */
                public Factory(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
                    void var2_2;
                    void var1_1;
                    this.matcher = var1_1;
                    this.methodGraphCompiler = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public MethodLocator make(TypeDescription instrumentedType) {
                    void var1_1;
                    return new ForElementMatcher((TypeDescription)var1_1, this.matcher, this.methodGraphCompiler);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.matcher.equals(((Factory)object).matcher)) {
                        return false;
                    }
                    return this.methodGraphCompiler.equals(((Factory)object).methodGraphCompiler);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.matcher.hashCode()) * 31 + this.methodGraphCompiler.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForExplicitMethod
        implements MethodLocator,
        Factory {
            private final MethodDescription methodDescription;

            /*
             * WARNING - void declaration
             */
            protected ForExplicitMethod(MethodDescription methodDescription) {
                void var1_1;
                this.methodDescription = var1_1;
            }

            public MethodLocator make(TypeDescription instrumentedType) {
                return this;
            }

            public MethodDescription resolve(TypeDescription targetType, MethodDescription instrumentedMethod) {
                return this.methodDescription;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.methodDescription.equals(((ForExplicitMethod)object).methodDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.methodDescription.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForInstrumentedMethod implements MethodLocator,
        Factory
        {
            INSTANCE;


            @Override
            public final MethodLocator make(TypeDescription instrumentedType) {
                return this;
            }

            @Override
            public final MethodDescription resolve(TypeDescription targetType, MethodDescription instrumentedMethod) {
                return instrumentedMethod;
            }
        }

        public static interface Factory {
            public MethodLocator make(TypeDescription var1);
        }
    }
}

