/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.Addition;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Multiplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class HashCodeMethod
implements Implementation {
    private static final int DEFAULT_OFFSET = 17;
    private static final int DEFAULT_MULTIPLIER = 31;
    private static final MethodDescription.InDefinedShape HASH_CODE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Object.class).getDeclaredMethods().filter(ElementMatchers.isHashCode())).getOnly();
    private static final MethodDescription.InDefinedShape GET_CLASS = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Object.class).getDeclaredMethods().filter(ElementMatchers.named("getClass").and(ElementMatchers.takesArguments(0)))).getOnly();
    private final OffsetProvider offsetProvider;
    private final int multiplier;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> identity;

    /*
     * WARNING - void declaration
     */
    protected HashCodeMethod(OffsetProvider offsetProvider) {
        this((OffsetProvider)var1_1, 31, ElementMatchers.none(), ElementMatchers.none(), ElementMatchers.none());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HashCodeMethod(OffsetProvider offsetProvider, int multiplier, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> identity) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.offsetProvider = var1_1;
        this.multiplier = var2_2;
        this.ignored = var3_3;
        this.nonNullable = nonNullable;
        this.identity = identity;
    }

    public static HashCodeMethod usingSuperClassOffset() {
        return new HashCodeMethod(OffsetProvider.ForSuperMethodCall.INSTANCE);
    }

    public static HashCodeMethod usingTypeHashOffset(boolean dynamic) {
        boolean bl;
        return new HashCodeMethod((OffsetProvider)((Object)(bl ? OffsetProvider.ForDynamicTypeHash.INSTANCE : OffsetProvider.ForStaticTypeHash.INSTANCE)));
    }

    public static HashCodeMethod usingDefaultOffset() {
        return HashCodeMethod.usingOffset(17);
    }

    public static HashCodeMethod usingOffset(int value) {
        int n;
        return new HashCodeMethod(new OffsetProvider.ForFixedValue(n));
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeMethod withIgnoredFields(ElementMatcher<? super FieldDescription.InDefinedShape> ignored) {
        void var1_1;
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored.or(var1_1), this.nonNullable, this.identity);
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeMethod withNonNullableFields(ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable) {
        void var1_1;
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored, this.nonNullable.or(var1_1), this.identity);
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeMethod withIdentityFields(ElementMatcher<? super FieldDescription.InDefinedShape> identity) {
        void var1_1;
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored, this.nonNullable, this.identity.or(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeMethod withMultiplier(int multiplier) {
        void var1_1;
        if (multiplier == 0) {
            throw new IllegalArgumentException("Hash code multiplier must not be zero");
        }
        return new HashCodeMethod(this.offsetProvider, (int)var1_1, this.ignored, this.nonNullable, this.identity);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        void var1_1;
        if (implementationTarget.getInstrumentedType().isInterface()) {
            throw new IllegalStateException("Cannot implement meaningful hash code method for " + implementationTarget.getInstrumentedType());
        }
        return new Appender(this.offsetProvider.resolve(implementationTarget.getInstrumentedType()), this.multiplier, (List<FieldDescription.InDefinedShape>)var1_1.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.not(ElementMatchers.isStatic().or(this.ignored))), (ElementMatcher<? super FieldDescription.InDefinedShape>)this.nonNullable, (ElementMatcher<? super FieldDescription.InDefinedShape>)this.identity);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.multiplier != ((HashCodeMethod)object).multiplier) {
            return false;
        }
        if (!this.offsetProvider.equals(((HashCodeMethod)object).offsetProvider)) {
            return false;
        }
        if (!this.ignored.equals(((HashCodeMethod)object).ignored)) {
            return false;
        }
        if (!this.nonNullable.equals(((HashCodeMethod)object).nonNullable)) {
            return false;
        }
        return this.identity.equals(((HashCodeMethod)object).identity);
    }

    public int hashCode() {
        return ((((this.getClass().hashCode() * 31 + this.offsetProvider.hashCode()) * 31 + this.multiplier) * 31 + this.ignored.hashCode()) * 31 + this.nonNullable.hashCode()) * 31 + this.identity.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class Appender
    implements ByteCodeAppender {
        private final StackManipulation initialValue;
        private final int multiplier;
        private final List<FieldDescription.InDefinedShape> fieldDescriptions;
        private final ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable;
        private final ElementMatcher<? super FieldDescription.InDefinedShape> identity;

        /*
         * WARNING - void declaration
         */
        protected Appender(StackManipulation initialValue, int multiplier, List<FieldDescription.InDefinedShape> fieldDescriptions, ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable, ElementMatcher<? super FieldDescription.InDefinedShape> identity) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.initialValue = var1_1;
            this.multiplier = var2_2;
            this.fieldDescriptions = var3_3;
            this.nonNullable = nonNullable;
            this.identity = identity;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (instrumentedMethod.isStatic()) {
                throw new IllegalStateException("Hash code method must not be static: " + instrumentedMethod);
            }
            if (!instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                throw new IllegalStateException("Hash code method does not return primitive integer: " + instrumentedMethod);
            }
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(2 + (this.fieldDescriptions.size() << 3));
            stackManipulations.add(this.initialValue);
            int padding = 0;
            for (FieldDescription.InDefinedShape fieldDescription : this.fieldDescriptions) {
                stackManipulations.add(IntegerConstant.forValue(this.multiplier));
                stackManipulations.add(Multiplication.INTEGER);
                stackManipulations.add(MethodVariableAccess.loadThis());
                stackManipulations.add(FieldAccess.forField(fieldDescription).read());
                if (!fieldDescription.getType().isPrimitive() && this.identity.matches(fieldDescription)) {
                    stackManipulations.add(ValueTransformer.REFERENCE_IDENTITY);
                    stackManipulations.add(Addition.INTEGER);
                    continue;
                }
                NullValueGuard.NoOp nullValueGuard = fieldDescription.getType().isPrimitive() || fieldDescription.getType().isArray() || this.nonNullable.matches(fieldDescription) ? NullValueGuard.NoOp.INSTANCE : new NullValueGuard.UsingJump(instrumentedMethod);
                stackManipulations.add(nullValueGuard.before());
                stackManipulations.add(ValueTransformer.of(fieldDescription.getType()));
                stackManipulations.add(Addition.INTEGER);
                stackManipulations.add(nullValueGuard.after());
                padding = Math.max(padding, nullValueGuard.getRequiredVariablePadding());
            }
            stackManipulations.add(MethodReturn.INTEGER);
            return new ByteCodeAppender.Size(new StackManipulation.Compound(stackManipulations).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2).getMaximalSize(), var3_3.getStackSize() + padding);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.multiplier != ((Appender)object).multiplier) {
                return false;
            }
            if (!this.initialValue.equals(((Appender)object).initialValue)) {
                return false;
            }
            if (!((Object)this.fieldDescriptions).equals(((Appender)object).fieldDescriptions)) {
                return false;
            }
            if (!this.nonNullable.equals(((Appender)object).nonNullable)) {
                return false;
            }
            return this.identity.equals(((Appender)object).identity);
        }

        public int hashCode() {
            return ((((this.getClass().hashCode() * 31 + this.initialValue.hashCode()) * 31 + this.multiplier) * 31 + ((Object)this.fieldDescriptions).hashCode()) * 31 + this.nonNullable.hashCode()) * 31 + this.identity.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ValueTransformer implements StackManipulation
    {
        LONG{

            /*
             * WARNING - void declaration
             */
            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                void var1_1;
                methodVisitor.visitInsn(92);
                methodVisitor.visitIntInsn(16, 32);
                methodVisitor.visitInsn(125);
                methodVisitor.visitInsn(131);
                var1_1.visitInsn(136);
                return new StackManipulation.Size(-1, 3);
            }
        }
        ,
        FLOAT{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "floatToIntBits", "(F)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        DOUBLE{

            /*
             * WARNING - void declaration
             */
            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                void var1_1;
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "doubleToLongBits", "(D)J", false);
                methodVisitor.visitInsn(92);
                methodVisitor.visitIntInsn(16, 32);
                methodVisitor.visitInsn(125);
                methodVisitor.visitInsn(131);
                var1_1.visitInsn(136);
                return new StackManipulation.Size(-1, 3);
            }
        }
        ,
        BOOLEAN_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([Z)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        BYTE_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([B)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        SHORT_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([S)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        CHARACTER_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([C)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        INTEGER_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([I)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        LONG_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([J)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        FLOAT_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([F)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        DOUBLE_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([D)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        REFERENCE_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        NESTED_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "deepHashCode", "([Ljava/lang/Object;)I", false);
                return StackManipulation.Size.ZERO;
            }
        }
        ,
        REFERENCE_IDENTITY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/lang/System", "identityHashCode", "(Ljava/lang/Object;)I", false);
                return StackManipulation.Size.ZERO;
            }
        };


        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
        public static StackManipulation of(TypeDefinition typeDefinition) {
            TypeDefinition typeDefinition2;
            if (typeDefinition.represents(Boolean.TYPE) || typeDefinition.represents(Byte.TYPE) || typeDefinition.represents(Short.TYPE) || typeDefinition.represents(Character.TYPE) || typeDefinition.represents(Integer.TYPE)) {
                return StackManipulation.Trivial.INSTANCE;
            }
            if (typeDefinition.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents((Type)((Object)boolean[].class))) {
                return BOOLEAN_ARRAY;
            }
            if (typeDefinition.represents((Type)((Object)byte[].class))) {
                return BYTE_ARRAY;
            }
            if (typeDefinition.represents((Type)((Object)short[].class))) {
                return SHORT_ARRAY;
            }
            if (typeDefinition.represents((Type)((Object)char[].class))) {
                return CHARACTER_ARRAY;
            }
            if (typeDefinition.represents((Type)((Object)int[].class))) {
                return INTEGER_ARRAY;
            }
            if (typeDefinition.represents((Type)((Object)long[].class))) {
                return LONG_ARRAY;
            }
            if (typeDefinition.represents((Type)((Object)float[].class))) {
                return FLOAT_ARRAY;
            }
            if (typeDefinition.represents((Type)((Object)double[].class))) {
                return DOUBLE_ARRAY;
            }
            if (typeDefinition.isArray()) {
                if (typeDefinition.getComponentType().isArray()) {
                    return NESTED_ARRAY;
                }
                return REFERENCE_ARRAY;
            }
            return MethodInvocation.invoke(HASH_CODE).virtual(typeDefinition2.asErasure());
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    protected static interface NullValueGuard {
        public StackManipulation before();

        public StackManipulation after();

        public int getRequiredVariablePadding();

        @HashCodeAndEqualsPlugin.Enhance
        public static class UsingJump
        implements NullValueGuard {
            private final MethodDescription instrumentedMethod;
            private final Label label;

            /*
             * WARNING - void declaration
             */
            protected UsingJump(MethodDescription instrumentedMethod) {
                void var1_1;
                this.instrumentedMethod = var1_1;
                this.label = new Label();
            }

            public StackManipulation before() {
                return new BeforeInstruction(this);
            }

            public StackManipulation after() {
                return new AfterInstruction(this);
            }

            public int getRequiredVariablePadding() {
                return 1;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.instrumentedMethod.equals(((UsingJump)object).instrumentedMethod)) {
                    return false;
                }
                return this.label.equals(((UsingJump)object).label);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.instrumentedMethod.hashCode()) * 31 + this.label.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
            protected class AfterInstruction
            extends StackManipulation.AbstractBase {
                final /* synthetic */ UsingJump this$0;

                /*
                 * WARNING - void declaration
                 */
                protected AfterInstruction(UsingJump this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    void var2_2;
                    void var1_1;
                    methodVisitor.visitLabel(this.this$0.label);
                    implementationContext.getFrameGeneration().same1((MethodVisitor)var1_1, TypeDescription.ForLoadedType.of(Integer.TYPE), Arrays.asList(var2_2.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class)));
                    return StackManipulation.Size.ZERO;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.this$0.equals(((AfterInstruction)object).this$0);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.this$0.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
            protected class BeforeInstruction
            extends StackManipulation.AbstractBase {
                final /* synthetic */ UsingJump this$0;

                /*
                 * WARNING - void declaration
                 */
                protected BeforeInstruction(UsingJump this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    void var1_1;
                    methodVisitor.visitVarInsn(58, this.this$0.instrumentedMethod.getStackSize());
                    methodVisitor.visitVarInsn(25, this.this$0.instrumentedMethod.getStackSize());
                    methodVisitor.visitJumpInsn(198, this.this$0.label);
                    var1_1.visitVarInsn(25, this.this$0.instrumentedMethod.getStackSize());
                    return StackManipulation.Size.ZERO;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.this$0.equals(((BeforeInstruction)object).this$0);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.this$0.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NoOp implements NullValueGuard
        {
            INSTANCE;


            @Override
            public final StackManipulation before() {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public final StackManipulation after() {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public final int getRequiredVariablePadding() {
                return StackSize.ZERO.getSize();
            }
        }
    }

    protected static interface OffsetProvider {
        public StackManipulation resolve(TypeDescription var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForDynamicTypeHash implements OffsetProvider
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            public final StackManipulation resolve(TypeDescription instrumentedType) {
                void var1_1;
                return new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodInvocation.invoke(GET_CLASS).virtual((TypeDescription)var1_1), MethodInvocation.invoke(HASH_CODE).virtual(TypeDescription.ForLoadedType.of(Class.class)));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForStaticTypeHash implements OffsetProvider
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            public final StackManipulation resolve(TypeDescription instrumentedType) {
                void var1_1;
                return new StackManipulation.Compound(ClassConstant.of((TypeDescription)var1_1), MethodInvocation.invoke(HASH_CODE).virtual(TypeDescription.ForLoadedType.of(Class.class)));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForSuperMethodCall implements OffsetProvider
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            public final StackManipulation resolve(TypeDescription instrumentedType) {
                void var2_2;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                if (superClass == null) {
                    void var1_1;
                    throw new IllegalStateException(var1_1 + " does not declare a super class");
                }
                return new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodInvocation.invoke(HASH_CODE).special(var2_2.asErasure()));
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForFixedValue
        implements OffsetProvider {
            private final int value;

            /*
             * WARNING - void declaration
             */
            protected ForFixedValue(int value) {
                void var1_1;
                this.value = var1_1;
            }

            public StackManipulation resolve(TypeDescription instrumentedType) {
                return IntegerConstant.forValue(this.value);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.value == ((ForFixedValue)object).value;
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.value;
            }
        }
    }
}

