/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ConstantValue;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.RandomString;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public abstract class FixedValue
implements Implementation {
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    /*
     * WARNING - void declaration
     */
    protected FixedValue(Assigner assigner, Assigner.Typing typing) {
        void var2_2;
        void var1_1;
        this.assigner = var1_1;
        this.typing = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static AssignerConfigurable value(Object value) {
        void var1_1;
        ConstantValue constant = ConstantValue.Simple.wrapOrNull(value);
        if (constant == null) {
            Object object;
            return FixedValue.reference(object);
        }
        return new ForConstantValue(constant.toStackManipulation(), var1_1.getTypeDescription());
    }

    public static AssignerConfigurable reference(Object value) {
        Object object;
        return FixedValue.reference(value, "value$" + RandomString.hashOf(object));
    }

    /*
     * WARNING - void declaration
     */
    public static AssignerConfigurable reference(Object value, String name) {
        void var1_1;
        Object object;
        return new ForValue(object, (String)var1_1);
    }

    public static AssignerConfigurable value(TypeDescription type) {
        TypeDescription typeDescription;
        return new ForConstantValue(ClassConstant.of(typeDescription), TypeDescription.ForLoadedType.of(Class.class));
    }

    public static AssignerConfigurable value(ConstantValue constant) {
        ConstantValue constantValue;
        return new ForConstantValue(constant.toStackManipulation(), constantValue.getTypeDescription());
    }

    public static AssignerConfigurable value(JavaConstant constant) {
        return FixedValue.value((ConstantValue)constant);
    }

    public static AssignerConfigurable argument(int index) {
        int n;
        if (index < 0) {
            throw new IllegalArgumentException("Argument index cannot be negative: " + index);
        }
        return new ForArgument(n);
    }

    public static AssignerConfigurable self() {
        return new ForThisValue();
    }

    public static Implementation nullValue() {
        return ForNullValue.INSTANCE;
    }

    public static AssignerConfigurable originType() {
        return new ForOriginType();
    }

    /*
     * WARNING - void declaration
     */
    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, TypeDescription.Generic typeDescription, StackManipulation stackManipulation) {
        void var3_3;
        void var1_1;
        void var2_2;
        StackManipulation assignment = this.assigner.assign(typeDescription, instrumentedMethod.getReturnType(), this.typing);
        if (!assignment.isValid()) {
            throw new IllegalArgumentException("Cannot return value of type " + typeDescription + " for " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(stackManipulation, assignment, MethodReturn.of(instrumentedMethod.getReturnType())).apply(methodVisitor, (Implementation.Context)var2_2);
        return new ByteCodeAppender.Size(var1_1.getMaximalSize(), var3_3.getStackSize());
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.typing.equals((Object)((FixedValue)object).typing)) {
            return false;
        }
        return this.assigner.equals(((FixedValue)object).assigner);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.assigner.hashCode()) * 31 + this.typing.hashCode();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForValue
    extends FixedValue
    implements AssignerConfigurable {
        private static final String PREFIX = "value";
        private final String name;
        private final Object value;

        /*
         * WARNING - void declaration
         */
        protected ForValue(Object value, String name) {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC, var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ForValue(Assigner assigner, Assigner.Typing typing, Object value, String name) {
            super((Assigner)var1_1, (Assigner.Typing)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = name;
            this.value = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            void var2_2;
            void var1_1;
            return new ForValue((Assigner)var1_1, (Assigner.Typing)var2_2, this.value, this.name);
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withAuxiliaryField(new FieldDescription.Token(this.name, 4169, TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.value.getClass())), this.value);
        }

        /*
         * WARNING - void declaration
         */
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            void var1_1;
            return new StaticFieldByteCodeAppender(var1_1.getInstrumentedType());
        }

        public boolean equals(@MaybeNull Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.name.equals(((ForValue)object).name)) {
                return false;
            }
            return this.value.equals(((ForValue)object).value);
        }

        public int hashCode() {
            return (super.hashCode() * 31 + this.name.hashCode()) * 31 + this.value.hashCode();
        }

        @HashCodeAndEqualsPlugin.Enhance
        private class StaticFieldByteCodeAppender
        implements ByteCodeAppender {
            private final StackManipulation fieldGetAccess;

            /*
             * WARNING - void declaration
             */
            private StaticFieldByteCodeAppender(TypeDescription instrumentedType) {
                void var2_2;
                this.fieldGetAccess = FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)var2_2.getDeclaredFields().filter(ElementMatchers.named(ForValue.this.name))).getOnly()).read();
            }

            /*
             * WARNING - void declaration
             */
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                void var3_3;
                void var2_2;
                void var1_1;
                return ForValue.this.apply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (MethodDescription)var3_3, TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(ForValue.this.value.getClass()), this.fieldGetAccess);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.fieldGetAccess.equals(((StaticFieldByteCodeAppender)object).fieldGetAccess);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.fieldGetAccess.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForConstantValue
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final StackManipulation valueLoadInstruction;
        private final TypeDescription loadedType;

        /*
         * WARNING - void declaration
         */
        protected ForConstantValue(StackManipulation valueLoadInstruction, Class<?> loadedType) {
            this((StackManipulation)var1_1, TypeDescription.ForLoadedType.of(var2_2));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected ForConstantValue(StackManipulation valueLoadInstruction, TypeDescription loadedType) {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC, (StackManipulation)var1_1, (TypeDescription)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ForConstantValue(Assigner assigner, Assigner.Typing typing, StackManipulation valueLoadInstruction, TypeDescription loadedType) {
            super((Assigner)var1_1, (Assigner.Typing)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.valueLoadInstruction = var3_3;
            this.loadedType = loadedType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            void var2_2;
            void var1_1;
            return new ForConstantValue((Assigner)var1_1, (Assigner.Typing)var2_2, this.valueLoadInstruction, this.loadedType);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.apply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (MethodDescription)var3_3, this.loadedType.asGenericType(), this.valueLoadInstruction);
        }

        @Override
        public boolean equals(@MaybeNull Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.valueLoadInstruction.equals(((ForConstantValue)object).valueLoadInstruction)) {
                return false;
            }
            return this.loadedType.equals(((ForConstantValue)object).loadedType);
        }

        @Override
        public int hashCode() {
            return (super.hashCode() * 31 + this.valueLoadInstruction.hashCode()) * 31 + this.loadedType.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForArgument
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final int index;

        /*
         * WARNING - void declaration
         */
        protected ForArgument(int index) {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC, (int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ForArgument(Assigner assigner, Assigner.Typing typing, int index) {
            super((Assigner)var1_1, (Assigner.Typing)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.index = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (instrumentedMethod.getParameters().size() <= this.index) {
                throw new IllegalStateException(instrumentedMethod + " does not define a parameter with index " + this.index);
            }
            ParameterDescription parameterDescription = (ParameterDescription)instrumentedMethod.getParameters().get(this.index);
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), this.assigner.assign(parameterDescription.getType(), instrumentedMethod.getReturnType(), this.typing), MethodReturn.of(instrumentedMethod.getReturnType()));
            if (!stackManipulation.isValid()) {
                throw new IllegalStateException("Cannot assign " + instrumentedMethod.getReturnType() + " to " + parameterDescription);
            }
            return new ByteCodeAppender.Size(stackManipulation.apply((MethodVisitor)var1_1, (Implementation.Context)var2_2).getMaximalSize(), var3_3.getStackSize());
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        /*
         * WARNING - void declaration
         */
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            void var2_2;
            void var1_1;
            return new ForArgument((Assigner)var1_1, (Assigner.Typing)var2_2, this.index);
        }

        public boolean equals(@MaybeNull Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.index == ((ForArgument)object).index;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.index;
        }
    }

    protected static class ForThisValue
    extends FixedValue
    implements AssignerConfigurable {
        protected ForThisValue() {
            super(Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        /*
         * WARNING - void declaration
         */
        private ForThisValue(Assigner assigner, Assigner.Typing typing) {
            super((Assigner)var1_1, (Assigner.Typing)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            void var1_1;
            return new Appender(var1_1.getInstrumentedType());
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        /*
         * WARNING - void declaration
         */
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            void var2_2;
            void var1_1;
            return new ForThisValue((Assigner)var1_1, (Assigner.Typing)var2_2);
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            /*
             * WARNING - void declaration
             */
            protected Appender(TypeDescription instrumentedType) {
                void var1_1;
                this.instrumentedType = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (instrumentedMethod.isStatic() || !this.instrumentedType.isAssignableTo(instrumentedMethod.getReturnType().asErasure())) {
                    throw new IllegalStateException("Cannot return 'this' from " + instrumentedMethod);
                }
                return new ByteCodeAppender.Simple(MethodVariableAccess.loadThis(), MethodReturn.REFERENCE).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (MethodDescription)var3_3);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.instrumentedType.equals(((Appender)object).instrumentedType);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.instrumentedType.hashCode();
            }
        }
    }

    protected static class ForOriginType
    extends FixedValue
    implements AssignerConfigurable {
        protected ForOriginType() {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        /*
         * WARNING - void declaration
         */
        private ForOriginType(Assigner assigner, Assigner.Typing typing) {
            super((Assigner)var1_1, (Assigner.Typing)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            void var2_2;
            void var1_1;
            return new ForOriginType((Assigner)var1_1, (Assigner.Typing)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            void var1_1;
            return new Appender(this, var1_1.getOriginType().asErasure());
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription originType;
            final /* synthetic */ ForOriginType this$0;

            /*
             * WARNING - void declaration
             */
            protected Appender(ForOriginType this$0, TypeDescription originType) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.originType = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                void var3_3;
                void var2_2;
                void var1_1;
                return this.this$0.apply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (MethodDescription)var3_3, TypeDescription.ForLoadedType.of(Class.class).asGenericType(), ClassConstant.of(this.originType));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.originType.equals(((Appender)object).originType)) {
                    return false;
                }
                return this.this$0.equals(((Appender)object).this$0);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.originType.hashCode()) * 31 + this.this$0.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ForNullValue implements Implementation,
    ByteCodeAppender
    {
        INSTANCE;


        @Override
        public final ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        @Override
        public final InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (instrumentedMethod.getReturnType().isPrimitive()) {
                throw new IllegalStateException("Cannot return null from " + instrumentedMethod);
            }
            return new ByteCodeAppender.Simple(NullConstant.INSTANCE, MethodReturn.REFERENCE).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (MethodDescription)var3_3);
        }
    }

    public static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1, Assigner.Typing var2);
    }
}

