/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ConstantValue;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.RandomString;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public abstract class FieldAccessor
implements Implementation {
    protected final FieldLocation fieldLocation;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    /*
     * WARNING - void declaration
     */
    protected FieldAccessor(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.fieldLocation = var1_1;
        this.assigner = var2_2;
        this.typing = var3_3;
    }

    public static OwnerTypeLocatable ofField(String name) {
        String string;
        return FieldAccessor.of((FieldNameExtractor)new FieldNameExtractor.ForFixedValue(string));
    }

    public static OwnerTypeLocatable ofBeanProperty() {
        return FieldAccessor.of(FieldNameExtractor.ForBeanProperty.INSTANCE, FieldNameExtractor.ForBeanProperty.CAPITALIZED);
    }

    public static OwnerTypeLocatable of(FieldNameExtractor fieldNameExtractor) {
        return FieldAccessor.of(Collections.singletonList(fieldNameExtractor));
    }

    public static OwnerTypeLocatable of(FieldNameExtractor ... fieldNameExtractor) {
        return FieldAccessor.of(Arrays.asList(fieldNameExtractor));
    }

    public static OwnerTypeLocatable of(List<? extends FieldNameExtractor> fieldNameExtractors) {
        List<? extends FieldNameExtractor> list;
        return new ForImplicitProperty(new FieldLocation.Relative(list));
    }

    public static AssignerConfigurable of(Field field) {
        Field field2;
        return FieldAccessor.of(new FieldDescription.ForLoadedField(field2));
    }

    public static AssignerConfigurable of(FieldDescription fieldDescription) {
        FieldDescription fieldDescription2;
        return new ForImplicitProperty(new FieldLocation.Absolute(fieldDescription2));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.typing.equals((Object)((FieldAccessor)object).typing)) {
            return false;
        }
        if (!this.fieldLocation.equals(((FieldAccessor)object).fieldLocation)) {
            return false;
        }
        return this.assigner.equals(((FieldAccessor)object).assigner);
    }

    public int hashCode() {
        return ((this.getClass().hashCode() * 31 + this.fieldLocation.hashCode()) * 31 + this.assigner.hashCode()) * 31 + this.typing.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static abstract class ForSetter<T>
    extends FieldAccessor
    implements Implementation.Composable {
        private final TerminationHandler terminationHandler;

        /*
         * WARNING - void declaration
         */
        protected ForSetter(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, TerminationHandler terminationHandler) {
            super((FieldLocation)var1_1, (Assigner)var2_2, (Assigner.Typing)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.terminationHandler = terminationHandler;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            void var1_1;
            return new Appender(this, implementationTarget.getInstrumentedType(), this.initialize(implementationTarget.getInstrumentedType()), this.fieldLocation.prepare(var1_1.getInstrumentedType()));
        }

        @MaybeNull
        protected abstract T initialize(TypeDescription var1);

        protected abstract StackManipulation resolve(@MaybeNull T var1, FieldDescription var2, TypeDescription var3, MethodDescription var4);

        @Override
        public boolean equals(@MaybeNull Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.terminationHandler.equals((Object)((ForSetter)object).terminationHandler);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.terminationHandler.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;
            @MaybeNull
            @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
            private final T initialized;
            private final FieldLocation.Prepared fieldLocation;
            final /* synthetic */ ForSetter this$0;

            /*
             * WARNING - void declaration
             */
            protected Appender(ForSetter this$0, @MaybeNull TypeDescription instrumentedType, T initialized, FieldLocation.Prepared fieldLocation) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.instrumentedType = var2_2;
                this.initialized = var3_3;
                this.fieldLocation = fieldLocation;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                void var3_3;
                void var2_2;
                void var1_1;
                FieldDescription fieldDescription = this.fieldLocation.resolve(instrumentedMethod);
                if (!fieldDescription.isStatic() && instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot set instance field " + fieldDescription + " from " + instrumentedMethod);
                }
                if (fieldDescription.isFinal() && instrumentedMethod.isMethod()) {
                    throw new IllegalStateException("Cannot set final field " + fieldDescription + " from " + instrumentedMethod);
                }
                StackManipulation stackManipulation = this.this$0.resolve(this.initialized, fieldDescription, this.instrumentedType, instrumentedMethod);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Set value cannot be assigned to " + fieldDescription);
                }
                return new ByteCodeAppender.Size(new StackManipulation.Compound(instrumentedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), stackManipulation, FieldAccess.forField(fieldDescription).write(), this.this$0.terminationHandler.resolve(instrumentedMethod)).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2).getMaximalSize(), var3_3.getStackSize());
            }

            public boolean equals(@MaybeNull Object object) {
                block12: {
                    block11: {
                        Object t;
                        block10: {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            if (!this.instrumentedType.equals(((Appender)object).instrumentedType)) {
                                return false;
                            }
                            Object t2 = ((Appender)object).initialized;
                            t = this.initialized;
                            if (t2 == null) break block10;
                            if (t == null) break block11;
                            if (!t.equals(t2)) {
                                return false;
                            }
                            break block12;
                        }
                        if (t == null) break block12;
                    }
                    return false;
                }
                if (!this.fieldLocation.equals(((Appender)object).fieldLocation)) {
                    return false;
                }
                return ((FieldAccessor)this.this$0).equals(((Appender)object).this$0);
            }

            public int hashCode() {
                int n = (this.getClass().hashCode() * 31 + this.instrumentedType.hashCode()) * 31;
                Object t = this.initialized;
                if (t != null) {
                    n = n + t.hashCode();
                }
                return (n * 31 + this.fieldLocation.hashCode()) * 31 + ((FieldAccessor)this.this$0).hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class OfFieldValue
        extends ForSetter<FieldLocation.Prepared> {
            private final FieldLocation target;

            /*
             * WARNING - void declaration
             */
            protected OfFieldValue(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, TerminationHandler terminationHandler, FieldLocation target) {
                super((FieldLocation)var1_1, (Assigner)var2_2, (Assigner.Typing)var3_3, terminationHandler);
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = target;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected FieldLocation.Prepared initialize(TypeDescription instrumentedType) {
                void var1_1;
                return this.target.prepare((TypeDescription)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Expects its own initialized value as argument")
            protected StackManipulation resolve(@MaybeNull FieldLocation.Prepared target, FieldDescription fieldDescription, TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                void var2_2;
                void var1_1;
                FieldDescription resolved = target.resolve(instrumentedMethod);
                if (!resolved.isStatic() && instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot set instance field " + fieldDescription + " from " + instrumentedMethod);
                }
                return new StackManipulation.Compound(resolved.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(resolved).read(), this.assigner.assign(var1_1.getType(), var2_2.getType(), this.typing));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation andThen(Implementation implementation) {
                void var1_1;
                return new Implementation.Compound(new Implementation[]{new OfFieldValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.target), var1_1});
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation.Composable andThen(Implementation.Composable implementation) {
                void var1_1;
                return new Implementation.Compound.Composable(new OfFieldValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.target), (Implementation.Composable)var1_1);
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.target.equals(((OfFieldValue)object).target);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.target.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class OfReferenceValue
        extends ForSetter<FieldDescription.InDefinedShape> {
            protected static final String PREFIX = "fixedFieldValue";
            private final Object value;
            private final String name;

            /*
             * WARNING - void declaration
             */
            protected OfReferenceValue(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, TerminationHandler terminationHandler, Object value, String name) {
                super((FieldLocation)var1_1, (Assigner)var2_2, (Assigner.Typing)var3_3, terminationHandler);
                void var3_3;
                void var2_2;
                void var1_1;
                this.value = value;
                this.name = name;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withAuxiliaryField(new FieldDescription.Token(this.name, 4105, TypeDescription.ForLoadedType.of(this.value.getClass()).asGenericType()), this.value);
            }

            @Override
            protected FieldDescription.InDefinedShape initialize(TypeDescription instrumentedType) {
                return (FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Expects its own initialized value as argument")
            protected StackManipulation resolve(@MaybeNull FieldDescription.InDefinedShape target, FieldDescription fieldDescription, TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                void var2_2;
                void var1_1;
                if (fieldDescription.isFinal() && instrumentedMethod.isMethod()) {
                    throw new IllegalArgumentException("Cannot set final field " + fieldDescription + " from " + instrumentedMethod);
                }
                return new StackManipulation.Compound(FieldAccess.forField((FieldDescription.InDefinedShape)var1_1).read(), this.assigner.assign(TypeDescription.ForLoadedType.of(this.value.getClass()).asGenericType(), var2_2.getType(), this.typing));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation andThen(Implementation implementation) {
                void var1_1;
                return new Implementation.Compound(new Implementation[]{new OfReferenceValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.value, this.name), var1_1});
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation.Composable andThen(Implementation.Composable implementation) {
                void var1_1;
                return new Implementation.Compound.Composable(new OfReferenceValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.value, this.name), (Implementation.Composable)var1_1);
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.name.equals(((OfReferenceValue)object).name)) {
                    return false;
                }
                return this.value.equals(((OfReferenceValue)object).value);
            }

            @Override
            public int hashCode() {
                return (super.hashCode() * 31 + this.value.hashCode()) * 31 + this.name.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class OfConstantValue
        extends ForSetter<Void> {
            private final TypeDescription.Generic typeDescription;
            private final StackManipulation stackManipulation;

            /*
             * WARNING - void declaration
             */
            protected OfConstantValue(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, TerminationHandler terminationHandler, TypeDescription.Generic typeDescription, StackManipulation stackManipulation) {
                super((FieldLocation)var1_1, (Assigner)var2_2, (Assigner.Typing)var3_3, terminationHandler);
                void var3_3;
                void var2_2;
                void var1_1;
                this.typeDescription = typeDescription;
                this.stackManipulation = stackManipulation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            @AlwaysNull
            protected Void initialize(TypeDescription instrumentedType) {
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected StackManipulation resolve(@MaybeNull Void unused, FieldDescription fieldDescription, TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                void var2_2;
                return new StackManipulation.Compound(this.stackManipulation, this.assigner.assign(this.typeDescription, var2_2.getType(), this.typing));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation andThen(Implementation implementation) {
                void var1_1;
                return new Implementation.Compound(new Implementation[]{new OfConstantValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.typeDescription, this.stackManipulation), var1_1});
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation.Composable andThen(Implementation.Composable implementation) {
                void var1_1;
                return new Implementation.Compound.Composable(new OfConstantValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.typeDescription, this.stackManipulation), (Implementation.Composable)var1_1);
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.typeDescription.equals(((OfConstantValue)object).typeDescription)) {
                    return false;
                }
                return this.stackManipulation.equals(((OfConstantValue)object).stackManipulation);
            }

            @Override
            public int hashCode() {
                return (super.hashCode() * 31 + this.typeDescription.hashCode()) * 31 + this.stackManipulation.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfDefaultValue
        extends ForSetter<Void> {
            /*
             * WARNING - void declaration
             */
            protected OfDefaultValue(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, TerminationHandler terminationHandler) {
                super((FieldLocation)var1_1, (Assigner)var2_2, (Assigner.Typing)var3_3, terminationHandler);
                void var3_3;
                void var2_2;
                void var1_1;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            @AlwaysNull
            protected Void initialize(TypeDescription instrumentedType) {
                return null;
            }

            @Override
            protected StackManipulation resolve(@MaybeNull Void initialized, FieldDescription fieldDescription, TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return DefaultValue.of(fieldDescription.getType());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation andThen(Implementation implementation) {
                void var1_1;
                return new Implementation.Compound(new Implementation[]{new OfDefaultValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL), var1_1});
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation.Composable andThen(Implementation.Composable implementation) {
                void var1_1;
                return new Implementation.Compound.Composable(new OfDefaultValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL), (Implementation.Composable)var1_1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class OfParameterValue
        extends ForSetter<Void> {
            private final int index;

            /*
             * WARNING - void declaration
             */
            protected OfParameterValue(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, TerminationHandler terminationHandler, int index) {
                super((FieldLocation)var1_1, (Assigner)var2_2, (Assigner.Typing)var3_3, terminationHandler);
                void var3_3;
                void var2_2;
                void var1_1;
                this.index = index;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            @AlwaysNull
            protected Void initialize(TypeDescription instrumentedType) {
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected StackManipulation resolve(@MaybeNull Void unused, FieldDescription fieldDescription, TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                void var2_2;
                if (instrumentedMethod.getParameters().size() <= this.index) {
                    throw new IllegalStateException(instrumentedMethod + " does not define a parameter with index " + this.index);
                }
                return new StackManipulation.Compound(MethodVariableAccess.load((ParameterDescription)instrumentedMethod.getParameters().get(this.index)), this.assigner.assign(((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType(), var2_2.getType(), this.typing));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation andThen(Implementation implementation) {
                void var1_1;
                return new Implementation.Compound(new Implementation[]{new OfParameterValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.index), var1_1});
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Implementation.Composable andThen(Implementation.Composable implementation) {
                void var1_1;
                return new Implementation.Compound.Composable(new OfParameterValue(this.fieldLocation, this.assigner, this.typing, TerminationHandler.NON_OPERATIONAL, this.index), (Implementation.Composable)var1_1);
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.index == ((OfParameterValue)object).index;
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.index;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum TerminationHandler {
            RETURNING{

                /*
                 * WARNING - void declaration
                 */
                protected final StackManipulation resolve(MethodDescription instrumentedMethod) {
                    if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        void var1_1;
                        throw new IllegalStateException("Cannot implement setter with return value for " + var1_1);
                    }
                    return MethodReturn.VOID;
                }
            }
            ,
            NON_OPERATIONAL{

                protected final StackManipulation resolve(MethodDescription instrumentedMethod) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            };


            protected abstract StackManipulation resolve(MethodDescription var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ForImplicitProperty
    extends FieldAccessor
    implements OwnerTypeLocatable {
        /*
         * WARNING - void declaration
         */
        protected ForImplicitProperty(FieldLocation fieldLocation) {
            this((FieldLocation)var1_1, Assigner.DEFAULT, Assigner.Typing.STATIC);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ForImplicitProperty(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing) {
            super((FieldLocation)var1_1, (Assigner)var2_2, (Assigner.Typing)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            void var1_1;
            ForImplicitProperty forImplicitProperty = this;
            return new Appender(forImplicitProperty, forImplicitProperty.fieldLocation.prepare(var1_1.getInstrumentedType()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsArgumentAt(int index) {
            void var1_1;
            if (index < 0) {
                throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
            }
            return new ForSetter.OfParameterValue(this.fieldLocation, this.assigner, this.typing, ForSetter.TerminationHandler.RETURNING, (int)var1_1);
        }

        @Override
        public Implementation.Composable setsDefaultValue() {
            return new ForSetter.OfDefaultValue(this.fieldLocation, this.assigner, this.typing, ForSetter.TerminationHandler.RETURNING);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsValue(@MaybeNull Object value) {
            void var2_2;
            if (value == null) {
                return this.setsDefaultValue();
            }
            ConstantValue constant = ConstantValue.Simple.wrapOrNull(value);
            if (constant == null) {
                void var1_1;
                return this.setsReference(var1_1);
            }
            return this.setsValue(constant.toStackManipulation(), var2_2.getTypeDescription().asGenericType());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsValue(TypeDescription typeDescription) {
            void var1_1;
            return this.setsValue(ClassConstant.of((TypeDescription)var1_1), (Type)((Object)Class.class));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsValue(ConstantValue constant) {
            void var1_1;
            return this.setsValue(constant.toStackManipulation(), var1_1.getTypeDescription().asGenericType());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsValue(JavaConstant constant) {
            void var1_1;
            return this.setsValue((ConstantValue)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsValue(StackManipulation stackManipulation, Type type) {
            void var2_2;
            void var1_1;
            return this.setsValue((StackManipulation)var1_1, TypeDefinition.Sort.describe((Type)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsValue(StackManipulation stackManipulation, TypeDescription.Generic typeDescription) {
            void var1_1;
            void var2_2;
            return new ForSetter.OfConstantValue(this.fieldLocation, this.assigner, this.typing, ForSetter.TerminationHandler.RETURNING, (TypeDescription.Generic)var2_2, (StackManipulation)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsReference(Object value) {
            void var1_1;
            return this.setsReference(value, "fixedFieldValue$" + RandomString.hashOf(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsReference(Object value, String name) {
            void var2_2;
            void var1_1;
            return new ForSetter.OfReferenceValue(this.fieldLocation, this.assigner, this.typing, ForSetter.TerminationHandler.RETURNING, var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsFieldValueOf(Field field) {
            void var1_1;
            return this.setsFieldValueOf(new FieldDescription.ForLoadedField((Field)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsFieldValueOf(FieldDescription fieldDescription) {
            void var1_1;
            return new ForSetter.OfFieldValue(this.fieldLocation, this.assigner, this.typing, ForSetter.TerminationHandler.RETURNING, new FieldLocation.Absolute((FieldDescription)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsFieldValueOf(String fieldName) {
            void var1_1;
            return this.setsFieldValueOf(new FieldNameExtractor.ForFixedValue((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Implementation.Composable setsFieldValueOf(FieldNameExtractor fieldNameExtractor) {
            void var1_1;
            return new ForSetter.OfFieldValue(this.fieldLocation, this.assigner, this.typing, ForSetter.TerminationHandler.RETURNING, new FieldLocation.Relative(Collections.singletonList(var1_1)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PropertyConfigurable withAssigner(Assigner assigner, Assigner.Typing typing) {
            void var2_2;
            void var1_1;
            return new ForImplicitProperty(this.fieldLocation, (Assigner)var1_1, (Assigner.Typing)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AssignerConfigurable in(Class<?> type) {
            void var1_1;
            return this.in(TypeDescription.ForLoadedType.of(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            void var1_1;
            return this.in(new FieldLocator.ForExactType.Factory((TypeDescription)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AssignerConfigurable in(FieldLocator.Factory fieldLocatorFactory) {
            void var1_1;
            return new ForImplicitProperty(this.fieldLocation.with((FieldLocator.Factory)var1_1), this.assigner, this.typing);
        }

        @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
        protected class Appender
        implements ByteCodeAppender {
            private final FieldLocation.Prepared fieldLocation;
            final /* synthetic */ ForImplicitProperty this$0;

            /*
             * WARNING - void declaration
             */
            protected Appender(ForImplicitProperty this$0, FieldLocation.Prepared fieldLocation) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.fieldLocation = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                void var3_3;
                void var2_2;
                void var1_1;
                StackManipulation.Compound implementation;
                StackManipulation initialization;
                if (!instrumentedMethod.isMethod()) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not describe a field getter or setter");
                }
                FieldDescription fieldDescription = this.fieldLocation.resolve(instrumentedMethod);
                if (!fieldDescription.isStatic() && instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot set instance field " + fieldDescription + " from " + instrumentedMethod);
                }
                StackManipulation stackManipulation = initialization = fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis();
                if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    implementation = new StackManipulation.Compound(initialization, FieldAccess.forField(fieldDescription).read(), this.this$0.assigner.assign(fieldDescription.getType(), instrumentedMethod.getReturnType(), this.this$0.typing), MethodReturn.of(instrumentedMethod.getReturnType()));
                } else if (instrumentedMethod.getReturnType().represents(Void.TYPE) && instrumentedMethod.getParameters().size() == 1) {
                    if (fieldDescription.isFinal() && instrumentedMethod.isMethod()) {
                        throw new IllegalStateException("Cannot set final field " + fieldDescription + " from " + instrumentedMethod);
                    }
                    implementation = new StackManipulation.Compound(implementation, MethodVariableAccess.load((ParameterDescription)instrumentedMethod.getParameters().get(0)), this.this$0.assigner.assign(((ParameterDescription)instrumentedMethod.getParameters().get(0)).getType(), fieldDescription.getType(), this.this$0.typing), FieldAccess.forField(fieldDescription).write(), MethodReturn.VOID);
                } else {
                    throw new IllegalArgumentException("Method " + instrumentedMethod + " is no bean accessor");
                }
                if (!implementation.isValid()) {
                    throw new IllegalStateException("Cannot set or get value of " + instrumentedMethod + " using " + fieldDescription);
                }
                return new ByteCodeAppender.Size(implementation.apply((MethodVisitor)var1_1, (Implementation.Context)var2_2).getMaximalSize(), var3_3.getStackSize());
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.fieldLocation.equals(((Appender)object).fieldLocation)) {
                    return false;
                }
                return this.this$0.equals(((Appender)object).this$0);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.fieldLocation.hashCode()) * 31 + this.this$0.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OwnerTypeLocatable
    extends AssignerConfigurable {
        public AssignerConfigurable in(Class<?> var1);

        public AssignerConfigurable in(TypeDescription var1);

        public AssignerConfigurable in(FieldLocator.Factory var1);
    }

    public static interface AssignerConfigurable
    extends PropertyConfigurable {
        public PropertyConfigurable withAssigner(Assigner var1, Assigner.Typing var2);
    }

    public static interface PropertyConfigurable
    extends Implementation {
        public Implementation.Composable setsArgumentAt(int var1);

        public Implementation.Composable setsDefaultValue();

        public Implementation.Composable setsValue(Object var1);

        public Implementation.Composable setsValue(TypeDescription var1);

        public Implementation.Composable setsValue(ConstantValue var1);

        public Implementation.Composable setsValue(JavaConstant var1);

        public Implementation.Composable setsValue(StackManipulation var1, Type var2);

        public Implementation.Composable setsValue(StackManipulation var1, TypeDescription.Generic var2);

        public Implementation.Composable setsReference(Object var1);

        public Implementation.Composable setsReference(Object var1, String var2);

        public Implementation.Composable setsFieldValueOf(Field var1);

        public Implementation.Composable setsFieldValueOf(FieldDescription var1);

        public Implementation.Composable setsFieldValueOf(String var1);

        public Implementation.Composable setsFieldValueOf(FieldNameExtractor var1);
    }

    public static interface FieldNameExtractor {
        public String resolve(MethodDescription var1);

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForFixedValue
        implements FieldNameExtractor {
            private final String name;

            /*
             * WARNING - void declaration
             */
            protected ForFixedValue(String name) {
                void var1_1;
                this.name = var1_1;
            }

            public String resolve(MethodDescription methodDescription) {
                return this.name;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.name.equals(((ForFixedValue)object).name);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.name.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForBeanProperty implements FieldNameExtractor
        {
            INSTANCE{

                protected final char resolve(char character) {
                    return Character.toLowerCase(character);
                }
            }
            ,
            CAPITALIZED{

                protected final char resolve(char character) {
                    return Character.toUpperCase(character);
                }
            };


            /*
             * WARNING - void declaration
             */
            @Override
            public String resolve(MethodDescription methodDescription) {
                void var2_2;
                void var3_3;
                int crop;
                String name = methodDescription.getInternalName();
                if (name.startsWith("get") || name.startsWith("set")) {
                    crop = 3;
                } else if (name.startsWith("is")) {
                    crop = 2;
                } else {
                    throw new IllegalArgumentException(methodDescription + " does not follow Java bean naming conventions");
                }
                name = name.substring((int)var3_3);
                if (name.length() == 0) {
                    void var1_1;
                    throw new IllegalArgumentException(var1_1 + " does not specify a bean name");
                }
                return this.resolve(name.charAt(0)) + var2_2.substring(1);
            }

            protected abstract char resolve(char var1);
        }
    }

    protected static interface FieldLocation {
        public FieldLocation with(FieldLocator.Factory var1);

        public Prepared prepare(TypeDescription var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Relative
        implements FieldLocation {
            private final List<? extends FieldNameExtractor> fieldNameExtractors;
            private final FieldLocator.Factory fieldLocatorFactory;

            /*
             * WARNING - void declaration
             */
            protected Relative(List<? extends FieldNameExtractor> fieldNameExtractors) {
                this((List<? extends FieldNameExtractor>)var1_1, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private Relative(List<? extends FieldNameExtractor> fieldNameExtractors, FieldLocator.Factory fieldLocatorFactory) {
                void var2_2;
                void var1_1;
                this.fieldNameExtractors = var1_1;
                this.fieldLocatorFactory = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public FieldLocation with(FieldLocator.Factory fieldLocatorFactory) {
                void var1_1;
                return new Relative(this.fieldNameExtractors, (FieldLocator.Factory)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.implementation.FieldAccessor$FieldLocation$Prepared prepare(TypeDescription instrumentedType) {
                void var1_1;
                return new Prepared(this.fieldNameExtractors, this.fieldLocatorFactory.make((TypeDescription)var1_1));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!((Object)this.fieldNameExtractors).equals(((Relative)object).fieldNameExtractors)) {
                    return false;
                }
                return this.fieldLocatorFactory.equals(((Relative)object).fieldLocatorFactory);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + ((Object)this.fieldNameExtractors).hashCode()) * 31 + this.fieldLocatorFactory.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Prepared
            implements net.bytebuddy.implementation.FieldAccessor$FieldLocation$Prepared {
                private final List<? extends FieldNameExtractor> fieldNameExtractors;
                private final FieldLocator fieldLocator;

                /*
                 * WARNING - void declaration
                 */
                protected Prepared(List<? extends FieldNameExtractor> fieldNameExtractors, FieldLocator fieldLocator) {
                    void var2_2;
                    void var1_1;
                    this.fieldNameExtractors = var1_1;
                    this.fieldLocator = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public FieldDescription resolve(MethodDescription instrumentedMethod) {
                    void var2_2;
                    FieldLocator.Resolution resolution = FieldLocator.Resolution.Illegal.INSTANCE;
                    Iterator<? extends FieldNameExtractor> iterator = this.fieldNameExtractors.iterator();
                    while (iterator.hasNext() && !resolution.isResolved()) {
                        resolution = this.fieldLocator.locate(iterator.next().resolve(instrumentedMethod));
                    }
                    if (!resolution.isResolved()) {
                        void var1_1;
                        throw new IllegalStateException("Cannot resolve field for " + var1_1 + " using " + this.fieldLocator);
                    }
                    return var2_2.getField();
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!((Object)this.fieldNameExtractors).equals(((Prepared)object).fieldNameExtractors)) {
                        return false;
                    }
                    return this.fieldLocator.equals(((Prepared)object).fieldLocator);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + ((Object)this.fieldNameExtractors).hashCode()) * 31 + this.fieldLocator.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Absolute
        implements FieldLocation,
        Prepared {
            private final FieldDescription fieldDescription;

            /*
             * WARNING - void declaration
             */
            protected Absolute(FieldDescription fieldDescription) {
                void var1_1;
                this.fieldDescription = var1_1;
            }

            public FieldLocation with(FieldLocator.Factory fieldLocatorFactory) {
                throw new IllegalStateException("Cannot specify a field locator factory for an absolute field location");
            }

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
            public Prepared prepare(TypeDescription instrumentedType) {
                if (!this.fieldDescription.isStatic() && !instrumentedType.isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                    throw new IllegalStateException(this.fieldDescription + " is not declared by " + instrumentedType);
                }
                if (!this.fieldDescription.isAccessibleTo(instrumentedType)) {
                    void var1_1;
                    throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + var1_1);
                }
                return this;
            }

            public FieldDescription resolve(MethodDescription instrumentedMethod) {
                return this.fieldDescription;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.fieldDescription.equals(((Absolute)object).fieldDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.fieldDescription.hashCode();
            }
        }

        public static interface Prepared {
            public FieldDescription resolve(MethodDescription var1);
        }
    }
}

