/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.SafeVarargsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.assign.InstanceCheck;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class EqualsMethod
implements Implementation {
    private static final MethodDescription.InDefinedShape EQUALS = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Object.class).getDeclaredMethods().filter(ElementMatchers.isEquals())).getOnly();
    private final SuperClassCheck superClassCheck;
    private final TypeCompatibilityCheck typeCompatibilityCheck;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> identity;
    private final Comparator<? super FieldDescription.InDefinedShape> comparator;

    /*
     * WARNING - void declaration
     */
    protected EqualsMethod(SuperClassCheck superClassCheck) {
        this((SuperClassCheck)var1_1, TypeCompatibilityCheck.EXACT, ElementMatchers.none(), ElementMatchers.none(), ElementMatchers.none(), NaturalOrderComparator.INSTANCE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private EqualsMethod(SuperClassCheck superClassCheck, TypeCompatibilityCheck typeCompatibilityCheck, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> identity, Comparator<? super FieldDescription.InDefinedShape> comparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.superClassCheck = var1_1;
        this.typeCompatibilityCheck = var2_2;
        this.ignored = var3_3;
        this.nonNullable = nonNullable;
        this.identity = identity;
        this.comparator = comparator;
    }

    public static EqualsMethod requiringSuperClassEquality() {
        return new EqualsMethod(SuperClassCheck.ENABLED);
    }

    public static EqualsMethod isolated() {
        return new EqualsMethod(SuperClassCheck.DISABLED);
    }

    /*
     * WARNING - void declaration
     */
    public EqualsMethod withIgnoredFields(ElementMatcher<? super FieldDescription.InDefinedShape> ignored) {
        void var1_1;
        return new EqualsMethod(this.superClassCheck, this.typeCompatibilityCheck, this.ignored.or(var1_1), this.nonNullable, this.identity, this.comparator);
    }

    /*
     * WARNING - void declaration
     */
    public EqualsMethod withNonNullableFields(ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable) {
        void var1_1;
        return new EqualsMethod(this.superClassCheck, this.typeCompatibilityCheck, this.ignored, this.nonNullable.or(var1_1), this.identity, this.comparator);
    }

    /*
     * WARNING - void declaration
     */
    public EqualsMethod withIdentityFields(ElementMatcher<? super FieldDescription.InDefinedShape> identity) {
        void var1_1;
        return new EqualsMethod(this.superClassCheck, this.typeCompatibilityCheck, this.ignored, this.nonNullable, this.identity.or(var1_1), this.comparator);
    }

    public EqualsMethod withPrimitiveTypedFieldsFirst() {
        return this.withFieldOrder(TypePropertyComparator.FOR_PRIMITIVE_TYPES);
    }

    public EqualsMethod withEnumerationTypedFieldsFirst() {
        return this.withFieldOrder(TypePropertyComparator.FOR_ENUMERATION_TYPES);
    }

    public EqualsMethod withPrimitiveWrapperTypedFieldsFirst() {
        return this.withFieldOrder(TypePropertyComparator.FOR_PRIMITIVE_WRAPPER_TYPES);
    }

    public EqualsMethod withStringTypedFieldsFirst() {
        return this.withFieldOrder(TypePropertyComparator.FOR_STRING_TYPES);
    }

    /*
     * WARNING - void declaration
     */
    public EqualsMethod withFieldOrder(Comparator<? super FieldDescription.InDefinedShape> comparator) {
        void var1_1;
        return new EqualsMethod(this.superClassCheck, this.typeCompatibilityCheck, this.ignored, this.nonNullable, this.identity, new CompoundComparator(new Comparator[]{this.comparator, var1_1}));
    }

    public EqualsMethod withSubclassEquality() {
        return new EqualsMethod(this.superClassCheck, TypeCompatibilityCheck.SUBCLASS, this.ignored, this.nonNullable, this.identity, this.comparator);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        void var2_2;
        void var1_1;
        if (implementationTarget.getInstrumentedType().isInterface()) {
            throw new IllegalStateException("Cannot implement meaningful equals method for " + implementationTarget.getInstrumentedType());
        }
        ArrayList fields = new ArrayList(implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.not(ElementMatchers.isStatic().or(this.ignored))));
        Collections.sort(fields, this.comparator);
        return new Appender(implementationTarget.getInstrumentedType(), new StackManipulation.Compound(this.superClassCheck.resolve(implementationTarget.getInstrumentedType()), MethodVariableAccess.loadThis(), MethodVariableAccess.REFERENCE.loadFrom(1), ConditionalReturn.onIdentity().returningTrue(), this.typeCompatibilityCheck.resolve(var1_1.getInstrumentedType())), (List<FieldDescription.InDefinedShape>)var2_2, this.nonNullable, this.identity);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.superClassCheck.equals((Object)((EqualsMethod)object).superClassCheck)) {
            return false;
        }
        if (!this.typeCompatibilityCheck.equals((Object)((EqualsMethod)object).typeCompatibilityCheck)) {
            return false;
        }
        if (!this.ignored.equals(((EqualsMethod)object).ignored)) {
            return false;
        }
        if (!this.nonNullable.equals(((EqualsMethod)object).nonNullable)) {
            return false;
        }
        if (!this.identity.equals(((EqualsMethod)object).identity)) {
            return false;
        }
        return ((Object)this.comparator).equals(((EqualsMethod)object).comparator);
    }

    public int hashCode() {
        return (((((this.getClass().hashCode() * 31 + this.superClassCheck.hashCode()) * 31 + this.typeCompatibilityCheck.hashCode()) * 31 + this.ignored.hashCode()) * 31 + this.nonNullable.hashCode()) * 31 + this.identity.hashCode()) * 31 + this.comparator.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Not used within a serializable instance")
    protected static class CompoundComparator
    implements Comparator<FieldDescription.InDefinedShape> {
        private final List<Comparator<? super FieldDescription.InDefinedShape>> comparators = new ArrayList<Comparator<? super FieldDescription.InDefinedShape>>();

        /*
         * WARNING - void declaration
         */
        @SafeVarargsPlugin.Enhance
        @SafeVarargs
        protected CompoundComparator(Comparator<? super FieldDescription.InDefinedShape> ... comparator) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected CompoundComparator(List<? extends Comparator<? super FieldDescription.InDefinedShape>> comparators) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Comparator comparator = (Comparator)iterator.next();
                if (comparator instanceof CompoundComparator) {
                    this.comparators.addAll(((CompoundComparator)comparator).comparators);
                    continue;
                }
                if (comparator instanceof NaturalOrderComparator) continue;
                this.comparators.add((Comparator<? super FieldDescription.InDefinedShape>)var2_2);
            }
        }

        @Override
        public int compare(FieldDescription.InDefinedShape left, FieldDescription.InDefinedShape right) {
            for (Comparator<? super FieldDescription.InDefinedShape> comparator : this.comparators) {
                int comparison = comparator.compare(left, right);
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.comparators).hashCode();
        }

        @Override
        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.comparators).equals(((CompoundComparator)object).comparators);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TypePropertyComparator implements Comparator<FieldDescription.InDefinedShape>
    {
        FOR_PRIMITIVE_TYPES{

            protected final boolean resolve(TypeDefinition typeDefinition) {
                return typeDefinition.isPrimitive();
            }
        }
        ,
        FOR_ENUMERATION_TYPES{

            protected final boolean resolve(TypeDefinition typeDefinition) {
                return typeDefinition.isEnum();
            }
        }
        ,
        FOR_STRING_TYPES{

            protected final boolean resolve(TypeDefinition typeDefinition) {
                return typeDefinition.represents((Type)((Object)String.class));
            }
        }
        ,
        FOR_PRIMITIVE_WRAPPER_TYPES{

            protected final boolean resolve(TypeDefinition typeDefinition) {
                return typeDefinition.asErasure().isPrimitiveWrapper();
            }
        };


        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(FieldDescription.InDefinedShape left, FieldDescription.InDefinedShape right) {
            void var2_2;
            void var1_1;
            if (this.resolve(left.getType()) && !this.resolve(right.getType())) {
                return -1;
            }
            if (!this.resolve(var1_1.getType()) && this.resolve(var2_2.getType())) {
                return 1;
            }
            return 0;
        }

        protected abstract boolean resolve(TypeDefinition var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum NaturalOrderComparator implements Comparator<FieldDescription.InDefinedShape>
    {
        INSTANCE;


        @Override
        public final int compare(FieldDescription.InDefinedShape left, FieldDescription.InDefinedShape right) {
            return 0;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConditionalReturn
    extends StackManipulation.AbstractBase {
        private final int jumpCondition;
        private final int value;

        /*
         * WARNING - void declaration
         */
        protected ConditionalReturn(int jumpCondition) {
            this((int)var1_1, 3);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ConditionalReturn(int jumpCondition, int value) {
            void var2_2;
            void var1_1;
            this.jumpCondition = var1_1;
            this.value = var2_2;
        }

        protected static ConditionalReturn onZeroInteger() {
            return new ConditionalReturn(154);
        }

        protected static ConditionalReturn onNonZeroInteger() {
            return new ConditionalReturn(153);
        }

        protected static ConditionalReturn onNullValue() {
            return new ConditionalReturn(199);
        }

        protected static ConditionalReturn onNonIdentity() {
            return new ConditionalReturn(165);
        }

        protected static ConditionalReturn onIdentity() {
            return new ConditionalReturn(166);
        }

        protected static ConditionalReturn onNonEqualInteger() {
            return new ConditionalReturn(159);
        }

        protected StackManipulation returningTrue() {
            return new ConditionalReturn(this.jumpCondition, 4);
        }

        /*
         * WARNING - void declaration
         */
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            void var2_2;
            void var1_1;
            void var3_3;
            Label label = new Label();
            methodVisitor.visitJumpInsn(this.jumpCondition, label);
            methodVisitor.visitInsn(this.value);
            methodVisitor.visitInsn(172);
            methodVisitor.visitLabel((Label)var3_3);
            implementationContext.getFrameGeneration().same((MethodVisitor)var1_1, Arrays.asList(var2_2.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class)));
            return new StackManipulation.Size(-1, 1);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.jumpCondition != ((ConditionalReturn)object).jumpCondition) {
                return false;
            }
            return this.value == ((ConditionalReturn)object).value;
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.jumpCondition) * 31 + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class Appender
    implements ByteCodeAppender {
        private final TypeDescription instrumentedType;
        private final StackManipulation baseline;
        private final List<FieldDescription.InDefinedShape> fieldDescriptions;
        private final ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable;
        private final ElementMatcher<? super FieldDescription.InDefinedShape> identity;

        /*
         * WARNING - void declaration
         */
        protected Appender(TypeDescription instrumentedType, StackManipulation baseline, List<FieldDescription.InDefinedShape> fieldDescriptions, ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable, ElementMatcher<? super FieldDescription.InDefinedShape> identity) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.instrumentedType = var1_1;
            this.baseline = var2_2;
            this.fieldDescriptions = var3_3;
            this.nonNullable = nonNullable;
            this.identity = identity;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (instrumentedMethod.isStatic()) {
                throw new IllegalStateException("Hash code method must not be static: " + instrumentedMethod);
            }
            if (instrumentedMethod.getParameters().size() != 1 || ((ParameterDescription)instrumentedMethod.getParameters().getOnly()).getType().isPrimitive()) {
                throw new IllegalStateException();
            }
            if (!instrumentedMethod.getReturnType().represents(Boolean.TYPE)) {
                throw new IllegalStateException("Hash code method does not return primitive boolean: " + instrumentedMethod);
            }
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(3 + (this.fieldDescriptions.size() << 3));
            stackManipulations.add(this.baseline);
            int padding = 0;
            for (FieldDescription.InDefinedShape fieldDescription : this.fieldDescriptions) {
                stackManipulations.add(MethodVariableAccess.loadThis());
                stackManipulations.add(FieldAccess.forField(fieldDescription).read());
                stackManipulations.add(MethodVariableAccess.REFERENCE.loadFrom(1));
                stackManipulations.add(TypeCasting.to(this.instrumentedType));
                stackManipulations.add(FieldAccess.forField(fieldDescription).read());
                if (!fieldDescription.getType().isPrimitive() && this.identity.matches(fieldDescription)) {
                    stackManipulations.add(ConditionalReturn.onNonIdentity());
                    continue;
                }
                NullValueGuard.NoOp nullValueGuard = fieldDescription.getType().isPrimitive() || fieldDescription.getType().isArray() || this.nonNullable.matches(fieldDescription) ? NullValueGuard.NoOp.INSTANCE : new NullValueGuard.UsingJump(instrumentedMethod);
                stackManipulations.add(nullValueGuard.before());
                stackManipulations.add(ValueComparator.of(fieldDescription.getType()));
                stackManipulations.add(nullValueGuard.after());
                padding = Math.max(padding, nullValueGuard.getRequiredVariablePadding());
            }
            stackManipulations.add(IntegerConstant.forValue(true));
            stackManipulations.add(MethodReturn.INTEGER);
            return new ByteCodeAppender.Size(new StackManipulation.Compound(stackManipulations).apply((MethodVisitor)var1_1, (Implementation.Context)var2_2).getMaximalSize(), var3_3.getStackSize() + padding);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.instrumentedType.equals(((Appender)object).instrumentedType)) {
                return false;
            }
            if (!this.baseline.equals(((Appender)object).baseline)) {
                return false;
            }
            if (!((Object)this.fieldDescriptions).equals(((Appender)object).fieldDescriptions)) {
                return false;
            }
            if (!this.nonNullable.equals(((Appender)object).nonNullable)) {
                return false;
            }
            return this.identity.equals(((Appender)object).identity);
        }

        public int hashCode() {
            return ((((this.getClass().hashCode() * 31 + this.instrumentedType.hashCode()) * 31 + this.baseline.hashCode()) * 31 + ((Object)this.fieldDescriptions).hashCode()) * 31 + this.nonNullable.hashCode()) * 31 + this.identity.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ValueComparator implements StackManipulation
    {
        LONG{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitInsn(148);
                return new StackManipulation.Size(-2, 0);
            }
        }
        ,
        FLOAT{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "compare", "(FF)I", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        DOUBLE{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "compare", "(DD)I", false);
                return new StackManipulation.Size(-2, 0);
            }
        }
        ,
        BOOLEAN_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([Z[Z)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        BYTE_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([B[B)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        SHORT_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([S[S)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        CHARACTER_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([C[C)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        INTEGER_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([I[I)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        LONG_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([J[J)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        FLOAT_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([F[F)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        DOUBLE_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([D[D)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        REFERENCE_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "equals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        }
        ,
        NESTED_ARRAY{

            public final StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "deepEquals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", false);
                return new StackManipulation.Size(-1, 0);
            }
        };


        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
        public static StackManipulation of(TypeDefinition typeDefinition) {
            TypeDefinition typeDefinition2;
            if (typeDefinition.represents(Boolean.TYPE) || typeDefinition.represents(Byte.TYPE) || typeDefinition.represents(Short.TYPE) || typeDefinition.represents(Character.TYPE) || typeDefinition.represents(Integer.TYPE)) {
                return ConditionalReturn.onNonEqualInteger();
            }
            if (typeDefinition.represents(Long.TYPE)) {
                return new StackManipulation.Compound(LONG, ConditionalReturn.onNonZeroInteger());
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return new StackManipulation.Compound(FLOAT, ConditionalReturn.onNonZeroInteger());
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return new StackManipulation.Compound(DOUBLE, ConditionalReturn.onNonZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)boolean[].class))) {
                return new StackManipulation.Compound(BOOLEAN_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)byte[].class))) {
                return new StackManipulation.Compound(BYTE_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)short[].class))) {
                return new StackManipulation.Compound(SHORT_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)char[].class))) {
                return new StackManipulation.Compound(CHARACTER_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)int[].class))) {
                return new StackManipulation.Compound(INTEGER_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)long[].class))) {
                return new StackManipulation.Compound(LONG_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)float[].class))) {
                return new StackManipulation.Compound(FLOAT_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.represents((Type)((Object)double[].class))) {
                return new StackManipulation.Compound(DOUBLE_ARRAY, ConditionalReturn.onZeroInteger());
            }
            if (typeDefinition.isArray()) {
                return new StackManipulation.Compound(typeDefinition.getComponentType().isArray() ? NESTED_ARRAY : REFERENCE_ARRAY, ConditionalReturn.onZeroInteger());
            }
            return new StackManipulation.Compound(MethodInvocation.invoke(EQUALS).virtual(typeDefinition2.asErasure()), ConditionalReturn.onZeroInteger());
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    protected static interface NullValueGuard {
        public StackManipulation before();

        public StackManipulation after();

        public int getRequiredVariablePadding();

        @HashCodeAndEqualsPlugin.Enhance
        public static class UsingJump
        implements NullValueGuard {
            private final MethodDescription instrumentedMethod;
            private final Label firstValueNull;
            private final Label secondValueNull;
            private final Label endOfBlock;

            /*
             * WARNING - void declaration
             */
            protected UsingJump(MethodDescription instrumentedMethod) {
                void var1_1;
                this.instrumentedMethod = var1_1;
                this.firstValueNull = new Label();
                this.secondValueNull = new Label();
                this.endOfBlock = new Label();
            }

            public StackManipulation before() {
                return new BeforeInstruction(this);
            }

            public StackManipulation after() {
                return new AfterInstruction(this);
            }

            public int getRequiredVariablePadding() {
                return 2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.instrumentedMethod.equals(((UsingJump)object).instrumentedMethod)) {
                    return false;
                }
                if (!this.firstValueNull.equals(((UsingJump)object).firstValueNull)) {
                    return false;
                }
                if (!this.secondValueNull.equals(((UsingJump)object).secondValueNull)) {
                    return false;
                }
                return this.endOfBlock.equals(((UsingJump)object).endOfBlock);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.instrumentedMethod.hashCode()) * 31 + this.firstValueNull.hashCode()) * 31 + this.secondValueNull.hashCode()) * 31 + this.endOfBlock.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
            protected class AfterInstruction
            extends StackManipulation.AbstractBase {
                final /* synthetic */ UsingJump this$0;

                /*
                 * WARNING - void declaration
                 */
                protected AfterInstruction(UsingJump this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    void var2_2;
                    void var1_1;
                    methodVisitor.visitJumpInsn(167, this.this$0.endOfBlock);
                    methodVisitor.visitLabel(this.this$0.secondValueNull);
                    implementationContext.getFrameGeneration().same1(methodVisitor, TypeDescription.ForLoadedType.of(Object.class), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class)));
                    methodVisitor.visitJumpInsn(198, this.this$0.endOfBlock);
                    methodVisitor.visitLabel(this.this$0.firstValueNull);
                    implementationContext.getFrameGeneration().same(methodVisitor, Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class)));
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitInsn(172);
                    methodVisitor.visitLabel(this.this$0.endOfBlock);
                    implementationContext.getFrameGeneration().same((MethodVisitor)var1_1, Arrays.asList(var2_2.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class)));
                    return StackManipulation.Size.ZERO;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.this$0.equals(((AfterInstruction)object).this$0);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.this$0.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
            protected class BeforeInstruction
            extends StackManipulation.AbstractBase {
                final /* synthetic */ UsingJump this$0;

                /*
                 * WARNING - void declaration
                 */
                protected BeforeInstruction(UsingJump this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    void var1_1;
                    methodVisitor.visitVarInsn(58, this.this$0.instrumentedMethod.getStackSize());
                    methodVisitor.visitVarInsn(58, this.this$0.instrumentedMethod.getStackSize() + 1);
                    methodVisitor.visitVarInsn(25, this.this$0.instrumentedMethod.getStackSize() + 1);
                    methodVisitor.visitVarInsn(25, this.this$0.instrumentedMethod.getStackSize());
                    methodVisitor.visitJumpInsn(198, this.this$0.secondValueNull);
                    methodVisitor.visitJumpInsn(198, this.this$0.firstValueNull);
                    methodVisitor.visitVarInsn(25, this.this$0.instrumentedMethod.getStackSize() + 1);
                    var1_1.visitVarInsn(25, this.this$0.instrumentedMethod.getStackSize());
                    return StackManipulation.Size.ZERO;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.this$0.equals(((BeforeInstruction)object).this$0);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.this$0.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NoOp implements NullValueGuard
        {
            INSTANCE;


            @Override
            public final StackManipulation before() {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public final StackManipulation after() {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public final int getRequiredVariablePadding() {
                return StackSize.ZERO.getSize();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TypeCompatibilityCheck {
        EXACT{

            public final StackManipulation resolve(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), ConditionalReturn.onNullValue(), MethodVariableAccess.REFERENCE.loadFrom(0), MethodInvocation.invoke(GET_CLASS), MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke(GET_CLASS), ConditionalReturn.onNonIdentity());
            }
        }
        ,
        SUBCLASS{

            /*
             * WARNING - void declaration
             */
            protected final StackManipulation resolve(TypeDescription instrumentedType) {
                void var1_1;
                return new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), InstanceCheck.of((TypeDescription)var1_1), ConditionalReturn.onZeroInteger());
            }
        };

        protected static final MethodDescription.InDefinedShape GET_CLASS;

        protected abstract StackManipulation resolve(TypeDescription var1);

        static {
            GET_CLASS = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Object.class).getDeclaredMethods().filter(ElementMatchers.named("getClass"))).getOnly();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SuperClassCheck {
        DISABLED{

            protected final StackManipulation resolve(TypeDescription instrumentedType) {
                return StackManipulation.Trivial.INSTANCE;
            }
        }
        ,
        ENABLED{

            /*
             * WARNING - void declaration
             */
            protected final StackManipulation resolve(TypeDescription instrumentedType) {
                void var2_2;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                if (superClass == null) {
                    void var1_1;
                    throw new IllegalStateException(var1_1 + " does not declare a super class");
                }
                return new StackManipulation.Compound(MethodVariableAccess.loadThis(), MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke(EQUALS).special(var2_2.asErasure()), ConditionalReturn.onZeroInteger());
            }
        };


        protected abstract StackManipulation resolve(TypeDescription var1);
    }
}

