/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class DefaultMethodCall
implements Implementation {
    private final List<TypeDescription> prioritizedInterfaces;

    /*
     * WARNING - void declaration
     */
    protected DefaultMethodCall(List<TypeDescription> prioritizedInterfaces) {
        void var1_1;
        this.prioritizedInterfaces = var1_1;
    }

    public static Implementation prioritize(Class<?> ... prioritizedInterface) {
        Class<?>[] classArray;
        return DefaultMethodCall.prioritize(new TypeList.ForLoadedTypes(classArray));
    }

    /*
     * WARNING - void declaration
     */
    public static Implementation prioritize(Iterable<? extends Class<?>> prioritizedInterfaces) {
        void var1_1;
        Iterator<? extends Class<?>> iterator;
        ArrayList<void> list = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Class prioritizedInterface = (Class)iterator.next();
            list.add(var2_2);
        }
        return DefaultMethodCall.prioritize(new TypeList.ForLoadedTypes((List<? extends Class<?>>)var1_1));
    }

    public static Implementation prioritize(TypeDescription ... prioritizedInterface) {
        return DefaultMethodCall.prioritize(Arrays.asList(prioritizedInterface));
    }

    public static Implementation prioritize(Collection<? extends TypeDescription> prioritizedInterfaces) {
        Collection<? extends TypeDescription> collection;
        return new DefaultMethodCall(new ArrayList<TypeDescription>(collection));
    }

    public static Implementation unambiguousOnly() {
        return new DefaultMethodCall(Collections.<TypeDescription>emptyList());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        void var1_1;
        return new Appender(implementationTarget, this.filterRelevant(var1_1.getInstrumentedType()));
    }

    /*
     * WARNING - void declaration
     */
    private List<TypeDescription> filterRelevant(TypeDescription typeDescription) {
        void var2_2;
        ArrayList<TypeDescription> filtered = new ArrayList<TypeDescription>(this.prioritizedInterfaces.size());
        HashSet<TypeDescription> relevant = new HashSet<TypeDescription>(typeDescription.getInterfaces().asErasures());
        for (TypeDescription prioritizedInterface : this.prioritizedInterfaces) {
            if (!relevant.remove(prioritizedInterface)) continue;
            filtered.add(prioritizedInterface);
        }
        return var2_2;
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return ((Object)this.prioritizedInterfaces).equals(((DefaultMethodCall)object).prioritizedInterfaces);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + ((Object)this.prioritizedInterfaces).hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;
        private final List<TypeDescription> prioritizedInterfaces;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
        private final Set<TypeDescription> nonPrioritizedInterfaces;

        /*
         * WARNING - void declaration
         */
        protected Appender(Implementation.Target implementationTarget, List<TypeDescription> prioritizedInterfaces) {
            void var2_2;
            void var1_1;
            this.implementationTarget = implementationTarget;
            this.prioritizedInterfaces = prioritizedInterfaces;
            this.nonPrioritizedInterfaces = new HashSet<TypeDescription>(var1_1.getInstrumentedType().getInterfaces().asErasures());
            this.nonPrioritizedInterfaces.removeAll((Collection<?>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var1_1;
            void var2_2;
            StackManipulation defaultMethodInvocation = this.locateDefault(instrumentedMethod);
            if (!defaultMethodInvocation.isValid()) {
                throw new IllegalStateException("Cannot invoke default method on " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), defaultMethodInvocation, MethodReturn.of(instrumentedMethod.getReturnType())).apply(methodVisitor, (Implementation.Context)var2_2);
            return new ByteCodeAppender.Size(var1_1.getMaximalSize(), var3_3.getStackSize());
        }

        /*
         * WARNING - void declaration
         */
        private StackManipulation locateDefault(MethodDescription methodDescription) {
            void var3_3;
            MethodDescription.SignatureToken methodToken = methodDescription.asSignatureToken();
            Implementation.SpecialMethodInvocation specialMethodInvocation = Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
            for (TypeDescription typeDescription : this.prioritizedInterfaces) {
                specialMethodInvocation = this.implementationTarget.invokeDefault(methodToken, typeDescription).withCheckedCompatibilityTo(methodDescription.asTypeToken());
                if (!specialMethodInvocation.isValid()) continue;
                return specialMethodInvocation;
            }
            for (TypeDescription typeDescription : this.nonPrioritizedInterfaces) {
                Implementation.SpecialMethodInvocation other = this.implementationTarget.invokeDefault(methodToken, typeDescription).withCheckedCompatibilityTo(methodDescription.asTypeToken());
                if (specialMethodInvocation.isValid() && other.isValid()) {
                    throw new IllegalStateException(methodDescription + " has an ambiguous default method with " + other.getMethodDescription() + " and " + specialMethodInvocation.getMethodDescription());
                }
                specialMethodInvocation = other;
            }
            return var3_3;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.implementationTarget.equals(((Appender)object).implementationTarget)) {
                return false;
            }
            return ((Object)this.prioritizedInterfaces).equals(((Appender)object).prioritizedInterfaces);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.implementationTarget.hashCode()) * 31 + ((Object)this.prioritizedInterfaces).hashCode();
        }
    }
}

