/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.dynamic.scaffold.MethodRegistry;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ConstructorStrategy {
    public List<MethodDescription.Token> extractConstructors(TypeDescription var1);

    public MethodRegistry inject(TypeDescription var1, MethodRegistry var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForDefaultConstructor
    implements ConstructorStrategy {
        private final ElementMatcher<? super MethodDescription> elementMatcher;
        private final MethodAttributeAppender.Factory methodAttributeAppenderFactory;

        public ForDefaultConstructor() {
            this(ElementMatchers.any());
        }

        /*
         * WARNING - void declaration
         */
        public ForDefaultConstructor(ElementMatcher<? super MethodDescription> elementMatcher) {
            this((ElementMatcher<? super MethodDescription>)var1_1, MethodAttributeAppender.NoOp.INSTANCE);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ForDefaultConstructor(MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
            this(ElementMatchers.any(), (MethodAttributeAppender.Factory)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ForDefaultConstructor(ElementMatcher<? super MethodDescription> elementMatcher, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
            void var2_2;
            void var1_1;
            this.elementMatcher = var1_1;
            this.methodAttributeAppenderFactory = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
            void var2_2;
            TypeDescription.Generic superClass = instrumentedType.getSuperClass();
            if (superClass == null) {
                void var1_1;
                throw new IllegalArgumentException("Cannot extract constructors for " + var1_1);
            }
            if (((MethodList)var2_2.getDeclaredMethods().filter(ElementMatchers.isConstructor())).isEmpty()) {
                throw new IllegalStateException("Cannot define default constructor for class without super class constructor");
            }
            return Collections.singletonList(new MethodDescription.Token(1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MethodRegistry inject(TypeDescription instrumentedType, MethodRegistry methodRegistry) {
            void var3_3;
            void var2_2;
            Iterator iterator;
            TypeDescription.Generic superClass = instrumentedType.getSuperClass();
            if (superClass == null) {
                throw new IllegalArgumentException("Cannot inject constructors for " + instrumentedType);
            }
            MethodList candidates = (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(this.elementMatcher));
            if (candidates.isEmpty()) {
                throw new IllegalStateException("No possible candidate for super constructor invocation in " + superClass);
            }
            if (!((MethodList)candidates.filter(ElementMatchers.takesArguments(0))).isEmpty()) {
                candidates = (MethodList)candidates.filter(ElementMatchers.takesArguments(0));
            } else if (candidates.size() > 1) {
                throw new IllegalStateException("More than one possible super constructor for constructor delegation: " + candidates);
            }
            MethodCall methodCall = MethodCall.invoke((MethodDescription)candidates.getOnly());
            for (TypeDescription typeDescription : ((MethodDescription)iterator.getOnly()).getParameters().asTypeList().asErasures()) {
                methodCall = methodCall.with(typeDescription.getDefaultValue());
            }
            return var2_2.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0))), new MethodRegistry.Handler.ForImplementation((Implementation)var3_3), this.methodAttributeAppenderFactory, Transformer.NoOp.<MethodDescription>make());
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.elementMatcher.equals(((ForDefaultConstructor)object).elementMatcher)) {
                return false;
            }
            return this.methodAttributeAppenderFactory.equals(((ForDefaultConstructor)object).methodAttributeAppenderFactory);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.elementMatcher.hashCode()) * 31 + this.methodAttributeAppenderFactory.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Default implements ConstructorStrategy
    {
        NO_CONSTRUCTORS{

            @Override
            protected final List<MethodDescription.Token> doExtractConstructors(TypeDescription superClass) {
                return Collections.emptyList();
            }

            @Override
            protected final MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                return methodRegistry;
            }
        }
        ,
        DEFAULT_CONSTRUCTOR{

            /*
             * WARNING - void declaration
             */
            @Override
            protected final List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                void var1_1;
                MethodList methodList;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                methodList = superClass == null ? new MethodList.Empty() : (MethodList)methodList.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isVisibleTo(instrumentedType)));
                if (methodList.size() == 1) {
                    return Collections.singletonList(new MethodDescription.Token(1));
                }
                throw new IllegalArgumentException(instrumentedType.getSuperClass() + " declares no constructor that is visible to " + var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                void var2_2;
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), (MethodAttributeAppender.Factory)var2_2, Transformer.NoOp.<MethodDescription>make());
            }
        }
        ,
        IMITATE_SUPER_CLASS{

            /*
             * WARNING - void declaration
             */
            @Override
            protected final List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                void var1_1;
                void var2_2;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)var2_2.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)))).asTokenList(ElementMatchers.is(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                void var2_2;
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), (MethodAttributeAppender.Factory)var2_2, Transformer.NoOp.<MethodDescription>make());
            }
        }
        ,
        IMITATE_SUPER_CLASS_PUBLIC{

            /*
             * WARNING - void declaration
             */
            @Override
            protected final List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                void var1_1;
                void var2_2;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)var2_2.getDeclaredMethods().filter(ElementMatchers.isPublic().and(ElementMatchers.isConstructor()))).asTokenList(ElementMatchers.is(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                void var2_2;
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), (MethodAttributeAppender.Factory)var2_2, Transformer.NoOp.<MethodDescription>make());
            }
        }
        ,
        IMITATE_SUPER_CLASS_OPENING{

            /*
             * WARNING - void declaration
             */
            @Override
            protected final List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                void var1_1;
                void var2_2;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)var2_2.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)))).asTokenList(ElementMatchers.is(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                void var2_2;
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), (MethodAttributeAppender.Factory)var2_2, Transformer.NoOp.<MethodDescription>make());
            }

            @Override
            protected final int resolveModifier(int modifiers) {
                return 1;
            }
        };


        /*
         * WARNING - void declaration
         */
        @Override
        public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
            void var2_2;
            Iterator iterator;
            List<MethodDescription.Token> tokens = this.doExtractConstructors(instrumentedType);
            ArrayList<MethodDescription.Token> stripped = new ArrayList<MethodDescription.Token>(tokens.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                MethodDescription.Token token = (MethodDescription.Token)iterator.next();
                stripped.add(new MethodDescription.Token(token.getName(), this.resolveModifier(token.getModifiers()), token.getTypeVariableTokens(), token.getReturnType(), token.getParameterTokens(), token.getExceptionTypes(), token.getAnnotations(), var3_3.getDefaultValue(), TypeDescription.Generic.UNDEFINED));
            }
            return var2_2;
        }

        protected int resolveModifier(int modifiers) {
            return modifiers;
        }

        protected abstract List<MethodDescription.Token> doExtractConstructors(TypeDescription var1);

        /*
         * WARNING - void declaration
         */
        @Override
        public MethodRegistry inject(TypeDescription instrumentedType, MethodRegistry methodRegistry) {
            void var2_2;
            return this.doInject((MethodRegistry)var2_2, MethodAttributeAppender.NoOp.INSTANCE);
        }

        protected abstract MethodRegistry doInject(MethodRegistry var1, MethodAttributeAppender.Factory var2);

        /*
         * WARNING - void declaration
         */
        public ConstructorStrategy with(MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
            void var1_1;
            return new WithMethodAttributeAppenderFactory(this, (MethodAttributeAppender.Factory)var1_1);
        }

        public ConstructorStrategy withInheritedAnnotations() {
            return new WithMethodAttributeAppenderFactory(this, MethodAttributeAppender.ForInstrumentedMethod.EXCLUDING_RECEIVER);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class WithMethodAttributeAppenderFactory
        implements ConstructorStrategy {
            private final Default delegate;
            private final MethodAttributeAppender.Factory methodAttributeAppenderFactory;

            /*
             * WARNING - void declaration
             */
            protected WithMethodAttributeAppenderFactory(Default delegate, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                void var2_2;
                void var1_1;
                this.delegate = var1_1;
                this.methodAttributeAppenderFactory = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
                void var1_1;
                return this.delegate.extractConstructors((TypeDescription)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public MethodRegistry inject(TypeDescription instrumentedType, MethodRegistry methodRegistry) {
                void var2_2;
                return this.delegate.doInject((MethodRegistry)var2_2, this.methodAttributeAppenderFactory);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.delegate.equals(((WithMethodAttributeAppenderFactory)object).delegate)) {
                    return false;
                }
                return this.methodAttributeAppenderFactory.equals(((WithMethodAttributeAppenderFactory)object).methodAttributeAppenderFactory);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.delegate.hashCode()) * 31 + this.methodAttributeAppenderFactory.hashCode();
            }
        }
    }
}

