/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.implementation.MethodAccessorFactory;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.auxiliary.TrivialType;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MethodRebaseResolver {
    public Resolution resolve(MethodDescription.InDefinedShape var1);

    public List<DynamicType> getAuxiliaryTypes();

    public Map<MethodDescription.SignatureToken, Resolution> asTokenMap();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Default
    implements MethodRebaseResolver {
        private final Map<MethodDescription.InDefinedShape, Resolution> resolutions;
        private final List<DynamicType> dynamicTypes;

        /*
         * WARNING - void declaration
         */
        protected Default(Map<MethodDescription.InDefinedShape, Resolution> resolutions, List<DynamicType> dynamicTypes) {
            void var2_2;
            void var1_1;
            this.resolutions = var1_1;
            this.dynamicTypes = var2_2;
        }

        public static MethodRebaseResolver make(TypeDescription instrumentedType, Set<? extends MethodDescription.SignatureToken> rebaseables, ClassFileVersion classFileVersion, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, MethodNameTransformer methodNameTransformer) {
            DynamicType placeholderType = null;
            HashMap<MethodDescription.InDefinedShape, Resolution> resolutions = new HashMap<MethodDescription.InDefinedShape, Resolution>();
            for (MethodDescription.InDefinedShape instrumentedMethod : instrumentedType.getDeclaredMethods()) {
                Resolution resolution;
                if (!rebaseables.contains(instrumentedMethod.asSignatureToken())) continue;
                if (instrumentedMethod.isConstructor()) {
                    if (placeholderType == null) {
                        placeholderType = TrivialType.SIGNATURE_RELEVANT.make(auxiliaryTypeNamingStrategy.name(instrumentedType, TrivialType.SIGNATURE_RELEVANT), classFileVersion, MethodAccessorFactory.Illegal.INSTANCE);
                    }
                    resolution = Resolution.ForRebasedConstructor.of(instrumentedMethod, placeholderType.getTypeDescription());
                } else {
                    resolution = Resolution.ForRebasedMethod.of(instrumentedType, instrumentedMethod, methodNameTransformer);
                }
                resolutions.put(instrumentedMethod, resolution);
            }
            if (placeholderType == null) {
                return new Default(resolutions, Collections.<DynamicType>emptyList());
            }
            return new Default(resolutions, Collections.singletonList(placeholderType));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution resolve(MethodDescription.InDefinedShape methodDescription) {
            void var2_2;
            Resolution resolution = this.resolutions.get(methodDescription);
            if (resolution == null) {
                void var1_1;
                return new Resolution.Preserved((MethodDescription.InDefinedShape)var1_1);
            }
            return var2_2;
        }

        @Override
        public List<DynamicType> getAuxiliaryTypes() {
            return this.dynamicTypes;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<MethodDescription.SignatureToken, Resolution> asTokenMap() {
            void var1_1;
            HashMap tokenMap = new HashMap();
            for (Map.Entry<MethodDescription.InDefinedShape, Resolution> entry : this.resolutions.entrySet()) {
                void var3_3;
                tokenMap.put(entry.getKey().asSignatureToken(), var3_3.getValue());
            }
            return var1_1;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!((Object)this.resolutions).equals(((Default)object).resolutions)) {
                return false;
            }
            return ((Object)this.dynamicTypes).equals(((Default)object).dynamicTypes);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + ((Object)this.resolutions).hashCode()) * 31 + ((Object)this.dynamicTypes).hashCode();
        }
    }

    public static interface Resolution {
        public boolean isRebased();

        public MethodDescription.InDefinedShape getResolvedMethod();

        public TypeList getAppendedParameters();

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForRebasedConstructor
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;
            private final TypeDescription placeholderType;

            /*
             * WARNING - void declaration
             */
            protected ForRebasedConstructor(MethodDescription.InDefinedShape methodDescription, TypeDescription placeholderType) {
                void var2_2;
                void var1_1;
                this.methodDescription = var1_1;
                this.placeholderType = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public static Resolution of(MethodDescription.InDefinedShape methodDescription, TypeDescription placeholderType) {
                void var1_1;
                MethodDescription.InDefinedShape inDefinedShape;
                return new ForRebasedConstructor(new RebasedConstructor(inDefinedShape, placeholderType), (TypeDescription)var1_1);
            }

            public boolean isRebased() {
                return true;
            }

            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            public TypeList getAppendedParameters() {
                return new TypeList.Explicit(this.placeholderType);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.methodDescription.equals(((ForRebasedConstructor)object).methodDescription)) {
                    return false;
                }
                return this.placeholderType.equals(((ForRebasedConstructor)object).placeholderType);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.methodDescription.hashCode()) * 31 + this.placeholderType.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class RebasedConstructor
            extends MethodDescription.InDefinedShape.AbstractBase {
                private final MethodDescription.InDefinedShape methodDescription;
                private final TypeDescription placeholderType;

                /*
                 * WARNING - void declaration
                 */
                protected RebasedConstructor(MethodDescription.InDefinedShape methodDescription, TypeDescription placeholderType) {
                    void var2_2;
                    void var1_1;
                    this.methodDescription = var1_1;
                    this.placeholderType = var2_2;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Void.TYPE);
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    RebasedConstructor rebasedConstructor = this;
                    return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)rebasedConstructor, CompoundList.of(rebasedConstructor.methodDescription.getParameters().asTypeList().asErasures(), this.placeholderType));
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return this.methodDescription.getExceptionTypes().asRawTypes();
                }

                @Override
                @AlwaysNull
                public AnnotationValue<?, ?> getDefaultValue() {
                    return AnnotationValue.UNDEFINED;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.methodDescription.getDeclaringType();
                }

                @Override
                public int getModifiers() {
                    return 4098;
                }

                @Override
                public String getInternalName() {
                    return "<init>";
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForRebasedMethod
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            /*
             * WARNING - void declaration
             */
            protected ForRebasedMethod(MethodDescription.InDefinedShape methodDescription) {
                void var1_1;
                this.methodDescription = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public static Resolution of(TypeDescription instrumentedType, MethodDescription.InDefinedShape methodDescription, MethodNameTransformer methodNameTransformer) {
                void var2_2;
                void var1_1;
                TypeDescription typeDescription;
                return new ForRebasedMethod(new RebasedMethod(typeDescription, (MethodDescription.InDefinedShape)var1_1, (MethodNameTransformer)var2_2));
            }

            public boolean isRebased() {
                return true;
            }

            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            public TypeList getAppendedParameters() {
                return new TypeList.Empty();
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.methodDescription.equals(((ForRebasedMethod)object).methodDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.methodDescription.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class RebasedMethod
            extends MethodDescription.InDefinedShape.AbstractBase {
                private final TypeDescription instrumentedType;
                private final MethodDescription.InDefinedShape methodDescription;
                private final MethodNameTransformer methodNameTransformer;

                /*
                 * WARNING - void declaration
                 */
                protected RebasedMethod(TypeDescription instrumentedType, MethodDescription.InDefinedShape methodDescription, MethodNameTransformer methodNameTransformer) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.instrumentedType = var1_1;
                    this.methodDescription = var2_2;
                    this.methodNameTransformer = var3_3;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return this.methodDescription.getReturnType().asRawType();
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    RebasedMethod rebasedMethod = this;
                    return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)rebasedMethod, rebasedMethod.methodDescription.getParameters().asTypeList().asRawTypes());
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return this.methodDescription.getExceptionTypes().asRawTypes();
                }

                @Override
                @AlwaysNull
                public AnnotationValue<?, ?> getDefaultValue() {
                    return AnnotationValue.UNDEFINED;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.methodDescription.getDeclaringType();
                }

                @Override
                public int getModifiers() {
                    return 0x1000 | (this.methodDescription.isStatic() ? 8 : 0) | (this.methodDescription.isNative() ? 272 : 0) | (this.instrumentedType.isInterface() && !this.methodDescription.isNative() ? 1 : 2);
                }

                @Override
                public String getInternalName() {
                    return this.methodNameTransformer.transform(this.methodDescription);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Preserved
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            /*
             * WARNING - void declaration
             */
            public Preserved(MethodDescription.InDefinedShape methodDescription) {
                void var1_1;
                this.methodDescription = var1_1;
            }

            public boolean isRebased() {
                return false;
            }

            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            public TypeList getAppendedParameters() {
                throw new IllegalStateException("Cannot process additional parameters for non-rebased method: " + this.methodDescription);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.methodDescription.equals(((Preserved)object).methodDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.methodDescription.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Disabled implements MethodRebaseResolver
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final Resolution resolve(MethodDescription.InDefinedShape methodDescription) {
            void var1_1;
            return new Resolution.Preserved((MethodDescription.InDefinedShape)var1_1);
        }

        @Override
        public final List<DynamicType> getAuxiliaryTypes() {
            return Collections.emptyList();
        }

        @Override
        public final Map<MethodDescription.SignatureToken, Resolution> asTokenMap() {
            return Collections.emptyMap();
        }
    }
}

