/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.utility.RandomString;
import net.bytebuddy.utility.nullability.MaybeNull;

public interface MethodNameTransformer {
    public String transform(MethodDescription var1);

    @HashCodeAndEqualsPlugin.Enhance
    public static class Prefixing
    implements MethodNameTransformer {
        private static final String DEFAULT_PREFIX = "original";
        private final String prefix;

        public Prefixing() {
            this(DEFAULT_PREFIX);
        }

        /*
         * WARNING - void declaration
         */
        public Prefixing(String prefix) {
            void var1_1;
            this.prefix = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public String transform(MethodDescription methodDescription) {
            void var1_1;
            return this.prefix + var1_1.getInternalName();
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.prefix.equals(((Prefixing)object).prefix);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.prefix.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class Suffixing
    implements MethodNameTransformer {
        private static final String DEFAULT_SUFFIX = "original$";
        private final String suffix;

        public static MethodNameTransformer withRandomSuffix() {
            return new Suffixing(DEFAULT_SUFFIX + RandomString.make());
        }

        /*
         * WARNING - void declaration
         */
        public Suffixing(String suffix) {
            void var1_1;
            this.suffix = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public String transform(MethodDescription methodDescription) {
            void var1_1;
            return var1_1.getInternalName() + "$" + this.suffix;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.suffix.equals(((Suffixing)object).suffix);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.suffix.hashCode();
        }
    }
}

