/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.FilterableList;
import net.bytebuddy.utility.nullability.MaybeNull;

public interface MethodGraph {
    public Node locate(MethodDescription.SignatureToken var1);

    public NodeList listNodes();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Simple
    implements MethodGraph {
        private final LinkedHashMap<MethodDescription.SignatureToken, Node> nodes;

        /*
         * WARNING - void declaration
         */
        public Simple(LinkedHashMap<MethodDescription.SignatureToken, Node> nodes) {
            void var1_1;
            this.nodes = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static MethodGraph of(List<? extends MethodDescription> methodDescriptions) {
            void var1_1;
            Iterator<? extends MethodDescription> iterator;
            LinkedHashMap<MethodDescription.SignatureToken, Node.Simple> nodes = new LinkedHashMap<MethodDescription.SignatureToken, Node.Simple>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                MethodDescription methodDescription = (MethodDescription)iterator.next();
                nodes.put(methodDescription.asSignatureToken(), new Node.Simple((MethodDescription)var2_2));
            }
            return new Simple((LinkedHashMap<MethodDescription.SignatureToken, Node>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Node locate(MethodDescription.SignatureToken token) {
            void var1_1;
            Node node = this.nodes.get(token);
            if (node == null) {
                return Node.Unresolved.INSTANCE;
            }
            return var1_1;
        }

        @Override
        public NodeList listNodes() {
            return new NodeList(new ArrayList<Node>(this.nodes.values()));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.nodes.equals(((Simple)object).nodes);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.nodes.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeList
    extends FilterableList.AbstractBase<Node, NodeList> {
        private final List<? extends Node> nodes;

        /*
         * WARNING - void declaration
         */
        public NodeList(List<? extends Node> nodes) {
            void var1_1;
            this.nodes = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Node get(int index) {
            void var1_1;
            return this.nodes.get((int)var1_1);
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected NodeList wrap(List<Node> values) {
            void var1_1;
            return new NodeList((List<? extends Node>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public MethodList<?> asMethodList() {
            void var1_1;
            ArrayList<MethodDescription> methodDescriptions = new ArrayList<MethodDescription>(this.size());
            for (Node node : this.nodes) {
                methodDescriptions.add(node.getRepresentative());
            }
            return new MethodList.Explicit(var1_1);
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied.")
    public static interface Compiler {
        public static final Compiler DEFAULT = Default.forJavaHierarchy();

        public Linked compile(TypeDefinition var1);

        @Deprecated
        public Linked compile(TypeDescription var1);

        public Linked compile(TypeDefinition var1, TypeDescription var2);

        @Deprecated
        public Linked compile(TypeDescription var1, TypeDescription var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Default<T>
        extends AbstractBase {
            private final Harmonizer<T> harmonizer;
            private final Merger merger;
            private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;
            private final ElementMatcher<? super MethodDescription> matcher;

            /*
             * WARNING - void declaration
             */
            protected Default(Harmonizer<T> harmonizer, Merger merger, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
                this((Harmonizer<T>)var1_1, (Merger)var2_2, (TypeDescription.Generic.Visitor<TypeDescription.Generic>)((TypeDescription.Generic.Visitor<? extends TypeDescription.Generic>)var3_3), ElementMatchers.any());
                void var3_3;
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Default(Harmonizer<T> harmonizer, Merger merger, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor, ElementMatcher<? super MethodDescription> matcher) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.harmonizer = var1_1;
                this.merger = var2_2;
                this.visitor = var3_3;
                this.matcher = matcher;
            }

            /*
             * WARNING - void declaration
             */
            public static <S> Compiler of(Harmonizer<S> harmonizer, Merger merger) {
                void var1_1;
                Harmonizer<S> harmonizer2;
                return new Default<S>(harmonizer2, (Merger)var1_1, TypeDescription.Generic.Visitor.Reifying.INITIATING);
            }

            /*
             * WARNING - void declaration
             */
            public static <S> Compiler of(Harmonizer<S> harmonizer, Merger merger, ElementMatcher<? super MethodDescription> matcher) {
                void var2_2;
                void var1_1;
                Harmonizer<S> harmonizer2;
                return new Default<S>(harmonizer2, (Merger)var1_1, TypeDescription.Generic.Visitor.Reifying.INITIATING, (ElementMatcher<? super MethodDescription>)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public static <S> Compiler of(Harmonizer<S> harmonizer, Merger merger, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
                void var2_2;
                void var1_1;
                Harmonizer<S> harmonizer2;
                return new Default<S>(harmonizer2, (Merger)var1_1, (TypeDescription.Generic.Visitor<? extends TypeDescription.Generic>)var2_2);
            }

            public static Compiler forJavaHierarchy() {
                return Default.of(Harmonizer.ForJavaMethod.INSTANCE, Merger.Directional.LEFT);
            }

            public static Compiler forJVMHierarchy() {
                return Default.of(Harmonizer.ForJVMMethod.INSTANCE, Merger.Directional.LEFT);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
                void var1_1;
                void var2_2;
                Key.Store store;
                HashMap<TypeDefinition, Key.Store<T>> snapshots = new HashMap<TypeDefinition, Key.Store<T>>();
                Key.Store<T> rootStore = this.doAnalyze(typeDefinition, snapshots, ElementMatchers.isVirtual().and(ElementMatchers.isVisibleTo(viewPoint)).and(this.matcher));
                TypeDescription.Generic superClass = typeDefinition.getSuperClass();
                Object interfaceTypes = typeDefinition.getInterfaces();
                HashMap<TypeDescription, MethodGraph> interfaceGraphs = new HashMap<TypeDescription, MethodGraph>();
                interfaceTypes = interfaceTypes.iterator();
                while (interfaceTypes.hasNext()) {
                    TypeDescription.Generic interfaceType = (TypeDescription.Generic)interfaceTypes.next();
                    Key.Store store2 = (Key.Store)snapshots.get(interfaceType);
                    if (store2 == null) {
                        throw new IllegalStateException("Failed to resolve interface type " + interfaceType + " from " + snapshots.keySet());
                    }
                    interfaceGraphs.put(interfaceType.asErasure(), store2.asGraph(this.merger));
                }
                if (superClass == null) {
                    store = null;
                } else {
                    store = (Key.Store)snapshots.get(superClass);
                    if (store == null) {
                        void var3_3;
                        throw new IllegalStateException("Failed to resolve super class " + superClass + " from " + var3_3.keySet());
                    }
                }
                return new Linked.Delegation(var2_2.asGraph(this.merger), store == null ? Empty.INSTANCE : var1_1.asGraph(this.merger), interfaceGraphs);
            }

            /*
             * WARNING - void declaration
             */
            protected Key.Store<T> analyze(TypeDefinition typeDefinition, TypeDefinition key, Map<TypeDefinition, Key.Store<T>> snapshots, ElementMatcher<? super MethodDescription> relevanceMatcher) {
                Key.Store<T> store = snapshots.get(key);
                if (store == null) {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    store = this.doAnalyze((TypeDefinition)var1_1, snapshots, relevanceMatcher);
                    var3_3.put(var2_2, store);
                }
                return store;
            }

            /*
             * WARNING - void declaration
             */
            protected Key.Store<T> analyzeNullable(@MaybeNull TypeDescription.Generic typeDescription, Map<TypeDefinition, Key.Store<T>> snapshots, ElementMatcher<? super MethodDescription> relevanceMatcher) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (typeDescription == null) {
                    return new Key.Store();
                }
                return this.analyze(typeDescription.accept(this.visitor), (TypeDefinition)var1_1, (Map<TypeDefinition, Key.Store<T>>)var2_2, (ElementMatcher<? super MethodDescription>)((ElementMatcher<MethodDescription>)var3_3));
            }

            /*
             * WARNING - void declaration
             */
            protected Key.Store<T> doAnalyze(TypeDefinition typeDefinition, Map<TypeDefinition, Key.Store<T>> snapshots, ElementMatcher<? super MethodDescription> relevanceMatcher) {
                void var3_3;
                void var1_1;
                Key.Store<T> store = this.analyzeNullable(typeDefinition.getSuperClass(), snapshots, relevanceMatcher);
                Key.Store<T> interfaceStore = new Key.Store<T>();
                for (TypeDescription.Generic interfaceType : typeDefinition.getInterfaces()) {
                    interfaceStore = interfaceStore.combineWith(this.analyze(interfaceType.accept(this.visitor), interfaceType, snapshots, relevanceMatcher));
                }
                return store.inject(interfaceStore).registerTopLevel((List<MethodDescription>)var1_1.getDeclaredMethods().filter((ElementMatcher<?>)var3_3), this.harmonizer);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.harmonizer.equals(((Default)object).harmonizer)) {
                    return false;
                }
                if (!this.merger.equals(((Default)object).merger)) {
                    return false;
                }
                if (!this.visitor.equals(((Default)object).visitor)) {
                    return false;
                }
                return this.matcher.equals(((Default)object).matcher);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.harmonizer.hashCode()) * 31 + this.merger.hashCode()) * 31 + this.visitor.hashCode()) * 31 + this.matcher.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static abstract class Key<S> {
                protected final String internalName;
                protected final int parameterCount;

                /*
                 * WARNING - void declaration
                 */
                protected Key(String internalName, int parameterCount) {
                    void var2_2;
                    void var1_1;
                    this.internalName = var1_1;
                    this.parameterCount = var2_2;
                }

                protected abstract Set<S> getIdentifiers();

                public int hashCode() {
                    return this.internalName.hashCode() + 31 * this.parameterCount;
                }

                /*
                 * WARNING - void declaration
                 */
                public boolean equals(@MaybeNull Object other) {
                    void var1_1;
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Key)) {
                        return false;
                    }
                    Key key = (Key)other;
                    return this.internalName.equals(key.internalName) && this.parameterCount == key.parameterCount && !Collections.disjoint(this.getIdentifiers(), var1_1.getIdentifiers());
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class Store<V> {
                    private final LinkedHashMap<Harmonized<V>, Entry<V>> entries;

                    protected Store() {
                        this(new LinkedHashMap<Harmonized<V>, Entry<V>>());
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private Store(LinkedHashMap<Harmonized<V>, Entry<V>> entries) {
                        void var1_1;
                        this.entries = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static <W> Entry<W> combine(Entry<W> left, Entry<W> right) {
                        void var2_2;
                        void var1_1;
                        Entry<W> entry;
                        Object leftMethods = left.getCandidates();
                        Set<MethodDescription> rightMethods = right.getCandidates();
                        LinkedHashSet<MethodDescription> combined = new LinkedHashSet<MethodDescription>();
                        combined.addAll((Collection<MethodDescription>)leftMethods);
                        combined.addAll(rightMethods);
                        leftMethods = leftMethods.iterator();
                        block0: while (leftMethods.hasNext()) {
                            MethodDescription rightMethod;
                            TypeDescription rightType;
                            MethodDescription leftMethod = (MethodDescription)leftMethods.next();
                            TypeDescription leftType = leftMethod.getDeclaringType().asErasure();
                            Iterator<MethodDescription> iterator = rightMethods.iterator();
                            while (iterator.hasNext() && !leftType.equals(rightType = (rightMethod = iterator.next()).getDeclaringType().asErasure())) {
                                if (leftType.isAssignableTo(rightType)) {
                                    combined.remove(rightMethod);
                                    continue block0;
                                }
                                if (!leftType.isAssignableFrom(rightType)) continue;
                                combined.remove(leftMethod);
                                continue block0;
                            }
                        }
                        Harmonized<W> key = left.getKey().combineWith(right.getKey());
                        Visibility visibility = entry.getVisibility().expandTo(var1_1.getVisibility());
                        if (combined.size() == 1) {
                            return new Entry.Resolved<W>(key, (MethodDescription)combined.iterator().next(), visibility, false);
                        }
                        return new Entry.Ambiguous(var2_2, combined, visibility);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Store<V> registerTopLevel(List<? extends MethodDescription> methodDescriptions, Harmonizer<V> harmonizer) {
                        void var3_3;
                        Iterator iterator;
                        if (methodDescriptions.isEmpty()) {
                            return this;
                        }
                        LinkedHashMap<Harmonized<Entry<V>>, Entry<Entry<V>>> entries = new LinkedHashMap<Harmonized<Entry<V>>, Entry<Entry<V>>>(this.entries);
                        iterator = iterator.iterator();
                        while (iterator.hasNext()) {
                            MethodDescription methodDescription = (MethodDescription)iterator.next();
                            Harmonized<V> key = Harmonized.of(methodDescription, harmonizer);
                            Entry<Object> currentEntry = (Entry<Object>)entries.remove(key);
                            Entry<V> extendedEntry = (currentEntry == null ? new Entry.Initial<V>(key) : currentEntry).extendBy(methodDescription, harmonizer);
                            entries.put(extendedEntry.getKey(), extendedEntry);
                        }
                        return new Store<V>(var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Store<V> combineWith(Store<V> store) {
                        void var2_2;
                        Iterator<Entry<V>> iterator;
                        if (this.entries.isEmpty()) {
                            return store;
                        }
                        if (store.entries.isEmpty()) {
                            return this;
                        }
                        LinkedHashMap<Harmonized<void>, Entry<void>> entries = new LinkedHashMap<Harmonized<void>, Entry<void>>(this.entries);
                        for (Entry<V> entry : ((Store)((Object)iterator)).entries.values()) {
                            void var3_3;
                            Entry previousEntry = (Entry)entries.remove(entry.getKey());
                            Entry<V> injectedEntry = previousEntry == null ? entry : Store.combine(previousEntry, entry);
                            entries.put((Harmonized<void>)injectedEntry.getKey(), (Entry<void>)var3_3);
                        }
                        return new Store<V>(var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Store<V> inject(Store<V> store) {
                        void var2_2;
                        Iterator<Entry<V>> iterator;
                        if (this.entries.isEmpty()) {
                            return store;
                        }
                        if (store.entries.isEmpty()) {
                            return this;
                        }
                        LinkedHashMap<Harmonized<void>, Entry<void>> entries = new LinkedHashMap<Harmonized<void>, Entry<void>>(this.entries);
                        for (Entry<V> entry : ((Store)((Object)iterator)).entries.values()) {
                            void var3_3;
                            Entry previous = (Entry)entries.remove(entry.getKey());
                            Entry<V> injectedEntry = previous == null ? entry : previous.inject(entry);
                            entries.put((Harmonized<void>)injectedEntry.getKey(), (Entry<void>)var3_3);
                        }
                        return new Store<V>(var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected MethodGraph asGraph(Merger merger) {
                        void var2_2;
                        LinkedHashMap<Detached, Node> entries = new LinkedHashMap<Detached, Node>();
                        for (Entry<V> entry : this.entries.values()) {
                            Node node = entry.asNode(merger);
                            entries.put(entry.getKey().detach(node.getRepresentative().asTypeToken()), node);
                        }
                        return new Graph((LinkedHashMap<Key<MethodDescription.TypeToken>, Node>)var2_2);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.entries.equals(((Store)object).entries);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.entries.hashCode();
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    @HashCodeAndEqualsPlugin.Enhance
                    protected static class Graph
                    implements MethodGraph {
                        private final LinkedHashMap<Key<MethodDescription.TypeToken>, Node> entries;

                        /*
                         * WARNING - void declaration
                         */
                        protected Graph(LinkedHashMap<Key<MethodDescription.TypeToken>, Node> entries) {
                            void var1_1;
                            this.entries = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public Node locate(MethodDescription.SignatureToken token) {
                            void var1_1;
                            Node node = this.entries.get(Detached.of(token));
                            if (node == null) {
                                return Node.Unresolved.INSTANCE;
                            }
                            return var1_1;
                        }

                        @Override
                        public NodeList listNodes() {
                            return new NodeList(new ArrayList<Node>(this.entries.values()));
                        }

                        public boolean equals(@MaybeNull Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            return this.entries.equals(((Graph)object).entries);
                        }

                        public int hashCode() {
                            return this.getClass().hashCode() * 31 + this.entries.hashCode();
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static interface Entry<W> {
                        public Harmonized<W> getKey();

                        public Set<MethodDescription> getCandidates();

                        public Visibility getVisibility();

                        public Entry<W> extendBy(MethodDescription var1, Harmonizer<W> var2);

                        public Entry<W> inject(Entry<W> var1);

                        public Node asNode(Merger var1);

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        @HashCodeAndEqualsPlugin.Enhance
                        public static class Ambiguous<U>
                        implements Entry<U> {
                            private final Harmonized<U> key;
                            private final LinkedHashSet<MethodDescription> methodDescriptions;
                            private final Visibility visibility;

                            /*
                             * WARNING - void declaration
                             */
                            protected Ambiguous(Harmonized<U> key, LinkedHashSet<MethodDescription> methodDescriptions, Visibility visibility) {
                                void var3_3;
                                void var2_2;
                                void var1_1;
                                this.key = var1_1;
                                this.methodDescriptions = var2_2;
                                this.visibility = var3_3;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            protected static <Q> Entry<Q> of(Harmonized<Q> key, MethodDescription left, MethodDescription right, Visibility visibility) {
                                void var3_3;
                                void var2_2;
                                void var1_1;
                                Harmonized<Q> harmonized;
                                visibility = visibility.expandTo(left.getVisibility()).expandTo(right.getVisibility());
                                if (left.isBridge() ^ right.isBridge()) {
                                    return new Resolved<Q>(key, left.isBridge() ? right : left, visibility, false);
                                }
                                return new Ambiguous<Q>(harmonized, new LinkedHashSet<MethodDescription>(Arrays.asList(var1_1, var2_2)), (Visibility)var3_3);
                            }

                            @Override
                            public Harmonized<U> getKey() {
                                return this.key;
                            }

                            @Override
                            public Set<MethodDescription> getCandidates() {
                                return this.methodDescriptions;
                            }

                            @Override
                            public Visibility getVisibility() {
                                return this.visibility;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public Entry<U> extendBy(MethodDescription methodDescription, Harmonizer<U> harmonizer) {
                                void var3_3;
                                void var2_2;
                                Harmonized<U> key = this.key.extend((MethodDescription.InDefinedShape)methodDescription.asDefined(), harmonizer);
                                LinkedHashSet<MethodDescription> methodDescriptions = new LinkedHashSet<MethodDescription>();
                                TypeDescription declaringType = methodDescription.getDeclaringType().asErasure();
                                boolean bridge = methodDescription.isBridge();
                                Visibility visibility = this.visibility;
                                for (MethodDescription extendedMethod : this.methodDescriptions) {
                                    if (extendedMethod.getDeclaringType().asErasure().equals(declaringType)) {
                                        if (extendedMethod.isBridge() ^ bridge) {
                                            methodDescriptions.add(bridge ? extendedMethod : methodDescription);
                                        } else {
                                            methodDescriptions.add(methodDescription);
                                            methodDescriptions.add(extendedMethod);
                                        }
                                    }
                                    visibility = visibility.expandTo(extendedMethod.getVisibility());
                                }
                                if (methodDescriptions.isEmpty()) {
                                    void var1_1;
                                    return new Resolved<U>(key, (MethodDescription)var1_1, visibility, bridge);
                                }
                                if (methodDescriptions.size() == 1) {
                                    return new Resolved<U>(key, (MethodDescription)methodDescriptions.iterator().next(), visibility, false);
                                }
                                return new Ambiguous<U>(var2_2, (LinkedHashSet<MethodDescription>)var3_3, visibility);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public Entry<U> inject(Entry<U> entry) {
                                void var1_1;
                                void var2_2;
                                TypeDescription target;
                                LinkedHashSet<MethodDescription> methodDescriptions = new LinkedHashSet<MethodDescription>();
                                block0: for (MethodDescription methodDescription : this.methodDescriptions) {
                                    target = methodDescription.getDeclaringType().asErasure();
                                    for (MethodDescription methodDescription2 : entry.getCandidates()) {
                                        TypeDescription typeDescription = methodDescription2.getDeclaringType().asErasure();
                                        if (!typeDescription.equals(target) && typeDescription.isAssignableTo(target)) continue block0;
                                    }
                                    methodDescriptions.add(methodDescription);
                                }
                                block2: for (MethodDescription candidate : entry.getCandidates()) {
                                    target = candidate.getDeclaringType().asErasure();
                                    for (MethodDescription methodDescription2 : this.methodDescriptions) {
                                        if (methodDescription2.getDeclaringType().asErasure().isAssignableTo(target)) continue block2;
                                    }
                                    methodDescriptions.add(candidate);
                                }
                                if (methodDescriptions.size() == 1) {
                                    return new Resolved<U>(this.key.combineWith(entry.getKey()), (MethodDescription)methodDescriptions.iterator().next(), this.visibility.expandTo(entry.getVisibility()));
                                }
                                return new Ambiguous<U>(this.key.combineWith(entry.getKey()), (LinkedHashSet<MethodDescription>)var2_2, this.visibility.expandTo(var1_1.getVisibility()));
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public net.bytebuddy.dynamic.scaffold.MethodGraph$Node asNode(Merger merger) {
                                void var3_3;
                                Iterator iterator = this.methodDescriptions.iterator();
                                MethodDescription methodDescription = (MethodDescription)iterator.next();
                                while (iterator.hasNext()) {
                                    methodDescription = merger.merge(methodDescription, (MethodDescription)iterator.next());
                                }
                                return new Node(this.key.detach(methodDescription.asTypeToken()), (MethodDescription)var3_3, this.visibility);
                            }

                            public boolean equals(@MaybeNull Object object) {
                                if (this == object) {
                                    return true;
                                }
                                if (object == null) {
                                    return false;
                                }
                                if (this.getClass() != object.getClass()) {
                                    return false;
                                }
                                if (!this.visibility.equals(((Ambiguous)object).visibility)) {
                                    return false;
                                }
                                if (!this.key.equals(((Ambiguous)object).key)) {
                                    return false;
                                }
                                return this.methodDescriptions.equals(((Ambiguous)object).methodDescriptions);
                            }

                            public int hashCode() {
                                return ((this.getClass().hashCode() * 31 + this.key.hashCode()) * 31 + this.methodDescriptions.hashCode()) * 31 + this.visibility.hashCode();
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            @HashCodeAndEqualsPlugin.Enhance
                            protected static class Node
                            implements net.bytebuddy.dynamic.scaffold.MethodGraph$Node {
                                private final Detached key;
                                private final MethodDescription methodDescription;
                                private final Visibility visibility;

                                /*
                                 * WARNING - void declaration
                                 */
                                protected Node(Detached key, MethodDescription methodDescription, Visibility visibility) {
                                    void var3_3;
                                    void var2_2;
                                    void var1_1;
                                    this.key = var1_1;
                                    this.methodDescription = var2_2;
                                    this.visibility = var3_3;
                                }

                                @Override
                                public Node.Sort getSort() {
                                    return Node.Sort.AMBIGUOUS;
                                }

                                @Override
                                public MethodDescription getRepresentative() {
                                    return this.methodDescription;
                                }

                                @Override
                                public Set<MethodDescription.TypeToken> getMethodTypes() {
                                    return this.key.getIdentifiers();
                                }

                                @Override
                                public Visibility getVisibility() {
                                    return this.visibility;
                                }

                                public boolean equals(@MaybeNull Object object) {
                                    if (this == object) {
                                        return true;
                                    }
                                    if (object == null) {
                                        return false;
                                    }
                                    if (this.getClass() != object.getClass()) {
                                        return false;
                                    }
                                    if (!this.visibility.equals(((Node)object).visibility)) {
                                        return false;
                                    }
                                    if (!this.key.equals(((Node)object).key)) {
                                        return false;
                                    }
                                    return this.methodDescription.equals(((Node)object).methodDescription);
                                }

                                public int hashCode() {
                                    return ((this.getClass().hashCode() * 31 + this.key.hashCode()) * 31 + this.methodDescription.hashCode()) * 31 + this.visibility.hashCode();
                                }
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        @HashCodeAndEqualsPlugin.Enhance
                        public static class Resolved<U>
                        implements Entry<U> {
                            private static final int MADE_VISIBLE = 5;
                            private static final boolean NOT_MADE_VISIBLE = false;
                            private final Harmonized<U> key;
                            private final MethodDescription methodDescription;
                            private final Visibility visibility;
                            private final boolean madeVisible;

                            /*
                             * WARNING - void declaration
                             */
                            protected Resolved(Harmonized<U> key, MethodDescription methodDescription, Visibility visibility) {
                                this((Harmonized<U>)var1_1, (MethodDescription)var2_2, (Visibility)var3_3, false);
                                void var3_3;
                                void var2_2;
                                void var1_1;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            protected Resolved(Harmonized<U> key, MethodDescription methodDescription, Visibility visibility, boolean madeVisible) {
                                void var3_3;
                                void var2_2;
                                void var1_1;
                                this.key = var1_1;
                                this.methodDescription = var2_2;
                                this.visibility = var3_3;
                                this.madeVisible = madeVisible;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            private static <V> Entry<V> of(Harmonized<V> key, MethodDescription override, MethodDescription original, Visibility visibility) {
                                void var3_3;
                                void var1_1;
                                Harmonized<V> harmonized;
                                visibility = visibility.expandTo(original.getVisibility()).expandTo(override.getVisibility());
                                if (override.isBridge()) {
                                    void var2_2;
                                    return new Resolved<V>(key, original, visibility, (var2_2.getDeclaringType().getModifiers() & 5) == 0);
                                }
                                return new Resolved<V>(harmonized, (MethodDescription)var1_1, (Visibility)var3_3, false);
                            }

                            @Override
                            public Harmonized<U> getKey() {
                                return this.key;
                            }

                            @Override
                            public Set<MethodDescription> getCandidates() {
                                return Collections.singleton(this.methodDescription);
                            }

                            @Override
                            public Visibility getVisibility() {
                                return this.visibility;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public Entry<U> extendBy(MethodDescription methodDescription, Harmonizer<U> harmonizer) {
                                void var3_3;
                                void var1_1;
                                void var2_2;
                                Harmonized<U> key = this.key.extend((MethodDescription.InDefinedShape)methodDescription.asDefined(), harmonizer);
                                Visibility visibility = this.visibility.expandTo(methodDescription.getVisibility());
                                if (methodDescription.getDeclaringType().equals(this.methodDescription.getDeclaringType())) {
                                    return Ambiguous.of(key, methodDescription, this.methodDescription, visibility);
                                }
                                return Resolved.of(var2_2, (MethodDescription)var1_1, this.methodDescription, (Visibility)var3_3);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public Entry<U> inject(Entry<U> entry) {
                                void var1_1;
                                if (this.methodDescription.getDeclaringType().isInterface()) {
                                    void var2_2;
                                    LinkedHashSet<MethodDescription> candidates = new LinkedHashSet<MethodDescription>();
                                    candidates.add(this.methodDescription);
                                    TypeDescription target = this.methodDescription.getDeclaringType().asErasure();
                                    for (MethodDescription methodDescription : entry.getCandidates()) {
                                        if (methodDescription.getDeclaringType().asErasure().isAssignableTo(target)) {
                                            candidates.remove(this.methodDescription);
                                            candidates.add(methodDescription);
                                            continue;
                                        }
                                        if (methodDescription.getDeclaringType().asErasure().isAssignableFrom(target)) continue;
                                        candidates.add(methodDescription);
                                    }
                                    if (candidates.size() == 1) {
                                        return new Resolved<U>(this.key.combineWith(entry.getKey()), (MethodDescription)candidates.iterator().next(), this.visibility.expandTo(entry.getVisibility()), this.madeVisible);
                                    }
                                    return new Ambiguous<U>(this.key.combineWith(entry.getKey()), (LinkedHashSet<MethodDescription>)var2_2, this.visibility.expandTo(entry.getVisibility()));
                                }
                                return new Resolved<U>(this.key.combineWith(entry.getKey()), this.methodDescription, this.visibility.expandTo(var1_1.getVisibility()), this.madeVisible);
                            }

                            @Override
                            public net.bytebuddy.dynamic.scaffold.MethodGraph$Node asNode(Merger merger) {
                                return new Node(this.key.detach(this.methodDescription.asTypeToken()), this.methodDescription, this.visibility, this.madeVisible);
                            }

                            public boolean equals(@MaybeNull Object object) {
                                if (this == object) {
                                    return true;
                                }
                                if (object == null) {
                                    return false;
                                }
                                if (this.getClass() != object.getClass()) {
                                    return false;
                                }
                                if (this.madeVisible != ((Resolved)object).madeVisible) {
                                    return false;
                                }
                                if (!this.visibility.equals(((Resolved)object).visibility)) {
                                    return false;
                                }
                                if (!this.key.equals(((Resolved)object).key)) {
                                    return false;
                                }
                                return this.methodDescription.equals(((Resolved)object).methodDescription);
                            }

                            public int hashCode() {
                                return (((this.getClass().hashCode() * 31 + this.key.hashCode()) * 31 + this.methodDescription.hashCode()) * 31 + this.visibility.hashCode()) * 31 + this.madeVisible;
                            }

                            /*
                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                             */
                            @HashCodeAndEqualsPlugin.Enhance
                            protected static class Node
                            implements net.bytebuddy.dynamic.scaffold.MethodGraph$Node {
                                private final Detached key;
                                private final MethodDescription methodDescription;
                                private final Visibility visibility;
                                private final boolean visible;

                                /*
                                 * WARNING - void declaration
                                 */
                                protected Node(Detached key, MethodDescription methodDescription, Visibility visibility, boolean visible) {
                                    void var3_3;
                                    void var2_2;
                                    void var1_1;
                                    this.key = var1_1;
                                    this.methodDescription = var2_2;
                                    this.visibility = var3_3;
                                    this.visible = visible;
                                }

                                @Override
                                public Node.Sort getSort() {
                                    if (this.visible) {
                                        return Node.Sort.VISIBLE;
                                    }
                                    return Node.Sort.RESOLVED;
                                }

                                @Override
                                public MethodDescription getRepresentative() {
                                    return this.methodDescription;
                                }

                                @Override
                                public Set<MethodDescription.TypeToken> getMethodTypes() {
                                    return this.key.getIdentifiers();
                                }

                                @Override
                                public Visibility getVisibility() {
                                    return this.visibility;
                                }

                                public boolean equals(@MaybeNull Object object) {
                                    if (this == object) {
                                        return true;
                                    }
                                    if (object == null) {
                                        return false;
                                    }
                                    if (this.getClass() != object.getClass()) {
                                        return false;
                                    }
                                    if (this.visible != ((Node)object).visible) {
                                        return false;
                                    }
                                    if (!this.visibility.equals(((Node)object).visibility)) {
                                        return false;
                                    }
                                    if (!this.key.equals(((Node)object).key)) {
                                        return false;
                                    }
                                    return this.methodDescription.equals(((Node)object).methodDescription);
                                }

                                public int hashCode() {
                                    return (((this.getClass().hashCode() * 31 + this.key.hashCode()) * 31 + this.methodDescription.hashCode()) * 31 + this.visibility.hashCode()) * 31 + this.visible;
                                }
                            }
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public static class Initial<U>
                        implements Entry<U> {
                            private final Harmonized<U> key;

                            /*
                             * WARNING - void declaration
                             */
                            protected Initial(Harmonized<U> key) {
                                void var1_1;
                                this.key = var1_1;
                            }

                            @Override
                            public Harmonized<U> getKey() {
                                throw new IllegalStateException("Cannot extract key from initial entry:" + this);
                            }

                            @Override
                            public Set<MethodDescription> getCandidates() {
                                throw new IllegalStateException("Cannot extract method from initial entry:" + this);
                            }

                            @Override
                            public Visibility getVisibility() {
                                throw new IllegalStateException("Cannot extract visibility from initial entry:" + this);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public Entry<U> extendBy(MethodDescription methodDescription, Harmonizer<U> harmonizer) {
                                void var2_2;
                                void var1_1;
                                void v0 = var1_1;
                                return new Resolved<U>(this.key.extend((MethodDescription.InDefinedShape)methodDescription.asDefined(), (Harmonizer<U>)var2_2), (MethodDescription)v0, v0.getVisibility(), false);
                            }

                            @Override
                            public Entry<U> inject(Entry<U> entry) {
                                throw new IllegalStateException("Cannot inject into initial entry without a registered method: " + this);
                            }

                            @Override
                            public Node asNode(Merger merger) {
                                throw new IllegalStateException("Cannot transform initial entry without a registered method: " + this);
                            }

                            public int hashCode() {
                                return this.key.hashCode();
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public boolean equals(@MaybeNull Object other) {
                                void var1_1;
                                if (this == other) {
                                    return true;
                                }
                                if (other == null || this.getClass() != other.getClass()) {
                                    return false;
                                }
                                Initial initial = (Initial)other;
                                return this.key.equals(var1_1.key);
                            }
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static class Detached
                extends Key<MethodDescription.TypeToken> {
                    private final Set<MethodDescription.TypeToken> identifiers;

                    /*
                     * WARNING - void declaration
                     */
                    protected Detached(String internalName, int parameterCount, Set<MethodDescription.TypeToken> identifiers) {
                        super((String)var1_1, (int)var2_2);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.identifiers = var3_3;
                    }

                    protected static Detached of(MethodDescription.SignatureToken token) {
                        MethodDescription.SignatureToken signatureToken;
                        return new Detached(token.getName(), token.getParameterTypes().size(), Collections.singleton(signatureToken.asTypeToken()));
                    }

                    @Override
                    protected Set<MethodDescription.TypeToken> getIdentifiers() {
                        return this.identifiers;
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static class Harmonized<V>
                extends Key<V> {
                    private final Map<V, Set<MethodDescription.TypeToken>> identifiers;

                    /*
                     * WARNING - void declaration
                     */
                    protected Harmonized(String internalName, int parameterCount, Map<V, Set<MethodDescription.TypeToken>> identifiers) {
                        super((String)var1_1, (int)var2_2);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.identifiers = var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected static <Q> Harmonized<Q> of(MethodDescription methodDescription, Harmonizer<Q> harmonizer) {
                        void var2_2;
                        void var1_1;
                        MethodDescription methodDescription2;
                        MethodDescription.TypeToken typeToken = methodDescription.asTypeToken();
                        return new Harmonized(methodDescription.getInternalName(), methodDescription2.getParameters().size(), Collections.singletonMap(var1_1.harmonize((MethodDescription.TypeToken)var2_2), Collections.emptySet()));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Detached detach(MethodDescription.TypeToken typeToken) {
                        void var2_2;
                        void var1_1;
                        HashSet<Object> identifiers = new HashSet<Object>();
                        for (Set<MethodDescription.TypeToken> typeTokens : this.identifiers.values()) {
                            identifiers.addAll(typeTokens);
                        }
                        identifiers.add(var1_1);
                        return new Detached(this.internalName, this.parameterCount, (Set<MethodDescription.TypeToken>)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Harmonized<V> combineWith(Harmonized<V> key) {
                        void var2_2;
                        Iterator<Map.Entry<V, Set<MethodDescription.TypeToken>>> iterator;
                        HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>> identifiers = new HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>>(this.identifiers);
                        for (Map.Entry<V, Set<MethodDescription.TypeToken>> entry : ((Harmonized)((Object)iterator)).identifiers.entrySet()) {
                            void var3_3;
                            HashSet typeTokens = (HashSet)identifiers.get(entry.getKey());
                            if (typeTokens == null) {
                                identifiers.put((Set<MethodDescription.TypeToken>)entry.getKey(), entry.getValue());
                                continue;
                            }
                            typeTokens = new HashSet(typeTokens);
                            typeTokens.addAll(entry.getValue());
                            identifiers.put((Set<MethodDescription.TypeToken>)var3_3.getKey(), typeTokens);
                        }
                        return new Harmonized<V>(this.internalName, this.parameterCount, var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Harmonized<V> extend(MethodDescription.InDefinedShape methodDescription, Harmonizer<V> harmonizer) {
                        void var3_3;
                        HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>> identifiers = new HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>>(this.identifiers);
                        MethodDescription.TypeToken typeToken = methodDescription.asTypeToken();
                        V identifier = harmonizer.harmonize(typeToken);
                        HashSet<void> typeTokens = (HashSet<void>)identifiers.get(identifier);
                        if (typeTokens == null) {
                            identifiers.put((Set<MethodDescription.TypeToken>)identifier, Collections.singleton(typeToken));
                        } else {
                            void var2_2;
                            void var1_1;
                            typeTokens = new HashSet<void>(typeTokens);
                            typeTokens.add(var1_1);
                            identifiers.put((Set<MethodDescription.TypeToken>)var2_2, (Set<MethodDescription.TypeToken>)typeTokens);
                        }
                        return new Harmonized<V>(this.internalName, this.parameterCount, var3_3);
                    }

                    @Override
                    protected Set<V> getIdentifiers() {
                        return this.identifiers.keySet();
                    }
                }
            }

            public static interface Merger {
                public MethodDescription merge(MethodDescription var1, MethodDescription var2);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum Directional implements Merger
                {
                    LEFT(true),
                    RIGHT(false);

                    private final boolean left;

                    /*
                     * WARNING - void declaration
                     */
                    private Directional(boolean left) {
                        void var3_3;
                        this.left = var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final MethodDescription merge(MethodDescription left, MethodDescription right) {
                        void var2_2;
                        if (this.left) {
                            void var1_1;
                            return var1_1;
                        }
                        return var2_2;
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Harmonizer<S> {
                public S harmonize(MethodDescription.TypeToken var1);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForJVMMethod implements Harmonizer<Token>
                {
                    INSTANCE;


                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Token harmonize(MethodDescription.TypeToken typeToken) {
                        void var1_1;
                        return new Token((MethodDescription.TypeToken)var1_1);
                    }

                    protected static class Token {
                        private final MethodDescription.TypeToken typeToken;
                        private final int hashCode;

                        /*
                         * WARNING - void declaration
                         */
                        public Token(MethodDescription.TypeToken typeToken) {
                            void var1_1;
                            this.typeToken = typeToken;
                            this.hashCode = typeToken.getReturnType().hashCode() + 31 * var1_1.getParameterTypes().hashCode();
                        }

                        public int hashCode() {
                            return this.hashCode;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public boolean equals(@MaybeNull Object other) {
                            void var1_1;
                            if (this == other) {
                                return true;
                            }
                            if (!(other instanceof Token)) {
                                return false;
                            }
                            Token token = (Token)other;
                            return this.typeToken.getReturnType().equals(token.typeToken.getReturnType()) && this.typeToken.getParameterTypes().equals(var1_1.typeToken.getParameterTypes());
                        }

                        public String toString() {
                            return this.typeToken.toString();
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForJavaMethod implements Harmonizer<Token>
                {
                    INSTANCE;


                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Token harmonize(MethodDescription.TypeToken typeToken) {
                        void var1_1;
                        return new Token((MethodDescription.TypeToken)var1_1);
                    }

                    protected static class Token {
                        private final MethodDescription.TypeToken typeToken;
                        private final int hashCode;

                        /*
                         * WARNING - void declaration
                         */
                        protected Token(MethodDescription.TypeToken typeToken) {
                            void var1_1;
                            this.typeToken = typeToken;
                            this.hashCode = var1_1.getParameterTypes().hashCode();
                        }

                        public int hashCode() {
                            return this.hashCode;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public boolean equals(@MaybeNull Object other) {
                            void var1_1;
                            return this == other || other instanceof Token && this.typeToken.getParameterTypes().equals(((Token)var1_1).typeToken.getParameterTypes());
                        }

                        public String toString() {
                            return this.typeToken.getParameterTypes().toString();
                        }
                    }
                }
            }
        }

        public static abstract class AbstractBase
        implements Compiler {
            /*
             * WARNING - void declaration
             */
            public Linked compile(TypeDefinition typeDefinition) {
                void var1_1;
                void v0 = var1_1;
                return this.compile((TypeDefinition)v0, v0.asErasure());
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated
            public Linked compile(TypeDescription typeDescription) {
                void var1_1;
                void v0 = var1_1;
                return this.compile((TypeDefinition)v0, (TypeDescription)v0);
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated
            public Linked compile(TypeDescription typeDefinition, TypeDescription viewPoint) {
                void var2_2;
                void var1_1;
                return this.compile((TypeDefinition)var1_1, (TypeDescription)var2_2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForDeclaredMethods implements Compiler
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            public final Linked compile(TypeDefinition typeDefinition) {
                void var1_1;
                void v0 = var1_1;
                return this.compile((TypeDefinition)v0, v0.asErasure());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Deprecated
            public final Linked compile(TypeDescription typeDescription) {
                void var1_1;
                void v0 = var1_1;
                return this.compile((TypeDefinition)v0, (TypeDescription)v0);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
                void var3_3;
                Iterator iterator;
                LinkedHashMap<MethodDescription.SignatureToken, Node.Simple> nodes = new LinkedHashMap<MethodDescription.SignatureToken, Node.Simple>();
                for (MethodDescription methodDescription : (MethodList)iterator.getDeclaredMethods().filter(ElementMatchers.isVirtual().and(ElementMatchers.not(ElementMatchers.isBridge())).and(ElementMatchers.isVisibleTo(viewPoint)))) {
                    void var2_2;
                    nodes.put(methodDescription.asSignatureToken(), new Node.Simple((MethodDescription)var2_2));
                }
                return new Linked.Delegation(new Simple((LinkedHashMap<MethodDescription.SignatureToken, Node>)var3_3), Empty.INSTANCE, Collections.<TypeDescription, MethodGraph>emptyMap());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Deprecated
            public final Linked compile(TypeDescription typeDefinition, TypeDescription viewPoint) {
                void var2_2;
                void var1_1;
                return this.compile((TypeDefinition)var1_1, (TypeDescription)var2_2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Node {
        public Sort getSort();

        public MethodDescription getRepresentative();

        public Set<MethodDescription.TypeToken> getMethodTypes();

        public Visibility getVisibility();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Simple
        implements Node {
            private final MethodDescription methodDescription;

            /*
             * WARNING - void declaration
             */
            public Simple(MethodDescription methodDescription) {
                void var1_1;
                this.methodDescription = var1_1;
            }

            @Override
            public Sort getSort() {
                return Sort.RESOLVED;
            }

            @Override
            public MethodDescription getRepresentative() {
                return this.methodDescription;
            }

            @Override
            public Set<MethodDescription.TypeToken> getMethodTypes() {
                return Collections.emptySet();
            }

            @Override
            public Visibility getVisibility() {
                return this.methodDescription.getVisibility();
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.methodDescription.equals(((Simple)object).methodDescription);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.methodDescription.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Unresolved implements Node
        {
            INSTANCE;


            @Override
            public final Sort getSort() {
                return Sort.UNRESOLVED;
            }

            @Override
            public final MethodDescription getRepresentative() {
                throw new IllegalStateException("Cannot resolve the method of an illegal node");
            }

            @Override
            public final Set<MethodDescription.TypeToken> getMethodTypes() {
                throw new IllegalStateException("Cannot resolve bridge method of an illegal node");
            }

            @Override
            public final Visibility getVisibility() {
                throw new IllegalStateException("Cannot resolve visibility of an illegal node");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Sort {
            VISIBLE(true, true, true),
            RESOLVED(true, true, false),
            AMBIGUOUS(true, false, false),
            UNRESOLVED(false, false, false);

            private final boolean resolved;
            private final boolean unique;
            private final boolean madeVisible;

            /*
             * WARNING - void declaration
             */
            private Sort(boolean resolved, boolean unique, boolean madeVisible) {
                void var3_3;
                this.resolved = var3_3;
                this.unique = unique;
                this.madeVisible = madeVisible;
            }

            public final boolean isResolved() {
                return this.resolved;
            }

            public final boolean isUnique() {
                return this.unique;
            }

            public final boolean isMadeVisible() {
                return this.madeVisible;
            }
        }
    }

    public static interface Linked
    extends MethodGraph {
        public MethodGraph getSuperClassGraph();

        public MethodGraph getInterfaceGraph(TypeDescription var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Delegation
        implements Linked {
            private final MethodGraph methodGraph;
            private final MethodGraph superClassGraph;
            private final Map<TypeDescription, MethodGraph> interfaceGraphs;

            /*
             * WARNING - void declaration
             */
            public Delegation(MethodGraph methodGraph, MethodGraph superClassGraph, Map<TypeDescription, MethodGraph> interfaceGraphs) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.methodGraph = var1_1;
                this.superClassGraph = var2_2;
                this.interfaceGraphs = var3_3;
            }

            @Override
            public MethodGraph getSuperClassGraph() {
                return this.superClassGraph;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public MethodGraph getInterfaceGraph(TypeDescription typeDescription) {
                void var1_1;
                MethodGraph interfaceGraph = this.interfaceGraphs.get(typeDescription);
                if (interfaceGraph == null) {
                    return Empty.INSTANCE;
                }
                return var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Node locate(MethodDescription.SignatureToken token) {
                void var1_1;
                return this.methodGraph.locate((MethodDescription.SignatureToken)var1_1);
            }

            @Override
            public NodeList listNodes() {
                return this.methodGraph.listNodes();
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.methodGraph.equals(((Delegation)object).methodGraph)) {
                    return false;
                }
                if (!this.superClassGraph.equals(((Delegation)object).superClassGraph)) {
                    return false;
                }
                return ((Object)this.interfaceGraphs).equals(((Delegation)object).interfaceGraphs);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.methodGraph.hashCode()) * 31 + this.superClassGraph.hashCode()) * 31 + ((Object)this.interfaceGraphs).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Empty implements Compiler,
    Linked
    {
        INSTANCE;


        @Override
        public final Node locate(MethodDescription.SignatureToken token) {
            return Node.Unresolved.INSTANCE;
        }

        @Override
        public final NodeList listNodes() {
            return new NodeList(Collections.emptyList());
        }

        @Override
        public final MethodGraph getSuperClassGraph() {
            return this;
        }

        @Override
        public final MethodGraph getInterfaceGraph(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public final Linked compile(TypeDefinition typeDefinition) {
            return this;
        }

        @Override
        @Deprecated
        public final Linked compile(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public final Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
            return this;
        }

        @Override
        @Deprecated
        public final Linked compile(TypeDescription typeDefinition, TypeDescription viewPoint) {
            return this;
        }
    }
}

