/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.InjectionClassLoader;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.nullability.UnknownNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleParentClassLoader
extends InjectionClassLoader {
    private final List<? extends ClassLoader> parents;

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Must be invoked from targeting class loader type.")
    private static void doRegisterAsParallelCapable() {
        try {
            void var0;
            Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
            method.setAccessible(true);
            var0.invoke(null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public MultipleParentClassLoader(List<? extends ClassLoader> parents) {
        this(ClassLoadingStrategy.BOOTSTRAP_LOADER, (List<? extends ClassLoader>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MultipleParentClassLoader(@MaybeNull ClassLoader parent, List<? extends ClassLoader> parents) {
        this((ClassLoader)var1_1, (List<? extends ClassLoader>)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MultipleParentClassLoader(@MaybeNull ClassLoader parent, List<? extends ClassLoader> parents, boolean sealed) {
        super((ClassLoader)var1_1, (boolean)var3_3);
        void var2_2;
        void var3_3;
        void var1_1;
        this.parents = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        void var2_2;
        void var1_1;
        for (ClassLoader classLoader : this.parents) {
            try {
                Class<?> clazz = classLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.loadClass((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URL getResource(String name) {
        void var1_1;
        for (ClassLoader classLoader : this.parents) {
            URL classLoader2 = classLoader.getResource(name);
            if (classLoader2 == null) continue;
            return classLoader2;
        }
        return super.getResource((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        void var2_2;
        void var1_1;
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>(this.parents.size() + 1);
        for (ClassLoader classLoader : this.parents) {
            enumerations.add(classLoader.getResources(name));
        }
        enumerations.add(super.getResources((String)var1_1));
        return new CompoundEnumeration((List<Enumeration<URL>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Map<String, Class<?>> doDefineClasses(Map<String, byte[]> typeDefinitions) {
        void var2_2;
        Iterator iterator;
        HashMap types = new HashMap();
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            types.put(entry.getKey(), this.defineClass((String)entry.getKey(), (byte[])entry.getValue(), 0, ((byte[])var3_3.getValue()).length));
        }
        return var2_2;
    }

    static {
        MultipleParentClassLoader.doRegisterAsParallelCapable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Builder {
        private final boolean sealed;
        private final List<? extends ClassLoader> classLoaders;

        public Builder() {
            this(true);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(boolean sealed) {
            this(Collections.emptyList(), (boolean)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Builder(List<? extends ClassLoader> classLoaders, boolean sealed) {
            void var2_2;
            void var1_1;
            this.classLoaders = var1_1;
            this.sealed = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Builder append(Class<?> ... type) {
            void var1_1;
            return this.append(Arrays.asList(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public Builder append(Collection<? extends Class<?>> types) {
            void var2_2;
            Iterator iterator;
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(types.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Class type = (Class)iterator.next();
                classLoaders.add(var3_3.getClassLoader());
            }
            return this.append((List<? extends ClassLoader>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Builder append(ClassLoader ... classLoader) {
            void var1_1;
            return this.append(Arrays.asList(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public Builder append(List<? extends ClassLoader> classLoaders) {
            void var2_2;
            Iterator iterator;
            ArrayList<? extends ClassLoader> filtered = new ArrayList<ClassLoader>(this.classLoaders.size() + classLoaders.size());
            filtered.addAll(this.classLoaders);
            HashSet<? extends ClassLoader> registered = new HashSet<ClassLoader>(this.classLoaders);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ClassLoader classLoader = (ClassLoader)iterator.next();
                if (classLoader == null || !registered.add(classLoader)) continue;
                filtered.add(classLoader);
            }
            return new Builder((List<? extends ClassLoader>)var2_2, this.sealed);
        }

        /*
         * WARNING - void declaration
         */
        public Builder appendMostSpecific(Class<?> ... type) {
            void var1_1;
            return this.appendMostSpecific(Arrays.asList(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public Builder appendMostSpecific(Collection<? extends Class<?>> types) {
            void var2_2;
            Iterator iterator;
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(types.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Class type = (Class)iterator.next();
                classLoaders.add(var3_3.getClassLoader());
            }
            return this.appendMostSpecific((List<? extends ClassLoader>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Builder appendMostSpecific(ClassLoader ... classLoader) {
            void var1_1;
            return this.appendMostSpecific(Arrays.asList(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public Builder appendMostSpecific(List<? extends ClassLoader> classLoaders) {
            void var2_2;
            Iterator iterator;
            ArrayList<Object> filtered = new ArrayList<Object>(this.classLoaders.size() + classLoaders.size());
            filtered.addAll(this.classLoaders);
            iterator = iterator.iterator();
            block0: while (iterator.hasNext()) {
                void var3_3;
                ClassLoader classLoader = (ClassLoader)iterator.next();
                if (classLoader == null) continue;
                ClassLoader candidate = classLoader;
                do {
                    Iterator iterator2 = filtered.iterator();
                    while (iterator2.hasNext()) {
                        ClassLoader classLoader2 = (ClassLoader)iterator2.next();
                        if (!classLoader2.equals(candidate)) continue;
                        iterator2.remove();
                    }
                } while ((candidate = candidate.getParent()) != null);
                block3: for (ClassLoader classLoader3 : filtered) {
                    void var6_9;
                    while (!var6_9.equals(classLoader)) {
                        ClassLoader classLoader4 = var6_9.getParent();
                        if (classLoader4 != null) continue;
                        continue block3;
                    }
                    continue block0;
                }
                filtered.add(var3_3);
            }
            return new Builder((List<? extends ClassLoader>)var2_2, this.sealed);
        }

        /*
         * WARNING - void declaration
         */
        public Builder filter(ElementMatcher<? super ClassLoader> matcher) {
            void var2_2;
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(this.classLoaders.size());
            for (ClassLoader classLoader : this.classLoaders) {
                if (!matcher.matches(classLoader)) continue;
                classLoaders.add(classLoader);
            }
            return new Builder((List<? extends ClassLoader>)var2_2, this.sealed);
        }

        public ClassLoader build() {
            if (this.classLoaders.size() == 1) {
                return this.classLoaders.get(0);
            }
            return this.doBuild(ClassLoadingStrategy.BOOTSTRAP_LOADER);
        }

        /*
         * WARNING - void declaration
         */
        public ClassLoader build(ClassLoader parent) {
            void var1_1;
            if (this.classLoaders.isEmpty() || this.classLoaders.size() == 1 && this.classLoaders.contains(parent)) {
                return parent;
            }
            return this.filter(ElementMatchers.not(ElementMatchers.is(parent))).doBuild((ClassLoader)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Assuring privilege is explicit user responsibility.")
        private ClassLoader doBuild(@MaybeNull ClassLoader parent) {
            void var1_1;
            return new MultipleParentClassLoader((ClassLoader)var1_1, this.classLoaders, this.sealed);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.sealed != ((Builder)object).sealed) {
                return false;
            }
            return ((Object)this.classLoaders).equals(((Builder)object).classLoaders);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.sealed) * 31 + ((Object)this.classLoaders).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CompoundEnumeration
    implements Enumeration<URL> {
        private static final int FIRST = 0;
        private final List<Enumeration<URL>> enumerations;
        @UnknownNull
        private Enumeration<URL> current;

        /*
         * WARNING - void declaration
         */
        protected CompoundEnumeration(List<Enumeration<URL>> enumerations) {
            void var1_1;
            this.enumerations = var1_1;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.current != null && this.current.hasMoreElements()) {
                return true;
            }
            if (!this.enumerations.isEmpty()) {
                this.current = this.enumerations.remove(0);
                return this.hasMoreElements();
            }
            return false;
        }

        @Override
        @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Null reference is avoided by element check.")
        public URL nextElement() {
            if (this.hasMoreElements()) {
                return this.current.nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

