/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectionClassLoader
extends ClassLoader {
    private final AtomicBoolean sealed;

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Must be invoked from targeting class loader type.")
    private static void doRegisterAsParallelCapable() {
        try {
            void var0;
            Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
            method.setAccessible(true);
            var0.invoke(null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected InjectionClassLoader(@MaybeNull ClassLoader parent, boolean sealed) {
        super((ClassLoader)var1_1);
        void var2_2;
        void var1_1;
        this.sealed = new AtomicBoolean((boolean)var2_2);
    }

    public boolean isSealed() {
        return this.sealed.get();
    }

    public boolean seal() {
        return !this.sealed.getAndSet(true);
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> defineClass(String name, byte[] binaryRepresentation) throws ClassNotFoundException {
        void var1_1;
        void var2_2;
        return this.defineClasses(Collections.singletonMap(name, var2_2)).get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Class<?>> defineClasses(Map<String, byte[]> typeDefinitions) throws ClassNotFoundException {
        void var1_1;
        if (this.sealed.get()) {
            throw new IllegalStateException("Cannot inject classes into a sealed class loader");
        }
        return this.doDefineClasses((Map<String, byte[]>)var1_1);
    }

    protected abstract Map<String, Class<?>> doDefineClasses(Map<String, byte[]> var1) throws ClassNotFoundException;

    static {
        InjectionClassLoader.doRegisterAsParallelCapable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy implements ClassLoadingStrategy<InjectionClassLoader>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<TypeDescription, Class<?>> load(@MaybeNull InjectionClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot add types to bootstrap class loader: " + types);
            }
            LinkedHashMap typeDefinitions = new LinkedHashMap();
            HashMap typeDescriptions = new HashMap();
            for (Map.Entry entry : types.entrySet()) {
                typeDefinitions.put(((TypeDescription)entry.getKey()).getName(), entry.getValue());
                typeDescriptions.put(((TypeDescription)entry.getKey()).getName(), entry.getKey());
            }
            HashMap loadedTypes = new HashMap();
            try {
                void var3_5;
                for (Map.Entry<String, Class<?>> entry : classLoader.defineClasses((Map<String, byte[]>)var3_5).entrySet()) {
                    void var1_3;
                    loadedTypes.put((TypeDescription)typeDescriptions.get(entry.getKey()), (Class<?>)var1_3.getValue());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                void var2_4;
                throw new IllegalStateException("Cannot load classes: " + var2_4, classNotFoundException);
            }
            return loadedTypes;
        }
    }
}

