/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ClassReloadingStrategy
implements ClassLoadingStrategy<ClassLoader> {
    protected static final Dispatcher DISPATCHER;
    private final Instrumentation instrumentation;
    private final Strategy strategy;
    private final BootstrapInjection bootstrapInjection;
    private final Map<String, Class<?>> preregisteredTypes;
    private static final boolean ACCESS_CONTROLLER;

    /*
     * WARNING - void declaration
     */
    public ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy) {
        this((Instrumentation)var1_1, (Strategy)var2_2, BootstrapInjection.Disabled.INSTANCE, Collections.emptyMap());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy, BootstrapInjection bootstrapInjection, Map<String, Class<?>> preregisteredTypes) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.instrumentation = instrumentation;
        this.strategy = var2_2.validate((Instrumentation)var1_1);
        this.bootstrapInjection = var3_3;
        this.preregisteredTypes = preregisteredTypes;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return privilegedAction.run();
    }

    public static ClassReloadingStrategy of(Instrumentation instrumentation) {
        Instrumentation instrumentation2;
        if (DISPATCHER.isRetransformClassesSupported(instrumentation)) {
            return new ClassReloadingStrategy(instrumentation, Strategy.RETRANSFORMATION);
        }
        if (instrumentation.isRedefineClassesSupported()) {
            return new ClassReloadingStrategy(instrumentation, Strategy.REDEFINITION);
        }
        throw new IllegalArgumentException("Instrumentation does not support reloading of classes: " + instrumentation2);
    }

    /*
     * WARNING - void declaration
     */
    private static Instrumentation resolveByteBuddyAgentInstrumentation() {
        try {
            Class<?> installer = ClassLoader.getSystemClassLoader().loadClass("net.bytebuddy.agent.Installer");
            JavaModule source = JavaModule.ofType(AgentBuilder.class);
            JavaModule target = JavaModule.ofType(installer);
            if (source != null && !source.canRead(target)) {
                void var2_4;
                void var1_3;
                void var3_5;
                Class<?> module = Class.forName("java.lang.Module");
                module.getMethod("addReads", new Class[]{var3_5}).invoke(var1_3.unwrap(), var2_4.unwrap());
            }
            return (Instrumentation)installer.getMethod("getInstrumentation", new Class[0]).invoke(null, new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException installer = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            void var0_2;
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", (Throwable)var0_2);
        }
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        return ClassReloadingStrategy.of(ClassReloadingStrategy.resolveByteBuddyAgentInstrumentation());
    }

    public static ClassReloadingStrategy fromInstalledAgent(Strategy strategy) {
        Strategy strategy2;
        return new ClassReloadingStrategy(ClassReloadingStrategy.resolveByteBuddyAgentInstrumentation(), strategy2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap availableTypes = new HashMap(this.preregisteredTypes);
        for (Class type : this.instrumentation.getInitiatedClasses(classLoader)) {
            availableTypes.put(TypeDescription.ForLoadedType.getName(type), type);
        }
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap();
        HashMap loadedClasses = new HashMap();
        LinkedHashMap unloadedClasses = new LinkedHashMap();
        for (Map.Entry entry : types.entrySet()) {
            void var2_4;
            Class type = (Class)availableTypes.get(((TypeDescription)entry.getKey()).getName());
            if (type != null) {
                classDefinitions.put(type, new ClassDefinition(type, (byte[])entry.getValue()));
                loadedClasses.put((TypeDescription)entry.getKey(), type);
                continue;
            }
            unloadedClasses.put(entry.getKey(), var2_4.getValue());
        }
        try {
            this.strategy.apply(this.instrumentation, classDefinitions);
            if (!unloadedClasses.isEmpty()) {
                void var1_1;
                loadedClasses.putAll((classLoader == null ? this.bootstrapInjection.make(this.instrumentation) : new ClassInjector.UsingReflection((ClassLoader)var1_1)).inject(unloadedClasses));
            }
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Could not locate classes for redefinition", exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot redefine specified class", exception);
        }
        return loadedClasses;
    }

    /*
     * WARNING - void declaration
     */
    public ClassReloadingStrategy reset(Class<?> ... type) throws IOException {
        void var1_1;
        if (type.length == 0) {
            return this;
        }
        return this.reset(ClassFileLocator.ForClassLoader.of(type[0].getClassLoader()), (Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassReloadingStrategy reset(ClassFileLocator classFileLocator, Class<?> ... type) throws IOException {
        if (type.length > 0) {
            try {
                this.strategy.reset(this.instrumentation, classFileLocator, Arrays.asList(type));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException("Cannot locate types " + Arrays.toString(type), exception);
            }
            catch (UnmodifiableClassException exception) {
                void var1_3;
                void var2_4;
                throw new IllegalStateException("Cannot reset types " + Arrays.toString((Object[])var2_4), (Throwable)var1_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ClassReloadingStrategy enableBootstrapInjection(File folder) {
        void var1_1;
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, new BootstrapInjection.Enabled((File)var1_1), this.preregisteredTypes);
    }

    /*
     * WARNING - void declaration
     */
    public ClassReloadingStrategy preregistered(Class<?> ... type) {
        void var2_2;
        void var1_1;
        HashMap preregisteredTypes = new HashMap(this.preregisteredTypes);
        for (void aType : var1_1) {
            preregisteredTypes.put(TypeDescription.ForLoadedType.getName(aType), (Class<?>)aType);
        }
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, this.bootstrapInjection, (Map<String, Class<?>>)var2_2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        DISPATCHER = ClassReloadingStrategy.doPrivileged(JavaDispatcher.of(Dispatcher.class));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.strategy.equals((Object)((ClassReloadingStrategy)object).strategy)) {
            return false;
        }
        if (!this.instrumentation.equals(((ClassReloadingStrategy)object).instrumentation)) {
            return false;
        }
        if (!this.bootstrapInjection.equals(((ClassReloadingStrategy)object).bootstrapInjection)) {
            return false;
        }
        return ((Object)this.preregisteredTypes).equals(((ClassReloadingStrategy)object).preregisteredTypes);
    }

    public int hashCode() {
        return (((this.getClass().hashCode() * 31 + this.instrumentation.hashCode()) * 31 + this.strategy.hashCode()) * 31 + this.bootstrapInjection.hashCode()) * 31 + ((Object)this.preregisteredTypes).hashCode();
    }

    protected static interface BootstrapInjection {
        public ClassInjector make(Instrumentation var1);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Enabled
        implements BootstrapInjection {
            private final File folder;

            /*
             * WARNING - void declaration
             */
            protected Enabled(File folder) {
                void var1_1;
                this.folder = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ClassInjector make(Instrumentation instrumentation) {
                void var1_1;
                return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, (Instrumentation)var1_1);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.folder.equals(((Enabled)object).folder);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.folder.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Disabled implements BootstrapInjection
        {
            INSTANCE;


            @Override
            public final ClassInjector make(Instrumentation instrumentation) {
                throw new IllegalStateException("Bootstrap injection is not enabled");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        REDEFINITION(true){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException, ClassNotFoundException {
                void var2_2;
                instrumentation.redefineClasses(var2_2.values().toArray(new ClassDefinition[0]));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final Strategy validate(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    void var1_1;
                    throw new IllegalArgumentException("Does not support redefinition: " + var1_1);
                }
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws IOException, UnmodifiableClassException, ClassNotFoundException {
                void var1_1;
                Iterator iterator;
                HashMap classDefinitions = new HashMap(types.size());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Class type = (Class)iterator.next();
                    classDefinitions.put(type, new ClassDefinition(type, classFileLocator.locate(TypeDescription.ForLoadedType.getName(type)).resolve()));
                }
                this.apply((Instrumentation)var1_1, classDefinitions);
            }
        }
        ,
        RETRANSFORMATION(false){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException {
                void var3_5;
                ClassRedefinitionTransformer classRedefinitionTransformer = new ClassRedefinitionTransformer(classDefinitions);
                2 var4_6 = this;
                synchronized (var4_6) {
                    DISPATCHER.addTransformer(instrumentation, classRedefinitionTransformer, true);
                    try {
                        void var2_3;
                        DISPATCHER.retransformClasses(instrumentation, var2_3.keySet().toArray(new Class[0]));
                        instrumentation.removeTransformer(classRedefinitionTransformer);
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        var1_1.removeTransformer(classRedefinitionTransformer);
                        throw throwable;
                    }
                }
                var3_5.assertTransformation();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final Strategy validate(Instrumentation instrumentation) {
                if (!DISPATCHER.isRetransformClassesSupported(instrumentation)) {
                    void var1_1;
                    throw new IllegalArgumentException("Does not support retransformation: " + var1_1);
                }
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws UnmodifiableClassException, ClassNotFoundException {
                for (Class<?> type : types) {
                    if (DISPATCHER.isModifiableClass(instrumentation, type)) continue;
                    throw new IllegalArgumentException("Cannot modify type: " + type);
                }
                DISPATCHER.addTransformer(instrumentation, ClassResettingTransformer.INSTANCE, true);
                try {
                    void var3_4;
                    DISPATCHER.retransformClasses(instrumentation, var3_4.toArray(new Class[0]));
                    instrumentation.removeTransformer(ClassResettingTransformer.INSTANCE);
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.removeTransformer(ClassResettingTransformer.INSTANCE);
                    throw throwable;
                }
            }
        };

        @AlwaysNull
        private static final byte[] NO_REDEFINITION;
        private static final boolean REDEFINE_CLASSES = true;
        private final boolean redefinition;

        /*
         * WARNING - void declaration
         */
        private Strategy(boolean redefinition) {
            void var3_3;
            this.redefinition = var3_3;
        }

        protected abstract void apply(Instrumentation var1, Map<Class<?>, ClassDefinition> var2) throws UnmodifiableClassException, ClassNotFoundException;

        protected abstract Strategy validate(Instrumentation var1);

        public boolean isRedefinition() {
            return this.redefinition;
        }

        public abstract void reset(Instrumentation var1, ClassFileLocator var2, List<Class<?>> var3) throws IOException, UnmodifiableClassException, ClassNotFoundException;

        static {
            NO_REDEFINITION = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum ClassResettingTransformer implements ClassFileTransformer
        {
            INSTANCE;


            @Override
            @MaybeNull
            public final byte[] transform(@MaybeNull ClassLoader classLoader, @MaybeNull String internalTypeName, @MaybeNull Class<?> classBeingRedefined, @MaybeNull ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                return NO_REDEFINITION;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class ClassRedefinitionTransformer
        implements ClassFileTransformer {
            private final Map<Class<?>, ClassDefinition> redefinedClasses;

            /*
             * WARNING - void declaration
             */
            protected ClassRedefinitionTransformer(Map<Class<?>, ClassDefinition> redefinedClasses) {
                void var1_1;
                this.redefinedClasses = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @MaybeNull
            public byte[] transform(@MaybeNull ClassLoader classLoader, @MaybeNull String internalTypeName, @MaybeNull Class<?> classBeingRedefined, @MaybeNull ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                void var1_1;
                void var3_3;
                if (internalTypeName == null) {
                    return NO_REDEFINITION;
                }
                ClassDefinition redefinedClass = this.redefinedClasses.remove(var3_3);
                if (redefinedClass == null) {
                    return NO_REDEFINITION;
                }
                return var1_1.getDefinitionClassFile();
            }

            public void assertTransformation() {
                if (!this.redefinedClasses.isEmpty()) {
                    throw new IllegalStateException("Could not transform: " + this.redefinedClasses.keySet());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JavaDispatcher.Proxied(value="java.lang.instrument.Instrumentation")
    protected static interface Dispatcher {
        @JavaDispatcher.Proxied(value="isModifiableClass")
        public boolean isModifiableClass(Instrumentation var1, Class<?> var2);

        @JavaDispatcher.Proxied(value="isRetransformClassesSupported")
        public boolean isRetransformClassesSupported(Instrumentation var1);

        @JavaDispatcher.Proxied(value="addTransformer")
        public void addTransformer(Instrumentation var1, ClassFileTransformer var2, boolean var3);

        @JavaDispatcher.Proxied(value="retransformClasses")
        public void retransformClasses(Instrumentation var1, Class<?>[] var2) throws UnmodifiableClassException;
    }
}

