/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ClassLoadingStrategy<T extends ClassLoader> {
    @AlwaysNull
    public static final ClassLoader BOOTSTRAP_LOADER = null;
    @AlwaysNull
    public static final ProtectionDomain NO_PROTECTION_DOMAIN = null;

    public Map<TypeDescription, Class<?>> load(@MaybeNull T var1, Map<TypeDescription, byte[]> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForJnaInjection
    implements ClassLoadingStrategy<ClassLoader> {
        @MaybeNull
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ProtectionDomain protectionDomain;

        public ForJnaInjection() {
            this(NO_PROTECTION_DOMAIN);
        }

        /*
         * WARNING - void declaration
         */
        public ForJnaInjection(@MaybeNull ProtectionDomain protectionDomain) {
            void var1_1;
            this.protectionDomain = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            void var2_2;
            void var1_1;
            return new ClassInjector.UsingUnsafe((ClassLoader)var1_1, this.protectionDomain).inject((Map<? extends TypeDescription, byte[]>)var2_2);
        }

        public boolean equals(@MaybeNull Object object) {
            block10: {
                block9: {
                    ProtectionDomain protectionDomain;
                    block8: {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        object = ((ForJnaInjection)object).protectionDomain;
                        protectionDomain = this.protectionDomain;
                        if (object == null) break block8;
                        if (protectionDomain == null) break block9;
                        if (!protectionDomain.equals(object)) {
                            return false;
                        }
                        break block10;
                    }
                    if (protectionDomain == null) break block10;
                }
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = this.getClass().hashCode() * 31;
            ProtectionDomain protectionDomain = this.protectionDomain;
            if (protectionDomain != null) {
                n = n + protectionDomain.hashCode();
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForUnsafeInjection
    implements ClassLoadingStrategy<ClassLoader> {
        @MaybeNull
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ProtectionDomain protectionDomain;

        public ForUnsafeInjection() {
            this(NO_PROTECTION_DOMAIN);
        }

        /*
         * WARNING - void declaration
         */
        public ForUnsafeInjection(@MaybeNull ProtectionDomain protectionDomain) {
            void var1_1;
            this.protectionDomain = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            void var2_2;
            void var1_1;
            return new ClassInjector.UsingUnsafe((ClassLoader)var1_1, this.protectionDomain).inject((Map<? extends TypeDescription, byte[]>)var2_2);
        }

        public boolean equals(@MaybeNull Object object) {
            block10: {
                block9: {
                    ProtectionDomain protectionDomain;
                    block8: {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        object = ((ForUnsafeInjection)object).protectionDomain;
                        protectionDomain = this.protectionDomain;
                        if (object == null) break block8;
                        if (protectionDomain == null) break block9;
                        if (!protectionDomain.equals(object)) {
                            return false;
                        }
                        break block10;
                    }
                    if (protectionDomain == null) break block10;
                }
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = this.getClass().hashCode() * 31;
            ProtectionDomain protectionDomain = this.protectionDomain;
            if (protectionDomain != null) {
                n = n + protectionDomain.hashCode();
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForBootstrapInjection
    implements ClassLoadingStrategy<ClassLoader> {
        private final Instrumentation instrumentation;
        private final File folder;

        /*
         * WARNING - void declaration
         */
        public ForBootstrapInjection(Instrumentation instrumentation, File folder) {
            void var2_2;
            void var1_1;
            this.instrumentation = var1_1;
            this.folder = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            void var2_2;
            ClassInjector.UsingReflection usingReflection;
            usingReflection = classLoader == null ? ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation) : new ClassInjector.UsingReflection((ClassLoader)((Object)usingReflection));
            return usingReflection.inject((Map<? extends TypeDescription, byte[]>)var2_2);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.instrumentation.equals(((ForBootstrapInjection)object).instrumentation)) {
                return false;
            }
            return this.folder.equals(((ForBootstrapInjection)object).folder);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.instrumentation.hashCode()) * 31 + this.folder.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingLookup
    implements ClassLoadingStrategy<ClassLoader> {
        private final ClassInjector classInjector;

        /*
         * WARNING - void declaration
         */
        protected UsingLookup(ClassInjector classInjector) {
            void var1_1;
            this.classInjector = var1_1;
        }

        public static ClassLoadingStrategy<ClassLoader> of(Object lookup) {
            Object object;
            return new UsingLookup(ClassInjector.UsingLookup.of(object));
        }

        public static ClassLoadingStrategy<ClassLoader> withFallback(Callable<?> lookup) {
            return UsingLookup.withFallback(lookup, false);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassLoadingStrategy<ClassLoader> withFallback(Callable<?> lookup, boolean wrapper) {
            void var1_2;
            if (ClassInjector.UsingLookup.isAvailable()) {
                try {
                    return UsingLookup.of(lookup.call());
                }
                catch (Exception exception) {
                    void var0_1;
                    throw new IllegalStateException((Throwable)var0_1);
                }
            }
            if (ClassInjector.UsingUnsafe.isAvailable()) {
                return new ForUnsafeInjection();
            }
            if (var1_2 != false) {
                return Default.WRAPPER;
            }
            throw new IllegalStateException("Neither lookup or unsafe class injection is available");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            void var2_2;
            return this.classInjector.inject((Map<? extends TypeDescription, byte[]>)var2_2);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.classInjector.equals(((UsingLookup)object).classInjector);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.classInjector.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Configurable<S extends ClassLoader>
    extends ClassLoadingStrategy<S> {
        public Configurable<S> with(ProtectionDomain var1);

        public Configurable<S> with(PackageDefinitionStrategy var1);

        public Configurable<S> allowExistingTypes();

        public Configurable<S> opened();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Default implements Configurable<ClassLoader>
    {
        WRAPPER(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, false)),
        WRAPPER_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, false)),
        CHILD_FIRST(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, true)),
        CHILD_FIRST_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, true)),
        INJECTION(new InjectionDispatcher());

        private static final boolean DEFAULT_FORBID_EXISTING = true;
        private final Configurable<ClassLoader> dispatcher;

        /*
         * WARNING - void declaration
         */
        private Default(Configurable<ClassLoader> dispatcher) {
            void var3_3;
            this.dispatcher = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            void var2_2;
            void var1_1;
            return this.dispatcher.load(var1_1, (Map<TypeDescription, byte[]>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
            void var1_1;
            return this.dispatcher.with((ProtectionDomain)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
            void var1_1;
            return this.dispatcher.with((PackageDefinitionStrategy)var1_1);
        }

        @Override
        public final Configurable<ClassLoader> allowExistingTypes() {
            return this.dispatcher.allowExistingTypes();
        }

        @Override
        public final Configurable<ClassLoader> opened() {
            return this.dispatcher.opened();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class WrappingDispatcher
        implements Configurable<ClassLoader> {
            private static final boolean CHILD_FIRST = true;
            private static final boolean PARENT_FIRST = false;
            @MaybeNull
            @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
            private final ProtectionDomain protectionDomain;
            private final ByteArrayClassLoader.PersistenceHandler persistenceHandler;
            private final PackageDefinitionStrategy packageDefinitionStrategy;
            private final boolean childFirst;
            private final boolean forbidExisting;
            private final boolean sealed;

            /*
             * WARNING - void declaration
             */
            protected WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst) {
                this(NO_PROTECTION_DOMAIN, PackageDefinitionStrategy.Trivial.INSTANCE, (ByteArrayClassLoader.PersistenceHandler)var1_1, (boolean)var2_2, true, true);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private WrappingDispatcher(@MaybeNull ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst, boolean forbidExisting, boolean sealed) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.protectionDomain = var1_1;
                this.packageDefinitionStrategy = var2_2;
                this.persistenceHandler = var3_3;
                this.childFirst = childFirst;
                this.forbidExisting = forbidExisting;
                this.sealed = sealed;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                void var2_2;
                void var1_1;
                if (this.childFirst) {
                    return ByteArrayClassLoader.ChildFirst.load(classLoader, types, this.protectionDomain, this.persistenceHandler, this.packageDefinitionStrategy, this.forbidExisting, this.sealed);
                }
                return ByteArrayClassLoader.load((ClassLoader)var1_1, (Map<TypeDescription, byte[]>)var2_2, this.protectionDomain, this.persistenceHandler, this.packageDefinitionStrategy, this.forbidExisting, this.sealed);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
                void var1_1;
                return new WrappingDispatcher((ProtectionDomain)var1_1, this.packageDefinitionStrategy, this.persistenceHandler, this.childFirst, this.forbidExisting, this.sealed);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
                void var1_1;
                return new WrappingDispatcher(this.protectionDomain, (PackageDefinitionStrategy)var1_1, this.persistenceHandler, this.childFirst, this.forbidExisting, this.sealed);
            }

            @Override
            public Configurable<ClassLoader> allowExistingTypes() {
                return new WrappingDispatcher(this.protectionDomain, this.packageDefinitionStrategy, this.persistenceHandler, this.childFirst, false, this.sealed);
            }

            @Override
            public Configurable<ClassLoader> opened() {
                return new WrappingDispatcher(this.protectionDomain, this.packageDefinitionStrategy, this.persistenceHandler, this.childFirst, this.forbidExisting, false);
            }

            public boolean equals(@MaybeNull Object object) {
                block14: {
                    block13: {
                        ProtectionDomain protectionDomain;
                        block12: {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            if (this.childFirst != ((WrappingDispatcher)object).childFirst) {
                                return false;
                            }
                            if (this.forbidExisting != ((WrappingDispatcher)object).forbidExisting) {
                                return false;
                            }
                            if (this.sealed != ((WrappingDispatcher)object).sealed) {
                                return false;
                            }
                            if (!this.persistenceHandler.equals((Object)((WrappingDispatcher)object).persistenceHandler)) {
                                return false;
                            }
                            ProtectionDomain protectionDomain2 = ((WrappingDispatcher)object).protectionDomain;
                            protectionDomain = this.protectionDomain;
                            if (protectionDomain2 == null) break block12;
                            if (protectionDomain == null) break block13;
                            if (!protectionDomain.equals(protectionDomain2)) {
                                return false;
                            }
                            break block14;
                        }
                        if (protectionDomain == null) break block14;
                    }
                    return false;
                }
                return this.packageDefinitionStrategy.equals(((WrappingDispatcher)object).packageDefinitionStrategy);
            }

            public int hashCode() {
                int n = this.getClass().hashCode() * 31;
                ProtectionDomain protectionDomain = this.protectionDomain;
                if (protectionDomain != null) {
                    n = n + protectionDomain.hashCode();
                }
                return ((((n * 31 + this.persistenceHandler.hashCode()) * 31 + this.packageDefinitionStrategy.hashCode()) * 31 + this.childFirst) * 31 + this.forbidExisting) * 31 + this.sealed;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class InjectionDispatcher
        implements Configurable<ClassLoader> {
            @MaybeNull
            @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
            private final ProtectionDomain protectionDomain;
            private final PackageDefinitionStrategy packageDefinitionStrategy;
            private final boolean forbidExisting;

            protected InjectionDispatcher() {
                this(NO_PROTECTION_DOMAIN, PackageDefinitionStrategy.NoOp.INSTANCE, true);
            }

            /*
             * WARNING - void declaration
             */
            private InjectionDispatcher(@MaybeNull ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.protectionDomain = var1_1;
                this.packageDefinitionStrategy = var2_2;
                this.forbidExisting = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                void var2_2;
                void var1_1;
                if (classLoader == null) {
                    throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
                }
                return new ClassInjector.UsingReflection((ClassLoader)var1_1, this.protectionDomain, this.packageDefinitionStrategy, this.forbidExisting).inject((Map<? extends TypeDescription, byte[]>)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
                void var1_1;
                return new InjectionDispatcher((ProtectionDomain)var1_1, this.packageDefinitionStrategy, this.forbidExisting);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
                void var1_1;
                return new InjectionDispatcher(this.protectionDomain, (PackageDefinitionStrategy)var1_1, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> allowExistingTypes() {
                return new InjectionDispatcher(this.protectionDomain, this.packageDefinitionStrategy, false);
            }

            @Override
            public Configurable<ClassLoader> opened() {
                return this;
            }

            public boolean equals(@MaybeNull Object object) {
                block11: {
                    block10: {
                        ProtectionDomain protectionDomain;
                        block9: {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            if (this.forbidExisting != ((InjectionDispatcher)object).forbidExisting) {
                                return false;
                            }
                            ProtectionDomain protectionDomain2 = ((InjectionDispatcher)object).protectionDomain;
                            protectionDomain = this.protectionDomain;
                            if (protectionDomain2 == null) break block9;
                            if (protectionDomain == null) break block10;
                            if (!protectionDomain.equals(protectionDomain2)) {
                                return false;
                            }
                            break block11;
                        }
                        if (protectionDomain == null) break block11;
                    }
                    return false;
                }
                return this.packageDefinitionStrategy.equals(((InjectionDispatcher)object).packageDefinitionStrategy);
            }

            public int hashCode() {
                int n = this.getClass().hashCode() * 31;
                ProtectionDomain protectionDomain = this.protectionDomain;
                if (protectionDomain != null) {
                    n = n + protectionDomain.hashCode();
                }
                return (n * 31 + this.packageDefinitionStrategy.hashCode()) * 31 + this.forbidExisting;
            }
        }
    }
}

