/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassFilePostProcessor;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.InjectionClassLoader;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.utility.GraalImageCode;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayClassLoader
extends InjectionClassLoader {
    public static final String URL_SCHEMA = "bytebuddy";
    private static final int FROM_BEGINNING = 0;
    @AlwaysNull
    private static final URL NO_URL;
    private static final PackageLookupStrategy PACKAGE_LOOKUP_STRATEGY;
    protected static final SynchronizationStrategy.Initializable SYNCHRONIZATION_STRATEGY;
    protected final ConcurrentMap<String, byte[]> typeDefinitions;
    protected final PersistenceHandler persistenceHandler;
    @MaybeNull
    protected final ProtectionDomain protectionDomain;
    protected final PackageDefinitionStrategy packageDefinitionStrategy;
    protected final ClassFilePostProcessor classFilePostProcessor;
    @MaybeNull
    protected final Object accessControlContext;
    private static final boolean ACCESS_CONTROLLER;

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Must be invoked from targeting class loader type.")
    private static void doRegisterAsParallelCapable() {
        try {
            void var0;
            Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
            method.setAccessible(true);
            var0.invoke(null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return privilegedAction.run();
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions) {
        this((ClassLoader)var1_1, true, (Map<String, byte[]>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions) {
        this((ClassLoader)var1_1, (boolean)var2_2, (Map<String, byte[]>)var3_3, PersistenceHandler.LATENT);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
        this((ClassLoader)var1_1, true, (Map<String, byte[]>)var2_2, (PersistenceHandler)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
        this((ClassLoader)var1_1, (boolean)var2_2, (Map<String, byte[]>)var3_3, ClassLoadingStrategy.NO_PROTECTION_DOMAIN, persistenceHandler, PackageDefinitionStrategy.Trivial.INSTANCE);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
        this((ClassLoader)var1_1, true, (Map<String, byte[]>)var2_2, (ProtectionDomain)var3_3, persistenceHandler, packageDefinitionStrategy);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
        this((ClassLoader)var1_1, (boolean)var2_2, (Map<String, byte[]>)var3_3, protectionDomain, persistenceHandler, packageDefinitionStrategy, ClassFilePostProcessor.NoOp.INSTANCE);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, ClassFilePostProcessor classFilePostProcessor) {
        this((ClassLoader)var1_1, true, (Map<String, byte[]>)var2_2, (ProtectionDomain)var3_3, persistenceHandler, packageDefinitionStrategy, classFilePostProcessor);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, ClassFilePostProcessor classFilePostProcessor) {
        super((ClassLoader)var1_1, (boolean)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.typeDefinitions = new ConcurrentHashMap<String, byte[]>((Map<String, byte[]>)var3_3);
        this.protectionDomain = protectionDomain;
        this.persistenceHandler = persistenceHandler;
        this.packageDefinitionStrategy = packageDefinitionStrategy;
        this.classFilePostProcessor = classFilePostProcessor;
        this.accessControlContext = ByteArrayClassLoader.getContext();
    }

    @MaybeNull
    @AccessControllerPlugin.Enhance
    private static Object getContext() {
        if (ACCESS_CONTROLLER) {
            return AccessController.getContext();
        }
        return null;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction, @MaybeNull Object object) {
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction, (AccessControlContext)object);
        }
        return privilegedAction.run();
    }

    private static Object methodHandle() throws Exception {
        return Class.forName("java.lang.invoke.MethodHandles").getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        void var1_1;
        return ByteArrayClassLoader.load(classLoader, (Map<TypeDescription, byte[]>)var1_1, ClassLoadingStrategy.NO_PROTECTION_DOMAIN, PersistenceHandler.LATENT, PackageDefinitionStrategy.Trivial.INSTANCE, false, true);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Assuring privilege is explicit user responsibility.")
    public static Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting, boolean sealed) {
        void var3_4;
        HashMap<String, byte[]> typesByName = new HashMap<String, byte[]>();
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            typesByName.put(entry.getKey().getName(), entry.getValue());
        }
        classLoader = new ByteArrayClassLoader(classLoader, sealed, typesByName, protectionDomain, (PersistenceHandler)var3_4, packageDefinitionStrategy, ClassFilePostProcessor.NoOp.INSTANCE);
        LinkedHashMap result = new LinkedHashMap();
        for (TypeDescription typeDescription : types.keySet()) {
            try {
                Class<?> type = Class.forName(typeDescription.getName(), false, classLoader);
                if (!GraalImageCode.getCurrent().isNativeImageExecution() && forbidExisting && type.getClassLoader() != classLoader) {
                    throw new IllegalStateException("Class already loaded: " + type);
                }
                result.put(typeDescription, type);
            }
            catch (ClassNotFoundException exception) {
                void var2_3;
                void var1_1;
                throw new IllegalStateException("Cannot load class " + var1_1, (Throwable)var2_3);
            }
        }
        return result;
    }

    @Override
    protected Map<String, Class<?>> doDefineClasses(Map<String, byte[]> typeDefinitions) throws ClassNotFoundException {
        LinkedHashMap<String, Class<?>> linkedHashMap;
        HashMap<String, byte[]> previous = new HashMap<String, byte[]>();
        Iterator<Map.Entry<String, byte[]>> iterator = typeDefinitions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            previous.put(entry.getKey(), this.typeDefinitions.putIfAbsent(entry.getKey(), entry.getValue()));
        }
        try {
            LinkedHashMap types = new LinkedHashMap();
            for (String name : typeDefinitions.keySet()) {
                Object object = SYNCHRONIZATION_STRATEGY.initialize().getClassLoadingLock(this, name);
                synchronized (object) {
                    Iterator iterator2;
                    types.put(name, this.loadClass((String)((Object)iterator2)));
                }
            }
            linkedHashMap = types;
        }
        catch (Throwable throwable) {
            Iterator iterator3;
            for (Map.Entry entry : iterator3.entrySet()) {
                if (entry.getValue() == null) {
                    this.persistenceHandler.release((String)entry.getKey(), this.typeDefinitions);
                    continue;
                }
                this.typeDefinitions.put((String)entry.getKey(), (byte[])iterator.getValue());
            }
            throw throwable;
        }
        for (Map.Entry entry : previous.entrySet()) {
            if (entry.getValue() == null) {
                this.persistenceHandler.release((String)entry.getKey(), this.typeDefinitions);
                continue;
            }
            this.typeDefinitions.put((String)entry.getKey(), (byte[])entry.getValue());
        }
        return linkedHashMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        void var2_2;
        void var1_1;
        byte[] binaryRepresentation = this.persistenceHandler.lookup(name, this.typeDefinitions);
        if (binaryRepresentation == null) {
            throw new ClassNotFoundException(name);
        }
        return (Class)ByteArrayClassLoader.doPrivileged(new ClassDefinitionAction(this, name, this.classFilePostProcessor.transform(this, (String)var1_1, this.protectionDomain, (byte[])var2_2)), this.accessControlContext);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @MaybeNull
    protected URL findResource(String name) {
        void var1_1;
        return this.persistenceHandler.url((String)var1_1, this.typeDefinitions);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Enumeration<URL> findResources(String name) {
        void var1_1;
        URL url = this.persistenceHandler.url(name, this.typeDefinitions);
        if (url == null) {
            return EmptyEnumeration.INSTANCE;
        }
        return new SingletonEnumeration((URL)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @MaybeNull
    private Package doGetPackage(String name) {
        void var1_1;
        return this.getPackage((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Package access$200(ByteArrayClassLoader x0, String x1, String x2, String x3, String x4, String x5, String x6, String x7, URL x8) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.definePackage((String)var1_1, (String)var2_2, (String)var3_3, x4, x5, x6, x7, x8);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Class access$300(ByteArrayClassLoader x0, String x1, byte[] x2, int x3, int x4, ProtectionDomain x5) throws ClassFormatError {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.defineClass((String)var1_1, (byte[])var2_2, (int)var3_3, x4, x5);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Package access$400(ByteArrayClassLoader x0, String x1) {
        void var1_1;
        return x0.doGetPackage((String)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        NO_URL = null;
        PACKAGE_LOOKUP_STRATEGY = ByteArrayClassLoader.doPrivileged(PackageLookupStrategy.CreationAction.INSTANCE);
        SYNCHRONIZATION_STRATEGY = ByteArrayClassLoader.doPrivileged(SynchronizationStrategy.CreationAction.INSTANCE);
        ByteArrayClassLoader.doRegisterAsParallelCapable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SingletonEnumeration
    implements Enumeration<URL> {
        @MaybeNull
        private URL element;

        /*
         * WARNING - void declaration
         */
        protected SingletonEnumeration(URL element) {
            void var1_1;
            this.element = var1_1;
        }

        @Override
        public boolean hasMoreElements() {
            return this.element != null;
        }

        @Override
        public URL nextElement() {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            try {
                URL uRL = this.element;
                return uRL;
            }
            finally {
                this.element = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EmptyEnumeration implements Enumeration<URL>
    {
        INSTANCE;


        @Override
        public final boolean hasMoreElements() {
            return false;
        }

        @Override
        public final URL nextElement() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChildFirst
    extends ByteArrayClassLoader {
        private static final String CLASS_FILE_SUFFIX = ".class";

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Must be invoked from targeting class loader type.")
        private static void doRegisterAsParallelCapable() {
            try {
                void var0;
                Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                method.setAccessible(true);
                var0.invoke(null, new Object[0]);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions) {
            super((ClassLoader)var1_1, (Map<String, byte[]>)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions) {
            super((ClassLoader)var1_1, (boolean)var2_2, (Map<String, byte[]>)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
            super((ClassLoader)var1_1, (Map<String, byte[]>)var2_2, (PersistenceHandler)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
            super((ClassLoader)var1_1, (boolean)var2_2, (Map<String, byte[]>)var3_3, persistenceHandler);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
            super((ClassLoader)var1_1, (Map<String, byte[]>)var2_2, (ProtectionDomain)var3_3, persistenceHandler, packageDefinitionStrategy);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
            super((ClassLoader)var1_1, (boolean)var2_2, (Map<String, byte[]>)var3_3, protectionDomain, persistenceHandler, packageDefinitionStrategy);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, ClassFilePostProcessor classFilePostProcessor) {
            super((ClassLoader)var1_1, (Map<String, byte[]>)var2_2, (ProtectionDomain)var3_3, persistenceHandler, packageDefinitionStrategy, classFilePostProcessor);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ChildFirst(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, ClassFilePostProcessor classFilePostProcessor) {
            super((ClassLoader)var1_1, (boolean)var2_2, (Map<String, byte[]>)var3_3, protectionDomain, persistenceHandler, packageDefinitionStrategy, classFilePostProcessor);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            void var1_1;
            return ChildFirst.load(classLoader, (Map<TypeDescription, byte[]>)var1_1, ClassLoadingStrategy.NO_PROTECTION_DOMAIN, PersistenceHandler.LATENT, PackageDefinitionStrategy.Trivial.INSTANCE, false, true);
        }

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Assuring privilege is explicit user responsibility.")
        public static Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting, boolean sealed) {
            void var3_4;
            HashMap<String, byte[]> typesByName = new HashMap<String, byte[]>();
            for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
                typesByName.put(entry.getKey().getName(), entry.getValue());
            }
            classLoader = new ChildFirst(classLoader, sealed, typesByName, protectionDomain, (PersistenceHandler)var3_4, packageDefinitionStrategy, ClassFilePostProcessor.NoOp.INSTANCE);
            LinkedHashMap result = new LinkedHashMap();
            for (TypeDescription typeDescription : types.keySet()) {
                try {
                    Class<?> type = Class.forName(typeDescription.getName(), false, classLoader);
                    if (!GraalImageCode.getCurrent().isNativeImageExecution() && forbidExisting && type.getClassLoader() != classLoader) {
                        throw new IllegalStateException("Class already loaded: " + type);
                    }
                    result.put(typeDescription, type);
                }
                catch (ClassNotFoundException exception) {
                    void var2_3;
                    void var1_1;
                    throw new IllegalStateException("Cannot load class " + var1_1, (Throwable)var2_3);
                }
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = SYNCHRONIZATION_STRATEGY.initialize().getClassLoadingLock(this, name);
            synchronized (object) {
                Class<?> type = this.findLoadedClass(name);
                if (type != null) {
                    return type;
                }
                try {
                    type = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(type);
                    }
                    return type;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    void var2_3;
                    void var1_1;
                    return super.loadClass((String)var1_1, (boolean)var2_3);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public URL getResource(String name) {
            void var1_1;
            URL url = this.persistenceHandler.url(name, this.typeDefinitions);
            if (url != null || this.isShadowed(name)) {
                void var2_2;
                return var2_2;
            }
            return super.getResource((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            void var1_1;
            void var2_2;
            URL url = this.persistenceHandler.url(name, this.typeDefinitions);
            if (url == null) {
                return super.getResources(name);
            }
            return new PrependingEnumeration((URL)var2_2, super.getResources((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private boolean isShadowed(String resource) {
            if (this.persistenceHandler.isManifest() || !resource.endsWith(CLASS_FILE_SUFFIX)) {
                return false;
            }
            String name = resource.replace('/', '.').substring(0, resource.length() - 6);
            Object object = SYNCHRONIZATION_STRATEGY.initialize().getClassLoadingLock(this, name);
            synchronized (object) {
                void var1_1;
                if (this.typeDefinitions.containsKey(name)) {
                    return true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_3
                Class<?> loadedClass = this.findLoadedClass(name);
                return loadedClass != null && var1_1.getClassLoader() == this;
            }
        }

        static {
            ChildFirst.doRegisterAsParallelCapable();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class PrependingEnumeration
        implements Enumeration<URL> {
            @MaybeNull
            private URL nextElement;
            private final Enumeration<URL> enumeration;

            /*
             * WARNING - void declaration
             */
            protected PrependingEnumeration(URL url, Enumeration<URL> enumeration) {
                void var2_2;
                void var1_1;
                this.nextElement = var1_1;
                this.enumeration = var2_2;
            }

            @Override
            public boolean hasMoreElements() {
                return this.nextElement != null && this.enumeration.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (this.nextElement != null && this.enumeration.hasMoreElements()) {
                    try {
                        URL uRL = this.nextElement;
                        return uRL;
                    }
                    finally {
                        this.nextElement = this.enumeration.nextElement();
                    }
                }
                throw new NoSuchElementException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PersistenceHandler {
        MANIFEST(true){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final byte[] lookup(String name, ConcurrentMap<String, byte[]> typeDefinitions) {
                void var1_1;
                return (byte[])typeDefinitions.get(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final URL url(String resourceName, ConcurrentMap<String, byte[]> typeDefinitions) {
                void var2_2;
                void var1_1;
                void var3_3;
                if (!resourceName.endsWith(PersistenceHandler.CLASS_FILE_SUFFIX)) {
                    return NO_URL;
                }
                if (resourceName.startsWith("/")) {
                    resourceName = resourceName.substring(1);
                }
                String typeName = resourceName.replace('/', '.').substring(0, resourceName.length() - 6);
                byte[] binaryRepresentation = (byte[])typeDefinitions.get(var3_3);
                if (binaryRepresentation == null) {
                    return NO_URL;
                }
                return (URL)ByteArrayClassLoader.doPrivileged(new UrlDefinitionAction((String)var1_1, (byte[])var2_2));
            }

            @Override
            protected final void release(String name, ConcurrentMap<String, byte[]> typeDefinitions) {
            }
        }
        ,
        LATENT(false){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final byte[] lookup(String name, ConcurrentMap<String, byte[]> typeDefinitions) {
                void var1_1;
                return (byte[])typeDefinitions.remove(var1_1);
            }

            @Override
            protected final URL url(String resourceName, ConcurrentMap<String, byte[]> typeDefinitions) {
                return NO_URL;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final void release(String name, ConcurrentMap<String, byte[]> typeDefinitions) {
                void var1_1;
                typeDefinitions.remove(var1_1);
            }
        };

        private static final String CLASS_FILE_SUFFIX = ".class";
        private final boolean manifest;

        /*
         * WARNING - void declaration
         */
        private PersistenceHandler(boolean manifest) {
            void var3_3;
            this.manifest = var3_3;
        }

        public boolean isManifest() {
            return this.manifest;
        }

        @MaybeNull
        protected abstract byte[] lookup(String var1, ConcurrentMap<String, byte[]> var2);

        @MaybeNull
        protected abstract URL url(String var1, ConcurrentMap<String, byte[]> var2);

        protected abstract void release(String var1, ConcurrentMap<String, byte[]> var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class UrlDefinitionAction
        implements PrivilegedAction<URL> {
            private static final Dispatcher DISPATCHER;
            private static final String ENCODING = "UTF-8";
            private static final int NO_PORT = -1;
            private static final String NO_FILE = "";
            private final String typeName;
            private final byte[] binaryRepresentation;
            private static final boolean ACCESS_CONTROLLER;

            /*
             * WARNING - void declaration
             */
            protected UrlDefinitionAction(String typeName, byte[] binaryRepresentation) {
                void var2_2;
                void var1_1;
                this.typeName = var1_1;
                this.binaryRepresentation = var2_2;
            }

            @AccessControllerPlugin.Enhance
            private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
                if (ACCESS_CONTROLLER) {
                    return AccessController.doPrivileged(privilegedAction);
                }
                return privilegedAction.run();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public URL run() {
                try {
                    void var3_5;
                    String path = URLEncoder.encode(this.typeName.replace('.', '/'), ENCODING);
                    ByteArrayUrlStreamHandler handler = new ByteArrayUrlStreamHandler(this.binaryRepresentation);
                    URL url = DISPATCHER.of(URI.create("bytebuddy://" + path), handler);
                    if (url == null) {
                        void var2_4;
                        return DISPATCHER.make(ByteArrayClassLoader.URL_SCHEMA, path, -1, NO_FILE, (URLStreamHandler)var2_4);
                    }
                    return var3_5;
                }
                catch (MalformedURLException exception) {
                    throw new IllegalStateException("Cannot create URL for " + this.typeName, exception);
                }
                catch (UnsupportedEncodingException exception) {
                    void var1_3;
                    throw new IllegalStateException("Could not find encoding: UTF-8", (Throwable)var1_3);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static {
                try {
                    Class.forName("java.security.AccessController", false, null);
                    ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ACCESS_CONTROLLER = false;
                }
                catch (SecurityException securityException) {
                    ACCESS_CONTROLLER = true;
                }
                DISPATCHER = UrlDefinitionAction.doPrivileged(JavaDispatcher.of(Dispatcher.class));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.typeName.equals(((UrlDefinitionAction)object).typeName)) {
                    return false;
                }
                return Arrays.equals(this.binaryRepresentation, ((UrlDefinitionAction)object).binaryRepresentation);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.typeName.hashCode()) * 31 + Arrays.hashCode(this.binaryRepresentation);
            }

            @JavaDispatcher.Proxied(value="java.net.URL")
            protected static interface Dispatcher {
                @JavaDispatcher.IsConstructor
                @JavaDispatcher.Proxied(value="make")
                public URL make(String var1, String var2, int var3, String var4, URLStreamHandler var5) throws MalformedURLException;

                @MaybeNull
                @JavaDispatcher.IsStatic
                @JavaDispatcher.Defaults
                @JavaDispatcher.Proxied(value="of")
                public URL of(URI var1, URLStreamHandler var2) throws MalformedURLException;
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class ByteArrayUrlStreamHandler
            extends URLStreamHandler {
                private final byte[] binaryRepresentation;

                /*
                 * WARNING - void declaration
                 */
                protected ByteArrayUrlStreamHandler(byte[] binaryRepresentation) {
                    void var1_1;
                    this.binaryRepresentation = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                protected URLConnection openConnection(URL url) {
                    void var1_1;
                    return new ByteArrayUrlConnection((URL)var1_1, new ByteArrayInputStream(this.binaryRepresentation));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return Arrays.equals(this.binaryRepresentation, ((ByteArrayUrlStreamHandler)object).binaryRepresentation);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + Arrays.hashCode(this.binaryRepresentation);
                }

                protected static class ByteArrayUrlConnection
                extends URLConnection {
                    private final InputStream inputStream;

                    /*
                     * WARNING - void declaration
                     */
                    protected ByteArrayUrlConnection(URL url, InputStream inputStream) {
                        super((URL)var1_1);
                        void var2_2;
                        void var1_1;
                        this.inputStream = var2_2;
                    }

                    public void connect() {
                        this.connected = true;
                    }

                    public InputStream getInputStream() {
                        this.connect();
                        return this.inputStream;
                    }
                }
            }
        }
    }

    protected static interface PackageLookupStrategy {
        @MaybeNull
        public Package apply(ByteArrayClassLoader var1, String var2);

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForJava9CapableVm
        implements PackageLookupStrategy {
            private final Method getDefinedPackage;

            /*
             * WARNING - void declaration
             */
            protected ForJava9CapableVm(Method getDefinedPackage) {
                void var1_1;
                this.getDefinedPackage = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public Package apply(ByteArrayClassLoader classLoader, String name) {
                try {
                    void var2_4;
                    return (Package)this.getDefinedPackage.invoke((Object)classLoader, var2_4);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException(exception);
                }
                catch (InvocationTargetException exception) {
                    void var1_3;
                    throw new IllegalStateException(var1_3.getTargetException());
                }
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.getDefinedPackage.equals(((ForJava9CapableVm)object).getDefinedPackage);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.getDefinedPackage.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForLegacyVm implements PackageLookupStrategy
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            @MaybeNull
            public final Package apply(ByteArrayClassLoader classLoader, String name) {
                void var2_2;
                return ByteArrayClassLoader.access$400(classLoader, (String)var2_2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CreationAction implements PrivilegedAction<PackageLookupStrategy>
        {
            INSTANCE;


            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
            public final PackageLookupStrategy run() {
                if (JavaModule.isSupported()) {
                    try {
                        return new ForJava9CapableVm(ClassLoader.class.getMethod("getDefinedPackage", String.class));
                    }
                    catch (Exception exception) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
                return ForLegacyVm.INSTANCE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class ClassDefinitionAction
    implements PrivilegedAction<Class<?>> {
        private final String name;
        private final byte[] binaryRepresentation;
        final /* synthetic */ ByteArrayClassLoader this$0;

        /*
         * WARNING - void declaration
         */
        protected ClassDefinitionAction(ByteArrayClassLoader this$0, String name, byte[] binaryRepresentation) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.name = var2_2;
            this.binaryRepresentation = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> run() {
            String packageName;
            PackageDefinitionStrategy.Definition definition;
            int packageIndex = this.name.lastIndexOf(46);
            if (packageIndex != -1 && (definition = this.this$0.packageDefinitionStrategy.define(this.this$0, packageName = this.name.substring(0, packageIndex), this.name)).isDefined()) {
                void var3_4;
                void var2_3;
                Package definedPackage = PACKAGE_LOOKUP_STRATEGY.apply(this.this$0, packageName);
                if (definedPackage == null) {
                    ByteArrayClassLoader.access$200(this.this$0, packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                } else if (!var2_3.isCompatibleTo((Package)var3_4)) {
                    void var1_2;
                    throw new SecurityException("Sealing violation for package " + (String)var1_2);
                }
            }
            return ByteArrayClassLoader.access$300(this.this$0, this.name, this.binaryRepresentation, 0, this.binaryRepresentation.length, this.this$0.protectionDomain);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.name.equals(((ClassDefinitionAction)object).name)) {
                return false;
            }
            if (!Arrays.equals(this.binaryRepresentation, ((ClassDefinitionAction)object).binaryRepresentation)) {
                return false;
            }
            return this.this$0.equals(((ClassDefinitionAction)object).this$0);
        }

        public int hashCode() {
            return ((this.getClass().hashCode() * 31 + this.name.hashCode()) * 31 + Arrays.hashCode(this.binaryRepresentation)) * 31 + this.this$0.hashCode();
        }
    }

    protected static interface SynchronizationStrategy {
        public Object getClassLoadingLock(ByteArrayClassLoader var1, String var2);

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForJava8CapableVm
        implements SynchronizationStrategy,
        Initializable {
            private final Object methodHandle;
            private final Method bindTo;
            private final Method invokeWithArguments;

            /*
             * WARNING - void declaration
             */
            protected ForJava8CapableVm(Object methodHandle, Method bindTo, Method invokeWithArguments) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.methodHandle = var1_1;
                this.bindTo = var2_2;
                this.invokeWithArguments = var3_3;
            }

            public SynchronizationStrategy initialize() {
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Object getClassLoadingLock(ByteArrayClassLoader classLoader, String name) {
                try {
                    void var2_4;
                    return this.invokeWithArguments.invoke(this.bindTo.invoke(this.methodHandle, classLoader), new Object[]{new Object[]{var2_4}});
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException(exception);
                }
                catch (InvocationTargetException exception) {
                    void var1_3;
                    throw new IllegalStateException(var1_3.getTargetException());
                }
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.methodHandle.equals(((ForJava8CapableVm)object).methodHandle)) {
                    return false;
                }
                if (!this.bindTo.equals(((ForJava8CapableVm)object).bindTo)) {
                    return false;
                }
                return this.invokeWithArguments.equals(((ForJava8CapableVm)object).invokeWithArguments);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.methodHandle.hashCode()) * 31 + this.bindTo.hashCode()) * 31 + this.invokeWithArguments.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForJava7CapableVm
        implements SynchronizationStrategy,
        Initializable {
            private final Method method;

            /*
             * WARNING - void declaration
             */
            protected ForJava7CapableVm(Method method) {
                void var1_1;
                this.method = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Object getClassLoadingLock(ByteArrayClassLoader classLoader, String name) {
                try {
                    void var2_4;
                    return this.method.invoke((Object)classLoader, var2_4);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException(exception);
                }
                catch (InvocationTargetException exception) {
                    void var1_3;
                    throw new IllegalStateException(var1_3.getTargetException());
                }
            }

            @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Assuring privilege is explicit user responsibility.")
            public SynchronizationStrategy initialize() {
                try {
                    this.method.setAccessible(true);
                    return this;
                }
                catch (Exception exception) {
                    return ForLegacyVm.INSTANCE;
                }
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.method.equals(((ForJava7CapableVm)object).method);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.method.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForLegacyVm implements SynchronizationStrategy,
        Initializable
        {
            INSTANCE;


            @Override
            public final Object getClassLoadingLock(ByteArrayClassLoader classLoader, String name) {
                return classLoader;
            }

            @Override
            public final SynchronizationStrategy initialize() {
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CreationAction implements PrivilegedAction<Initializable>
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
            public final Initializable run() {
                try {
                    void var2_2;
                    void var1_1;
                    Class<?> methodType = Class.forName("java.lang.invoke.MethodType");
                    Class<?> methodHandle = Class.forName("java.lang.invoke.MethodHandle");
                    return new ForJava8CapableVm(Class.forName("java.lang.invoke.MethodHandles$Lookup").getMethod("findVirtual", Class.class, String.class, methodType).invoke(ByteArrayClassLoader.methodHandle(), ClassLoader.class, "getClassLoadingLock", var1_1.getMethod("methodType", Class.class, Class[].class).invoke(null, Object.class, new Class[]{String.class})), methodHandle.getMethod("bindTo", Object.class), var2_2.getMethod("invokeWithArguments", Object[].class));
                }
                catch (Exception exception) {
                    try {
                        return (Initializable)((Object)(ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V5).isAtLeast(ClassFileVersion.JAVA_V9) && ByteArrayClassLoader.class.getClassLoader() == null ? ForLegacyVm.INSTANCE : new ForJava7CapableVm(ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class))));
                    }
                    catch (Exception exception2) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }

        public static interface Initializable {
            public SynchronizationStrategy initialize();
        }
    }
}

