/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.SafeVarargsPlugin;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Transformer<T> {
    public T transform(TypeDescription var1, T var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound<S>
    implements Transformer<S> {
        private final List<Transformer<S>> transformers = new ArrayList<Transformer<S>>();

        /*
         * WARNING - void declaration
         */
        @SafeVarargsPlugin.Enhance
        @SafeVarargs
        public Compound(Transformer<S> ... transformer) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Compound(List<? extends Transformer<S>> transformers) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Transformer transformer = (Transformer)iterator.next();
                if (transformer instanceof Compound) {
                    this.transformers.addAll(((Compound)transformer).transformers);
                    continue;
                }
                if (transformer instanceof NoOp) continue;
                this.transformers.add((Transformer<S>)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public S transform(TypeDescription instrumentedType, S target) {
            void var2_2;
            for (Transformer<S> transformer : this.transformers) {
                target = transformer.transform(instrumentedType, target);
            }
            return var2_2;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.transformers).equals(((Compound)object).transformers);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.transformers).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForMethod
    implements Transformer<MethodDescription> {
        private final Transformer<MethodDescription.Token> transformer;

        /*
         * WARNING - void declaration
         */
        public ForMethod(Transformer<MethodDescription.Token> transformer) {
            void var1_1;
            this.transformer = var1_1;
        }

        public static Transformer<MethodDescription> withModifiers(ModifierContributor.ForMethod ... modifierContributor) {
            return ForMethod.withModifiers(Arrays.asList(modifierContributor));
        }

        public static Transformer<MethodDescription> withModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
            List<? extends ModifierContributor.ForMethod> list;
            return new ForMethod(new MethodModifierTransformer(ModifierContributor.Resolver.of(list)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            void var2_2;
            void var1_1;
            return new TransformedMethod(instrumentedType, methodDescription.getDeclaringType(), this.transformer.transform((TypeDescription)var1_1, (MethodDescription.Token)methodDescription.asToken(ElementMatchers.none())), (MethodDescription.InDefinedShape)var2_2.asDefined());
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.transformer.equals(((ForMethod)object).transformer);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.transformer.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class TransformedMethod
        extends MethodDescription.AbstractBase {
            private final TypeDescription instrumentedType;
            private final TypeDefinition declaringType;
            private final MethodDescription.Token token;
            private final MethodDescription.InDefinedShape methodDescription;

            /*
             * WARNING - void declaration
             */
            protected TransformedMethod(TypeDescription instrumentedType, TypeDefinition declaringType, MethodDescription.Token token, MethodDescription.InDefinedShape methodDescription) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.instrumentedType = var1_1;
                this.declaringType = var2_2;
                this.token = var3_3;
                this.methodDescription = methodDescription;
            }

            @Override
            public TypeList.Generic getTypeVariables() {
                TransformedMethod transformedMethod = this;
                return new TypeList.Generic.ForDetachedTypes.OfTypeVariables(transformedMethod, transformedMethod.token.getTypeVariableTokens(), new AttachmentVisitor(this));
            }

            @Override
            public TypeDescription.Generic getReturnType() {
                return this.token.getReturnType().accept(new AttachmentVisitor(this));
            }

            @Override
            public ParameterList<?> getParameters() {
                return new TransformedParameterList(this);
            }

            @Override
            public TypeList.Generic getExceptionTypes() {
                return new TypeList.Generic.ForDetachedTypes(this.token.getExceptionTypes(), new AttachmentVisitor(this));
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return this.token.getAnnotations();
            }

            @Override
            public String getInternalName() {
                return this.token.getName();
            }

            @Override
            public TypeDefinition getDeclaringType() {
                return this.declaringType;
            }

            @Override
            public int getModifiers() {
                return this.token.getModifiers();
            }

            @Override
            @MaybeNull
            public AnnotationValue<?, ?> getDefaultValue() {
                return this.token.getDefaultValue();
            }

            @Override
            public MethodDescription.InDefinedShape asDefined() {
                return this.methodDescription;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public TypeDescription.Generic getReceiverType() {
                void var1_1;
                TypeDescription.Generic receiverType = this.token.getReceiverType();
                if (receiverType == null) {
                    return TypeDescription.Generic.UNDEFINED;
                }
                return var1_1.accept(new AttachmentVisitor(this));
            }

            @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
            protected class AttachmentVisitor
            extends TypeDescription.Generic.Visitor.Substitutor.WithoutTypeSubstitution {
                final /* synthetic */ TransformedMethod this$0;

                /*
                 * WARNING - void declaration
                 */
                protected AttachmentVisitor(TransformedMethod this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public TypeDescription.Generic onTypeVariable(TypeDescription.Generic typeVariable) {
                    void var1_1;
                    void var2_2;
                    TypeList.Generic candidates = (TypeList.Generic)this.this$0.getTypeVariables().filter(ElementMatchers.named(typeVariable.getSymbol()));
                    return new TypeDescription.Generic.OfTypeVariable.WithAnnotationOverlay(candidates.isEmpty() ? this.this$0.instrumentedType.findExpectedVariable(typeVariable.getSymbol()) : (TypeDescription.Generic)var2_2.getOnly(), (AnnotationSource)var1_1);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.this$0.equals(((AttachmentVisitor)object).this$0);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.this$0.hashCode();
                }
            }

            protected class TransformedParameter
            extends ParameterDescription.AbstractBase {
                private final int index;
                private final ParameterDescription.Token parameterToken;
                final /* synthetic */ TransformedMethod this$0;

                /*
                 * WARNING - void declaration
                 */
                protected TransformedParameter(TransformedMethod this$0, int index, ParameterDescription.Token parameterToken) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.index = var2_2;
                    this.parameterToken = var3_3;
                }

                public TypeDescription.Generic getType() {
                    return this.parameterToken.getType().accept(new AttachmentVisitor(this.this$0));
                }

                public MethodDescription getDeclaringMethod() {
                    return this.this$0;
                }

                public int getIndex() {
                    return this.index;
                }

                public boolean isNamed() {
                    return this.parameterToken.getName() != null;
                }

                public boolean hasModifiers() {
                    return this.parameterToken.getModifiers() != null;
                }

                /*
                 * WARNING - void declaration
                 */
                public String getName() {
                    void var1_1;
                    String name = this.parameterToken.getName();
                    if (name == null) {
                        return super.getName();
                    }
                    return var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public int getModifiers() {
                    void var1_1;
                    Integer modifiers = this.parameterToken.getModifiers();
                    if (modifiers == null) {
                        return super.getModifiers();
                    }
                    return var1_1.intValue();
                }

                public AnnotationList getDeclaredAnnotations() {
                    return this.parameterToken.getAnnotations();
                }

                public ParameterDescription.InDefinedShape asDefined() {
                    return (ParameterDescription.InDefinedShape)this.this$0.methodDescription.getParameters().get(this.index);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected class TransformedParameterList
            extends ParameterList.AbstractBase<ParameterDescription> {
                final /* synthetic */ TransformedMethod this$0;

                /*
                 * WARNING - void declaration
                 */
                protected TransformedParameterList(TransformedMethod this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ParameterDescription get(int index) {
                    void var1_1;
                    TransformedMethod transformedMethod = this.this$0;
                    return new TransformedParameter(transformedMethod, index, (ParameterDescription.Token)transformedMethod.token.getParameterTokens().get((int)var1_1));
                }

                @Override
                public int size() {
                    return this.this$0.token.getParameterTokens().size();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class MethodModifierTransformer
        implements Transformer<MethodDescription.Token> {
            private final ModifierContributor.Resolver<ModifierContributor.ForMethod> resolver;

            /*
             * WARNING - void declaration
             */
            protected MethodModifierTransformer(ModifierContributor.Resolver<ModifierContributor.ForMethod> resolver) {
                void var1_1;
                this.resolver = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public MethodDescription.Token transform(TypeDescription instrumentedType, MethodDescription.Token target) {
                void var2_2;
                return new MethodDescription.Token(target.getName(), this.resolver.resolve(target.getModifiers()), target.getTypeVariableTokens(), target.getReturnType(), target.getParameterTokens(), target.getExceptionTypes(), target.getAnnotations(), target.getDefaultValue(), var2_2.getReceiverType());
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.resolver.equals(((MethodModifierTransformer)object).resolver);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.resolver.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForField
    implements Transformer<FieldDescription> {
        private final Transformer<FieldDescription.Token> transformer;

        /*
         * WARNING - void declaration
         */
        public ForField(Transformer<FieldDescription.Token> transformer) {
            void var1_1;
            this.transformer = var1_1;
        }

        public static Transformer<FieldDescription> withModifiers(ModifierContributor.ForField ... modifierContributor) {
            return ForField.withModifiers(Arrays.asList(modifierContributor));
        }

        public static Transformer<FieldDescription> withModifiers(List<? extends ModifierContributor.ForField> modifierContributors) {
            List<? extends ModifierContributor.ForField> list;
            return new ForField(new FieldModifierTransformer(ModifierContributor.Resolver.of(list)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
        public FieldDescription transform(TypeDescription instrumentedType, FieldDescription fieldDescription) {
            void var2_2;
            void var1_1;
            return new TransformedField(instrumentedType, fieldDescription.getDeclaringType(), this.transformer.transform((TypeDescription)var1_1, (FieldDescription.Token)fieldDescription.asToken(ElementMatchers.none())), (FieldDescription.InDefinedShape)var2_2.asDefined());
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.transformer.equals(((ForField)object).transformer);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.transformer.hashCode();
        }

        protected static class TransformedField
        extends FieldDescription.AbstractBase {
            private final TypeDescription instrumentedType;
            private final TypeDefinition declaringType;
            private final FieldDescription.Token token;
            private final FieldDescription.InDefinedShape fieldDescription;

            /*
             * WARNING - void declaration
             */
            protected TransformedField(TypeDescription instrumentedType, TypeDefinition declaringType, FieldDescription.Token token, FieldDescription.InDefinedShape fieldDescription) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.instrumentedType = var1_1;
                this.declaringType = var2_2;
                this.token = var3_3;
                this.fieldDescription = fieldDescription;
            }

            public TypeDescription.Generic getType() {
                return this.token.getType().accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this.instrumentedType));
            }

            public AnnotationList getDeclaredAnnotations() {
                return this.token.getAnnotations();
            }

            public TypeDefinition getDeclaringType() {
                return this.declaringType;
            }

            public int getModifiers() {
                return this.token.getModifiers();
            }

            public FieldDescription.InDefinedShape asDefined() {
                return this.fieldDescription;
            }

            public String getName() {
                return this.token.getName();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class FieldModifierTransformer
        implements Transformer<FieldDescription.Token> {
            private final ModifierContributor.Resolver<ModifierContributor.ForField> resolver;

            /*
             * WARNING - void declaration
             */
            protected FieldModifierTransformer(ModifierContributor.Resolver<ModifierContributor.ForField> resolver) {
                void var1_1;
                this.resolver = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public FieldDescription.Token transform(TypeDescription instrumentedType, FieldDescription.Token target) {
                void var2_2;
                return new FieldDescription.Token(target.getName(), this.resolver.resolve(target.getModifiers()), target.getType(), var2_2.getAnnotations());
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.resolver.equals(((FieldModifierTransformer)object).resolver);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.resolver.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoOp implements Transformer<Object>
    {
        INSTANCE;


        public static <T> Transformer<T> make() {
            return INSTANCE;
        }

        @Override
        public final Object transform(TypeDescription instrumentedType, Object target) {
            return target;
        }
    }
}

