/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nexus
extends WeakReference<ClassLoader> {
    public static final String PROPERTY = "net.bytebuddy.nexus.disabled";
    @AlwaysNull
    private static final ReferenceQueue<ClassLoader> NO_QUEUE = null;
    private static final ConcurrentMap<Nexus, Object> TYPE_INITIALIZERS = new ConcurrentHashMap<Nexus, Object>();
    private final String name;
    private final int classLoaderHashCode;
    private final int identification;

    /*
     * WARNING - void declaration
     */
    private Nexus(Class<?> type, int identification) {
        this(Nexus.nonAnonymous(type.getName()), var1_1.getClassLoader(), NO_QUEUE, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Nexus(String name, @MaybeNull ClassLoader classLoader, @MaybeNull ReferenceQueue<? super ClassLoader> referenceQueue, int identification) {
        void var2_2;
        void var1_1;
        void var3_3;
        ClassLoader classLoader2 = classLoader;
        super(classLoader2, classLoader2 == null ? null : var3_3);
        this.name = var1_1;
        this.classLoaderHashCode = System.identityHashCode(var2_2);
        this.identification = identification;
    }

    /*
     * WARNING - void declaration
     */
    private static String nonAnonymous(String typeName) {
        void var1_1;
        String string;
        int anonymousLoaderIndex = typeName.indexOf(47);
        if (anonymousLoaderIndex == -1) {
            return typeName;
        }
        return string.substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize(Class<?> type, int identification) throws Exception {
        Object typeInitializer = TYPE_INITIALIZERS.remove(new Nexus(type, identification));
        if (typeInitializer != null) {
            Class<?> clazz;
            void var1_2;
            Class.forName("net.bytebuddy.implementation.LoadedTypeInitializer", true, typeInitializer.getClass().getClassLoader()).getMethod("onLoad", Class.class).invoke((Object)var1_2, clazz);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void register(String name, @MaybeNull ClassLoader classLoader, @MaybeNull ReferenceQueue<? super ClassLoader> referenceQueue, int identification, Object typeInitializer) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        TYPE_INITIALIZERS.put(new Nexus(string, (ClassLoader)var1_1, (ReferenceQueue<? super ClassLoader>)var2_2, (int)var3_3), typeInitializer);
    }

    public static void clean(Reference<? super ClassLoader> reference) {
        Reference<? super ClassLoader> reference2;
        TYPE_INITIALIZERS.remove(reference2);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.name.hashCode();
        result = result * 31 + this.classLoaderHashCode;
        var1_1 = var1_1 * 31 + this.identification;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@MaybeNull Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Nexus nexus = (Nexus)other;
        return this.classLoaderHashCode == nexus.classLoaderHashCode && this.identification == nexus.identification && this.name.equals(nexus.name) && this.get() == var1_1.get();
    }

    public String toString() {
        return "Nexus{name='" + this.name + '\'' + ", classLoaderHashCode=" + this.classLoaderHashCode + ", identification=" + this.identification + ", classLoader=" + this.get() + '}';
    }
}

