/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.StreamDrainer;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

public interface ClassFileLocator
extends Closeable {
    public static final String CLASS_FILE_EXTENSION = ".class";
    public static final String META_INF_VERSIONS = "META-INF/versions/";

    public Resolution locate(String var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    implements Closeable,
    ClassFileLocator {
        private final List<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();

        /*
         * WARNING - void declaration
         */
        public Compound(ClassFileLocator ... classFileLocator) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Compound(List<? extends ClassFileLocator> classFileLocators) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                ClassFileLocator classFileLocator = (ClassFileLocator)iterator.next();
                if (classFileLocator instanceof Compound) {
                    this.classFileLocators.addAll(((Compound)classFileLocator).classFileLocators);
                    continue;
                }
                if (classFileLocator instanceof NoOp) continue;
                this.classFileLocators.add((ClassFileLocator)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution locate(String name) throws IOException {
            void var1_1;
            for (ClassFileLocator classFileLocator : this.classFileLocators) {
                Resolution resolution = classFileLocator.locate(name);
                if (!resolution.isResolved()) continue;
                return classFileLocator;
            }
            return new Resolution.Illegal((String)var1_1);
        }

        @Override
        public void close() throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocators) {
                classFileLocator.close();
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.classFileLocators).equals(((Compound)object).classFileLocators);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.classFileLocators).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Filtering
    implements ClassFileLocator {
        private final ElementMatcher<? super String> matcher;
        private final ClassFileLocator delegate;

        /*
         * WARNING - void declaration
         */
        public Filtering(ElementMatcher<? super String> matcher, ClassFileLocator delegate) {
            void var2_2;
            void var1_1;
            this.matcher = var1_1;
            this.delegate = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution locate(String name) throws IOException {
            void var1_1;
            if (this.matcher.matches(name)) {
                return this.delegate.locate(name);
            }
            return new Resolution.Illegal((String)var1_1);
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.matcher.equals(((Filtering)object).matcher)) {
                return false;
            }
            return this.delegate.equals(((Filtering)object).delegate);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.matcher.hashCode()) * 31 + this.delegate.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class PackageDiscriminating
    implements ClassFileLocator {
        private final Map<String, ClassFileLocator> classFileLocators;

        /*
         * WARNING - void declaration
         */
        public PackageDiscriminating(Map<String, ClassFileLocator> classFileLocators) {
            void var1_1;
            this.classFileLocators = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution locate(String name) throws IOException {
            void var1_1;
            void var2_3;
            int packageIndex = name.lastIndexOf(46);
            ClassFileLocator classFileLocator = this.classFileLocators.get(packageIndex == -1 ? "" : name.substring(0, packageIndex));
            if (classFileLocator == null) {
                return new Resolution.Illegal(name);
            }
            return var2_3.locate((String)var1_1);
        }

        @Override
        public void close() throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocators.values()) {
                classFileLocator.close();
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.classFileLocators).equals(((PackageDiscriminating)object).classFileLocators);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.classFileLocators).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForInstrumentation
    implements ClassFileLocator {
        private static final Dispatcher DISPATCHER;
        private final Instrumentation instrumentation;
        private final ClassLoadingDelegate classLoadingDelegate;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        public ForInstrumentation(Instrumentation instrumentation, @MaybeNull ClassLoader classLoader) {
            this((Instrumentation)var1_1, ClassLoadingDelegate.Default.of((ClassLoader)var2_2));
            void var2_2;
            void var1_1;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        /*
         * WARNING - void declaration
         */
        public ForInstrumentation(Instrumentation instrumentation, ClassLoadingDelegate classLoadingDelegate) {
            void var2_2;
            void var1_1;
            if (!DISPATCHER.isRetransformClassesSupported(instrumentation)) {
                throw new IllegalArgumentException(instrumentation + " does not support retransformation");
            }
            this.instrumentation = var1_1;
            this.classLoadingDelegate = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private static Instrumentation resolveByteBuddyAgentInstrumentation() {
            try {
                Class<?> installer = ClassLoader.getSystemClassLoader().loadClass("net.bytebuddy.agent.Installer");
                JavaModule source = JavaModule.ofType(AgentBuilder.class);
                JavaModule target = JavaModule.ofType(installer);
                if (source != null && !source.canRead(target)) {
                    void var2_4;
                    void var1_3;
                    void var3_5;
                    Class<?> module = Class.forName("java.lang.Module");
                    module.getMethod("addReads", new Class[]{var3_5}).invoke(var1_3.unwrap(), var2_4.unwrap());
                }
                return (Instrumentation)installer.getMethod("getInstrumentation", new Class[0]).invoke(null, new Object[0]);
            }
            catch (RuntimeException runtimeException) {
                RuntimeException installer = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                void var0_2;
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", (Throwable)var0_2);
            }
        }

        public static ClassFileLocator fromInstalledAgent(@MaybeNull ClassLoader classLoader) {
            ClassLoader classLoader2;
            return new ForInstrumentation(ForInstrumentation.resolveByteBuddyAgentInstrumentation(), classLoader2);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator of(Instrumentation instrumentation, Class<?> type) {
            void var1_1;
            Instrumentation instrumentation2;
            return new ForInstrumentation(instrumentation2, ClassLoadingDelegate.Explicit.of(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution locate(String name) {
            Resolution resolution;
            ExtractionClassFileTransformer classFileTransformer = new ExtractionClassFileTransformer(this.classLoadingDelegate.getClassLoader(), name);
            DISPATCHER.addTransformer(this.instrumentation, classFileTransformer, true);
            try {
                DISPATCHER.retransformClasses(this.instrumentation, new Class[]{this.classLoadingDelegate.locate(name)});
                byte[] binaryRepresentation = classFileTransformer.getBinaryRepresentation();
                resolution = binaryRepresentation == null ? new Resolution.Illegal(name) : new Resolution.Explicit((byte[])resolution);
                this.instrumentation.removeTransformer(classFileTransformer);
            }
            catch (Throwable throwable) {
                RuntimeException runtimeException;
                try {
                    this.instrumentation.removeTransformer((ClassFileTransformer)((Object)runtimeException));
                    throw throwable;
                }
                catch (RuntimeException runtimeException2) {
                    runtimeException = runtimeException2;
                    throw runtimeException2;
                }
                catch (Exception exception) {
                    void var1_1;
                    return new Resolution.Illegal((String)var1_1);
                }
            }
            return resolution;
        }

        @Override
        public void close() {
        }

        static /* synthetic */ Object access$000(PrivilegedAction x0) {
            return ForInstrumentation.doPrivileged(x0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            DISPATCHER = ForInstrumentation.doPrivileged(JavaDispatcher.of(Dispatcher.class));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.instrumentation.equals(((ForInstrumentation)object).instrumentation)) {
                return false;
            }
            return this.classLoadingDelegate.equals(((ForInstrumentation)object).classLoadingDelegate);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.instrumentation.hashCode()) * 31 + this.classLoadingDelegate.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class ExtractionClassFileTransformer
        implements ClassFileTransformer {
            @AlwaysNull
            private static final byte[] DO_NOT_TRANSFORM = null;
            @MaybeNull
            private final ClassLoader classLoader;
            private final String typeName;
            @MaybeNull
            @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The array is not to be modified by contract")
            private volatile byte[] binaryRepresentation;

            /*
             * WARNING - void declaration
             */
            protected ExtractionClassFileTransformer(@MaybeNull ClassLoader classLoader, String typeName) {
                void var2_2;
                void var1_1;
                this.classLoader = var1_1;
                this.typeName = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @MaybeNull
            @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="The array is not modified by class contract.")
            public byte[] transform(@MaybeNull ClassLoader classLoader, @MaybeNull String internalName, @MaybeNull Class<?> redefinedType, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                void var2_2;
                void var1_1;
                if (internalName != null && ElementMatchers.isChildOf(this.classLoader).matches(var1_1) && this.typeName.equals(var2_2.replace('/', '.'))) {
                    this.binaryRepresentation = (byte[])binaryRepresentation.clone();
                }
                return DO_NOT_TRANSFORM;
            }

            @MaybeNull
            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The array is not to be modified by contract")
            protected byte[] getBinaryRepresentation() {
                return this.binaryRepresentation;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ClassLoadingDelegate {
            public Class<?> locate(String var1) throws ClassNotFoundException;

            @MaybeNull
            public ClassLoader getClassLoader();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Explicit
            implements ClassLoadingDelegate {
                private final ClassLoadingDelegate fallbackDelegate;
                private final Map<String, Class<?>> types;

                /*
                 * WARNING - void declaration
                 */
                public Explicit(@MaybeNull ClassLoader classLoader, Collection<? extends Class<?>> types) {
                    this(Default.of((ClassLoader)var1_1), (Collection<? extends Class<?>>)var2_2);
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Explicit(ClassLoadingDelegate fallbackDelegate, Collection<? extends Class<?>> types) {
                    Iterator<Class<?>> iterator;
                    this.fallbackDelegate = iterator;
                    this.types = new HashMap();
                    for (Class<?> type : types) {
                        void var2_2;
                        this.types.put(TypeDescription.ForLoadedType.getName(type), (Class<?>)var2_2);
                    }
                }

                public static ClassLoadingDelegate of(Class<?> type) {
                    Class<?> clazz;
                    return new Explicit(type.getClassLoader(), Collections.singleton(clazz));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    void var2_2;
                    Class<?> type = this.types.get(name);
                    if (type == null) {
                        void var1_1;
                        return this.fallbackDelegate.locate((String)var1_1);
                    }
                    return var2_2;
                }

                @Override
                @MaybeNull
                public ClassLoader getClassLoader() {
                    return this.fallbackDelegate.getClassLoader();
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.fallbackDelegate.equals(((Explicit)object).fallbackDelegate)) {
                        return false;
                    }
                    return ((Object)this.types).equals(((Explicit)object).types);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.fallbackDelegate.hashCode()) * 31 + ((Object)this.types).hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class ForDelegatingClassLoader
            extends Default {
                private static final String DELEGATING_CLASS_LOADER_NAME = "sun.reflect.DelegatingClassLoader";
                private static final int ONLY = 0;
                private static final Dispatcher.Initializable DISPATCHER;
                private static final boolean ACCESS_CONTROLLER;

                /*
                 * WARNING - void declaration
                 */
                protected ForDelegatingClassLoader(ClassLoader classLoader) {
                    super((ClassLoader)var1_1);
                    void var1_1;
                }

                @AccessControllerPlugin.Enhance
                private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
                    if (ACCESS_CONTROLLER) {
                        return AccessController.doPrivileged(privilegedAction);
                    }
                    return privilegedAction.run();
                }

                protected static boolean isDelegating(@MaybeNull ClassLoader classLoader) {
                    ClassLoader classLoader2;
                    return classLoader != null && classLoader2.getClass().getName().equals(DELEGATING_CLASS_LOADER_NAME);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    void var1_1;
                    Vector<Class<?>> classes;
                    try {
                        classes = DISPATCHER.initialize().extract(this.classLoader);
                    }
                    catch (RuntimeException runtimeException) {
                        return super.locate(name);
                    }
                    if (classes.size() != 1) {
                        return super.locate(name);
                    }
                    Class<?> type = classes.get(0);
                    if (TypeDescription.ForLoadedType.getName(type).equals(name)) {
                        void var2_2;
                        return var2_2;
                    }
                    return super.locate((String)var1_1);
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                static {
                    try {
                        Class.forName("java.security.AccessController", false, null);
                        ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ACCESS_CONTROLLER = false;
                    }
                    catch (SecurityException securityException) {
                        ACCESS_CONTROLLER = true;
                    }
                    DISPATCHER = ForDelegatingClassLoader.doPrivileged(Dispatcher.CreationAction.INSTANCE);
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static interface Dispatcher {
                    public Vector<Class<?>> extract(ClassLoader var1);

                    @HashCodeAndEqualsPlugin.Enhance
                    public static class Unresolved
                    implements Initializable {
                        private final String message;

                        /*
                         * WARNING - void declaration
                         */
                        public Unresolved(String message) {
                            void var1_1;
                            this.message = var1_1;
                        }

                        public Dispatcher initialize() {
                            throw new UnsupportedOperationException("Could not locate classes vector: " + this.message);
                        }

                        public boolean equals(@MaybeNull Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            return this.message.equals(((Unresolved)object).message);
                        }

                        public int hashCode() {
                            return this.getClass().hashCode() * 31 + this.message.hashCode();
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    @HashCodeAndEqualsPlugin.Enhance
                    public static class Resolved
                    implements PrivilegedAction<Dispatcher>,
                    Dispatcher,
                    Initializable {
                        private final Field field;
                        private static final boolean ACCESS_CONTROLLER;

                        /*
                         * WARNING - void declaration
                         */
                        public Resolved(Field field) {
                            void var1_1;
                            this.field = var1_1;
                        }

                        @AccessControllerPlugin.Enhance
                        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
                            if (ACCESS_CONTROLLER) {
                                return AccessController.doPrivileged(privilegedAction);
                            }
                            return privilegedAction.run();
                        }

                        @Override
                        public Dispatcher initialize() {
                            return Resolved.doPrivileged(this);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public Vector<Class<?>> extract(ClassLoader classLoader) {
                            try {
                                return (Vector)this.field.get(classLoader);
                            }
                            catch (IllegalAccessException exception) {
                                void var1_2;
                                throw new IllegalStateException("Cannot access field", (Throwable)var1_2);
                            }
                        }

                        @Override
                        public Dispatcher run() {
                            this.field.setAccessible(true);
                            return this;
                        }

                        public boolean equals(@MaybeNull Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            return this.field.equals(((Resolved)object).field);
                        }

                        public int hashCode() {
                            return this.getClass().hashCode() * 31 + this.field.hashCode();
                        }

                        static {
                            try {
                                Class.forName("java.security.AccessController", false, null);
                                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
                                return;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                ACCESS_CONTROLLER = false;
                                return;
                            }
                            catch (SecurityException securityException) {
                                ACCESS_CONTROLLER = true;
                                return;
                            }
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public static enum CreationAction implements PrivilegedAction<Initializable>
                    {
                        INSTANCE;


                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public final Initializable run() {
                            try {
                                return new Resolved(ClassLoader.class.getDeclaredField("classes"));
                            }
                            catch (Exception exception) {
                                void var1_1;
                                return new Unresolved(var1_1.getMessage());
                            }
                        }
                    }

                    public static interface Initializable {
                        public Dispatcher initialize();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Default
            implements ClassLoadingDelegate {
                private static final ClassLoader BOOT_LOADER_PROXY = (ClassLoader)ForInstrumentation.access$000(BootLoaderProxyCreationAction.INSTANCE);
                protected final ClassLoader classLoader;

                /*
                 * WARNING - void declaration
                 */
                protected Default(ClassLoader classLoader) {
                    void var1_1;
                    this.classLoader = var1_1;
                }

                public static ClassLoadingDelegate of(@MaybeNull ClassLoader classLoader) {
                    ClassLoader classLoader2;
                    if (ForDelegatingClassLoader.isDelegating(classLoader)) {
                        return new ForDelegatingClassLoader(classLoader);
                    }
                    return new Default(classLoader == null ? BOOT_LOADER_PROXY : classLoader2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    void var1_1;
                    return this.classLoader.loadClass((String)var1_1);
                }

                @Override
                @MaybeNull
                public ClassLoader getClassLoader() {
                    if (this.classLoader == BOOT_LOADER_PROXY) {
                        return ClassLoadingStrategy.BOOTSTRAP_LOADER;
                    }
                    return this.classLoader;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.classLoader.equals(((Default)object).classLoader);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.classLoader.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static enum BootLoaderProxyCreationAction implements PrivilegedAction<ClassLoader>
                {
                    INSTANCE;


                    @Override
                    public final ClassLoader run() {
                        return new URLClassLoader(new URL[0], ClassLoadingStrategy.BOOTSTRAP_LOADER);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @JavaDispatcher.Proxied(value="java.lang.instrument.Instrumentation")
        protected static interface Dispatcher {
            @JavaDispatcher.Proxied(value="isRetransformClassesSupported")
            public boolean isRetransformClassesSupported(Instrumentation var1);

            @JavaDispatcher.Proxied(value="addTransformer")
            public void addTransformer(Instrumentation var1, ClassFileTransformer var2, boolean var3);

            @JavaDispatcher.Proxied(value="retransformClasses")
            public void retransformClasses(Instrumentation var1, Class<?>[] var2) throws UnmodifiableClassException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForUrl
    implements ClassFileLocator {
        private final ClassLoader classLoader;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        public ForUrl(URL ... url) {
            void var1_1;
            this.classLoader = ForUrl.doPrivileged(new ClassLoaderCreationAction((URL[])var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public ForUrl(Collection<? extends URL> urls) {
            this(var1_1.toArray(new URL[0]));
            void var1_1;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution locate(String name) throws IOException {
            void var1_1;
            return ForClassLoader.locate(this.classLoader, (String)var1_1);
        }

        @Override
        public void close() throws IOException {
            if (this.classLoader instanceof Closeable) {
                ((Closeable)((Object)this.classLoader)).close();
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.classLoader.equals(((ForUrl)object).classLoader);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.classLoader.hashCode();
        }

        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
                return;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
                return;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class ClassLoaderCreationAction
        implements PrivilegedAction<ClassLoader> {
            private final URL[] url;

            /*
             * WARNING - void declaration
             */
            protected ClassLoaderCreationAction(URL[] url) {
                void var1_1;
                this.url = var1_1;
            }

            @Override
            public ClassLoader run() {
                return new URLClassLoader(this.url, ClassLoadingStrategy.BOOTSTRAP_LOADER);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return Arrays.equals(this.url, ((ClassLoaderCreationAction)object).url);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + Arrays.hashCode(this.url);
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class ForFolder
    extends MultiReleaseAware {
        private final File folder;

        /*
         * WARNING - void declaration
         */
        public ForFolder(File folder) {
            this(NO_MULTI_RELEASE, (File)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected ForFolder(int[] version, File folder) {
            super((int[])var1_1);
            void var2_2;
            void var1_1;
            this.folder = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator of(File folder, ClassFileVersion classFileVersion) throws IOException {
            File file;
            void var3_6;
            int[] version;
            boolean multiRelease;
            if (classFileVersion.getJavaVersion() < 9) {
                return new ForFolder(NO_MULTI_RELEASE, folder);
            }
            File manifest = new File(folder, "META-INF/MANIFEST.MF");
            if (manifest.exists()) {
                FileInputStream inputStream = new FileInputStream(manifest);
                try {
                    multiRelease = Boolean.parseBoolean(new Manifest(inputStream).getMainAttributes().getValue("Multi-Release"));
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            } else {
                multiRelease = false;
            }
            if (multiRelease) {
                File[] file2 = new File(folder, ClassFileLocator.META_INF_VERSIONS).listFiles();
                if (file2 != null) {
                    TreeSet<Integer> versions = new TreeSet<Integer>();
                    for (int index = 0; index < file2.length; ++index) {
                        try {
                            int candidate = Integer.parseInt(file2[index].getName());
                            if (candidate <= 7 || candidate > classFileVersion.getJavaVersion()) continue;
                            versions.add(candidate);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    version = new int[versions.size()];
                    Iterator iterator = versions.iterator();
                    for (int index = 0; index < versions.size(); ++index) {
                        version[versions.size() - index - 1] = (Integer)iterator.next();
                    }
                } else {
                    version = NO_MULTI_RELEASE;
                }
            } else {
                version = NO_MULTI_RELEASE;
            }
            return new ForFolder((int[])var3_6, file);
        }

        /*
         * WARNING - void declaration
         */
        @MaybeNull
        @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Null value indicates failed lookup.")
        protected byte[] doLocate(String path) throws IOException {
            File file = new File(this.folder, path);
            if (file.exists()) {
                byte[] byArray;
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    byArray = StreamDrainer.DEFAULT.drain(inputStream);
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                ((InputStream)inputStream).close();
                return byArray;
            }
            return null;
        }

        public void close() {
        }

        public boolean equals(@MaybeNull Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.folder.equals(((ForFolder)object).folder);
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.folder.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class ForModuleFile
    implements ClassFileLocator {
        private static final String JMOD_FILE_EXTENSION = ".jmod";
        private static final List<String> BOOT_LOCATIONS = Arrays.asList("jmods", "../jmods", "modules");
        private final ZipFile zipFile;

        /*
         * WARNING - void declaration
         */
        public ForModuleFile(ZipFile zipFile) {
            void var1_1;
            this.zipFile = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator ofBootPath() throws IOException {
            void var1_1;
            String javaHome = System.getProperty("java.home").replace('\\', '/');
            Object bootPath = null;
            for (String location : BOOT_LOCATIONS) {
                void var3_3;
                File candidate = new File(javaHome, location);
                if (!candidate.isDirectory()) continue;
                bootPath = var3_3;
                break;
            }
            if (bootPath == null) {
                void var0;
                throw new IllegalStateException("Boot modules do not exist in " + (String)var0 + " for any of " + BOOT_LOCATIONS);
            }
            return ForModuleFile.ofBootPath((File)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator ofBootPath(File bootPath) throws IOException {
            void var2_2;
            File[] fileArray;
            File[] module = bootPath.listFiles();
            if (module == null) {
                return NoOp.INSTANCE;
            }
            ClassFileVersion classFileVersion = ClassFileVersion.ofThisVm();
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>(module.length);
            for (File aModule : fileArray) {
                if (aModule.isFile()) {
                    classFileLocators.add(ForModuleFile.of(aModule));
                    continue;
                }
                if (!aModule.isDirectory()) continue;
                classFileLocators.add(ForFolder.of(aModule, classFileVersion));
            }
            return new Compound((List<? extends ClassFileLocator>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator ofModulePath() throws IOException {
            void var0;
            String modulePath = System.getProperty("jdk.module.path");
            if (modulePath == null) {
                return NoOp.INSTANCE;
            }
            return ForModuleFile.ofModulePath((String)var0);
        }

        public static ClassFileLocator ofModulePath(String modulePath) throws IOException {
            return ForModuleFile.ofModulePath(modulePath, System.getProperty("user.dir"));
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator ofModulePath(String modulePath, String baseFolder) throws IOException {
            void var3_3;
            String[] stringArray;
            ClassFileVersion classFileVersion = ClassFileVersion.ofThisVm();
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (String element : Pattern.compile(System.getProperty("path.separator"), 16).split((CharSequence)stringArray)) {
                File[] fileArray;
                File file = new File(baseFolder, element);
                if (file.isDirectory()) {
                    File[] module = file.listFiles();
                    if (module == null) continue;
                    fileArray = module;
                    int n = module.length;
                    for (int i = 0; i < n; ++i) {
                        File aModule = fileArray[i];
                        if (aModule.isDirectory()) {
                            classFileLocators.add(ForFolder.of(aModule, classFileVersion));
                            continue;
                        }
                        if (!aModule.isFile()) continue;
                        classFileLocators.add(aModule.getName().endsWith(JMOD_FILE_EXTENSION) ? ForModuleFile.of(aModule) : ForJarFile.of(aModule, classFileVersion));
                    }
                    continue;
                }
                if (!fileArray.isFile()) continue;
                classFileLocators.add(fileArray.getName().endsWith(JMOD_FILE_EXTENSION) ? ForModuleFile.of((File)fileArray) : ForJarFile.of((File)fileArray));
            }
            return new Compound((List<? extends ClassFileLocator>)var3_3);
        }

        public static ClassFileLocator of(File file) throws IOException {
            File file2;
            return new ForModuleFile(new ZipFile(file2));
        }

        /*
         * WARNING - void declaration
         */
        public Resolution locate(String name) throws IOException {
            Resolution.Explicit explicit;
            ZipEntry zipEntry = this.zipFile.getEntry("classes/" + name.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (zipEntry == null) {
                return new Resolution.Illegal(name);
            }
            InputStream inputStream = this.zipFile.getInputStream((ZipEntry)((Object)explicit));
            try {
                explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            inputStream.close();
            return explicit;
        }

        public void close() throws IOException {
            this.zipFile.close();
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.zipFile.equals(((ForModuleFile)object).zipFile);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.zipFile.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class ForJarFile
    extends MultiReleaseAware {
        private static final List<String> RUNTIME_LOCATIONS = Arrays.asList("lib/rt.jar", "../lib/rt.jar", "../Classes/classes.jar");
        private final JarFile jarFile;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
        private final boolean close;

        /*
         * WARNING - void declaration
         */
        public ForJarFile(JarFile jarFile) {
            this(NO_MULTI_RELEASE, (JarFile)var1_1, false);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected ForJarFile(int[] version, JarFile jarFile, boolean close) {
            super((int[])var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.jarFile = var2_2;
            this.close = var3_3;
        }

        public static ClassFileLocator of(File file) throws IOException {
            File file2;
            return new ForJarFile(MultiReleaseAware.NO_MULTI_RELEASE, new JarFile(file2, false, 1), true);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator of(File file, ClassFileVersion classFileVersion) throws IOException {
            void var1_1;
            File file2;
            return ForJarFile.of(new JarFile(file2, false, 1), (ClassFileVersion)var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator of(JarFile jarFile, ClassFileVersion classFileVersion) throws IOException {
            void var1_1;
            return ForJarFile.of(jarFile, (ClassFileVersion)var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        private static ClassFileLocator of(JarFile jarFile, ClassFileVersion classFileVersion, boolean close) throws IOException {
            void var2_2;
            JarFile jarFile2;
            void var1_1;
            int[] version;
            if (classFileVersion.getJavaVersion() < 9) {
                return new ForJarFile(jarFile);
            }
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && Boolean.parseBoolean(manifest.getMainAttributes().getValue("Multi-Release"))) {
                TreeSet<Integer> versions = new TreeSet<Integer>();
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String name = enumeration.nextElement().getName();
                    if (!name.endsWith(ClassFileLocator.CLASS_FILE_EXTENSION) || !name.startsWith(ClassFileLocator.META_INF_VERSIONS)) continue;
                    try {
                        int candidate = Integer.parseInt(name.substring(18, name.indexOf(47, 18)));
                        if (candidate <= 7 || candidate > classFileVersion.getJavaVersion()) continue;
                        versions.add(candidate);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                version = new int[versions.size()];
                Iterator iterator = versions.iterator();
                for (int index = 0; index < versions.size(); ++index) {
                    version[versions.size() - index - 1] = (Integer)iterator.next();
                }
            } else {
                version = MultiReleaseAware.NO_MULTI_RELEASE;
            }
            return new ForJarFile((int[])var1_1, jarFile2, (boolean)var2_2);
        }

        public static ClassFileLocator ofClassPath() throws IOException {
            return ForJarFile.ofClassPath(System.getProperty("java.class.path"));
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator ofClassPath(String classPath) throws IOException {
            void var2_2;
            String[] stringArray;
            ClassFileVersion classFileVersion = ClassFileVersion.ofThisVm();
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (String element : Pattern.compile(File.pathSeparator, 16).split((CharSequence)stringArray)) {
                File file = new File(element);
                if (file.isDirectory()) {
                    classFileLocators.add(ForFolder.of(file, classFileVersion));
                    continue;
                }
                if (!file.isFile()) continue;
                classFileLocators.add(ForJarFile.of(file, classFileVersion));
            }
            return new Compound((List<? extends ClassFileLocator>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator ofRuntimeJar() throws IOException {
            void var1_1;
            String javaHome = System.getProperty("java.home").replace('\\', '/');
            Object runtimeJar = null;
            for (String location : RUNTIME_LOCATIONS) {
                void var3_3;
                File candidate = new File(javaHome, location);
                if (!candidate.isFile()) continue;
                runtimeJar = var3_3;
                break;
            }
            if (runtimeJar == null) {
                void var0;
                throw new IllegalStateException("Runtime jar does not exist in " + (String)var0 + " for any of " + RUNTIME_LOCATIONS);
            }
            return ForJarFile.of((File)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @MaybeNull
        @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Null value indicates failed lookup.")
        protected byte[] doLocate(String path) throws IOException {
            byte[] byArray;
            ZipEntry zipEntry = this.jarFile.getEntry(path);
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = this.jarFile.getInputStream(zipEntry);
            try {
                byArray = StreamDrainer.DEFAULT.drain(inputStream);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            inputStream.close();
            return byArray;
        }

        public void close() throws IOException {
            if (this.close) {
                this.jarFile.close();
            }
        }

        public boolean equals(@MaybeNull Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.jarFile.equals(((ForJarFile)object).jarFile);
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.jarFile.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class ForModule
    implements ClassFileLocator {
        private static final Object[] NO_ARGUMENT = new Object[0];
        private final JavaModule module;

        /*
         * WARNING - void declaration
         */
        protected ForModule(JavaModule module) {
            void var1_1;
            this.module = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should always be wrapped for clarity")
        public static ClassFileLocator ofBootLayer() {
            try {
                Iterator iterator;
                HashMap<String, ClassFileLocator> bootModules = new HashMap<String, ClassFileLocator>();
                Class<?> layerType = Class.forName("java.lang.ModuleLayer");
                Method getPackages = JavaType.MODULE.load().getMethod("getPackages", new Class[0]);
                for (Object rawModule : (Set)layerType.getMethod("modules", new Class[0]).invoke(((Class)((Object)iterator)).getMethod("boot", new Class[0]).invoke(null, new Object[0]), new Object[0])) {
                    Iterator iterator2;
                    ClassFileLocator classFileLocator = ForModule.of(JavaModule.of(rawModule));
                    for (Object packageName : (Set)getPackages.invoke((Object)iterator2, NO_ARGUMENT)) {
                        bootModules.put((String)packageName, classFileLocator);
                    }
                }
                return new PackageDiscriminating(bootModules);
            }
            catch (Exception exception) {
                void var0_1;
                throw new IllegalStateException("Cannot process boot layer", (Throwable)var0_1);
            }
        }

        public static ClassFileLocator of(JavaModule module) {
            JavaModule javaModule;
            if (module.isNamed()) {
                return new ForModule(module);
            }
            return ForClassLoader.of(javaModule.getClassLoader());
        }

        /*
         * WARNING - void declaration
         */
        public Resolution locate(String name) throws IOException {
            void var1_1;
            return ForModule.locate(this.module, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected static Resolution locate(JavaModule module, String typeName2) throws IOException {
            void var1_1;
            InputStream inputStream = module.getResourceAsStream(((String)typeName2).replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    typeName2 = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                }
                catch (Throwable typeName2) {
                    InputStream inputStream2;
                    inputStream2.close();
                    throw typeName2;
                }
                inputStream.close();
                return typeName2;
            }
            return new Resolution.Illegal((String)var1_1);
        }

        public void close() {
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.module.equals(((ForModule)object).module);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.module.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class WeaklyReferenced
        extends WeakReference<Object>
        implements ClassFileLocator {
            private final int hashCode;

            /*
             * WARNING - void declaration
             */
            protected WeaklyReferenced(Object module) {
                super(module);
                void var1_1;
                this.hashCode = System.identityHashCode(var1_1);
            }

            public static ClassFileLocator of(JavaModule module) {
                JavaModule javaModule;
                if (module.isNamed()) {
                    if (module.getClassLoader() == null || module.getClassLoader() == ClassLoader.getSystemClassLoader() || module.getClassLoader() == ClassLoader.getSystemClassLoader().getParent()) {
                        return new ForModule(module);
                    }
                    return new WeaklyReferenced(module.unwrap());
                }
                return ForClassLoader.WeaklyReferenced.of(javaModule.getClassLoader());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Resolution locate(String name) throws IOException {
                void var1_1;
                void var2_2;
                Object module = this.get();
                if (module == null) {
                    return new Resolution.Illegal(name);
                }
                return ForModule.locate(JavaModule.of(var2_2), (String)var1_1);
            }

            @Override
            public void close() {
            }

            public int hashCode() {
                return this.hashCode;
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(@MaybeNull Object other) {
                void var1_1;
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Object module = ((Reference)(other = (WeaklyReferenced)other)).get();
                return module != null && this.get() == var1_1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForClassLoader
    implements ClassFileLocator {
        private static final ClassLoader BOOT_LOADER_PROXY;
        private final ClassLoader classLoader;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        protected ForClassLoader(ClassLoader classLoader) {
            void var1_1;
            this.classLoader = var1_1;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        public static ClassFileLocator ofSystemLoader() {
            return new ForClassLoader(ClassLoader.getSystemClassLoader());
        }

        public static ClassFileLocator ofPlatformLoader() {
            return ForClassLoader.of(ClassLoader.getSystemClassLoader().getParent());
        }

        public static ClassFileLocator ofBootLoader() {
            return new ForClassLoader(BOOT_LOADER_PROXY);
        }

        public static ClassFileLocator of(@MaybeNull ClassLoader classLoader) {
            ClassLoader classLoader2;
            return new ForClassLoader(classLoader == null ? BOOT_LOADER_PROXY : classLoader2);
        }

        /*
         * WARNING - void declaration
         */
        public static byte[] read(Class<?> type) {
            try {
                ClassLoader classLoader = type.getClassLoader();
                return ForClassLoader.locate(classLoader == null ? BOOT_LOADER_PROXY : classLoader, TypeDescription.ForLoadedType.getName(type)).resolve();
            }
            catch (IOException exception) {
                void var1_2;
                Class<?> clazz;
                throw new IllegalStateException("Cannot read class file for " + clazz, (Throwable)var1_2);
            }
        }

        public static Map<Class<?>, byte[]> read(Class<?> ... type) {
            return ForClassLoader.read(Arrays.asList(type));
        }

        /*
         * WARNING - void declaration
         */
        public static Map<Class<?>, byte[]> read(Collection<? extends Class<?>> types) {
            void var1_1;
            Iterator<? extends Class<?>> iterator;
            HashMap<void, byte[]> result = new HashMap<void, byte[]>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Class type = (Class)iterator.next();
                void v0 = var2_2;
                result.put(v0, ForClassLoader.read(v0));
            }
            return var1_1;
        }

        public static Map<String, byte[]> readToNames(Class<?> ... type) {
            return ForClassLoader.readToNames(Arrays.asList(type));
        }

        /*
         * WARNING - void declaration
         */
        public static Map<String, byte[]> readToNames(Collection<? extends Class<?>> types) {
            void var1_1;
            Iterator<? extends Class<?>> iterator;
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Class type = (Class)iterator.next();
                result.put(type.getName(), ForClassLoader.read(var2_2));
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution locate(String name) throws IOException {
            void var1_1;
            return ForClassLoader.locate(this.classLoader, (String)var1_1);
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - void declaration
         */
        protected static Resolution locate(ClassLoader classLoader, String name2) throws IOException {
            void var1_1;
            InputStream inputStream = classLoader.getResourceAsStream(((String)name2).replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    name2 = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                }
                catch (Throwable name2) {
                    InputStream inputStream2;
                    inputStream2.close();
                    throw name2;
                }
                inputStream.close();
                return name2;
            }
            return new Resolution.Illegal((String)var1_1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            BOOT_LOADER_PROXY = ForClassLoader.doPrivileged(BootLoaderProxyCreationAction.INSTANCE);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.classLoader.equals(((ForClassLoader)object).classLoader);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.classLoader.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class WeaklyReferenced
        extends WeakReference<ClassLoader>
        implements ClassFileLocator {
            private final int hashCode;

            /*
             * WARNING - void declaration
             */
            protected WeaklyReferenced(ClassLoader classLoader) {
                super(classLoader);
                void var1_1;
                this.hashCode = System.identityHashCode(var1_1);
            }

            public static ClassFileLocator of(@MaybeNull ClassLoader classLoader) {
                ClassLoader classLoader2;
                if (classLoader == null || classLoader == ClassLoader.getSystemClassLoader() || classLoader == ClassLoader.getSystemClassLoader().getParent()) {
                    return ForClassLoader.of(classLoader);
                }
                return new WeaklyReferenced(classLoader2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Resolution locate(String name) throws IOException {
                void var1_1;
                void var2_2;
                ClassLoader classLoader = (ClassLoader)this.get();
                if (classLoader == null) {
                    return new Resolution.Illegal(name);
                }
                return ForClassLoader.locate((ClassLoader)var2_2, (String)var1_1);
            }

            @Override
            public void close() {
            }

            public int hashCode() {
                return this.hashCode;
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(@MaybeNull Object other) {
                void var1_1;
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ClassLoader classLoader = (ClassLoader)((Reference)(other = (WeaklyReferenced)other)).get();
                return classLoader != null && this.get() == var1_1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum BootLoaderProxyCreationAction implements PrivilegedAction<ClassLoader>
        {
            INSTANCE;


            @Override
            public final ClassLoader run() {
                return new URLClassLoader(new URL[0], ClassLoadingStrategy.BOOTSTRAP_LOADER);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Simple
    implements ClassFileLocator {
        private final Map<String, byte[]> classFiles;

        /*
         * WARNING - void declaration
         */
        public Simple(Map<String, byte[]> classFiles) {
            void var1_1;
            this.classFiles = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator of(String typeName, byte[] binaryRepresentation) {
            void var1_1;
            String string;
            return new Simple(Collections.singletonMap(string, var1_1));
        }

        public static ClassFileLocator of(DynamicType dynamicType) {
            return Simple.of(dynamicType.getAllTypes());
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator of(Map<TypeDescription, byte[]> binaryRepresentations) {
            void var1_1;
            Object object;
            HashMap classFiles = new HashMap();
            for (Map.Entry entry : object.entrySet()) {
                classFiles.put(((TypeDescription)entry.getKey()).getName(), entry.getValue());
            }
            return new Simple((Map<String, byte[]>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static ClassFileLocator ofResources(Map<String, byte[]> binaryRepresentations) {
            void var1_1;
            Object object;
            HashMap classFiles = new HashMap();
            for (Map.Entry entry : object.entrySet()) {
                if (!((String)entry.getKey()).endsWith(ClassFileLocator.CLASS_FILE_EXTENSION)) continue;
                classFiles.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).length() - 6).replace('/', '.'), entry.getValue());
            }
            return new Simple((Map<String, byte[]>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Resolution locate(String name) {
            void var2_2;
            byte[] binaryRepresentation = this.classFiles.get(name);
            if (binaryRepresentation == null) {
                void var1_1;
                return new Resolution.Illegal((String)var1_1);
            }
            return new Resolution.Explicit((byte[])var2_2);
        }

        @Override
        public void close() {
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.classFiles).equals(((Simple)object).classFiles);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.classFiles).hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static abstract class MultiReleaseAware
    implements ClassFileLocator {
        private static final String MULTI_RELEASE_ATTRIBUTE = "Multi-Release";
        protected static final int[] NO_MULTI_RELEASE = new int[0];
        private final int[] version;

        /*
         * WARNING - void declaration
         */
        protected MultiReleaseAware(int[] version) {
            void var1_1;
            this.version = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Resolution locate(String name) throws IOException {
            void var1_1;
            String path = name.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION;
            for (int index = 0; index < this.version.length + 1; ++index) {
                byte[] binaryRepresentation = this.doLocate(index == this.version.length ? path : ClassFileLocator.META_INF_VERSIONS + this.version[index] + "/" + path);
                if (binaryRepresentation == null) continue;
                return new Resolution.Explicit(binaryRepresentation);
            }
            return new Resolution.Illegal((String)var1_1);
        }

        @MaybeNull
        protected abstract byte[] doLocate(String var1) throws IOException;

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return Arrays.equals(this.version, ((MultiReleaseAware)object).version);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + Arrays.hashCode(this.version);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoOp implements ClassFileLocator
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final Resolution locate(String name) {
            void var1_1;
            return new Resolution.Illegal((String)var1_1);
        }

        @Override
        public final void close() {
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public byte[] resolve();

        @HashCodeAndEqualsPlugin.Enhance
        public static class Explicit
        implements Resolution {
            private final byte[] binaryRepresentation;

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The array is not modified by class contract.")
            public Explicit(byte[] binaryRepresentation) {
                void var1_1;
                this.binaryRepresentation = var1_1;
            }

            public boolean isResolved() {
                return true;
            }

            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The array is not modified by class contract.")
            public byte[] resolve() {
                return this.binaryRepresentation;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return Arrays.equals(this.binaryRepresentation, ((Explicit)object).binaryRepresentation);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + Arrays.hashCode(this.binaryRepresentation);
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Illegal
        implements Resolution {
            private final String typeName;

            /*
             * WARNING - void declaration
             */
            public Illegal(String typeName) {
                void var1_1;
                this.typeName = var1_1;
            }

            public boolean isResolved() {
                return false;
            }

            public byte[] resolve() {
                throw new IllegalStateException("Could not locate class file for " + this.typeName);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.typeName.equals(((Illegal)object).typeName);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.typeName.hashCode();
            }
        }
    }
}

