/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.DeclaredByType;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.jar.asm.signature.SignatureWriter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RecordComponentDescription
extends ByteCodeElement.TypeDependant<InDefinedShape, Token>,
DeclaredByType.WithMandatoryDeclaration,
NamedElement.WithDescriptor,
AnnotationSource {
    public TypeDescription.Generic getType();

    public MethodDescription getAccessor();

    @Override
    public Token asToken(ElementMatcher<? super TypeDescription> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Token
    implements ByteCodeElement.Token<Token> {
        private final String name;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;
        private transient /* synthetic */ int hashCode;

        /*
         * WARNING - void declaration
         */
        public Token(String name, TypeDescription.Generic type) {
            this((String)var1_1, (TypeDescription.Generic)var2_2, Collections.emptyList());
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Token(String name, TypeDescription.Generic type, List<? extends AnnotationDescription> annotations) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.type = var2_2;
            this.annotations = var3_3;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription.Generic getType() {
            return this.type;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Token accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var1_1;
            return new Token(this.name, (TypeDescription.Generic)this.type.accept(var1_1), this.annotations);
        }

        /*
         * WARNING - void declaration
         */
        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                void var2_3;
                Token token = this;
                int result = token.name.hashCode();
                result = result * 31 + token.type.hashCode();
                var2_3 = var2_3 * 31 + token.annotations.hashCode();
                n = n2 = var2_3;
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Token token = (Token)other;
            return this.name.equals(token.name) && this.type.equals(token.type) && this.annotations.equals(var1_1.annotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSubstituting
    extends AbstractBase
    implements InGenericShape {
        private final TypeDescription.Generic declaringType;
        private final RecordComponentDescription recordComponentDescription;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        /*
         * WARNING - void declaration
         */
        public TypeSubstituting(TypeDescription.Generic declaringType, RecordComponentDescription recordComponentDescription, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.declaringType = var1_1;
            this.recordComponentDescription = var2_2;
            this.visitor = var3_3;
        }

        @Override
        public MethodDescription.InGenericShape getAccessor() {
            return (MethodDescription.InGenericShape)((MethodList)this.declaringType.getDeclaredMethods().filter(ElementMatchers.named(this.getActualName()))).getOnly();
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.recordComponentDescription.getType().accept(this.visitor);
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.recordComponentDescription.asDefined();
        }

        @Override
        public TypeDefinition getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public String getActualName() {
            return this.recordComponentDescription.getActualName();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.recordComponentDescription.getDeclaredAnnotations();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final TypeDescription declaringType;
        private final String name;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;

        /*
         * WARNING - void declaration
         */
        public Latent(TypeDescription declaringType, Token token) {
            this((TypeDescription)var1_1, token.getName(), token.getType(), var2_2.getAnnotations());
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Latent(TypeDescription declaringType, String name, TypeDescription.Generic type, List<? extends AnnotationDescription> annotations) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.declaringType = var1_1;
            this.name = var2_2;
            this.type = var3_3;
            this.annotations = annotations;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.type.accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public String getActualName() {
            return this.name;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoadedRecordComponent
    extends InDefinedShape.AbstractBase {
        protected static final RecordComponent RECORD_COMPONENT;
        private final AnnotatedElement recordComponent;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        protected ForLoadedRecordComponent(AnnotatedElement recordComponent) {
            void var1_1;
            this.recordComponent = var1_1;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        public static RecordComponentDescription of(Object recordComponent) {
            Object object;
            if (!RECORD_COMPONENT.isInstance(recordComponent)) {
                throw new IllegalArgumentException("Not a record component: " + recordComponent);
            }
            return new ForLoadedRecordComponent((AnnotatedElement)object);
        }

        @Override
        public TypeDescription.Generic getType() {
            return new TypeDescription.Generic.LazyProjection.OfRecordComponent(this.recordComponent);
        }

        @Override
        public MethodDescription.InDefinedShape getAccessor() {
            return new MethodDescription.ForLoadedMethod(RECORD_COMPONENT.getAccessor(this.recordComponent));
        }

        @Override
        public TypeDescription getDeclaringType() {
            return TypeDescription.ForLoadedType.of(RECORD_COMPONENT.getDeclaringRecord(this.recordComponent));
        }

        @Override
        public String getActualName() {
            return RECORD_COMPONENT.getName(this.recordComponent);
        }

        @Override
        @MaybeNull
        public String getGenericSignature() {
            return RECORD_COMPONENT.getGenericSignature(this.recordComponent);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotations(this.recordComponent.getDeclaredAnnotations());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            RECORD_COMPONENT = ForLoadedRecordComponent.doPrivileged(JavaDispatcher.of(RecordComponent.class));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @JavaDispatcher.Proxied(value="java.lang.reflect.RecordComponent")
        protected static interface RecordComponent {
            @JavaDispatcher.Instance
            @JavaDispatcher.Proxied(value="isInstance")
            public boolean isInstance(Object var1);

            @JavaDispatcher.Proxied(value="getName")
            public String getName(Object var1);

            @JavaDispatcher.Proxied(value="getDeclaringRecord")
            public Class<?> getDeclaringRecord(Object var1);

            @JavaDispatcher.Proxied(value="getAccessor")
            public Method getAccessor(Object var1);

            @JavaDispatcher.Proxied(value="getType")
            public Class<?> getType(Object var1);

            @JavaDispatcher.Proxied(value="getGenericType")
            public Type getGenericType(Object var1);

            @MaybeNull
            @JavaDispatcher.Proxied(value="getGenericSignature")
            public String getGenericSignature(Object var1);

            @JavaDispatcher.Proxied(value="getAnnotatedType")
            public AnnotatedElement getAnnotatedType(Object var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase
    implements RecordComponentDescription {
        /*
         * WARNING - void declaration
         */
        @Override
        public Token asToken(ElementMatcher<? super TypeDescription> matcher) {
            void var1_1;
            return new Token(this.getActualName(), this.getType().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment((ElementMatcher<? super TypeDescription>)var1_1)), this.getDeclaredAnnotations());
        }

        @Override
        public String getDescriptor() {
            return this.getType().asErasure().getDescriptor();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public String getGenericSignature() {
            TypeDescription.Generic recordComponentType = this.getType();
            try {
                void var1_1;
                if (recordComponentType.getSort().isNonGeneric()) {
                    return NON_GENERIC_SIGNATURE;
                }
                return var1_1.accept(new TypeDescription.Generic.Visitor.ForSignatureVisitor(new SignatureWriter())).toString();
            }
            catch (GenericSignatureFormatError genericSignatureFormatError) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        public int hashCode() {
            return this.getActualName().hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecordComponentDescription)) {
                return false;
            }
            RecordComponentDescription recordComponentDescription = (RecordComponentDescription)other;
            return this.getActualName().equals(var1_1.getActualName());
        }

        public String toString() {
            return this.getType().getTypeName() + " " + this.getActualName();
        }
    }

    public static interface InDefinedShape
    extends RecordComponentDescription {
        public MethodDescription.InDefinedShape getAccessor();

        public TypeDescription getDeclaringType();

        public static abstract class AbstractBase
        extends net.bytebuddy.description.type.RecordComponentDescription$AbstractBase
        implements InDefinedShape {
            public MethodDescription.InDefinedShape getAccessor() {
                return (MethodDescription.InDefinedShape)((MethodList)this.getDeclaringType().getDeclaredMethods().filter(ElementMatchers.named(this.getActualName()))).getOnly();
            }

            public InDefinedShape asDefined() {
                return this;
            }
        }
    }

    public static interface InGenericShape
    extends RecordComponentDescription {
        public MethodDescription.InGenericShape getAccessor();
    }
}

