/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.FilterableList;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ParameterList<T extends ParameterDescription>
extends FilterableList<T, ParameterList<T>> {
    public TypeList.Generic asTypeList();

    public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> var1);

    public ParameterList<ParameterDescription.InDefinedShape> asDefined();

    public boolean hasExplicitMetaData();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty<S extends ParameterDescription>
    extends FilterableList.Empty<S, ParameterList<S>>
    implements ParameterList<S> {
        @Override
        public boolean hasExplicitMetaData() {
            return true;
        }

        @Override
        public TypeList.Generic asTypeList() {
            return new TypeList.Generic.Empty();
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            return new ByteCodeElement.Token.TokenList((ByteCodeElement.Token[])new ParameterDescription.Token[0]);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSubstituting
    extends AbstractBase<ParameterDescription.InGenericShape> {
        private final MethodDescription.InGenericShape declaringMethod;
        private final List<? extends ParameterDescription> parameterDescriptions;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        /*
         * WARNING - void declaration
         */
        public TypeSubstituting(MethodDescription.InGenericShape declaringMethod, List<? extends ParameterDescription> parameterDescriptions, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.declaringMethod = var1_1;
            this.parameterDescriptions = var2_2;
            this.visitor = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ParameterDescription.InGenericShape get(int index) {
            void var1_1;
            return new ParameterDescription.TypeSubstituting(this.declaringMethod, this.parameterDescriptions.get((int)var1_1), this.visitor);
        }

        @Override
        public int size() {
            return this.parameterDescriptions.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForTokens
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final List<? extends ParameterDescription.Token> tokens;

        /*
         * WARNING - void declaration
         */
        public ForTokens(MethodDescription.InDefinedShape declaringMethod, List<? extends ParameterDescription.Token> tokens) {
            void var2_2;
            void var1_1;
            this.declaringMethod = var1_1;
            this.tokens = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ParameterDescription.InDefinedShape get(int index) {
            void var2_2;
            void var1_1;
            int offset = this.declaringMethod.isStatic() ? 0 : 1;
            for (ParameterDescription.Token token : this.tokens.subList(0, index)) {
                offset += token.getType().getStackSize().getSize();
            }
            return new ParameterDescription.Latent(this.declaringMethod, this.tokens.get(index), (int)var1_1, (int)var2_2);
        }

        @Override
        public int size() {
            return this.tokens.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Explicit<S extends ParameterDescription>
    extends AbstractBase<S> {
        private final List<? extends S> parameterDescriptions;

        /*
         * WARNING - void declaration
         */
        public Explicit(S ... parameterDescription) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Explicit(List<? extends S> parameterDescriptions) {
            void var1_1;
            this.parameterDescriptions = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public S get(int index) {
            void var1_1;
            return (S)((ParameterDescription)this.parameterDescriptions.get((int)var1_1));
        }

        @Override
        public int size() {
            return this.parameterDescriptions.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ForTypes
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final MethodDescription.InDefinedShape methodDescription;
            private final List<? extends TypeDefinition> typeDefinitions;

            /*
             * WARNING - void declaration
             */
            public ForTypes(MethodDescription.InDefinedShape methodDescription, TypeDefinition ... typeDefinition) {
                this((MethodDescription.InDefinedShape)var1_1, Arrays.asList(var2_2));
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForTypes(MethodDescription.InDefinedShape methodDescription, List<? extends TypeDefinition> typeDefinitions) {
                void var2_2;
                void var1_1;
                this.methodDescription = var1_1;
                this.typeDefinitions = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                void var2_2;
                void var1_1;
                int offset = this.methodDescription.isStatic() ? 0 : 1;
                for (int previous = 0; previous < index; ++previous) {
                    offset += this.typeDefinitions.get(previous).getStackSize().getSize();
                }
                return new ParameterDescription.Latent(this.methodDescription, this.typeDefinitions.get(index).asGenericType(), (int)var1_1, (int)var2_2);
            }

            @Override
            public int size() {
                return this.typeDefinitions.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ForLoadedExecutable<T>
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        protected static final Executable EXECUTABLE;
        protected final T executable;
        protected final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        protected ForLoadedExecutable(T executable, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            void var2_2;
            void var1_1;
            this.executable = var1_1;
            this.parameterAnnotationSource = var2_2;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Constructor<?> constructor) {
            Constructor<?> constructor2;
            return ForLoadedExecutable.of(constructor, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)new ParameterDescription.ForLoadedParameter.ParameterAnnotationSource.ForLoadedConstructor(constructor2));
        }

        /*
         * WARNING - void declaration
         */
        public static ParameterList<ParameterDescription.InDefinedShape> of(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            void var1_1;
            Constructor<?> constructor2;
            if (EXECUTABLE.isInstance(constructor)) {
                return new OfConstructor(constructor, parameterAnnotationSource);
            }
            return new OfLegacyVmConstructor(constructor2, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)var1_1);
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Method method) {
            Method method2;
            return ForLoadedExecutable.of(method, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)new ParameterDescription.ForLoadedParameter.ParameterAnnotationSource.ForLoadedMethod(method2));
        }

        /*
         * WARNING - void declaration
         */
        public static ParameterList<ParameterDescription.InDefinedShape> of(Method method, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
            void var1_1;
            Method method2;
            if (EXECUTABLE.isInstance(method)) {
                return new OfMethod(method, parameterAnnotationSource);
            }
            return new OfLegacyVmMethod(method2, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)var1_1);
        }

        @Override
        public int size() {
            return EXECUTABLE.getParameterCount(this.executable);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            EXECUTABLE = ForLoadedExecutable.doPrivileged(JavaDispatcher.of(Executable.class));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmMethod
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Method method;
            private final Class<?>[] parameterType;
            private final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;

            /*
             * WARNING - void declaration
             */
            protected OfLegacyVmMethod(Method method, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                void var2_2;
                void var1_1;
                this.method = method;
                this.parameterType = var1_1.getParameterTypes();
                this.parameterAnnotationSource = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                void var1_1;
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmMethod(this.method, (int)var1_1, this.parameterType, this.parameterAnnotationSource);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmConstructor
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Constructor<?> constructor;
            private final Class<?>[] parameterType;
            private final ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource;

            /*
             * WARNING - void declaration
             */
            protected OfLegacyVmConstructor(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                void var2_2;
                void var1_1;
                this.constructor = constructor;
                this.parameterType = var1_1.getParameterTypes();
                this.parameterAnnotationSource = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                void var1_1;
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmConstructor(this.constructor, (int)var1_1, this.parameterType, this.parameterAnnotationSource);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfMethod
        extends ForLoadedExecutable<Method> {
            /*
             * WARNING - void declaration
             */
            protected OfMethod(Method method, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                super(var1_1, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                void var1_1;
                return new ParameterDescription.ForLoadedParameter.OfMethod((Method)this.executable, (int)var1_1, this.parameterAnnotationSource);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfConstructor
        extends ForLoadedExecutable<Constructor<?>> {
            /*
             * WARNING - void declaration
             */
            protected OfConstructor(Constructor<?> constructor, ParameterDescription.ForLoadedParameter.ParameterAnnotationSource parameterAnnotationSource) {
                super(var1_1, (ParameterDescription.ForLoadedParameter.ParameterAnnotationSource)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                void var1_1;
                return new ParameterDescription.ForLoadedParameter.OfConstructor((Constructor)this.executable, (int)var1_1, this.parameterAnnotationSource);
            }
        }

        @JavaDispatcher.Proxied(value="java.lang.reflect.Executable")
        protected static interface Executable {
            @JavaDispatcher.Instance
            @JavaDispatcher.Proxied(value="isInstance")
            public boolean isInstance(Object var1);

            @JavaDispatcher.Proxied(value="getParameterCount")
            public int getParameterCount(Object var1);

            @JavaDispatcher.Proxied(value="getParameters")
            public Object[] getParameters(Object var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase<S extends ParameterDescription>
    extends FilterableList.AbstractBase<S, ParameterList<S>>
    implements ParameterList<S> {
        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasExplicitMetaData() {
            for (ParameterDescription parameterDescription : this) {
                void var2_2;
                if (parameterDescription.isNamed() && var2_2.hasModifiers()) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            void var2_2;
            ArrayList tokens = new ArrayList(this.size());
            for (ParameterDescription parameterDescription : this) {
                tokens.add(parameterDescription.asToken(matcher));
            }
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>((List<ParameterDescription.Token>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeList.Generic asTypeList() {
            void var1_1;
            ArrayList<TypeDescription.Generic> types = new ArrayList<TypeDescription.Generic>(this.size());
            for (ParameterDescription parameterDescription : this) {
                void var3_3;
                types.add(var3_3.getType());
            }
            return new TypeList.Generic.Explicit((List<? extends TypeDefinition>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            void var1_1;
            ArrayList declaredForms = new ArrayList(this.size());
            for (ParameterDescription parameterDescription : this) {
                void var3_3;
                declaredForms.add(var3_3.asDefined());
            }
            return new Explicit<ParameterDescription.InDefinedShape>((List<ParameterDescription.InDefinedShape>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected ParameterList<S> wrap(List<S> values) {
            void var1_1;
            return new Explicit(var1_1);
        }
    }
}

