/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ParameterDescription
extends ByteCodeElement.TypeDependant<InDefinedShape, Token>,
ModifierReviewable.ForParameterDescription,
NamedElement.WithOptionalName,
NamedElement.WithRuntimeName,
AnnotationSource {
    public static final String NAME_PREFIX = "arg";

    public TypeDescription.Generic getType();

    public MethodDescription getDeclaringMethod();

    public int getIndex();

    public boolean hasModifiers();

    public int getOffset();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Token
    implements ByteCodeElement.Token<Token> {
        @AlwaysNull
        public static final String NO_NAME = null;
        @AlwaysNull
        public static final Integer NO_MODIFIERS = null;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;
        @MaybeNull
        private final String name;
        @MaybeNull
        private final Integer modifiers;
        private transient /* synthetic */ int hashCode;

        /*
         * WARNING - void declaration
         */
        public Token(TypeDescription.Generic type) {
            this((TypeDescription.Generic)var1_1, Collections.emptyList());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Token(TypeDescription.Generic type, List<? extends AnnotationDescription> annotations) {
            this((TypeDescription.Generic)var1_1, (List<? extends AnnotationDescription>)var2_2, NO_NAME, NO_MODIFIERS);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Token(TypeDescription.Generic type, @MaybeNull String name, @MaybeNull Integer modifiers) {
            this((TypeDescription.Generic)var1_1, Collections.emptyList(), (String)var2_2, (Integer)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Token(TypeDescription.Generic type, List<? extends AnnotationDescription> annotations, @MaybeNull String name, @MaybeNull Integer modifiers) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.type = var1_1;
            this.annotations = var2_2;
            this.name = var3_3;
            this.modifiers = modifiers;
        }

        public TypeDescription.Generic getType() {
            return this.type;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        @MaybeNull
        public String getName() {
            return this.name;
        }

        @MaybeNull
        public Integer getModifiers() {
            return this.modifiers;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Token accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var1_1;
            return new Token((TypeDescription.Generic)this.type.accept(var1_1), this.annotations, this.name, this.modifiers);
        }

        /*
         * WARNING - void declaration
         */
        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                void var2_3;
                Token token = this;
                int result = token.type.hashCode();
                result = result * 31 + token.annotations.hashCode();
                result = result * 31 + (token.name != null ? token.name.hashCode() : 0);
                var2_3 = var2_3 * 31 + (token.modifiers != null ? token.modifiers.hashCode() : 0);
                n = n2 = var2_3;
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            return this.type.equals(token.type) && this.annotations.equals(token.annotations) && (this.name != null ? this.name.equals(token.name) : token.name == null) && (this.modifiers != null ? this.modifiers.equals(token.modifiers) : var1_1.modifiers == null);
        }

        public String toString() {
            return "ParameterDescription.Token{type=" + this.type + ", annotations=" + this.annotations + ", name='" + this.name + '\'' + ", modifiers=" + this.modifiers + '}';
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TypeList
        extends AbstractList<Token> {
            private final List<? extends TypeDefinition> typeDescriptions;

            /*
             * WARNING - void declaration
             */
            public TypeList(List<? extends TypeDefinition> typeDescriptions) {
                void var1_1;
                this.typeDescriptions = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Token get(int index) {
                void var1_1;
                return new Token(this.typeDescriptions.get((int)var1_1).asGenericType());
            }

            @Override
            public int size() {
                return this.typeDescriptions.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSubstituting
    extends AbstractBase
    implements InGenericShape {
        private final MethodDescription.InGenericShape declaringMethod;
        private final ParameterDescription parameterDescription;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        /*
         * WARNING - void declaration
         */
        public TypeSubstituting(MethodDescription.InGenericShape declaringMethod, ParameterDescription parameterDescription, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.declaringMethod = var1_1;
            this.parameterDescription = var2_2;
            this.visitor = var3_3;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.parameterDescription.getType().accept(this.visitor);
        }

        @Override
        public MethodDescription.InGenericShape getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.parameterDescription.getIndex();
        }

        @Override
        public boolean isNamed() {
            return this.parameterDescription.isNamed();
        }

        @Override
        public boolean hasModifiers() {
            return this.parameterDescription.hasModifiers();
        }

        @Override
        public int getOffset() {
            return this.parameterDescription.getOffset();
        }

        @Override
        public String getName() {
            return this.parameterDescription.getName();
        }

        @Override
        public int getModifiers() {
            return this.parameterDescription.getModifiers();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.parameterDescription.getDeclaredAnnotations();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.parameterDescription.asDefined();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final TypeDescription.Generic parameterType;
        private final List<? extends AnnotationDescription> declaredAnnotations;
        @MaybeNull
        private final String name;
        @MaybeNull
        private final Integer modifiers;
        private final int index;
        private final int offset;

        /*
         * WARNING - void declaration
         */
        public Latent(MethodDescription.InDefinedShape declaringMethod, Token token, int index, int offset) {
            this((MethodDescription.InDefinedShape)var1_1, token.getType(), token.getAnnotations(), token.getName(), var2_2.getModifiers(), (int)var3_3, offset);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Latent(MethodDescription.InDefinedShape declaringMethod, TypeDescription.Generic parameterType, int index, int offset) {
            this((MethodDescription.InDefinedShape)var1_1, (TypeDescription.Generic)var2_2, Collections.emptyList(), Token.NO_NAME, Token.NO_MODIFIERS, (int)var3_3, offset);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Latent(MethodDescription.InDefinedShape declaringMethod, TypeDescription.Generic parameterType, List<? extends AnnotationDescription> declaredAnnotations, @MaybeNull String name, @MaybeNull Integer modifiers, int index, int offset) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.declaringMethod = var1_1;
            this.parameterType = var2_2;
            this.declaredAnnotations = var3_3;
            this.name = name;
            this.modifiers = modifiers;
            this.index = index;
            this.offset = offset;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.parameterType.accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public MethodDescription.InDefinedShape getDeclaringMethod() {
            return this.declaringMethod;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public boolean isNamed() {
            return this.name != null;
        }

        @Override
        public boolean hasModifiers() {
            return this.modifiers != null;
        }

        @Override
        public String getName() {
            if (this.name == null) {
                return super.getName();
            }
            return this.name;
        }

        @Override
        public int getModifiers() {
            if (this.modifiers == null) {
                return super.getModifiers();
            }
            return this.modifiers;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ForLoadedParameter<T extends AccessibleObject>
    extends InDefinedShape.AbstractBase {
        private static final Parameter PARAMETER;
        protected final T executable;
        protected final int index;
        protected final ParameterAnnotationSource parameterAnnotationSource;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        protected ForLoadedParameter(T executable, int index, ParameterAnnotationSource parameterAnnotationSource) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.executable = var1_1;
            this.index = var2_2;
            this.parameterAnnotationSource = var3_3;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        @Override
        public String getName() {
            return PARAMETER.getName(ParameterList.ForLoadedExecutable.EXECUTABLE.getParameters(this.executable)[this.index]);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isNamed() {
            return PARAMETER.isNamePresent(ParameterList.ForLoadedExecutable.EXECUTABLE.getParameters(this.executable)[this.index]);
        }

        @Override
        public int getModifiers() {
            return PARAMETER.getModifiers(ParameterList.ForLoadedExecutable.EXECUTABLE.getParameters(this.executable)[this.index]);
        }

        @Override
        public boolean hasModifiers() {
            return this.isNamed() || ((AbstractBase)this).getModifiers() != 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            PARAMETER = ForLoadedParameter.doPrivileged(JavaDispatcher.of(Parameter.class));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmConstructor
        extends InDefinedShape.AbstractBase {
            private final Constructor<?> constructor;
            private final int index;
            private final Class<?>[] parameterType;
            private final ParameterAnnotationSource parameterAnnotationSource;

            /*
             * WARNING - void declaration
             */
            protected OfLegacyVmConstructor(Constructor<?> constructor, int index, Class<?>[] parameterType, ParameterAnnotationSource parameterAnnotationSource) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.constructor = var1_1;
                this.index = var2_2;
                this.parameterType = var3_3;
                this.parameterAnnotationSource = parameterAnnotationSource;
            }

            @Override
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.parameterType[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfConstructorParameter(this.constructor, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor(this.constructor);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AnnotationList getDeclaredAnnotations() {
                void var2_2;
                void var1_1;
                MethodDescription.InDefinedShape declaringMethod = this.getDeclaringMethod();
                Annotation[][] parameterAnnotation = this.parameterAnnotationSource.getParameterAnnotations();
                if (parameterAnnotation.length != declaringMethod.getParameters().size() && var1_1.getDeclaringType().isInnerClass()) {
                    return (AnnotationList)((Object)(this.index == 0 ? new AnnotationList.Empty() : new AnnotationList.ForLoadedAnnotations(parameterAnnotation[this.index - 1])));
                }
                return new AnnotationList.ForLoadedAnnotations((Annotation[])var2_2[this.index]);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfLegacyVmMethod
        extends InDefinedShape.AbstractBase {
            private final Method method;
            private final int index;
            private final Class<?>[] parameterType;
            private final ParameterAnnotationSource parameterAnnotationSource;

            /*
             * WARNING - void declaration
             */
            protected OfLegacyVmMethod(Method method, int index, Class<?>[] parameterType, ParameterAnnotationSource parameterAnnotationSource) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.method = var1_1;
                this.index = var2_2;
                this.parameterType = var3_3;
                this.parameterAnnotationSource = parameterAnnotationSource;
            }

            @Override
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.parameterType[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfMethodParameter(this.method, this.index, this.parameterType);
            }

            @Override
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod(this.method);
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean isNamed() {
                return false;
            }

            @Override
            public boolean hasModifiers() {
                return false;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(this.parameterAnnotationSource.getParameterAnnotations()[this.index]);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfConstructor
        extends ForLoadedParameter<Constructor<?>> {
            /*
             * WARNING - void declaration
             */
            protected OfConstructor(Constructor<?> constructor, int index, ParameterAnnotationSource parameterAnnotationSource) {
                super(var1_1, (int)var2_2, (ParameterAnnotationSource)var3_3);
                void var3_3;
                void var2_2;
                void var1_1;
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs.")
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedConstructor((Constructor)this.executable);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs.")
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(((Constructor)this.executable).getParameterTypes()[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfConstructorParameter((Constructor)this.executable, this.index, ((Constructor)this.executable).getParameterTypes());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs")
            public AnnotationList getDeclaredAnnotations() {
                void var1_1;
                void var2_2;
                MethodDescription.InDefinedShape declaringMethod;
                Annotation[][] annotation = this.parameterAnnotationSource.getParameterAnnotations();
                if (annotation.length != (declaringMethod = this.getDeclaringMethod()).getParameters().size() && var2_2.getDeclaringType().isInnerClass()) {
                    return (AnnotationList)((Object)(this.index == 0 ? new AnnotationList.Empty() : new AnnotationList.ForLoadedAnnotations(annotation[this.index - 1])));
                }
                return new AnnotationList.ForLoadedAnnotations((Annotation[])var1_1[this.index]);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class OfMethod
        extends ForLoadedParameter<Method> {
            /*
             * WARNING - void declaration
             */
            protected OfMethod(Method method, int index, ParameterAnnotationSource parameterAnnotationSource) {
                super(var1_1, (int)var2_2, (ParameterAnnotationSource)var3_3);
                void var3_3;
                void var2_2;
                void var1_1;
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs.")
            public MethodDescription.InDefinedShape getDeclaringMethod() {
                return new MethodDescription.ForLoadedMethod((Method)this.executable);
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs.")
            public TypeDescription.Generic getType() {
                if (TypeDescription.AbstractBase.RAW_TYPES) {
                    return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(((Method)this.executable).getParameterTypes()[this.index]);
                }
                return new TypeDescription.Generic.LazyProjection.OfMethodParameter((Method)this.executable, this.index, ((Method)this.executable).getParameterTypes());
            }

            @Override
            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="The implicit field type casting is not understood by Findbugs.")
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.ForLoadedAnnotations(this.parameterAnnotationSource.getParameterAnnotations()[this.index]);
            }
        }

        @JavaDispatcher.Proxied(value="java.lang.reflect.Parameter")
        protected static interface Parameter {
            @JavaDispatcher.Proxied(value="getModifiers")
            public int getModifiers(Object var1);

            @JavaDispatcher.Proxied(value="isNamePresent")
            public boolean isNamePresent(Object var1);

            @JavaDispatcher.Proxied(value="getName")
            public String getName(Object var1);
        }

        public static interface ParameterAnnotationSource {
            public Annotation[][] getParameterAnnotations();

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForLoadedMethod
            implements ParameterAnnotationSource {
                private final Method method;

                /*
                 * WARNING - void declaration
                 */
                public ForLoadedMethod(Method method) {
                    void var1_1;
                    this.method = var1_1;
                }

                public Annotation[][] getParameterAnnotations() {
                    return this.method.getParameterAnnotations();
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.method.equals(((ForLoadedMethod)object).method);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.method.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForLoadedConstructor
            implements ParameterAnnotationSource {
                private final Constructor<?> constructor;

                /*
                 * WARNING - void declaration
                 */
                public ForLoadedConstructor(Constructor<?> constructor) {
                    void var1_1;
                    this.constructor = var1_1;
                }

                @Override
                public Annotation[][] getParameterAnnotations() {
                    return this.constructor.getParameterAnnotations();
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.constructor.equals(((ForLoadedConstructor)object).constructor);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.constructor.hashCode();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements ParameterDescription {
        private transient /* synthetic */ int offset;
        private transient /* synthetic */ int hashCode;

        @Override
        public String getName() {
            return ParameterDescription.NAME_PREFIX.concat(String.valueOf(this.getIndex()));
        }

        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public String getActualName() {
            if (this.isNamed()) {
                return this.getName();
            }
            return "";
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @CachedReturnPlugin.Enhance(value="offset")
        public int getOffset() {
            int n;
            int n2 = this.offset;
            if (n2 != 0) {
                n = 0;
            } else {
                void var3_4;
                AbstractBase abstractBase = this;
                TypeList parameterType = abstractBase.getDeclaringMethod().getParameters().asTypeList().asErasures();
                int offset = abstractBase.getDeclaringMethod().isStatic() ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
                for (int i = 0; i < abstractBase.getIndex(); ++i) {
                    offset += ((TypeDescription)parameterType.get(i)).getStackSize().getSize();
                }
                n = n2 = var3_4;
            }
            if (n == 0) {
                n2 = this.offset;
            } else {
                this.offset = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Token asToken(ElementMatcher<? super TypeDescription> matcher) {
            void var1_1;
            return new Token(this.getType().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment((ElementMatcher<? super TypeDescription>)var1_1)), this.getDeclaredAnnotations(), this.isNamed() ? this.getName() : Token.NO_NAME, this.hasModifiers() ? Integer.valueOf(this.getModifiers()) : Token.NO_MODIFIERS);
        }

        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                AbstractBase abstractBase = this;
                n = n2 = abstractBase.getDeclaringMethod().hashCode() ^ abstractBase.getIndex();
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterDescription)) {
                return false;
            }
            ParameterDescription parameterDescription = (ParameterDescription)other;
            return this.getDeclaringMethod().equals(parameterDescription.getDeclaringMethod()) && this.getIndex() == var1_1.getIndex();
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder stringBuilder = new StringBuilder(Modifier.toString(this.getModifiers()));
            if (this.getModifiers() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.isVarArgs() ? this.getType().asErasure().getName().replaceFirst("\\[]$", "...") : this.getType().asErasure().getName());
            return var1_1.append(' ').append(this.getName()).toString();
        }
    }

    public static interface InDefinedShape
    extends ParameterDescription {
        public MethodDescription.InDefinedShape getDeclaringMethod();

        public static abstract class AbstractBase
        extends net.bytebuddy.description.method.ParameterDescription$AbstractBase
        implements InDefinedShape {
            public InDefinedShape asDefined() {
                return this;
            }
        }
    }

    public static interface InGenericShape
    extends ParameterDescription {
        public MethodDescription.InGenericShape getDeclaringMethod();
    }
}

