/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.FilterableList;
import net.bytebuddy.utility.ConstructorComparator;
import net.bytebuddy.utility.GraalImageCode;
import net.bytebuddy.utility.MethodComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MethodList<T extends MethodDescription>
extends FilterableList<T, MethodList<T>> {
    public ByteCodeElement.Token.TokenList<MethodDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> var1);

    public List<MethodDescription.SignatureToken> asSignatureTokenList();

    public List<MethodDescription.SignatureToken> asSignatureTokenList(ElementMatcher<? super TypeDescription> var1, TypeDescription var2);

    public MethodList<MethodDescription.InDefinedShape> asDefined();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty<S extends MethodDescription>
    extends FilterableList.Empty<S, MethodList<S>>
    implements MethodList<S> {
        @Override
        public ByteCodeElement.Token.TokenList<MethodDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            return new ByteCodeElement.Token.TokenList((ByteCodeElement.Token[])new MethodDescription.Token[0]);
        }

        @Override
        public List<MethodDescription.SignatureToken> asSignatureTokenList() {
            return Collections.emptyList();
        }

        @Override
        public List<MethodDescription.SignatureToken> asSignatureTokenList(ElementMatcher<? super TypeDescription> matcher, TypeDescription typeDescription) {
            return Collections.emptyList();
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> asDefined() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSubstituting
    extends AbstractBase<MethodDescription.InGenericShape> {
        protected final TypeDescription.Generic declaringType;
        protected final List<? extends MethodDescription> methodDescriptions;
        protected final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        /*
         * WARNING - void declaration
         */
        public TypeSubstituting(TypeDescription.Generic declaringType, List<? extends MethodDescription> methodDescriptions, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.declaringType = var1_1;
            this.methodDescriptions = var2_2;
            this.visitor = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MethodDescription.InGenericShape get(int index) {
            void var1_1;
            return new MethodDescription.TypeSubstituting(this.declaringType, this.methodDescriptions.get((int)var1_1), this.visitor);
        }

        @Override
        public int size() {
            return this.methodDescriptions.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForTokens
    extends AbstractBase<MethodDescription.InDefinedShape> {
        private final TypeDescription declaringType;
        private final List<? extends MethodDescription.Token> tokens;

        /*
         * WARNING - void declaration
         */
        public ForTokens(TypeDescription declaringType, MethodDescription.Token ... token) {
            this((TypeDescription)var1_1, Arrays.asList(var2_2));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ForTokens(TypeDescription declaringType, List<? extends MethodDescription.Token> tokens) {
            void var2_2;
            void var1_1;
            this.declaringType = var1_1;
            this.tokens = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MethodDescription.InDefinedShape get(int index) {
            void var1_1;
            return new MethodDescription.Latent(this.declaringType, this.tokens.get((int)var1_1));
        }

        @Override
        public int size() {
            return this.tokens.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Explicit<S extends MethodDescription>
    extends AbstractBase<S> {
        private final List<? extends S> methodDescriptions;

        /*
         * WARNING - void declaration
         */
        public Explicit(S ... methodDescription) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Explicit(List<? extends S> methodDescriptions) {
            void var1_1;
            this.methodDescriptions = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public S get(int index) {
            void var1_1;
            return (S)((MethodDescription)this.methodDescriptions.get((int)var1_1));
        }

        @Override
        public int size() {
            return this.methodDescriptions.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoadedMethods
    extends AbstractBase<MethodDescription.InDefinedShape> {
        private final List<? extends Method> methods;
        private final List<? extends Constructor<?>> constructors;

        /*
         * WARNING - void declaration
         */
        public ForLoadedMethods(Class<?> type) {
            this(GraalImageCode.getCurrent().sorted(type.getDeclaredConstructors(), ConstructorComparator.INSTANCE), GraalImageCode.getCurrent().sorted(var1_1.getDeclaredMethods(), MethodComparator.INSTANCE));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ForLoadedMethods(Constructor<?>[] constructor, Method[] method) {
            this(Arrays.asList(var1_1), Arrays.asList(var2_2));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ForLoadedMethods(List<? extends Constructor<?>> constructors, List<? extends Method> methods) {
            void var2_2;
            void var1_1;
            this.constructors = var1_1;
            this.methods = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MethodDescription.InDefinedShape get(int index) {
            void var1_1;
            if (index < this.constructors.size()) {
                return new MethodDescription.ForLoadedConstructor(this.constructors.get(index));
            }
            return new MethodDescription.ForLoadedMethod(this.methods.get((int)(var1_1 - this.constructors.size())));
        }

        @Override
        public int size() {
            return this.constructors.size() + this.methods.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase<S extends MethodDescription>
    extends FilterableList.AbstractBase<S, MethodList<S>>
    implements MethodList<S> {
        /*
         * WARNING - void declaration
         */
        @Override
        protected MethodList<S> wrap(List<S> values) {
            void var1_1;
            return new Explicit(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteCodeElement.Token.TokenList<MethodDescription.Token> asTokenList(ElementMatcher<? super TypeDescription> matcher) {
            void var2_2;
            ArrayList tokens = new ArrayList(this.size());
            for (MethodDescription methodDescription : this) {
                tokens.add(methodDescription.asToken(matcher));
            }
            return new ByteCodeElement.Token.TokenList<MethodDescription.Token>((List<MethodDescription.Token>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<MethodDescription.SignatureToken> asSignatureTokenList() {
            void var1_1;
            ArrayList<MethodDescription.SignatureToken> tokens = new ArrayList<MethodDescription.SignatureToken>(this.size());
            for (MethodDescription methodDescription : this) {
                void var3_3;
                tokens.add(var3_3.asSignatureToken());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<MethodDescription.SignatureToken> asSignatureTokenList(ElementMatcher<? super TypeDescription> matcher, TypeDescription typeDescription) {
            void var3_3;
            ArrayList<MethodDescription.SignatureToken> tokens = new ArrayList<MethodDescription.SignatureToken>(this.size());
            for (MethodDescription methodDescription : this) {
                tokens.add(((MethodDescription.Token)methodDescription.asToken(matcher)).asSignatureToken(typeDescription));
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MethodList<MethodDescription.InDefinedShape> asDefined() {
            void var1_1;
            ArrayList declaredForms = new ArrayList(this.size());
            for (MethodDescription methodDescription : this) {
                void var3_3;
                declaredForms.add(var3_3.asDefined());
            }
            return new Explicit<MethodDescription.InDefinedShape>((List<MethodDescription.InDefinedShape>)var1_1);
        }
    }
}

